/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.rule;

import java.util.regex.Pattern;
import metaconfig.Configured;
import metaconfig.Configured$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.meta.Defn;
import scala.meta.Dialect$;
import scala.meta.Importee;
import scala.meta.Lit;
import scala.meta.Lit$;
import scala.meta.Name;
import scala.meta.Term;
import scala.meta.Tree;
import scala.meta.inputs.Position;
import scala.meta.package$;
import scala.meta.tokens.Tokens;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scalafix.internal.rule.RemoveUnusedConfig;
import scalafix.internal.rule.RemoveUnusedConfig$;
import scalafix.lint.Diagnostic;
import scalafix.patch.Patch;
import scalafix.v1.Configuration;
import scalafix.v1.Rule;
import scalafix.v1.SemanticDocument;
import scalafix.v1.SemanticRule;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0001%\u0011ABU3n_Z,WK\\;tK\u0012T!a\u0001\u0003\u0002\tI,H.\u001a\u0006\u0003\u000b\u0019\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002\u000f\u0005A1oY1mC\u001aL\u0007p\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!BA\u0007\u0007\u0003\t1\u0018'\u0003\u0002\u0010\u0019\ta1+Z7b]RL7MU;mK\"A\u0011\u0003\u0001B\u0001B\u0003%!#\u0001\u0004d_:4\u0017n\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011!CU3n_Z,WK\\;tK\u0012\u001cuN\u001c4jO\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\"!\u0007\u000e\u0011\u0005M\u0001\u0001\"B\t\u0017\u0001\u0004\u0011\u0002\"B\f\u0001\t\u0003aB#A\r\t\u000by\u0001A\u0011I\u0010\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u000b\u0002AA\u0011\u0011e\n\b\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011aeI\u0001\u0007!J,G-\u001a4\n\u0005!J#AB*ue&twM\u0003\u0002'G!)1\u0006\u0001C!Y\u0005I\u0011n\u001d*foJLG/Z\u000b\u0002[A\u0011!EL\u0005\u0003_\r\u0012qAQ8pY\u0016\fg\u000eC\u00032\u0001\u0011\u0005#'A\txSRD7i\u001c8gS\u001e,(/\u0019;j_:$\"a\r\u001f\u0011\u0007Q:\u0014(D\u00016\u0015\u00051\u0014AC7fi\u0006\u001cwN\u001c4jO&\u0011\u0001(\u000e\u0002\u000b\u0007>tg-[4ve\u0016$\u0007CA\u0006;\u0013\tYDB\u0001\u0003Sk2,\u0007\"B\t1\u0001\u0004i\u0004CA\u0006?\u0013\tyDBA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006\u0003\u0002!\tEQ\u0001\u0004M&DHCA\"U!\t!eJ\u0004\u0002F\u0019:\u0011ai\u0013\b\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\"\ta\u0001\u0010:p_Rt\u0014\"A\u0004\n\u000551\u0011BA'\r\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0014)\u0003\u000bA\u000bGo\u00195\n\u0005E\u0013&aA!qS*\u00111KB\u0001\u0005kRLG\u000eC\u0003V\u0001\u0002\u000fa+A\u0002e_\u000e\u0004\"aC,\n\u0005ac!\u0001E*f[\u0006tG/[2E_\u000e,X.\u001a8u\u0011\u001dQ\u0006A1A\u0005\nm\u000bQ#\u001e8vg\u0016$\u0007K]5wCR,Gj\\2bYZ\u000bG.F\u0001]!\ti6-D\u0001_\u0015\ty\u0006-A\u0003sK\u001e,\u0007P\u0003\u0002TC*\t!-\u0001\u0003kCZ\f\u0017B\u00013_\u0005\u001d\u0001\u0016\r\u001e;fe:DaA\u001a\u0001!\u0002\u0013a\u0016AF;okN,G\r\u0015:jm\u0006$X\rT8dC24\u0016\r\u001c\u0011\t\u000b!\u0004A\u0011A5\u00023%\u001cXK\\;tK\u0012\u0004&/\u001b<bi\u0016$\u0015.Y4o_N$\u0018n\u0019\u000b\u0003[)DQa[4A\u00021\fq!\\3tg\u0006<W\r\u0005\u0002E[&\u0011a\u000e\u0015\u0002\u000b\t&\fwM\\8ti&\u001c\u0007\"\u00029\u0001\t\u0013\t\u0018AD5na>\u0014H\u000fU8tSRLwN\u001c\u000b\u0004e\u0006\r\u0001CA:|\u001d\t!\u0018P\u0004\u0002vo:\u0011qI^\u0005\u0002I%\u0011\u0001pI\u0001\u0005[\u0016$\u0018-\u0003\u0002Nu*\u0011\u0001pI\u0005\u0003yv\u0014\u0001\u0002U8tSRLwN\\\u0005\u0003}~\u0014q!\u00117jCN,7OC\u0002\u0002\u0002i\fa!\u001b8qkR\u001c\bbBA\u0003_\u0002\u0007\u0011qA\u0001\tS6\u0004xN\u001d;fKB!\u0011\u0011BA\u0006\u001b\u0005Q\u0018bAA\u0007u\nA\u0011*\u001c9peR,W\rC\u0004\u0002\u0012\u0001!I!a\u0005\u0002\u0019\tLg\u000eZ3s)>\\WM\\:\u0015\r\u0005U\u0011\u0011EA\u0016!\r\u0019\u0018qC\u0005\u0005\u00033\tYB\u0001\u0004U_.,gn]\u0005\u0004}\u0006u!bAA\u0010u\u00061Ao\\6f]ND\u0001\"a\t\u0002\u0010\u0001\u0007\u0011QE\u0001\u0005I\u00164g\u000e\u0005\u0003\u0002\n\u0005\u001d\u0012bAA\u0015u\n!A)\u001a4o\u0011!\ti#a\u0004A\u0002\u0005=\u0012\u0001\u00022pIf\u0004B!!\u0003\u00022%\u0019\u00111\u0007>\u0003\tQ+'/\u001c\u0005\b\u0003o\u0001A\u0011BA\u001d\u0003I!WM\u001a8U_.,gn\u001d+p%\u0016lwN^3\u0015\t\u0005m\u0012\u0011\t\t\u0006E\u0005u\u0012QC\u0005\u0004\u0003\u007f\u0019#AB(qi&|g\u000e\u0003\u0005\u0002$\u0005U\u0002\u0019AA\u0013\u0001")
public class RemoveUnused
extends SemanticRule {
    public final RemoveUnusedConfig scalafix$internal$rule$RemoveUnused$$config;
    private final Pattern unusedPrivateLocalVal;

    public String description() {
        return "Removes unused imports and terms that reported by the compiler under -Ywarn-unused";
    }

    public boolean isRewrite() {
        return true;
    }

    public Configured<Rule> withConfiguration(Configuration config) {
        return config.scalacOptions().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.startsWith("-Ywarn-unused");
            }
        }) ? config.conf().getOrElse("RemoveUnused", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]), (Object)this.scalafix$internal$rule$RemoveUnused$$config, RemoveUnusedConfig$.MODULE$.decoder()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RemoveUnused apply(RemoveUnusedConfig x$2) {
                return new RemoveUnused(x$2);
            }
        }) : Configured$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The compiler option -Ywarn-unused is required to use RemoveUnused. "})).s((Seq)Nil$.MODULE$)).append((Object)"Run `scalac -Ywarn-unused:help` for more details. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Obtained ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.scalacOptions()}))).toString());
    }

    public Patch fix(SemanticDocument doc) {
        Set isUnusedTerm = Set$.MODULE$.empty();
        Set isUnusedImport = Set$.MODULE$.empty();
        doc.diagnostics().foreach((Function1)new Serializable(this, isUnusedTerm, isUnusedImport){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveUnused $outer;
            private final Set isUnusedTerm$1;
            private final Set isUnusedImport$1;

            /*
             * Enabled aggressive block sorting
             */
            public final Object apply(Diagnostic diagnostic) {
                BoxedUnit boxedUnit;
                if (this.$outer.scalafix$internal$rule$RemoveUnused$$config.imports()) {
                    String string = diagnostic.message();
                    String string2 = "Unused import";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        boxedUnit = this.isUnusedImport$1.$plus$eq((Object)diagnostic.position());
                        return boxedUnit;
                    }
                }
                if (this.$outer.scalafix$internal$rule$RemoveUnused$$config.privates() && diagnostic.message().startsWith("private") && diagnostic.message().endsWith("is never used")) {
                    boxedUnit = this.isUnusedTerm$1.$plus$eq((Object)diagnostic.position());
                    return boxedUnit;
                }
                if (this.$outer.scalafix$internal$rule$RemoveUnused$$config.locals() && diagnostic.message().startsWith("local") && diagnostic.message().endsWith("is never used")) {
                    boxedUnit = this.isUnusedTerm$1.$plus$eq((Object)diagnostic.position());
                    return boxedUnit;
                }
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isUnusedTerm$1 = isUnusedTerm$1;
                this.isUnusedImport$1 = isUnusedImport$1;
            }
        });
        return isUnusedImport.isEmpty() && isUnusedTerm.isEmpty() ? scalafix.v1.package$.MODULE$.Patch().empty() : scalafix.v1.package$.MODULE$.XtensionSeqPatch((Iterable)package$.MODULE$.XtensionCollectionLikeUI(doc.tree()).collect((PartialFunction)new Serializable(this, isUnusedTerm, isUnusedImport){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveUnused $outer;
            private final Set isUnusedTerm$1;
            private final Set isUnusedImport$1;

            public final <A1 extends Tree, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Importee importee;
                A1 A1 = x1;
                if (A1 instanceof Importee && this.isUnusedImport$1.apply((Object)this.$outer.scalafix$internal$rule$RemoveUnused$$importPosition(importee = (Importee)A1))) {
                    Patch patch;
                    Importee.Rename rename;
                    Option option;
                    Importee importee2 = importee;
                    if (importee2 instanceof Importee.Rename && !(option = Importee.Rename$.MODULE$.unapply(rename = (Importee.Rename)importee2)).isEmpty()) {
                        Name to = (Name)((Tuple2)option.get())._2();
                        patch = scalafix.v1.package$.MODULE$.Patch().replaceTree((Tree)to, "_").atomic();
                    } else {
                        patch = scalafix.v1.package$.MODULE$.Patch().removeImportee(importee).atomic();
                    }
                    object = patch;
                } else {
                    Defn defn;
                    object = A1 instanceof Defn && this.isUnusedTerm$1.apply((Object)(defn = (Defn)A1).pos()) ? scalafix.v1.package$.MODULE$.XtensionOptionPatch(this.$outer.scalafix$internal$rule$RemoveUnused$$defnTokensToRemove(defn).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Patch apply(Tokens tokens) {
                            return scalafix.v1.package$.MODULE$.Patch().removeTokens(tokens);
                        }
                    })).asPatch().atomic() : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Tree x1) {
                Defn defn;
                Importee importee;
                Tree tree = x1;
                boolean bl = tree instanceof Importee && this.isUnusedImport$1.apply((Object)this.$outer.scalafix$internal$rule$RemoveUnused$$importPosition(importee = (Importee)tree)) ? true : tree instanceof Defn && this.isUnusedTerm$1.apply((Object)(defn = (Defn)tree).pos());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isUnusedTerm$1 = isUnusedTerm$1;
                this.isUnusedImport$1 = isUnusedImport$1;
            }
        })).asPatch();
    }

    private Pattern unusedPrivateLocalVal() {
        return this.unusedPrivateLocalVal;
    }

    public boolean isUnusedPrivateDiagnostic(Diagnostic message) {
        return this.unusedPrivateLocalVal().matcher(message.message()).matches();
    }

    public Position scalafix$internal$rule$RemoveUnused$$importPosition(Importee importee) {
        Position position;
        Importee.Rename rename;
        Option option;
        Importee importee2 = importee;
        if (importee2 instanceof Importee.Rename && !(option = Importee.Rename$.MODULE$.unapply(rename = (Importee.Rename)importee2)).isEmpty()) {
            Name from = (Name)((Tuple2)option.get())._1();
            position = from.pos();
        } else {
            position = importee.pos();
        }
        return position;
    }

    public Tokens scalafix$internal$rule$RemoveUnused$$binderTokens(Defn defn, Term body) {
        int startDef = defn.tokens(Dialect$.MODULE$.current()).start();
        int startBody = body.tokens(Dialect$.MODULE$.current()).start();
        return defn.tokens(Dialect$.MODULE$.current()).take(startBody - startDef);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tokens> scalafix$internal$rule$RemoveUnused$$defnTokensToRemove(Defn defn) {
        Option option;
        Option option2;
        boolean bl = false;
        Defn.Val val = null;
        boolean bl2 = false;
        ObjectRef objectRef = ObjectRef.create(null);
        Defn defn2 = defn;
        if (defn2 instanceof Defn.Val) {
            Lit lit;
            Option option3;
            Term term;
            bl = true;
            val = (Defn.Val)defn2;
            Option option4 = Defn.Val$.MODULE$.unapply(val);
            if (!option4.isEmpty() && (term = (Term)((Tuple4)option4.get())._4()) instanceof Lit && !(option3 = Lit$.MODULE$.unapply(lit = (Lit)term)).isEmpty()) {
                return new Some((Object)val.tokens(Dialect$.MODULE$.current()));
            }
        }
        if (bl && !(option2 = Defn.Val$.MODULE$.unapply(val)).isEmpty()) {
            Term rhs = (Term)((Tuple4)option2.get())._4();
            return new Some((Object)this.scalafix$internal$rule$RemoveUnused$$binderTokens((Defn)val, rhs));
        }
        if (defn2 instanceof Defn.Var) {
            Lit lit;
            Option option5;
            Some some;
            Term term;
            Option option6;
            bl2 = true;
            objectRef.elem = (Defn.Var)defn2;
            Option option7 = Defn.Var$.MODULE$.unapply((Defn.Var)objectRef.elem);
            if (!option7.isEmpty() && (option6 = (Option)((Tuple4)option7.get())._4()) instanceof Some && (term = (Term)(some = (Some)option6).x()) instanceof Lit && !(option5 = Lit$.MODULE$.unapply(lit = (Lit)term)).isEmpty()) {
                return new Some((Object)((Defn.Var)objectRef.elem).tokens(Dialect$.MODULE$.current()));
            }
        }
        if (bl2 && !(option = Defn.Var$.MODULE$.unapply((Defn.Var)objectRef.elem)).isEmpty()) {
            Option rhs = (Option)((Tuple4)option.get())._4();
            return rhs.map((Function1)new Serializable(this, objectRef){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RemoveUnused $outer;
                private final ObjectRef x16$1;

                public final Tokens apply(Term x$3) {
                    return this.$outer.scalafix$internal$rule$RemoveUnused$$binderTokens((Defn)((Defn.Var)this.x16$1.elem), x$3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.x16$1 = x16$1;
                }
            });
        }
        if (!(defn2 instanceof Defn.Def)) return None$.MODULE$;
        Defn.Def def = (Defn.Def)defn2;
        return new Some((Object)def.tokens(Dialect$.MODULE$.current()));
    }

    public RemoveUnused(RemoveUnusedConfig config) {
        this.scalafix$internal$rule$RemoveUnused$$config = config;
        super(scalafix.v1.package$.MODULE$.RuleName().apply("RemoveUnused").withDeprecatedName("RemoveUnusedImports", "Use RemoveUnused instead", "0.6.0").withDeprecatedName("RemoveUnusedTerms", "Use RemoveUnused instead", "0.6.0"));
        this.unusedPrivateLocalVal = Pattern.compile("(local|private) (.*) is never used");
    }

    public RemoveUnused() {
        this(RemoveUnusedConfig$.MODULE$.default());
    }
}

