/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.rule;

import metaconfig.Configured;
import metaconfig.Configured$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Set;
import scala.meta.Importee;
import scala.meta.Name;
import scala.meta.Tree;
import scala.meta.inputs.Position;
import scala.meta.package$;
import scala.reflect.ScalaSignature;
import scalafix.lint.Diagnostic;
import scalafix.patch.Patch;
import scalafix.rule.RuleName$;
import scalafix.v1.Configuration;
import scalafix.v1.Rule;
import scalafix.v1.SemanticDoc;
import scalafix.v1.SemanticRule;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u0013\t\u0019\"+Z7pm\u0016,f.^:fI&k\u0007o\u001c:ug*\u00111\u0001B\u0001\u0005eVdWM\u0003\u0002\u0006\r\u0005A\u0011N\u001c;fe:\fGNC\u0001\b\u0003!\u00198-\u00197bM&D8\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q!!\u0004\u0004\u0002\u0005Y\f\u0014BA\b\r\u00051\u0019V-\\1oi&\u001c'+\u001e7f\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u0015\u00015\t!\u0001C\u0003\u0017\u0001\u0011\u0005s#A\u0006eKN\u001c'/\u001b9uS>tW#\u0001\r\u0011\u0005e\u0011cB\u0001\u000e!!\tYb$D\u0001\u001d\u0015\ti\u0002\"\u0001\u0004=e>|GO\u0010\u0006\u0002?\u0005)1oY1mC&\u0011\u0011EH\u0001\u0007!J,G-\u001a4\n\u0005\r\"#AB*ue&twM\u0003\u0002\"=!)a\u0005\u0001C!O\u0005\tr/\u001b;i\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005!\n\u0004cA\u0015-]5\t!FC\u0001,\u0003)iW\r^1d_:4\u0017nZ\u0005\u0003[)\u0012!bQ8oM&<WO]3e!\tYq&\u0003\u00021\u0019\t!!+\u001e7f\u0011\u0015\u0011T\u00051\u00014\u0003\u0019\u0019wN\u001c4jOB\u00111\u0002N\u0005\u0003k1\u0011QbQ8oM&<WO]1uS>t\u0007\"B\u001c\u0001\t\u0003B\u0014a\u00014jqR\u0011\u0011h\u0012\t\u0003u\u0005s!aO \u000f\u0005qrdBA\u000e>\u0013\u00059\u0011BA\u0007\u0007\u0013\t\u0001E\"A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%!\u0002)bi\u000eD\u0017B\u0001#F\u0005\r\t\u0005/\u001b\u0006\u0003\r\u001a\tA!\u001e;jY\")\u0001J\u000ea\u0002\u0013\u0006\u0019Am\\2\u0011\u0005-Q\u0015BA&\r\u0005-\u0019V-\\1oi&\u001cGi\\2")
public class RemoveUnusedImports
extends SemanticRule {
    public String description() {
        return "Rewrite that removes unused imports reported by the compiler under -Xwarn-unused-import.";
    }

    public Configured<Rule> withConfiguration(Configuration config) {
        return config.scalaVersion().startsWith("2.11") && !config.scalacOptions().contains((Object)"-Ywarn-unused-import") ? Configured$.MODULE$.error(new StringBuilder(81).append("The compiler option -Ywarn-unused-import is required to use RemoveUnusedImports. ").append(new StringBuilder(9).append("Obtained ").append(config.scalacOptions()).toString()).toString()) : Configured$.MODULE$.ok((Object)this);
    }

    public Patch fix(SemanticDoc doc) {
        Set unusedImports = doc.diagnostics().toIterator().collect((PartialFunction)new Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Diagnostic, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                String string = A1.message();
                String string2 = "Unused import";
                Object object = !(string != null ? !string.equals(string2) : string2 != null) ? A1.position() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Diagnostic x1) {
                Diagnostic diagnostic = x1;
                String string = diagnostic.message();
                String string2 = "Unused import";
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                return bl;
            }
        }).toSet();
        return scalafix.v1.package$.MODULE$.XtensionSeqPatch((Iterable)package$.MODULE$.XtensionCollectionLikeUI(doc.tree()).collect((PartialFunction)new Serializable(this, unusedImports){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveUnusedImports $outer;
            private final Set unusedImports$1;

            public final <A1 extends Tree, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Importee importee;
                A1 A1 = x2;
                Object object = A1 instanceof Importee && RemoveUnusedImports.scalafix$internal$rule$RemoveUnusedImports$$isUnused$1(importee = (Importee)A1, this.unusedImports$1) ? scalafix.v1.package$.MODULE$.Patch().removeImportee(importee).atomic() : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tree x2) {
                Importee importee;
                Tree tree = x2;
                boolean bl = tree instanceof Importee && RemoveUnusedImports.scalafix$internal$rule$RemoveUnusedImports$$isUnused$1(importee = (Importee)tree, this.unusedImports$1);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.unusedImports$1 = unusedImports$1;
            }
        })).asPatch();
    }

    public static final boolean scalafix$internal$rule$RemoveUnusedImports$$isUnused$1(Importee importee, Set unusedImports$1) {
        Position position;
        Importee.Rename rename;
        Option option;
        Importee importee2 = importee;
        if (importee2 instanceof Importee.Rename && !(option = Importee.Rename$.MODULE$.unapply(rename = (Importee.Rename)importee2)).isEmpty()) {
            Name name = (Name)((Tuple2)option.get())._1();
            position = name.pos();
        } else {
            position = importee.pos();
        }
        Position pos = position;
        return unusedImports$1.contains((Object)pos);
    }

    public RemoveUnusedImports() {
        super(RuleName$.MODULE$.stringToRuleName("RemoveUnusedImports"));
    }
}

