/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.rule;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.regex.Pattern;
import metaconfig.Configured;
import metaconfig.Configured$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.meta.Defn;
import scala.meta.Dialect$;
import scala.meta.Importee;
import scala.meta.Lit;
import scala.meta.Lit$;
import scala.meta.Name;
import scala.meta.Term;
import scala.meta.Tree;
import scala.meta.inputs.Position;
import scala.meta.package$;
import scala.meta.tokens.Tokens;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scalafix.internal.rule.RemoveUnusedConfig;
import scalafix.internal.rule.RemoveUnusedConfig$;
import scalafix.lint.Diagnostic;
import scalafix.patch.Patch;
import scalafix.v1.Configuration;
import scalafix.v1.Rule;
import scalafix.v1.SemanticDocument;
import scalafix.v1.SemanticRule;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u0001%\u0011ABU3n_Z,WK\\;tK\u0012T!a\u0001\u0003\u0002\tI,H.\u001a\u0006\u0003\u000b\u0019\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002\u000f\u0005A1oY1mC\u001aL\u0007p\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!BA\u0007\u0007\u0003\t1\u0018'\u0003\u0002\u0010\u0019\ta1+Z7b]RL7MU;mK\"A\u0011\u0003\u0001B\u0001B\u0003%!#\u0001\u0004d_:4\u0017n\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011!CU3n_Z,WK\\;tK\u0012\u001cuN\u001c4jO\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\"!\u0007\u000e\u0011\u0005M\u0001\u0001\"B\t\u0017\u0001\u0004\u0011\u0002\"B\f\u0001\t\u0003aB#A\r\t\u000by\u0001A\u0011I\u0010\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u000b\u0002AA\u0011\u0011E\u000b\b\u0003E!\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u0005\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0003\u0019\u0001&/\u001a3fM&\u00111\u0006\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%2\u0003\"\u0002\u0018\u0001\t\u0003z\u0013!C5t%\u0016<(/\u001b;f+\u0005\u0001\u0004CA\u00193\u001b\u00051\u0013BA\u001a'\u0005\u001d\u0011un\u001c7fC:DQ!\u000e\u0001\u0005BY\n\u0011c^5uQ\u000e{gNZ5hkJ\fG/[8o)\t9\u0004\tE\u00029wuj\u0011!\u000f\u0006\u0002u\u0005QQ.\u001a;bG>tg-[4\n\u0005qJ$AC\"p]\u001aLw-\u001e:fIB\u00111BP\u0005\u0003\u007f1\u0011AAU;mK\")\u0011\u0003\u000ea\u0001\u0003B\u00111BQ\u0005\u0003\u00072\u0011QbQ8oM&<WO]1uS>t\u0007\"B#\u0001\t\u00032\u0015a\u00014jqR\u0011q)\u0016\t\u0003\u0011>s!!S'\u000f\u0005)ceBA\u0012L\u0013\u00059\u0011BA\u0007\u0007\u0013\tqE\"A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&!\u0002)bi\u000eD\u0017B\u0001*T\u0005\r\t\u0005/\u001b\u0006\u0003)\u001a\tA!\u001e;jY\")a\u000b\u0012a\u0002/\u0006\u0019Am\\2\u0011\u0005-A\u0016BA-\r\u0005A\u0019V-\\1oi&\u001cGi\\2v[\u0016tG\u000fC\u0004\\\u0001\t\u0007I\u0011\u0002/\u0002+UtWo]3e!JLg/\u0019;f\u0019>\u001c\u0017\r\u001c,bYV\tQ\f\u0005\u0002_I6\tqL\u0003\u0002aC\u0006)!/Z4fq*\u0011AK\u0019\u0006\u0002G\u0006!!.\u0019<b\u0013\t)wLA\u0004QCR$XM\u001d8\t\r\u001d\u0004\u0001\u0015!\u0003^\u0003Y)h.^:fIB\u0013\u0018N^1uK2{7-\u00197WC2\u0004\u0003\"B5\u0001\t\u0003Q\u0017!G5t+:,8/\u001a3Qe&4\u0018\r^3ES\u0006<gn\\:uS\u000e$\"\u0001M6\t\u000b1D\u0007\u0019A7\u0002\u000f5,7o]1hKB\u0011\u0001J\\\u0005\u0003_F\u0013!\u0002R5bO:|7\u000f^5d\u0011\u0015\t\b\u0001\"\u0003s\u00039IW\u000e]8siB{7/\u001b;j_:$2a]A\u0003!\t!HP\u0004\u0002vu:\u0011a\u000f\u001f\b\u0003G]L\u0011aJ\u0005\u0003s\u001a\nA!\\3uC&\u0011aj\u001f\u0006\u0003s\u001aJ!! @\u0003\u0011A{7/\u001b;j_:L1a`A\u0001\u0005\u001d\tE.[1tKNT1!a\u0001|\u0003\u0019Ig\u000e];ug\"9\u0011q\u00019A\u0002\u0005%\u0011\u0001C5na>\u0014H/Z3\u0011\t\u0005-\u0011QB\u0007\u0002w&\u0019\u0011qB>\u0003\u0011%k\u0007o\u001c:uK\u0016Dq!a\u0005\u0001\t\u0013\t)\"\u0001\u0007cS:$WM\u001d+pW\u0016t7\u000f\u0006\u0004\u0002\u0018\u0005\r\u0012Q\u0006\t\u0004i\u0006e\u0011\u0002BA\u000e\u0003;\u0011a\u0001V8lK:\u001c\u0018bA@\u0002 )\u0019\u0011\u0011E>\u0002\rQ|7.\u001a8t\u0011!\t)#!\u0005A\u0002\u0005\u001d\u0012\u0001\u00023fM:\u0004B!a\u0003\u0002*%\u0019\u00111F>\u0003\t\u0011+gM\u001c\u0005\t\u0003_\t\t\u00021\u0001\u00022\u0005!!m\u001c3z!\u0011\tY!a\r\n\u0007\u0005U2P\u0001\u0003UKJl\u0007bBA\u001d\u0001\u0011%\u00111H\u0001\u0013I\u00164g\u000eV8lK:\u001cHk\u001c*f[>4X\r\u0006\u0003\u0002>\u0005\r\u0003#B\u0019\u0002@\u0005]\u0011bAA!M\t1q\n\u001d;j_:D\u0001\"!\n\u00028\u0001\u0007\u0011q\u0005")
public class RemoveUnused
extends SemanticRule {
    private final RemoveUnusedConfig config;
    private final Pattern unusedPrivateLocalVal;

    public String description() {
        return "Removes unused imports and terms that reported by the compiler under -Ywarn-unused";
    }

    public boolean isRewrite() {
        return true;
    }

    public Configured<Rule> withConfiguration(Configuration config) {
        return !config.scalacOptions().exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("-Ywarn-unused"))) ? Configured$.MODULE$.error(new StringBuilder(117).append("The compiler option -Ywarn-unused is required to use RemoveUnused. ").append("Run `scalac -Ywarn-unused:help` for more details. ").append(new StringBuilder(9).append("Obtained ").append(config.scalacOptions()).toString()).toString()) : config.conf().getOrElse("RemoveUnused", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]), (Object)this.config, RemoveUnusedConfig$.MODULE$.decoder()).map((Function1 & java.io.Serializable & Serializable)x$2 -> new RemoveUnused((RemoveUnusedConfig)x$2));
    }

    public Patch fix(SemanticDocument doc) {
        Set isUnusedTerm = Set$.MODULE$.empty();
        Set isUnusedImport = Set$.MODULE$.empty();
        doc.diagnostics().foreach((Function1 & java.io.Serializable & Serializable)diagnostic -> {
            BoxedUnit boxedUnit;
            if ($this.config.imports()) {
                String string = diagnostic.message();
                String string2 = "Unused import";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    boxedUnit = isUnusedImport.$plus$eq((Object)diagnostic.position());
                    return boxedUnit;
                }
            }
            if ($this.config.privates() && diagnostic.message().startsWith("private") && diagnostic.message().endsWith("is never used")) {
                boxedUnit = isUnusedTerm.$plus$eq((Object)diagnostic.position());
                return boxedUnit;
            }
            if ($this.config.locals() && diagnostic.message().startsWith("local") && diagnostic.message().endsWith("is never used")) {
                boxedUnit = isUnusedTerm.$plus$eq((Object)diagnostic.position());
                return boxedUnit;
            }
            boxedUnit = BoxedUnit.UNIT;
            return boxedUnit;
        });
        return isUnusedImport.isEmpty() && isUnusedTerm.isEmpty() ? scalafix.v1.package$.MODULE$.Patch().empty() : scalafix.v1.package$.MODULE$.XtensionSeqPatch((Iterable)package$.MODULE$.XtensionCollectionLikeUI(doc.tree()).collect((PartialFunction)new Serializable(this, isUnusedTerm, isUnusedImport){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveUnused $outer;
            private final Set isUnusedTerm$1;
            private final Set isUnusedImport$1;

            public final <A1 extends Tree, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Importee importee;
                A1 A1 = x1;
                if (A1 instanceof Importee && this.isUnusedImport$1.apply((Object)this.$outer.scalafix$internal$rule$RemoveUnused$$importPosition(importee = (Importee)A1))) {
                    Patch patch;
                    Importee.Rename rename;
                    Option option;
                    Importee importee2 = importee;
                    if (importee2 instanceof Importee.Rename && !(option = Importee.Rename$.MODULE$.unapply(rename = (Importee.Rename)importee2)).isEmpty()) {
                        Name to = (Name)((Tuple2)option.get())._2();
                        patch = scalafix.v1.package$.MODULE$.Patch().replaceTree((Tree)to, "_").atomic();
                    } else {
                        patch = scalafix.v1.package$.MODULE$.Patch().removeImportee(importee).atomic();
                    }
                    object = patch;
                } else {
                    Defn defn;
                    object = A1 instanceof Defn && this.isUnusedTerm$1.apply((Object)(defn = (Defn)A1).pos()) ? scalafix.v1.package$.MODULE$.XtensionOptionPatch(this.$outer.scalafix$internal$rule$RemoveUnused$$defnTokensToRemove(defn).map((Function1 & java.io.Serializable & Serializable)tokens -> scalafix.v1.package$.MODULE$.Patch().removeTokens(tokens))).asPatch().atomic() : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Tree x1) {
                Defn defn;
                Importee importee;
                Tree tree = x1;
                boolean bl = tree instanceof Importee && this.isUnusedImport$1.apply((Object)this.$outer.scalafix$internal$rule$RemoveUnused$$importPosition(importee = (Importee)tree)) ? true : tree instanceof Defn && this.isUnusedTerm$1.apply((Object)(defn = (Defn)tree).pos());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.isUnusedTerm$1 = isUnusedTerm$1;
                this.isUnusedImport$1 = isUnusedImport$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.meta.tokens.Tokens )}, serializedLambda);
            }
        })).asPatch();
    }

    private Pattern unusedPrivateLocalVal() {
        return this.unusedPrivateLocalVal;
    }

    public boolean isUnusedPrivateDiagnostic(Diagnostic message) {
        return this.unusedPrivateLocalVal().matcher(message.message()).matches();
    }

    public Position scalafix$internal$rule$RemoveUnused$$importPosition(Importee importee) {
        Position position;
        Importee.Rename rename;
        Option option;
        Importee importee2 = importee;
        if (importee2 instanceof Importee.Rename && !(option = Importee.Rename$.MODULE$.unapply(rename = (Importee.Rename)importee2)).isEmpty()) {
            Name from = (Name)((Tuple2)option.get())._1();
            position = from.pos();
        } else {
            position = importee.pos();
        }
        return position;
    }

    private Tokens binderTokens(Defn defn, Term body) {
        int startDef = defn.tokens(Dialect$.MODULE$.current()).start();
        int startBody = body.tokens(Dialect$.MODULE$.current()).start();
        return defn.tokens(Dialect$.MODULE$.current()).take(startBody - startDef);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tokens> scalafix$internal$rule$RemoveUnused$$defnTokensToRemove(Defn defn) {
        Option option;
        Option option2;
        boolean bl = false;
        Defn.Val val = null;
        boolean bl2 = false;
        ObjectRef objectRef = ObjectRef.create(null);
        Defn defn2 = defn;
        if (defn2 instanceof Defn.Val) {
            Lit lit;
            Option option3;
            Term term;
            bl = true;
            val = (Defn.Val)defn2;
            Option option4 = Defn.Val$.MODULE$.unapply(val);
            if (!option4.isEmpty() && (term = (Term)((Tuple4)option4.get())._4()) instanceof Lit && !(option3 = Lit$.MODULE$.unapply(lit = (Lit)term)).isEmpty()) {
                return new Some((Object)val.tokens(Dialect$.MODULE$.current()));
            }
        }
        if (bl && !(option2 = Defn.Val$.MODULE$.unapply(val)).isEmpty()) {
            Term rhs = (Term)((Tuple4)option2.get())._4();
            return new Some((Object)this.binderTokens((Defn)val, rhs));
        }
        if (defn2 instanceof Defn.Var) {
            Lit lit;
            Option option5;
            Some some;
            Term term;
            Option option6;
            bl2 = true;
            objectRef.elem = (Defn.Var)defn2;
            Option option7 = Defn.Var$.MODULE$.unapply((Defn.Var)objectRef.elem);
            if (!option7.isEmpty() && (option6 = (Option)((Tuple4)option7.get())._4()) instanceof Some && (term = (Term)(some = (Some)option6).value()) instanceof Lit && !(option5 = Lit$.MODULE$.unapply(lit = (Lit)term)).isEmpty()) {
                return new Some((Object)((Defn.Var)objectRef.elem).tokens(Dialect$.MODULE$.current()));
            }
        }
        if (bl2 && !(option = Defn.Var$.MODULE$.unapply((Defn.Var)objectRef.elem)).isEmpty()) {
            Option rhs = (Option)((Tuple4)option.get())._4();
            return rhs.map((Function1 & java.io.Serializable & Serializable)x$3 -> this.binderTokens((Defn)((Defn.Var)x16$1.elem), (Term)x$3));
        }
        if (!(defn2 instanceof Defn.Def)) return None$.MODULE$;
        Defn.Def def = (Defn.Def)defn2;
        return new Some((Object)def.tokens(Dialect$.MODULE$.current()));
    }

    public RemoveUnused(RemoveUnusedConfig config) {
        this.config = config;
        super(scalafix.v1.package$.MODULE$.RuleName().apply("RemoveUnused").withDeprecatedName("RemoveUnusedImports", "Use RemoveUnused instead", "0.6.0").withDeprecatedName("RemoveUnusedTerms", "Use RemoveUnused instead", "0.6.0"));
        this.unusedPrivateLocalVal = Pattern.compile("(local|private) (.*) is never used");
    }

    public RemoveUnused() {
        this(RemoveUnusedConfig$.MODULE$.default());
    }
}

