/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.rule;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import metaconfig.Configured;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.meta.Defn;
import scala.meta.Mod;
import scala.meta.Stat;
import scala.meta.Term;
import scala.meta.Tree;
import scala.meta.Tree$;
import scala.meta.inputs.Position;
import scala.meta.tokens.Token;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalafix.config.Regex;
import scalafix.internal.rule.DisableSyntax$;
import scalafix.internal.rule.DisableSyntax$AbstractWithVals$2$;
import scalafix.internal.rule.DisableSyntax$DefaultArgs$2$;
import scalafix.internal.rule.DisableSyntax$NoValPatterns$2$;
import scalafix.internal.rule.DisableSyntaxConfig;
import scalafix.internal.rule.DisableSyntaxConfig$;
import scalafix.internal.rule.Keyword$;
import scalafix.lint.Diagnostic;
import scalafix.patch.Patch;
import scalafix.rule.RuleName$;
import scalafix.v0.LintCategory;
import scalafix.v0.LintCategory$;
import scalafix.v1.Configuration;
import scalafix.v1.Rule;
import scalafix.v1.SyntacticDocument;
import scalafix.v1.SyntacticRule;

public final class DisableSyntax
extends SyntacticRule {
    public final DisableSyntaxConfig scalafix$internal$rule$DisableSyntax$$config;
    public final LintCategory scalafix$internal$rule$DisableSyntax$$noFinalVal;
    public final LintCategory scalafix$internal$rule$DisableSyntax$$noValPatternCategory;

    public static PartialFunction<Tree, List<Diagnostic>> FinalizeMatcher(String string) {
        return DisableSyntax$.MODULE$.FinalizeMatcher(string);
    }

    public DisableSyntax(DisableSyntaxConfig config) {
        this.scalafix$internal$rule$DisableSyntax$$config = config;
        super(RuleName$.MODULE$.stringToRuleName("DisableSyntax"));
        this.scalafix$internal$rule$DisableSyntax$$noFinalVal = LintCategory$.MODULE$.error("noFinalVal", "Final vals cause problems with incremental compilation");
        this.scalafix$internal$rule$DisableSyntax$$noValPatternCategory = LintCategory$.MODULE$.error("noValPatterns", "Pattern matching in val assignment can result in match error, use \"_ match { ... }\" with a fallback case instead.");
    }

    public DisableSyntax() {
        this(DisableSyntaxConfig$.MODULE$.apply(DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$1(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$2(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$3(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$4(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$5(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$6(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$7(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$8(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$9(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$10(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$11(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$12(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$13(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$14(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$15(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$16(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$17(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$18(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$19(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$20(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$21(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$22(), DisableSyntaxConfig$.MODULE$.$lessinit$greater$default$23()));
    }

    public String description() {
        return "Reports an error for disabled features such as var or XML literals.";
    }

    public boolean isLinter() {
        return true;
    }

    public Configured<Rule> withConfiguration(Configuration config) {
        return config.conf().getOrElse("disableSyntax", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DisableSyntax"}), (Object)DisableSyntaxConfig$.MODULE$.default(), DisableSyntaxConfig$.MODULE$.decoder()).map((Function1 & Serializable)_$1 -> new DisableSyntax((DisableSyntaxConfig)_$1));
    }

    private Seq<Diagnostic> checkRegex(SyntacticDocument doc) {
        Builder regexDiagnostics = package$.MODULE$.Seq().newBuilder();
        this.scalafix$internal$rule$DisableSyntax$$config.regex().foreach((Function1)(JProcedure1 & Serializable)regex -> {
            Tuple3 tuple3;
            Either either = (Either)regex.value();
            if (either instanceof Right) {
                Pattern pat = (Pattern)((Right)either).value();
                tuple3 = Tuple3$.MODULE$.apply((Object)pat.matcher(CharBuffer.wrap(doc.input().chars())), (Object)pat.pattern(), (Object)BoxesRunTime.boxToInteger((int)0));
            } else if (either instanceof Left) {
                Regex reg = (Regex)((Left)either).value();
                Pattern pattern = reg.pattern();
                int groupIndex = BoxesRunTime.unboxToInt((Object)reg.captureGroup().getOrElse(DisableSyntax::$anonfun$1));
                tuple3 = Tuple3$.MODULE$.apply((Object)pattern.matcher(CharBuffer.wrap(doc.input().chars())), (Object)pattern.pattern(), (Object)BoxesRunTime.boxToInteger((int)groupIndex));
            } else {
                throw new MatchError((Object)either);
            }
            Tuple3 tuple32 = tuple3;
            Matcher matcher = (Matcher)tuple32._1();
            String pattern = (String)tuple32._2();
            int groupIndex = BoxesRunTime.unboxToInt((Object)tuple32._3());
            String message = (String)regex.message().getOrElse(() -> DisableSyntax.$anonfun$2(pattern));
            while (matcher.find()) {
                regexDiagnostics.$plus$eq((Object)scalafix.v1.package$.MODULE$.Diagnostic().apply((String)regex.id().getOrElse(() -> DisableSyntax.checkRegex$$anonfun$1$$anonfun$1(pattern)), DisableSyntax.messageSubstitution$1(matcher, message), DisableSyntax.pos$1(doc, matcher, groupIndex), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5()));
            }
        });
        return (Seq)regexDiagnostics.result();
    }

    private Seq<Diagnostic> checkTokens(SyntacticDocument doc) {
        return (Seq)doc.tree().tokens().collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ DisableSyntax $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Token x) {
                Option<String> option;
                Token token = x;
                if (token != null && !(option = Keyword$.MODULE$.unapply(token)).isEmpty()) {
                    String string;
                    String keyword = string = (String)option.get();
                    Token token2 = token;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.isDisabled(keyword)) {
                        return true;
                    }
                }
                if (token instanceof Token.Semicolon) {
                    Token.Semicolon semicolon = (Token.Semicolon)token;
                    if (scala.meta.package$.MODULE$.Token().Semicolon().unapply(semicolon)) {
                        Token.Semicolon token3 = semicolon;
                        if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noSemicolons()) {
                            return true;
                        }
                    }
                }
                if (token instanceof Token.Tab) {
                    Token.Tab tab = (Token.Tab)token;
                    if (scala.meta.package$.MODULE$.Token().Tab().unapply(tab)) {
                        Token.Tab token4 = tab;
                        if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noTabs()) {
                            return true;
                        }
                    }
                }
                if (token instanceof Token.Xml$.Start) {
                    Token.Xml$.Start start = (Token.Xml$.Start)token;
                    if (scala.meta.package$.MODULE$.Token().Xml().Start().unapply(start)) {
                        Token.Xml$.Start token5 = start;
                        if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noXml()) {
                            return true;
                        }
                    }
                }
                if (token instanceof Token.Ident) {
                    Token.Ident ident;
                    Token.Ident token6 = ident = (Token.Ident)token;
                    String string = token6.value();
                    String string2 = "asInstanceOf";
                    if (!(string != null ? !string.equals(string2) : string2 != null) && this.$outer.scalafix$internal$rule$DisableSyntax$$config.noAsInstanceOf()) {
                        return true;
                    }
                    Token.Ident token7 = ident;
                    String string3 = token7.value();
                    String string4 = "isInstanceOf";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null) && this.$outer.scalafix$internal$rule$DisableSyntax$$config.noIsInstanceOf()) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Token x, Function1 function1) {
                Option<String> option;
                Token token = x;
                if (token != null && !(option = Keyword$.MODULE$.unapply(token)).isEmpty()) {
                    String string;
                    String keyword = string = (String)option.get();
                    Token token2 = token;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.isDisabled(keyword)) {
                        String string2 = keyword;
                        switch (string2 == null ? 0 : string2.hashCode()) {
                            case -934396624: {
                                if (!"return".equals(string2)) break;
                                return scalafix.v1.package$.MODULE$.Diagnostic().apply(keyword, "return should be avoided, consider using if/else instead", token2.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                            }
                            case 116519: {
                                if (!"var".equals(string2)) break;
                                return scalafix.v1.package$.MODULE$.Diagnostic().apply(keyword, "mutable state should be avoided", token2.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                            }
                            case 3392903: {
                                if (!"null".equals(string2)) break;
                                return scalafix.v1.package$.MODULE$.Diagnostic().apply(keyword, "null should be avoided, consider using Option instead", token2.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                            }
                            case 110339814: {
                                if (!"throw".equals(string2)) break;
                                return scalafix.v1.package$.MODULE$.Diagnostic().apply(keyword, "exceptions should be avoided, consider encoding the error in the return type instead", token2.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                            }
                            case 113101617: {
                                if (!"while".equals(string2)) break;
                                return scalafix.v1.package$.MODULE$.Diagnostic().apply(keyword, "while loops should be avoided, consider using recursion instead", token2.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                            }
                        }
                        return scalafix.v1.package$.MODULE$.Diagnostic().apply(keyword, new StringBuilder(12).append(keyword).append(" is disabled").toString(), token2.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                    }
                }
                if (token instanceof Token.Semicolon) {
                    Token.Semicolon semicolon = (Token.Semicolon)token;
                    if (scala.meta.package$.MODULE$.Token().Semicolon().unapply(semicolon)) {
                        Token.Semicolon token3 = semicolon;
                        if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noSemicolons()) {
                            return scalafix.v1.package$.MODULE$.Diagnostic().apply("noSemicolons", "semicolons are disabled", token3.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                        }
                    }
                }
                if (token instanceof Token.Tab) {
                    Token.Tab tab = (Token.Tab)token;
                    if (scala.meta.package$.MODULE$.Token().Tab().unapply(tab)) {
                        Token.Tab token4 = tab;
                        if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noTabs()) {
                            return scalafix.v1.package$.MODULE$.Diagnostic().apply("noTabs", "tabs are disabled", token4.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                        }
                    }
                }
                if (token instanceof Token.Xml$.Start) {
                    Token.Xml$.Start start = (Token.Xml$.Start)token;
                    if (scala.meta.package$.MODULE$.Token().Xml().Start().unapply(start)) {
                        Token.Xml$.Start token5 = start;
                        if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noXml()) {
                            return scalafix.v1.package$.MODULE$.Diagnostic().apply("noXml", "xml literals should be avoided", token5.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                        }
                    }
                }
                if (token instanceof Token.Ident) {
                    Token.Ident ident;
                    Token.Ident token6 = ident = (Token.Ident)token;
                    String string = token6.value();
                    String string3 = "asInstanceOf";
                    if (!(string != null ? !string.equals(string3) : string3 != null) && this.$outer.scalafix$internal$rule$DisableSyntax$$config.noAsInstanceOf()) {
                        return scalafix.v1.package$.MODULE$.Diagnostic().apply("asInstanceOf", "asInstanceOf casts are disabled, use pattern matching instead", token6.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                    }
                    Token.Ident token7 = ident;
                    String string4 = token7.value();
                    String string5 = "isInstanceOf";
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null) && this.$outer.scalafix$internal$rule$DisableSyntax$$config.noIsInstanceOf()) {
                        return scalafix.v1.package$.MODULE$.Diagnostic().apply("isInstanceOf", "isInstanceOf checks are disabled, use pattern matching instead", token7.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
                    }
                }
                return function1.apply((Object)x);
            }
        });
    }

    private Seq<Diagnostic> checkTree(SyntacticDocument doc) {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        LazyRef lazyRef3 = new LazyRef();
        Serializable DefaultMatcher = new Serializable(lazyRef3, lazyRef, lazyRef2, this){
            private final LazyRef NoValPatterns$lzy1$3;
            private final LazyRef AbstractWithVals$lzy1$3;
            private final LazyRef DefaultArgs$lzy1$3;
            private final /* synthetic */ DisableSyntax $outer;
            {
                this.NoValPatterns$lzy1$3 = NoValPatterns$lzy1$4;
                this.AbstractWithVals$lzy1$3 = AbstractWithVals$lzy1$4;
                this.DefaultArgs$lzy1$3 = DefaultArgs$lzy1$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tree x) {
                String string;
                Option option;
                Tuple2 tuple2;
                Term.Name name;
                Option option2;
                Tuple2 tuple22;
                Term term;
                Option option3;
                String string2;
                Option option4;
                Tuple4 tuple4;
                Term.Name name2;
                Option option5;
                String string3;
                Option option6;
                Tuple2 tuple23;
                Term.Name name3;
                Option option7;
                Tuple2 tuple24;
                Term term2;
                Option option8;
                String string4;
                Option option9;
                Tuple4 tuple42;
                Term.Name name4;
                Option option10;
                Option option11;
                Defn.Def def;
                Option option12;
                Defn.Object object;
                Option option13;
                Option option14;
                Mod.Contravariant contravariant;
                Mod.Covariant covariant;
                Option option15;
                Option option16;
                Tree tree = x;
                if (tree instanceof Defn.Val && !(option16 = Defn.Val$.MODULE$.unapply((Defn.Val)tree)).isEmpty()) {
                    Tuple4 tuple43 = (Tuple4)option16.get();
                    List mods = (List)tuple43._1();
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noFinalVal() && mods.exists(DisableSyntax::scalafix$internal$rule$DisableSyntax$$anon$2$$_$isDefinedAt$$anonfun$1)) {
                        return true;
                    }
                }
                if (tree != null && !(option15 = DisableSyntax.scalafix$internal$rule$DisableSyntax$$_$NoValPatterns$1(this.NoValPatterns$lzy1$3).unapply(tree)).isEmpty()) {
                    Tree tree2;
                    Tree v = tree2 = (Tree)option15.get();
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noValPatterns()) {
                        return true;
                    }
                }
                if (tree instanceof Mod.Covariant && Mod.Covariant$.MODULE$.unapply(covariant = (Mod.Covariant)tree)) {
                    Mod.Covariant t = covariant;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noCovariantTypes()) {
                        return true;
                    }
                }
                if (tree instanceof Mod.Contravariant && Mod.Contravariant$.MODULE$.unapply(contravariant = (Mod.Contravariant)tree)) {
                    Mod.Contravariant t = contravariant;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noContravariantTypes()) {
                        return true;
                    }
                }
                if (tree != null && !(option14 = DisableSyntax.scalafix$internal$rule$DisableSyntax$$_$AbstractWithVals$1(this.AbstractWithVals$lzy1$3).unapply(tree)).isEmpty()) {
                    List list;
                    List vals = list = (List)option14.get();
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noValInAbstract()) {
                        return true;
                    }
                }
                if (tree instanceof Defn.Object && !(option13 = Defn.Object$.MODULE$.unapply(object = (Defn.Object)tree)).isEmpty()) {
                    Tuple3 tuple3 = (Tuple3)option13.get();
                    List mods = (List)tuple3._1();
                    Defn.Object t = object;
                    if (mods.exists(DisableSyntax::scalafix$internal$rule$DisableSyntax$$anon$2$$_$isDefinedAt$$anonfun$2) && this.$outer.scalafix$internal$rule$DisableSyntax$$config.noImplicitObject()) {
                        return true;
                    }
                }
                if (tree instanceof Defn.Def && !(option12 = Defn.Def$.MODULE$.unapply(def = (Defn.Def)tree)).isEmpty()) {
                    Tuple6 tuple6 = (Tuple6)option12.get();
                    List mods = (List)tuple6._1();
                    Defn.Def t = def;
                    if (mods.exists(DisableSyntax::scalafix$internal$rule$DisableSyntax$$anon$2$$_$isDefinedAt$$anonfun$3) && DisableSyntax.scalafix$internal$rule$DisableSyntax$$_$hasNonImplicitParam$1(t) && this.$outer.scalafix$internal$rule$DisableSyntax$$config.noImplicitConversion()) {
                        return true;
                    }
                }
                if (tree != null && !(option11 = DisableSyntax.scalafix$internal$rule$DisableSyntax$$_$DefaultArgs$1(this.DefaultArgs$lzy1$3).unapply(tree)).isEmpty()) {
                    List list;
                    List params = list = (List)option11.get();
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noDefaultArgs()) {
                        return true;
                    }
                }
                if (tree instanceof Term.ApplyInfix && !(option10 = Term.ApplyInfix$.MODULE$.unapply((Term.ApplyInfix)tree)).isEmpty() && (name4 = (Term.Name)(tuple42 = (Tuple4)option10.get())._2()) != null && !(option9 = Term.Name$.MODULE$.unapply(name4)).isEmpty() && "==".equals(string4 = (String)option9.get())) {
                    Term.Name t = name4;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noUniversalEquality()) {
                        return true;
                    }
                }
                if (tree instanceof Term.Apply && !(option8 = Term.Apply$.MODULE$.unapply((Term.Apply)tree)).isEmpty() && (term2 = (Term)(tuple24 = (Tuple2)option8.get())._1()) instanceof Term.Select && !(option7 = Term.Select$.MODULE$.unapply((Term.Select)term2)).isEmpty() && (name3 = (Term.Name)(tuple23 = (Tuple2)option7.get())._2()) != null && !(option6 = Term.Name$.MODULE$.unapply(name3)).isEmpty() && "==".equals(string3 = (String)option6.get())) {
                    Term.Name t = name3;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noUniversalEquality()) {
                        return true;
                    }
                }
                if (tree instanceof Term.ApplyInfix && !(option5 = Term.ApplyInfix$.MODULE$.unapply((Term.ApplyInfix)tree)).isEmpty() && (name2 = (Term.Name)(tuple4 = (Tuple4)option5.get())._2()) != null && !(option4 = Term.Name$.MODULE$.unapply(name2)).isEmpty() && "!=".equals(string2 = (String)option4.get())) {
                    Term.Name t = name2;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noUniversalEquality()) {
                        return true;
                    }
                }
                if (tree instanceof Term.Apply && !(option3 = Term.Apply$.MODULE$.unapply((Term.Apply)tree)).isEmpty() && (term = (Term)(tuple22 = (Tuple2)option3.get())._1()) instanceof Term.Select && !(option2 = Term.Select$.MODULE$.unapply((Term.Select)term)).isEmpty() && (name = (Term.Name)(tuple2 = (Tuple2)option2.get())._2()) != null && !(option = Term.Name$.MODULE$.unapply(name)).isEmpty() && "!=".equals(string = (String)option.get())) {
                    Term.Name t = name;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noUniversalEquality()) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tree x, Function1 function1) {
                String string;
                Option option;
                Tuple2 tuple2;
                Term.Name name;
                Option option2;
                Tuple2 tuple22;
                Term term;
                Option option3;
                String string2;
                Option option4;
                Tuple4 tuple4;
                Term.Name name2;
                Option option5;
                String string3;
                Option option6;
                Tuple2 tuple23;
                Term.Name name3;
                Option option7;
                Tuple2 tuple24;
                Term term2;
                Option option8;
                String string4;
                Option option9;
                Tuple4 tuple42;
                Term.Name name4;
                Option option10;
                Option option11;
                Defn.Def def;
                Option option12;
                Defn.Object object;
                Option option13;
                Option option14;
                Mod.Contravariant contravariant;
                Mod.Covariant covariant;
                Option option15;
                Option option16;
                Tree tree = x;
                if (tree instanceof Defn.Val && !(option16 = Defn.Val$.MODULE$.unapply((Defn.Val)tree)).isEmpty()) {
                    Tuple4 tuple43 = (Tuple4)option16.get();
                    List mods = (List)tuple43._1();
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noFinalVal() && mods.exists(DisableSyntax::scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$1)) {
                        Mod mod = (Mod)mods.find(DisableSyntax::scalafix$internal$rule$DisableSyntax$$anon$2$$_$_$$anonfun$6).get();
                        return (SeqOps)new .colon.colon((Object)this.$outer.scalafix$internal$rule$DisableSyntax$$noFinalVal.at(mod.pos()), (List)Nil$.MODULE$);
                    }
                }
                if (tree != null && !(option15 = DisableSyntax.scalafix$internal$rule$DisableSyntax$$_$NoValPatterns$1(this.NoValPatterns$lzy1$3).unapply(tree)).isEmpty()) {
                    Tree tree2;
                    Tree v = tree2 = (Tree)option15.get();
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noValPatterns()) {
                        return (SeqOps)new .colon.colon((Object)this.$outer.scalafix$internal$rule$DisableSyntax$$noValPatternCategory.at(v.pos()), (List)Nil$.MODULE$);
                    }
                }
                if (tree instanceof Mod.Covariant && Mod.Covariant$.MODULE$.unapply(covariant = (Mod.Covariant)tree)) {
                    Mod.Covariant t = covariant;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noCovariantTypes()) {
                        return (SeqOps)new .colon.colon((Object)scalafix.v1.package$.MODULE$.Diagnostic().apply("covariant", "Covariant types could lead to error-prone situations", t.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5()), (List)Nil$.MODULE$);
                    }
                }
                if (tree instanceof Mod.Contravariant && Mod.Contravariant$.MODULE$.unapply(contravariant = (Mod.Contravariant)tree)) {
                    Mod.Contravariant t = contravariant;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noContravariantTypes()) {
                        return (SeqOps)new .colon.colon((Object)scalafix.v1.package$.MODULE$.Diagnostic().apply("contravariant", "Contravariant types could lead to error-prone situations", t.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5()), (List)Nil$.MODULE$);
                    }
                }
                if (tree != null && !(option14 = DisableSyntax.scalafix$internal$rule$DisableSyntax$$_$AbstractWithVals$1(this.AbstractWithVals$lzy1$3).unapply(tree)).isEmpty()) {
                    List list;
                    List vals = list = (List)option14.get();
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noValInAbstract()) {
                        return vals.map(DisableSyntax::scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$2);
                    }
                }
                if (tree instanceof Defn.Object && !(option13 = Defn.Object$.MODULE$.unapply(object = (Defn.Object)tree)).isEmpty()) {
                    Tuple3 tuple3 = (Tuple3)option13.get();
                    List mods = (List)tuple3._1();
                    Defn.Object t = object;
                    if (mods.exists(DisableSyntax::scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$3) && this.$outer.scalafix$internal$rule$DisableSyntax$$config.noImplicitObject()) {
                        return (SeqOps)new .colon.colon((Object)scalafix.v1.package$.MODULE$.Diagnostic().apply("implicitObject", "implicit objects may cause implicit resolution errors", t.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5()), (List)Nil$.MODULE$);
                    }
                }
                if (tree instanceof Defn.Def && !(option12 = Defn.Def$.MODULE$.unapply(def = (Defn.Def)tree)).isEmpty()) {
                    Tuple6 tuple6 = (Tuple6)option12.get();
                    List mods = (List)tuple6._1();
                    Defn.Def t = def;
                    if (mods.exists(DisableSyntax::scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$4) && DisableSyntax.scalafix$internal$rule$DisableSyntax$$_$hasNonImplicitParam$1(t) && this.$outer.scalafix$internal$rule$DisableSyntax$$config.noImplicitConversion()) {
                        return (SeqOps)new .colon.colon((Object)scalafix.v1.package$.MODULE$.Diagnostic().apply("implicitConversion", "implicit conversions weaken type safety and always can be replaced by explicit conversions", t.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5()), (List)Nil$.MODULE$);
                    }
                }
                if (tree != null && !(option11 = DisableSyntax.scalafix$internal$rule$DisableSyntax$$_$DefaultArgs$1(this.DefaultArgs$lzy1$3).unapply(tree)).isEmpty()) {
                    List list;
                    List params = list = (List)option11.get();
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noDefaultArgs()) {
                        return params.map(DisableSyntax::scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$5);
                    }
                }
                if (tree instanceof Term.ApplyInfix && !(option10 = Term.ApplyInfix$.MODULE$.unapply((Term.ApplyInfix)tree)).isEmpty() && (name4 = (Term.Name)(tuple42 = (Tuple4)option10.get())._2()) != null && !(option9 = Term.Name$.MODULE$.unapply(name4)).isEmpty() && "==".equals(string4 = (String)option9.get())) {
                    Term.Name t = name4;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noUniversalEquality()) {
                        return (SeqOps)new .colon.colon((Object)this.$outer.scalafix$internal$rule$DisableSyntax$$noUniversalEqualityDiagnostic("==", t), (List)Nil$.MODULE$);
                    }
                }
                if (tree instanceof Term.Apply && !(option8 = Term.Apply$.MODULE$.unapply((Term.Apply)tree)).isEmpty() && (term2 = (Term)(tuple24 = (Tuple2)option8.get())._1()) instanceof Term.Select && !(option7 = Term.Select$.MODULE$.unapply((Term.Select)term2)).isEmpty() && (name3 = (Term.Name)(tuple23 = (Tuple2)option7.get())._2()) != null && !(option6 = Term.Name$.MODULE$.unapply(name3)).isEmpty() && "==".equals(string3 = (String)option6.get())) {
                    Term.Name t = name3;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noUniversalEquality()) {
                        return (SeqOps)new .colon.colon((Object)this.$outer.scalafix$internal$rule$DisableSyntax$$noUniversalEqualityDiagnostic("==", t), (List)Nil$.MODULE$);
                    }
                }
                if (tree instanceof Term.ApplyInfix && !(option5 = Term.ApplyInfix$.MODULE$.unapply((Term.ApplyInfix)tree)).isEmpty() && (name2 = (Term.Name)(tuple4 = (Tuple4)option5.get())._2()) != null && !(option4 = Term.Name$.MODULE$.unapply(name2)).isEmpty() && "!=".equals(string2 = (String)option4.get())) {
                    Term.Name t = name2;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noUniversalEquality()) {
                        return (SeqOps)new .colon.colon((Object)this.$outer.scalafix$internal$rule$DisableSyntax$$noUniversalEqualityDiagnostic("!=", t), (List)Nil$.MODULE$);
                    }
                }
                if (tree instanceof Term.Apply && !(option3 = Term.Apply$.MODULE$.unapply((Term.Apply)tree)).isEmpty() && (term = (Term)(tuple22 = (Tuple2)option3.get())._1()) instanceof Term.Select && !(option2 = Term.Select$.MODULE$.unapply((Term.Select)term)).isEmpty() && (name = (Term.Name)(tuple2 = (Tuple2)option2.get())._2()) != null && !(option = Term.Name$.MODULE$.unapply(name)).isEmpty() && "!=".equals(string = (String)option.get())) {
                    Term.Name t = name;
                    if (this.$outer.scalafix$internal$rule$DisableSyntax$$config.noUniversalEquality()) {
                        return (SeqOps)new .colon.colon((Object)this.$outer.scalafix$internal$rule$DisableSyntax$$noUniversalEqualityDiagnostic("!=", t), (List)Nil$.MODULE$);
                    }
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{scalafix$internal$rule$DisableSyntax$$anon$2$$_$isDefinedAt$$anonfun$1(scala.meta.Mod ), scalafix$internal$rule$DisableSyntax$$anon$2$$_$isDefinedAt$$anonfun$2(scala.meta.Mod ), scalafix$internal$rule$DisableSyntax$$anon$2$$_$isDefinedAt$$anonfun$3(scala.meta.Mod ), scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$1(scala.meta.Mod ), scalafix$internal$rule$DisableSyntax$$anon$2$$_$_$$anonfun$6(scala.meta.Mod ), scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$2(scala.meta.Defn$Val ), scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$3(scala.meta.Mod ), scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$4(scala.meta.Mod ), scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$5(scala.meta.Term )}, serializedLambda);
            }
        };
        PartialFunction<Tree, List<Diagnostic>> FinalizeMatcher = DisableSyntax$.MODULE$.FinalizeMatcher("noFinalize");
        return (Seq)scala.meta.package$.MODULE$.XtensionCollectionLikeUI(doc.tree()).collect(DefaultMatcher.orElse(FinalizeMatcher)).flatten(Predef$.MODULE$.$conforms());
    }

    public Patch fix(SyntacticDocument doc) {
        return scalafix.v1.package$.MODULE$.XtensionSeqPatch((Iterable)((IterableOps)((IterableOps)this.checkTree(doc).$plus$plus(this.checkTokens(doc))).$plus$plus(this.checkRegex(doc))).map((Function1 & Serializable)msg -> scalafix.v1.package$.MODULE$.Patch().lint(msg))).asPatch();
    }

    public Diagnostic scalafix$internal$rule$DisableSyntax$$noUniversalEqualityDiagnostic(String symbol, Term.Name t) {
        return scalafix.v1.package$.MODULE$.Diagnostic().apply(symbol, this.scalafix$internal$rule$DisableSyntax$$config.noUniversalEqualityMessage(), t.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
    }

    private static final Position pos$1(SyntacticDocument doc$1, Matcher matcher, int groupIndex) {
        if (matcher.group(groupIndex) == null) {
            return scala.meta.package$.MODULE$.Position().Range().apply(doc$1.input(), matcher.start(), matcher.end());
        }
        return scala.meta.package$.MODULE$.Position().Range().apply(doc$1.input(), matcher.start(groupIndex), matcher.end(groupIndex));
    }

    private static final /* synthetic */ String messageSubstitution$1$$anonfun$1(Matcher matcher$1, String x$1, int x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToInteger((int)x$2));
        if (tuple2 != null) {
            String msg = (String)tuple2._1();
            int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
            String groupText = matcher$1.group(idx);
            if (groupText != null) {
                return msg.replace(new StringBuilder(3).append("{$").append(idx).append("}").toString(), matcher$1.group(idx));
            }
            return msg;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String messageSubstitution$1(Matcher matcher, String message) {
        return (String)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), matcher.groupCount()).foldLeft((Object)message, (Function2 & Serializable)(x$1, x$2) -> DisableSyntax.messageSubstitution$1$$anonfun$1(matcher, (String)x$1, BoxesRunTime.unboxToInt((Object)x$2)));
    }

    private static final int $anonfun$1() {
        return 0;
    }

    private static final String $anonfun$2(String pattern$1) {
        return new StringBuilder(12).append(pattern$1).append(" is disabled").toString();
    }

    private static final String checkRegex$$anonfun$1$$anonfun$1(String pattern$2) {
        return pattern$2;
    }

    private static final DisableSyntax$AbstractWithVals$2$ AbstractWithVals$lzyINIT1$1(LazyRef AbstractWithVals$lzy1$1) {
        DisableSyntax$AbstractWithVals$2$ disableSyntax$AbstractWithVals$2$;
        LazyRef lazyRef = AbstractWithVals$lzy1$1;
        synchronized (lazyRef) {
            disableSyntax$AbstractWithVals$2$ = (DisableSyntax$AbstractWithVals$2$)(AbstractWithVals$lzy1$1.initialized() ? AbstractWithVals$lzy1$1.value() : AbstractWithVals$lzy1$1.initialize((Object)new DisableSyntax$AbstractWithVals$2$()));
        }
        return disableSyntax$AbstractWithVals$2$;
    }

    public static final DisableSyntax$AbstractWithVals$2$ scalafix$internal$rule$DisableSyntax$$_$AbstractWithVals$1(LazyRef AbstractWithVals$lzy1$2) {
        return (DisableSyntax$AbstractWithVals$2$)(AbstractWithVals$lzy1$2.initialized() ? AbstractWithVals$lzy1$2.value() : DisableSyntax.AbstractWithVals$lzyINIT1$1(AbstractWithVals$lzy1$2));
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$DisableSyntax$AbstractWithVals$2$$$_$_$$anonfun$3(Mod _$2) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)_$2, Tree$.MODULE$.classifiable()).is(Mod.Abstract$.MODULE$.ClassifierClass());
    }

    public static final /* synthetic */ IterableOnce scalafix$internal$rule$DisableSyntax$AbstractWithVals$2$$$_$_$$anonfun$4(Stat x$1) {
        Stat stat = x$1;
        if (stat instanceof Defn.Val) {
            Defn.Val v = (Defn.Val)stat;
            return Some$.MODULE$.apply((Object)v);
        }
        return None$.MODULE$;
    }

    private static final DisableSyntax$DefaultArgs$2$ DefaultArgs$lzyINIT1$1(LazyRef DefaultArgs$lzy1$1) {
        DisableSyntax$DefaultArgs$2$ disableSyntax$DefaultArgs$2$;
        LazyRef lazyRef = DefaultArgs$lzy1$1;
        synchronized (lazyRef) {
            disableSyntax$DefaultArgs$2$ = (DisableSyntax$DefaultArgs$2$)(DefaultArgs$lzy1$1.initialized() ? DefaultArgs$lzy1$1.value() : DefaultArgs$lzy1$1.initialize((Object)new DisableSyntax$DefaultArgs$2$()));
        }
        return disableSyntax$DefaultArgs$2$;
    }

    public static final DisableSyntax$DefaultArgs$2$ scalafix$internal$rule$DisableSyntax$$_$DefaultArgs$1(LazyRef DefaultArgs$lzy1$2) {
        return (DisableSyntax$DefaultArgs$2$)(DefaultArgs$lzy1$2.initialized() ? DefaultArgs$lzy1$2.value() : DisableSyntax.DefaultArgs$lzyINIT1$1(DefaultArgs$lzy1$2));
    }

    public static final /* synthetic */ IterableOnce scalafix$internal$rule$DisableSyntax$DefaultArgs$2$$$_$_$$anonfun$5(List params) {
        return params.flatMap((Function1 & Serializable)param -> param.default().toList().map((Function1 & Serializable)term -> term));
    }

    private static final DisableSyntax$NoValPatterns$2$ NoValPatterns$lzyINIT1$1(LazyRef NoValPatterns$lzy1$1) {
        DisableSyntax$NoValPatterns$2$ disableSyntax$NoValPatterns$2$;
        LazyRef lazyRef = NoValPatterns$lzy1$1;
        synchronized (lazyRef) {
            disableSyntax$NoValPatterns$2$ = (DisableSyntax$NoValPatterns$2$)(NoValPatterns$lzy1$1.initialized() ? NoValPatterns$lzy1$1.value() : NoValPatterns$lzy1$1.initialize((Object)new DisableSyntax$NoValPatterns$2$()));
        }
        return disableSyntax$NoValPatterns$2$;
    }

    public static final DisableSyntax$NoValPatterns$2$ scalafix$internal$rule$DisableSyntax$$_$NoValPatterns$1(LazyRef NoValPatterns$lzy1$2) {
        return (DisableSyntax$NoValPatterns$2$)(NoValPatterns$lzy1$2.initialized() ? NoValPatterns$lzy1$2.value() : DisableSyntax.NoValPatterns$lzyINIT1$1(NoValPatterns$lzy1$2));
    }

    public static final boolean scalafix$internal$rule$DisableSyntax$$_$hasNonImplicitParam$1(Defn.Def d) {
        return d.paramss().exists((Function1 & Serializable)_$3 -> _$3.exists((Function1 & Serializable)_$4 -> _$4.mods().forall((Function1 & Serializable)_$5 -> !scala.meta.package$.MODULE$.XtensionClassifiable(_$5, Tree$.MODULE$.classifiable()).is(Mod.Implicit$.MODULE$.ClassifierClass()))));
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$DisableSyntax$$anon$2$$_$isDefinedAt$$anonfun$1(Mod _$6) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)_$6, Tree$.MODULE$.classifiable()).is(Mod.Final$.MODULE$.ClassifierClass());
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$DisableSyntax$$anon$2$$_$isDefinedAt$$anonfun$2(Mod _$8) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)_$8, Tree$.MODULE$.classifiable()).is(Mod.Implicit$.MODULE$.ClassifierClass());
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$DisableSyntax$$anon$2$$_$isDefinedAt$$anonfun$3(Mod _$9) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)_$9, Tree$.MODULE$.classifiable()).is(Mod.Implicit$.MODULE$.ClassifierClass());
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$1(Mod _$6) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)_$6, Tree$.MODULE$.classifiable()).is(Mod.Final$.MODULE$.ClassifierClass());
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$DisableSyntax$$anon$2$$_$_$$anonfun$6(Mod _$7) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)_$7, Tree$.MODULE$.classifiable()).is(Mod.Final$.MODULE$.ClassifierClass());
    }

    public static final /* synthetic */ Diagnostic scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$2(Defn.Val v) {
        return scalafix.v1.package$.MODULE$.Diagnostic().apply("valInAbstract", "val definitions in traits/abstract classes may cause initialization bugs", v.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$3(Mod _$8) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)_$8, Tree$.MODULE$.classifiable()).is(Mod.Implicit$.MODULE$.ClassifierClass());
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$4(Mod _$9) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)_$9, Tree$.MODULE$.classifiable()).is(Mod.Implicit$.MODULE$.ClassifierClass());
    }

    public static final /* synthetic */ Diagnostic scalafix$internal$rule$DisableSyntax$$anon$2$$_$applyOrElse$$anonfun$5(Term m) {
        return scalafix.v1.package$.MODULE$.Diagnostic().apply("defaultArgs", "Default args makes it hard to use methods as functions.", m.pos(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$4(), scalafix.v1.package$.MODULE$.Diagnostic().apply$default$5());
    }
}

