/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.rule;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import metaconfig.Configured;
import metaconfig.Configured$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.meta.Case;
import scala.meta.Case$;
import scala.meta.Defn;
import scala.meta.Importee;
import scala.meta.Importer;
import scala.meta.Importer$;
import scala.meta.Lit;
import scala.meta.Lit$;
import scala.meta.Name;
import scala.meta.Pat;
import scala.meta.Term;
import scala.meta.Tree;
import scala.meta.Tree$;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.tokens.Token;
import scala.meta.tokens.Token$;
import scala.meta.tokens.Tokens;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;
import scalafix.internal.rule.RemoveUnused$;
import scalafix.internal.rule.RemoveUnusedConfig;
import scalafix.internal.rule.RemoveUnusedConfig$;
import scalafix.patch.Patch;
import scalafix.util.Trivia$;
import scalafix.v1.Configuration;
import scalafix.v1.Rule;
import scalafix.v1.SemanticDocument;
import scalafix.v1.SemanticRule;

public class RemoveUnused
extends SemanticRule {
    private final RemoveUnusedConfig config;

    public RemoveUnused(RemoveUnusedConfig config) {
        this.config = config;
        super(scalafix.v1.package$.MODULE$.RuleName().apply("RemoveUnused").withDeprecatedName("RemoveUnusedImports", "Use RemoveUnused instead", "0.6.0").withDeprecatedName("RemoveUnusedTerms", "Use RemoveUnused instead", "0.6.0"));
    }

    public RemoveUnused() {
        this(RemoveUnusedConfig$.MODULE$.default());
    }

    public String description() {
        return "Removes unused imports and terms that reported by the compiler under -Wunused";
    }

    public boolean isRewrite() {
        return true;
    }

    private List<String> warnUnusedPrefix() {
        return (List)new .colon.colon((Object)"-Wunused", (List)new .colon.colon((Object)"-Ywarn-unused", (List)Nil$.MODULE$));
    }

    private List<String> warnUnusedString() {
        return (List)new .colon.colon((Object)"-Xlint", (List)new .colon.colon((Object)"-Xlint:unused", (List)Nil$.MODULE$));
    }

    public Configured<Rule> withConfiguration(Configuration config) {
        boolean diagnosticsAvailableInSemanticdb = ((SeqOps)new .colon.colon((Object)"3.0", (List)new .colon.colon((Object)"3.1", (List)new .colon.colon((Object)"3.2", (List)new .colon.colon((Object)"3.3.0", (List)new .colon.colon((Object)"3.3.1", (List)new .colon.colon((Object)"3.3.2", (List)new .colon.colon((Object)"3.3.3", (List)Nil$.MODULE$)))))))).forall((Function1 & Serializable)v -> !config.scalaVersion().startsWith((String)v));
        boolean hasWarnUnused = config.scalacOptions().exists((Function1 & Serializable)option -> this.warnUnusedPrefix().exists((Function1 & Serializable)prefix -> option.startsWith((String)prefix)) || this.warnUnusedString().contains(option));
        if (!hasWarnUnused) {
            return Configured$.MODULE$.error(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|A Scala compiler option is required to use RemoveUnused. To fix this problem,\n          |update your build to add -Ywarn-unused (with 2.12), -Wunused (with 2.13), or \n          |-Wunused:all (with 3.3.4+)")));
        }
        if (!diagnosticsAvailableInSemanticdb) {
            return Configured$.MODULE$.error("You must use a more recent version of the Scala 3 compiler (3.3.4+)");
        }
        return config.conf().getOrElse("RemoveUnused", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Object)this.config, RemoveUnusedConfig$.MODULE$.decoder()).map((Function1 & Serializable)_$1 -> new RemoveUnused((RemoveUnusedConfig)_$1));
    }

    public Patch fix(SemanticDocument doc) {
        Set isUnusedTerm = (Set)Set$.MODULE$.empty();
        Set isUnusedImport = (Set)Set$.MODULE$.empty();
        Set isUnusedPattern = (Set)Set$.MODULE$.empty();
        Set isUnusedParam = (Set)Set$.MODULE$.empty();
        Regex unusedPatterExpr = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^pattern var .* in (value|method) .* is never used"));
        doc.diagnostics().foreach((Function1)(JProcedure1 & Serializable)diagnostic -> {
            block20: {
                block21: {
                    String msg;
                    block18: {
                        block19: {
                            block16: {
                                block17: {
                                    block14: {
                                        block15: {
                                            msg = diagnostic.message();
                                            if (this.config.imports()) {
                                                String string = diagnostic.message().toLowerCase();
                                                String string2 = "unused import";
                                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                                    isUnusedImport.$plus$eq((Object)diagnostic.position());
                                                    return;
                                                }
                                            }
                                            if (!this.config.privates()) break block14;
                                            if (msg.startsWith("private") && msg.endsWith("is never used")) break block15;
                                            String string = msg;
                                            String string3 = "unused private member";
                                            if (string != null ? !string.equals(string3) : string3 != null) break block14;
                                        }
                                        isUnusedTerm.$plus$eq((Object)diagnostic.position());
                                        return;
                                    }
                                    if (!this.config.locals()) break block16;
                                    if (msg.startsWith("local") && msg.endsWith("is never used")) break block17;
                                    String string = msg;
                                    String string4 = "unused local definition";
                                    if (string != null ? !string.equals(string4) : string4 != null) break block16;
                                }
                                isUnusedTerm.$plus$eq((Object)diagnostic.position());
                                return;
                            }
                            if (!this.config.patternvars()) break block18;
                            if (unusedPatterExpr.findFirstMatchIn((CharSequence)diagnostic.message()).isDefined()) break block19;
                            String string = msg;
                            String string5 = "unused pattern variable";
                            if (string != null ? !string.equals(string5) : string5 != null) break block18;
                        }
                        isUnusedPattern.$plus$eq((Object)diagnostic.position());
                        return;
                    }
                    if (!this.config.params()) break block20;
                    if (msg.startsWith("parameter") && msg.endsWith("is never used")) break block21;
                    String string = msg;
                    String string6 = "unused explicit parameter";
                    if (string != null ? !string.equals(string6) : string6 != null) break block20;
                }
                isUnusedParam.$plus$eq((Object)diagnostic.position());
                return;
            }
        });
        if (isUnusedImport.isEmpty() && isUnusedTerm.isEmpty() && isUnusedPattern.isEmpty() && isUnusedParam.isEmpty()) {
            return scalafix.v1.package$.MODULE$.Patch().empty();
        }
        return scalafix.v1.package$.MODULE$.XtensionSeqPatch((Iterable)scala.meta.package$.MODULE$.XtensionCollectionLikeUI(doc.tree()).collect((PartialFunction)new Serializable(isUnusedTerm, isUnusedParam, isUnusedPattern, isUnusedImport, this){
            private final Set isUnusedTerm$2;
            public final Set scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedParam$2;
            private final Set isUnusedPattern$4;
            public final Set scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedImport$3;
            private final /* synthetic */ RemoveUnused $outer;
            {
                this.isUnusedTerm$2 = isUnusedTerm$3;
                this.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedParam$2 = isUnusedParam$3;
                this.isUnusedPattern$4 = isUnusedPattern$8;
                this.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedImport$3 = isUnusedImport$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tree x) {
                Option option;
                Option option2;
                Option option3;
                Option option4;
                SeqOps seqOps;
                Tuple4 tuple4;
                List list;
                Defn.Var var;
                Option option5;
                SeqOps seqOps2;
                Tuple4 tuple42;
                List list2;
                Defn.Val val;
                Option option6;
                Defn.Def def;
                Option option7;
                Defn i;
                Option option8;
                Tree tree = x;
                if (tree instanceof Importer && !(option8 = Importer$.MODULE$.unapply((Importer)tree)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)option8.get();
                    List list3 = (List)tuple2._2();
                    List importees = list3;
                    if (importees.forall(RemoveUnused::scalafix$internal$rule$RemoveUnused$$anon$2$$_$isDefinedAt$$anonfun$1)) {
                        return true;
                    }
                    List importees2 = list3;
                    return true;
                }
                if (tree instanceof Defn && this.isUnusedTerm$2.apply((Object)(i = (Defn)tree).pos())) {
                    return true;
                }
                if (tree instanceof Defn.Def && !(option7 = Defn.Def$.MODULE$.unapply(def = (Defn.Def)tree)).isEmpty()) {
                    Tuple6 tuple6 = (Tuple6)option7.get();
                    Term.Name name = (Term.Name)tuple6._2();
                    Defn.Def i2 = def;
                    if (this.isUnusedTerm$2.apply((Object)name.pos())) {
                        return true;
                    }
                }
                if (tree instanceof Defn.Val && !(option6 = Defn.Val$.MODULE$.unapply(val = (Defn.Val)tree)).isEmpty() && (list2 = (List)(tuple42 = (Tuple4)option6.get())._2()) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps2 = package$.MODULE$.List().unapplySeq((SeqOps)list2), 1) == 0) {
                    Pat pat;
                    Pat pat2 = pat = (Pat)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps2, 0);
                    Defn.Val i3 = val;
                    if (this.isUnusedTerm$2.exists(arg_0 -> RemoveUnused.scalafix$internal$rule$RemoveUnused$$anon$2$$_$isDefinedAt$$anonfun$2(pat2, arg_0))) {
                        return true;
                    }
                }
                if (tree instanceof Defn.Var && !(option5 = Defn.Var$.MODULE$.unapply(var = (Defn.Var)tree)).isEmpty() && (list = (List)(tuple4 = (Tuple4)option5.get())._2()) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
                    Pat pat;
                    Pat pat3 = pat = (Pat)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    Defn.Var i4 = var;
                    if (this.isUnusedTerm$2.exists(arg_0 -> RemoveUnused.scalafix$internal$rule$RemoveUnused$$anon$2$$_$isDefinedAt$$anonfun$3(pat3, arg_0))) {
                        return true;
                    }
                }
                if (tree instanceof Term.Match && !(option4 = Term.Match$.MODULE$.unapply((Term.Match)tree)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)option4.get();
                    List cases = (List)tuple2._2();
                    return true;
                }
                if (tree instanceof Term.PartialFunction && !(option3 = Term.PartialFunction$.MODULE$.unapply((Term.PartialFunction)tree)).isEmpty()) {
                    List list4;
                    List cases = list4 = (List)option3.get();
                    return true;
                }
                if (tree instanceof Term.Try && !(option2 = Term.Try$.MODULE$.unapply((Term.Try)tree)).isEmpty()) {
                    Tuple3 tuple3 = (Tuple3)option2.get();
                    List cases = (List)tuple3._2();
                    return true;
                }
                if (tree instanceof Term.Function && !(option = Term.Function$.MODULE$.unapply((Term.Function)tree)).isEmpty()) {
                    Option option9;
                    Term.Param param;
                    SeqOps seqOps3;
                    Tuple2 tuple2 = (Tuple2)option.get();
                    List list5 = (List)tuple2._1();
                    if (list5 != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps3 = package$.MODULE$.List().unapplySeq((SeqOps)list5), 1) == 0 && (param = (Term.Param)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps3, 0)) != null && !(option9 = Term.Param$.MODULE$.unapply(param)).isEmpty()) {
                        Term.Param param2;
                        Tuple4 tuple43 = (Tuple4)option9.get();
                        Name name = (Name)tuple43._2();
                        Option option10 = (Option)tuple43._3();
                        Name name2 = name;
                        if (None$.MODULE$.equals(option10)) {
                            Term.Param param3 = param;
                            if (this.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedParam$2.apply((Object)name2.pos())) {
                                return true;
                            }
                        }
                        Name name3 = name;
                        if (option10 instanceof Some && this.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedParam$2.apply((Object)this.$outer.scalafix$internal$rule$RemoveUnused$$posExclParens((Tree)(param2 = param)))) {
                            return true;
                        }
                    }
                    List params = list5;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Tree x, Function1 function1) {
                Option option;
                Option option2;
                Option option3;
                Option option4;
                SeqOps seqOps;
                Tuple4 tuple4;
                List list;
                Defn.Var var;
                Option option5;
                SeqOps seqOps2;
                Tuple4 tuple42;
                List list2;
                Defn.Val val;
                Option option6;
                Defn.Def def;
                Option option7;
                Defn i;
                Option option8;
                Tree tree = x;
                if (tree instanceof Importer && !(option8 = Importer$.MODULE$.unapply((Importer)tree)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)option8.get();
                    List list3 = (List)tuple2._2();
                    List importees = list3;
                    if (importees.forall(RemoveUnused::scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$1)) {
                        return scalafix.v1.package$.MODULE$.XtensionSeqPatch((Iterable)importees.map(RemoveUnused::scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$2)).asPatch();
                    }
                    List importees2 = list3;
                    boolean hasUsedWildcard = importees2.exists((Function1 & Serializable)x$1 -> {
                        Importee importee = x$1;
                        if (importee instanceof Importee.Wildcard) {
                            Importee.Wildcard i = (Importee.Wildcard)importee;
                            return !RemoveUnused.scalafix$internal$rule$RemoveUnused$$_$isUnusedImportee$1(this.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedImport$3, (Importee)i);
                        }
                        return false;
                    });
                    return scalafix.v1.package$.MODULE$.XtensionSeqPatch((Iterable)importees2.collect((PartialFunction)new Serializable(hasUsedWildcard, this){
                        private final boolean hasUsedWildcard$1;
                        private final /* synthetic */ $anon$2 $outer;
                        {
                            this.hasUsedWildcard$1 = hasUsedWildcard$2;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Importee x) {
                            Importee i;
                            Importee.Rename rename;
                            Option option;
                            Importee importee = x;
                            if (importee instanceof Importee.Rename && !(option = Importee.Rename$.MODULE$.unapply(rename = (Importee.Rename)importee)).isEmpty()) {
                                Tuple2 tuple2 = (Tuple2)option.get();
                                Name to = (Name)tuple2._2();
                                Importee.Rename i2 = rename;
                                if (RemoveUnused.scalafix$internal$rule$RemoveUnused$$_$isUnusedImportee$1(this.$outer.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedImport$3, (Importee)i2) && this.hasUsedWildcard$1) {
                                    return true;
                                }
                            }
                            return RemoveUnused.scalafix$internal$rule$RemoveUnused$$_$isUnusedImportee$1(this.$outer.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedImport$3, i = importee);
                        }

                        public final Object applyOrElse(Importee x, Function1 function1) {
                            Importee i;
                            Importee.Rename rename;
                            Option option;
                            Importee importee = x;
                            if (importee instanceof Importee.Rename && !(option = Importee.Rename$.MODULE$.unapply(rename = (Importee.Rename)importee)).isEmpty()) {
                                Tuple2 tuple2 = (Tuple2)option.get();
                                Name to = (Name)tuple2._2();
                                Importee.Rename i2 = rename;
                                if (RemoveUnused.scalafix$internal$rule$RemoveUnused$$_$isUnusedImportee$1(this.$outer.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedImport$3, (Importee)i2) && this.hasUsedWildcard$1) {
                                    return scalafix.v1.package$.MODULE$.Patch().replaceTree((Tree)to, "_").atomic();
                                }
                            }
                            if (RemoveUnused.scalafix$internal$rule$RemoveUnused$$_$isUnusedImportee$1(this.$outer.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedImport$3, i = importee)) {
                                return scalafix.v1.package$.MODULE$.Patch().removeImportee(i).atomic();
                            }
                            return function1.apply((Object)x);
                        }
                    })).asPatch();
                }
                if (tree instanceof Defn && this.isUnusedTerm$2.apply((Object)(i = (Defn)tree).pos())) {
                    return scalafix.v1.package$.MODULE$.XtensionOptionPatch(this.$outer.scalafix$internal$rule$RemoveUnused$$defnPatch(i)).asPatch().atomic();
                }
                if (tree instanceof Defn.Def && !(option7 = Defn.Def$.MODULE$.unapply(def = (Defn.Def)tree)).isEmpty()) {
                    Tuple6 tuple6 = (Tuple6)option7.get();
                    Term.Name name = (Term.Name)tuple6._2();
                    Defn.Def i2 = def;
                    if (this.isUnusedTerm$2.apply((Object)name.pos())) {
                        return scalafix.v1.package$.MODULE$.XtensionOptionPatch(this.$outer.scalafix$internal$rule$RemoveUnused$$defnPatch((Defn)i2)).asPatch().atomic();
                    }
                }
                if (tree instanceof Defn.Val && !(option6 = Defn.Val$.MODULE$.unapply(val = (Defn.Val)tree)).isEmpty() && (list2 = (List)(tuple42 = (Tuple4)option6.get())._2()) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps2 = package$.MODULE$.List().unapplySeq((SeqOps)list2), 1) == 0) {
                    Pat pat;
                    Pat pat2 = pat = (Pat)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps2, 0);
                    Defn.Val i3 = val;
                    if (this.isUnusedTerm$2.exists(arg_0 -> RemoveUnused.scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$3(pat2, arg_0))) {
                        return scalafix.v1.package$.MODULE$.XtensionOptionPatch(this.$outer.scalafix$internal$rule$RemoveUnused$$defnPatch((Defn)i3)).asPatch().atomic();
                    }
                }
                if (tree instanceof Defn.Var && !(option5 = Defn.Var$.MODULE$.unapply(var = (Defn.Var)tree)).isEmpty() && (list = (List)(tuple4 = (Tuple4)option5.get())._2()) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
                    Pat pat;
                    Pat pat3 = pat = (Pat)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    Defn.Var i4 = var;
                    if (this.isUnusedTerm$2.exists(arg_0 -> RemoveUnused.scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$4(pat3, arg_0))) {
                        return scalafix.v1.package$.MODULE$.XtensionOptionPatch(this.$outer.scalafix$internal$rule$RemoveUnused$$defnPatch((Defn)i4)).asPatch().atomic();
                    }
                }
                if (tree instanceof Term.Match && !(option4 = Term.Match$.MODULE$.unapply((Term.Match)tree)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)option4.get();
                    List cases = (List)tuple2._2();
                    return this.$outer.scalafix$internal$rule$RemoveUnused$$_$patchPatVarsIn$1(this.isUnusedPattern$4, cases);
                }
                if (tree instanceof Term.PartialFunction && !(option3 = Term.PartialFunction$.MODULE$.unapply((Term.PartialFunction)tree)).isEmpty()) {
                    List list4;
                    List cases = list4 = (List)option3.get();
                    return this.$outer.scalafix$internal$rule$RemoveUnused$$_$patchPatVarsIn$1(this.isUnusedPattern$4, cases);
                }
                if (tree instanceof Term.Try && !(option2 = Term.Try$.MODULE$.unapply((Term.Try)tree)).isEmpty()) {
                    Tuple3 tuple3 = (Tuple3)option2.get();
                    List cases = (List)tuple3._2();
                    return this.$outer.scalafix$internal$rule$RemoveUnused$$_$patchPatVarsIn$1(this.isUnusedPattern$4, cases);
                }
                if (tree instanceof Term.Function && !(option = Term.Function$.MODULE$.unapply((Term.Function)tree)).isEmpty()) {
                    Option option9;
                    Term.Param param;
                    SeqOps seqOps3;
                    Tuple2 tuple2 = (Tuple2)option.get();
                    List list5 = (List)tuple2._1();
                    if (list5 != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps3 = package$.MODULE$.List().unapplySeq((SeqOps)list5), 1) == 0 && (param = (Term.Param)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps3, 0)) != null && !(option9 = Term.Param$.MODULE$.unapply(param)).isEmpty()) {
                        Term.Param param2;
                        Tuple4 tuple43 = (Tuple4)option9.get();
                        Name name = (Name)tuple43._2();
                        Option option10 = (Option)tuple43._3();
                        Name name2 = name;
                        if (None$.MODULE$.equals(option10)) {
                            Term.Param param3 = param;
                            if (this.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedParam$2.apply((Object)name2.pos())) {
                                return scalafix.v1.package$.MODULE$.Patch().replaceTree((Tree)param3, "_");
                            }
                        }
                        Name name3 = name;
                        if (option10 instanceof Some && this.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedParam$2.apply((Object)this.$outer.scalafix$internal$rule$RemoveUnused$$posExclParens((Tree)(param2 = param)))) {
                            return scalafix.v1.package$.MODULE$.Patch().replaceTree((Tree)name3, "_");
                        }
                    }
                    List params = list5;
                    return scalafix.v1.package$.MODULE$.XtensionSeqPatch((Iterable)params.collect((PartialFunction)new Serializable(this){
                        private final /* synthetic */ $anon$2 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Term.Param x) {
                            Option option;
                            Term.Param param = x;
                            if (param != null && !(option = Term.Param$.MODULE$.unapply(param)).isEmpty()) {
                                Tuple4 tuple4 = (Tuple4)option.get();
                                Name name = (Name)tuple4._2();
                                Term.Param param2 = param;
                                if (this.$outer.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedParam$2.apply((Object)param2.pos()) || this.$outer.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedParam$2.apply((Object)name.pos())) {
                                    return true;
                                }
                            }
                            return false;
                        }

                        public final Object applyOrElse(Term.Param x, Function1 function1) {
                            Option option;
                            Term.Param param = x;
                            if (param != null && !(option = Term.Param$.MODULE$.unapply(param)).isEmpty()) {
                                Tuple4 tuple4 = (Tuple4)option.get();
                                Name name = (Name)tuple4._2();
                                Term.Param param2 = param;
                                if (this.$outer.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedParam$2.apply((Object)param2.pos()) || this.$outer.scalafix$internal$rule$RemoveUnused$$anon$2$$isUnusedParam$2.apply((Object)name.pos())) {
                                    return scalafix.v1.package$.MODULE$.Patch().replaceTree((Tree)name, "_");
                                }
                            }
                            return function1.apply((Object)x);
                        }
                    })).asPatch();
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{scalafix$internal$rule$RemoveUnused$$anon$2$$_$isDefinedAt$$anonfun$1(scala.meta.Importee ), scalafix$internal$rule$RemoveUnused$$anon$2$$_$isDefinedAt$$anonfun$2(scala.meta.Pat scala.meta.inputs.Position ), scalafix$internal$rule$RemoveUnused$$anon$2$$_$isDefinedAt$$anonfun$3(scala.meta.Pat scala.meta.inputs.Position ), scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$1(scala.meta.Importee ), scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$2(scala.meta.Importee ), $anonfun$3(scala.meta.Importee ), scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$3(scala.meta.Pat scala.meta.inputs.Position ), scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$4(scala.meta.Pat scala.meta.inputs.Position )}, serializedLambda);
            }
        })).asPatch();
    }

    public Tokens scalafix$internal$rule$RemoveUnused$$leftTokens(Tree t, Tree right) {
        return t.tokens().dropRightWhile((Function1 & Serializable)_$4 -> _$4.start() >= right.pos().start());
    }

    private Option<Tokens> defnTokensToRemove(Defn defn) {
        Defn.Var var;
        Option option;
        Defn.Val val;
        Option option2;
        Defn defn2 = defn;
        if (defn2 instanceof Defn.Val && !(option2 = Defn.Val$.MODULE$.unapply(val = (Defn.Val)defn2)).isEmpty()) {
            Option option3;
            Tuple4 tuple4 = (Tuple4)option2.get();
            Term term = (Term)tuple4._4();
            if (term instanceof Lit && !(option3 = Lit$.MODULE$.unapply((Lit)term)).isEmpty()) {
                Object object = option3.get();
                Defn.Val i = val;
                return Some$.MODULE$.apply((Object)i.tokens());
            }
            Term rhs = term;
            Defn.Val i = val;
            return Some$.MODULE$.apply((Object)this.scalafix$internal$rule$RemoveUnused$$leftTokens((Tree)i, (Tree)rhs));
        }
        if (defn2 instanceof Defn.Var && !(option = Defn.Var$.MODULE$.unapply(var = (Defn.Var)defn2)).isEmpty()) {
            Option option4;
            Term term;
            Tuple4 tuple4 = (Tuple4)option.get();
            Option option5 = (Option)tuple4._4();
            if (option5 instanceof Some && (term = (Term)((Some)option5).value()) instanceof Lit && !(option4 = Lit$.MODULE$.unapply((Lit)term)).isEmpty()) {
                Object object = option4.get();
                Defn.Var i = var;
                return Some$.MODULE$.apply((Object)i.tokens());
            }
            Option rhs = option5;
            Defn.Var i = var;
            return rhs.map((Function1 & Serializable)_$5 -> this.scalafix$internal$rule$RemoveUnused$$leftTokens((Tree)i, (Tree)_$5));
        }
        if (defn2 instanceof Defn.Def) {
            Defn.Def i = (Defn.Def)defn2;
            return Some$.MODULE$.apply((Object)i.tokens());
        }
        return None$.MODULE$;
    }

    public Option<Patch> scalafix$internal$rule$RemoveUnused$$defnPatch(Defn defn) {
        return this.defnTokensToRemove(defn).map((Function1 & Serializable)tokens -> {
            Option maybeLocally;
            Term.Block block2;
            Option option;
            Term term;
            Tuple4 tuple4;
            Option option2;
            Option option3;
            None$ none$;
            Term.Block block3;
            Option option4;
            Tuple4 tuple42;
            Term term2;
            Option option5;
            Defn defn = defn;
            if (defn instanceof Defn.Val && !(option5 = Defn.Val$.MODULE$.unapply((Defn.Val)defn)).isEmpty() && (term2 = (Term)(tuple42 = (Tuple4)option5.get())._4()) instanceof Term.Block && !(option4 = Term.Block$.MODULE$.unapply(block3 = (Term.Block)term2)).isEmpty()) {
                List list = (List)option4.get();
                Term.Block x = block3;
                none$ = Some$.MODULE$.apply((Object)x);
            } else if (defn instanceof Defn.Var && !(option3 = Defn.Var$.MODULE$.unapply((Defn.Var)defn)).isEmpty() && (option2 = (Option)(tuple4 = (Tuple4)option3.get())._4()) instanceof Some && (term = (Term)((Some)option2).value()) instanceof Term.Block && !(option = Term.Block$.MODULE$.unapply(block2 = (Term.Block)term)).isEmpty()) {
                List list = (List)option.get();
                Term.Block x = block2;
                none$ = Some$.MODULE$.apply((Object)x);
            } else {
                none$ = None$.MODULE$;
            }
            None$ maybeRHSBlock = none$;
            Option option6 = maybeLocally = maybeRHSBlock.map((Function1 & Serializable)block -> {
                Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)block.pos().start()));
                Option option = block.stats().headOption().map((Function1 & Serializable)_$6 -> _$6.pos().start());
                if (!(some != null ? !some.equals(option) : option != null)) {
                    return "locally:";
                }
                return "locally";
            });
            if (option6 instanceof Some) {
                String locally = (String)((Some)option6).value();
                Tokens tokensNoTrailingTrivia = tokens.dropRightWhile((Function1 & Serializable)_$7 -> scala.meta.package$.MODULE$.XtensionClassifiable(_$7, Token$.MODULE$.classifiable()).is(Trivia$.MODULE$.classifier()));
                return scalafix.v1.package$.MODULE$.Patch().removeTokens((Iterable)tokensNoTrailingTrivia).$plus(tokensNoTrailingTrivia.lastOption().map((Function1 & Serializable)_$8 -> scalafix.v1.package$.MODULE$.Patch().addRight(_$8, locally)));
            }
            return scalafix.v1.package$.MODULE$.Patch().removeTokens((Iterable)tokens);
        });
    }

    public Position scalafix$internal$rule$RemoveUnused$$posExclParens(Tree tree) {
        int leftTokenCount = tree.tokens().takeWhile((Function1 & Serializable)tk -> scala.meta.package$.MODULE$.XtensionClassifiable(tk, Token$.MODULE$.classifiable()).is(Token.LeftParen$.MODULE$.classifier()) || scala.meta.package$.MODULE$.XtensionClassifiable(tk, Token$.MODULE$.classifiable()).is(Trivia$.MODULE$.classifier())).size();
        int rightTokenCount = tree.tokens().takeRightWhile((Function1 & Serializable)tk -> scala.meta.package$.MODULE$.XtensionClassifiable(tk, Token$.MODULE$.classifiable()).is(Token.RightParen$.MODULE$.classifier()) || scala.meta.package$.MODULE$.XtensionClassifiable(tk, Token$.MODULE$.classifiable()).is(Trivia$.MODULE$.classifier())).size();
        Position position = tree.pos();
        if (position instanceof Position.Range) {
            Position.Range range = (Position.Range)position;
            Input input = range.input();
            int start = range.start();
            int end = range.end();
            return scala.meta.package$.MODULE$.Position().Range().apply(input, start + leftTokenCount, end - rightTokenCount);
        }
        Position other = position;
        return other;
    }

    public final boolean scalafix$internal$rule$RemoveUnused$$_$checkUnusedPatTree$1(Set isUnusedPattern$3, Tree t) {
        return isUnusedPattern$3.apply((Object)t.pos()) || isUnusedPattern$3.apply((Object)this.scalafix$internal$rule$RemoveUnused$$posExclParens(t));
    }

    private final PartialFunction patchPatTree$1(Set isUnusedPattern$5) {
        return new Serializable(isUnusedPattern$5, this){
            private final Set isUnusedPattern$6;
            private final /* synthetic */ RemoveUnused $outer;
            {
                this.isUnusedPattern$6 = isUnusedPattern$9;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tree x) {
                Pat.Bind bind;
                Option option;
                Tuple2 tuple2;
                Pat pat;
                Pat.Typed typed;
                Option option2;
                Pat.Var v;
                Tree tree = x;
                if (tree instanceof Pat.Var && this.$outer.scalafix$internal$rule$RemoveUnused$$_$checkUnusedPatTree$1(this.isUnusedPattern$6, (Tree)(v = (Pat.Var)tree))) {
                    return true;
                }
                if (tree instanceof Pat.Typed && !(option2 = Pat.Typed$.MODULE$.unapply(typed = (Pat.Typed)tree)).isEmpty() && (pat = (Pat)(tuple2 = (Tuple2)option2.get())._1()) instanceof Pat.Var) {
                    Pat.Var v2 = (Pat.Var)pat;
                    Pat.Typed t = typed;
                    if (this.$outer.scalafix$internal$rule$RemoveUnused$$_$checkUnusedPatTree$1(this.isUnusedPattern$6, (Tree)t)) {
                        return true;
                    }
                }
                if (tree instanceof Pat.Bind && !(option = Pat.Bind$.MODULE$.unapply(bind = (Pat.Bind)tree)).isEmpty()) {
                    Tuple2 tuple22 = (Tuple2)option.get();
                    Pat rhs = (Pat)tuple22._2();
                    Pat.Bind b = bind;
                    if (this.$outer.scalafix$internal$rule$RemoveUnused$$_$checkUnusedPatTree$1(this.isUnusedPattern$6, (Tree)b)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tree x, Function1 function1) {
                Pat.Bind bind;
                Option option;
                Tuple2 tuple2;
                Pat pat;
                Pat.Typed typed;
                Option option2;
                Pat.Var v;
                Tree tree = x;
                if (tree instanceof Pat.Var && this.$outer.scalafix$internal$rule$RemoveUnused$$_$checkUnusedPatTree$1(this.isUnusedPattern$6, (Tree)(v = (Pat.Var)tree))) {
                    return scalafix.v1.package$.MODULE$.Patch().replaceTree((Tree)v, "_");
                }
                if (tree instanceof Pat.Typed && !(option2 = Pat.Typed$.MODULE$.unapply(typed = (Pat.Typed)tree)).isEmpty() && (pat = (Pat)(tuple2 = (Tuple2)option2.get())._1()) instanceof Pat.Var) {
                    Pat.Var v2 = (Pat.Var)pat;
                    Pat.Typed t = typed;
                    if (this.$outer.scalafix$internal$rule$RemoveUnused$$_$checkUnusedPatTree$1(this.isUnusedPattern$6, (Tree)t)) {
                        return scalafix.v1.package$.MODULE$.Patch().replaceTree((Tree)v2, "_");
                    }
                }
                if (tree instanceof Pat.Bind && !(option = Pat.Bind$.MODULE$.unapply(bind = (Pat.Bind)tree)).isEmpty()) {
                    Tuple2 tuple22 = (Tuple2)option.get();
                    Pat rhs = (Pat)tuple22._2();
                    Pat.Bind b = bind;
                    if (this.$outer.scalafix$internal$rule$RemoveUnused$$_$checkUnusedPatTree$1(this.isUnusedPattern$6, (Tree)b)) {
                        return scalafix.v1.package$.MODULE$.Patch().removeTokens((Iterable)this.$outer.scalafix$internal$rule$RemoveUnused$$leftTokens((Tree)b, (Tree)rhs));
                    }
                }
                return function1.apply((Object)x);
            }
        };
    }

    public final Patch scalafix$internal$rule$RemoveUnused$$_$patchPatVarsIn$1(Set isUnusedPattern$2, List cases) {
        return scalafix.v1.package$.MODULE$.XtensionSeqPatch((Iterable)cases.map((Function1 & Serializable)x$1 -> {
            Option option;
            Case case_ = x$1;
            if (case_ != null && !(option = Case$.MODULE$.unapply(case_)).isEmpty()) {
                Tuple3 tuple3 = (Tuple3)option.get();
                Pat extract = (Pat)tuple3._1();
                return extract;
            }
            throw new MatchError((Object)case_);
        }).flatMap((Function1 & Serializable)_$2 -> scala.meta.package$.MODULE$.XtensionCollectionLikeUI((Tree)_$2).collect(this.patchPatTree$1(isUnusedPattern$2)))).asPatch().atomic();
    }

    public static final boolean scalafix$internal$rule$RemoveUnused$$_$isUnusedImportee$1(Set isUnusedImport$2, Importee importee) {
        Position position;
        Option option;
        Importee importee2 = importee;
        if (importee2 instanceof Importee.Rename && !(option = Importee.Rename$.MODULE$.unapply((Importee.Rename)importee2)).isEmpty()) {
            Tuple2 tuple2 = (Tuple2)option.get();
            Name from = (Name)tuple2._1();
            position = from.pos();
        } else {
            position = importee.pos();
        }
        Position pos = position;
        return isUnusedImport$2.exists((Function1 & Serializable)unused -> unused.start() <= pos.start() && pos.end() <= unused.end());
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$RemoveUnused$$anon$2$$_$isDefinedAt$$anonfun$1(Importee _$3) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)_$3, Tree$.MODULE$.classifiable()).is(Importee.Unimport$.MODULE$.ClassifierClass());
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$RemoveUnused$$anon$2$$_$isDefinedAt$$anonfun$2(Pat pat$1, Position p) {
        return p.start() == pat$1.pos().start();
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$RemoveUnused$$anon$2$$_$isDefinedAt$$anonfun$3(Pat pat$2, Position p) {
        return p.start() == pat$2.pos().start();
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$1(Importee _$3) {
        return scala.meta.package$.MODULE$.XtensionClassifiable((Object)_$3, Tree$.MODULE$.classifiable()).is(Importee.Unimport$.MODULE$.ClassifierClass());
    }

    public static final /* synthetic */ Patch scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$2(Importee importee) {
        return scalafix.v1.package$.MODULE$.Patch().removeImportee(importee);
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$3(Pat pat$3, Position p) {
        return p.start() == pat$3.pos().start();
    }

    public static final /* synthetic */ boolean scalafix$internal$rule$RemoveUnused$$anon$2$$_$applyOrElse$$anonfun$4(Pat pat$4, Position p) {
        return p.start() == pat$4.pos().start();
    }
}

