/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.rule;

import java.io.Serializable;
import metaconfig.Conf;
import metaconfig.ConfDecoder;
import metaconfig.ConfError;
import metaconfig.ConfError$;
import metaconfig.Configured;
import metaconfig.Configured$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.deriving.Mirror;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scalafix.internal.rule.DisabledKeyword;
import scalafix.internal.rule.Keyword$;

public final class DisabledKeyword$
implements Mirror.Product,
Serializable {
    private static final ConfDecoder<DisabledKeyword> reader;
    public static final DisabledKeyword$ MODULE$;

    private DisabledKeyword$() {
    }

    static {
        MODULE$ = new DisabledKeyword$();
        reader = new ConfDecoder<DisabledKeyword>(){
            {
                ConfDecoder.$init$((ConfDecoder)this);
            }

            public Configured read(Conf conf) {
                Conf conf2 = conf;
                if (conf2 instanceof Conf.Null) {
                    return DisabledKeyword$.scalafix$internal$rule$DisabledKeyword$$anon$2$$_$readKeyword$1(conf, "null");
                }
                if (conf2 instanceof Conf.Str) {
                    String keyword = ((Conf.Str)conf2).value();
                    return DisabledKeyword$.scalafix$internal$rule$DisabledKeyword$$anon$2$$_$readKeyword$1(conf, keyword);
                }
                if (conf2 instanceof Conf.Bool) {
                    boolean value = ((Conf.Bool)conf2).value();
                    if (value) {
                        return DisabledKeyword$.scalafix$internal$rule$DisabledKeyword$$anon$2$$_$readKeyword$1(conf, "true");
                    }
                    return DisabledKeyword$.scalafix$internal$rule$DisabledKeyword$$anon$2$$_$readKeyword$1(conf, "false");
                }
                return Configured$.MODULE$.typeMismatch("String", conf);
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DisabledKeyword$.class);
    }

    public DisabledKeyword apply(String keyword) {
        return new DisabledKeyword(keyword);
    }

    public DisabledKeyword unapply(DisabledKeyword x$1) {
        return x$1;
    }

    public ConfDecoder<DisabledKeyword> reader() {
        return reader;
    }

    public ConfError oneOfTypo(String keyword, Conf conf) {
        String closestKeyword = (String)Keyword$.MODULE$.all().minBy((Function1 & Serializable)s2 -> MODULE$.levenshtein(keyword, (String)s2), (Ordering)Ordering.Int$.MODULE$);
        double relativeDistance = (double)this.levenshtein(keyword, closestKeyword) / (double)keyword.length();
        String didYouMean = relativeDistance < 0.2 ? new StringBuilder(18).append(" (Did you mean: ").append(closestKeyword).append("?)").toString() : "";
        return ConfError$.MODULE$.message(new StringBuilder(34).append(keyword).append(" is not in our supported keywords.").append(didYouMean).toString());
    }

    private int levenshtein(String s1, String s2) {
        int[][] dist = (int[][])Array$.MODULE$.tabulate(s2.length() + 1, s1.length() + 1, (Function2)(JFunction2.mcIII.sp & Serializable)(j, i) -> {
            if (j == 0) {
                return i;
            }
            if (i == 0) {
                return j;
            }
            return 0;
        }, ClassTag$.MODULE$.apply(Integer.TYPE));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), s2.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), s1.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            dist$2[j$1][i] = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s2), j - 1) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s1), i - 1) ? dist[j - 1][i - 1] : RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(dist[j - 1][i]), dist[j][i - 1])), dist[j - 1][i - 1]) + 1;
        }));
        return dist[s2.length()][s1.length()];
    }

    public DisabledKeyword fromProduct(Product x$0) {
        return new DisabledKeyword((String)x$0.productElement(0));
    }

    public static final Configured scalafix$internal$rule$DisabledKeyword$$anon$2$$_$readKeyword$1(Conf conf$2, String keyword) {
        if (Keyword$.MODULE$.set().contains((Object)keyword)) {
            return Configured.Ok$.MODULE$.apply((Object)MODULE$.apply(keyword));
        }
        return Configured.NotOk$.MODULE$.apply(MODULE$.oneOfTypo(keyword, conf$2));
    }
}

