/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.rule;

import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.meta.Term;
import scala.meta.Tree;
import scala.meta.internal.trees.InternalTree;
import scala.meta.package$;
import scala.meta.tokens.Token;
import scalafix.lint.Diagnostic;
import scalafix.patch.Patch;
import scalafix.rule.RuleName$;
import scalafix.v1.SemanticDocument;
import scalafix.v1.SemanticRule;

public class NoAutoTupling
extends SemanticRule {
    public NoAutoTupling() {
        super(RuleName$.MODULE$.stringToRuleName("NoAutoTupling"));
    }

    public String description() {
        return "Inserts explicit tuples for adapted argument lists for compatibility with -Yno-adapted-args";
    }

    public boolean isRewrite() {
        return true;
    }

    public Patch scalafix$internal$rule$NoAutoTupling$$addWrappingParens(Seq<Term> args) {
        return scalafix.v1.package$.MODULE$.Patch().addLeft(((InternalTree)args.head()).tokens().head(), "(").$plus(scalafix.v1.package$.MODULE$.Patch().addRight(((InternalTree)args.last()).tokens().last(), ")"));
    }

    public Patch scalafix$internal$rule$NoAutoTupling$$insertUnit(Term.Apply t) {
        return scalafix.v1.package$.MODULE$.Patch().addRight((Token)((IndexedSeqOps)t.tokens().init()).last(), "()");
    }

    public Patch fix(SemanticDocument doc) {
        Set unitAdaptations = doc.diagnostics().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Diagnostic x) {
                Diagnostic diagnostic = x;
                Diagnostic message = diagnostic;
                return message.message().startsWith("Adaptation of argument list by inserting ()") || message.message().startsWith("adaptation of an empty argument list by inserting ()");
            }

            public final Object applyOrElse(Diagnostic x, Function1 function1) {
                Diagnostic diagnostic = x;
                Diagnostic message = diagnostic;
                if (message.message().startsWith("Adaptation of argument list by inserting ()") || message.message().startsWith("adaptation of an empty argument list by inserting ()")) {
                    return message.position();
                }
                return function1.apply((Object)x);
            }
        }).toSet();
        Set tupleAdaptations = doc.diagnostics().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Diagnostic x) {
                Diagnostic diagnostic = x;
                Diagnostic message = diagnostic;
                return message.message().startsWith("Adapting argument list by creating") || message.message().startsWith("adapted the argument list to the expected");
            }

            public final Object applyOrElse(Diagnostic x, Function1 function1) {
                Diagnostic diagnostic = x;
                Diagnostic message = diagnostic;
                if (message.message().startsWith("Adapting argument list by creating") || message.message().startsWith("adapted the argument list to the expected")) {
                    return message.position();
                }
                return function1.apply((Object)x);
            }
        }).toSet();
        return scalafix.v1.package$.MODULE$.XtensionSeqPatch((Iterable)package$.MODULE$.XtensionCollectionLikeUI(doc.tree()).collect((PartialFunction)new Serializable(tupleAdaptations, unitAdaptations, this){
            private final Set tupleAdaptations$1;
            private final Set unitAdaptations$1;
            private final /* synthetic */ NoAutoTupling $outer;
            {
                this.tupleAdaptations$1 = tupleAdaptations$2;
                this.unitAdaptations$1 = unitAdaptations$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tree x) {
                Tree tree = x;
                if (tree instanceof Term.Apply) {
                    Term.Apply apply = (Term.Apply)tree;
                    Term.Apply t = apply;
                    if (this.tupleAdaptations$1.contains((Object)t.pos())) {
                        return true;
                    }
                    Term.Apply t2 = apply;
                    if (t2.args().isEmpty() && this.unitAdaptations$1.contains((Object)t2.pos())) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tree x, Function1 function1) {
                Tree tree = x;
                if (tree instanceof Term.Apply) {
                    Term.Apply apply = (Term.Apply)tree;
                    Term.Apply t = apply;
                    if (this.tupleAdaptations$1.contains((Object)t.pos())) {
                        return this.$outer.scalafix$internal$rule$NoAutoTupling$$addWrappingParens((Seq<Term>)t.args());
                    }
                    Term.Apply t2 = apply;
                    if (t2.args().isEmpty() && this.unitAdaptations$1.contains((Object)t2.pos())) {
                        return this.$outer.scalafix$internal$rule$NoAutoTupling$$insertUnit(t2);
                    }
                }
                return function1.apply((Object)x);
            }
        }).map((Function1 & Serializable)_$1 -> _$1.atomic())).asPatch();
    }
}

