/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.rule;

import dotty.tools.pc.ScalaPresentationCompiler;
import java.io.Serializable;
import metaconfig.Configured;
import metaconfig.Configured$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.pc.PresentationCompiler;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scalafix.internal.pc.PresentationCompilerTypeInferrer;
import scalafix.internal.pc.PresentationCompilerTypeInferrer$;
import scalafix.internal.rule.ExplicitResultTypesBase;
import scalafix.internal.rule.ExplicitResultTypesConfig;
import scalafix.internal.rule.ExplicitResultTypesConfig$;
import scalafix.internal.rule.Scala3Printer;
import scalafix.patch.Patch;
import scalafix.patch.Patch$;
import scalafix.v1.Configuration;
import scalafix.v1.Rule;
import scalafix.v1.SemanticDocument;

public final class ExplicitResultTypes
extends ExplicitResultTypesBase<Scala3Printer> {
    private final ExplicitResultTypesConfig config;
    private final Option<PresentationCompilerTypeInferrer> pcTypeInferrer;

    public ExplicitResultTypes(ExplicitResultTypesConfig config, Option<PresentationCompilerTypeInferrer> pcTypeInferrer) {
        this.config = config;
        this.pcTypeInferrer = pcTypeInferrer;
    }

    @Override
    public ExplicitResultTypesConfig config() {
        return this.config;
    }

    public ExplicitResultTypes() {
        this(ExplicitResultTypesConfig$.MODULE$.default(), (Option<PresentationCompilerTypeInferrer>)None$.MODULE$);
    }

    public void afterComplete() {
        this.shutdownCompiler();
    }

    private void shutdownCompiler() {
        this.pcTypeInferrer.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.shutdownCompiler());
    }

    public Configured<Rule> withConfiguration(Configuration config) {
        String majorMinorScalaVersion = this.stripPatchVersion(config.scalaVersion());
        if (config.scalaVersion().startsWith("2.")) {
            return Configured$.MODULE$.error(new StringBuilder(123).append("The ExplicitResultTypes rule needs to run with the same Scala binary version as the one used to compile target sources (").append(majorMinorScalaVersion).append("). ").append(new StringBuilder(113).append("To fix this problem, either remove ExplicitResultTypes from .scalafix.conf or make sure Scalafix is loaded with ").append(majorMinorScalaVersion).append(".").toString()).toString());
        }
        if (((SeqOps)new .colon.colon((Object)"3.0", (List)new .colon.colon((Object)"3.1", (List)new .colon.colon((Object)"3.2", (List)Nil$.MODULE$)))).exists((Function1 & Serializable)v -> config.scalaVersion().startsWith((String)v))) {
            return Configured$.MODULE$.error(new StringBuilder(248).append("The ExplicitResultTypes rule requires Scala 3 target sources to be compiled with Scala 3.3.0 or greater, but they were compiled with ").append(config.scalaVersion()).append(". ").append("To fix this problem, either remove ExplicitResultTypes from .scalafix.conf or upgrade the compiler in your build.").toString());
        }
        return config.conf().getOrElse("ExplicitResultTypes", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]), (Object)this.config(), ExplicitResultTypesConfig$.MODULE$.reader()).andThen((Function1 & Serializable)conf -> {
            boolean matchingMinors;
            String majorMinorCompilerScalaVersion = this.stripPatchVersion(this.compilerScalaVersion());
            String string = majorMinorScalaVersion;
            String string2 = majorMinorCompilerScalaVersion;
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (matchingMinors = false);
            if (!matchingMinors && !conf.fetchScala3CompilerArtifactsOnVersionMismatch()) {
                return Configured$.MODULE$.error(new StringBuilder(335).append("The ExplicitResultTypes rule was compiled with a different Scala 3 minor (").append(majorMinorCompilerScalaVersion).append(") ").append(new StringBuilder(107).append("than the target sources (").append(majorMinorScalaVersion).append("). To fix this problem, make sure you are running the latest version of Scalafix. ").toString()).append("If that is the case, either change your build to stick to the Scala 3 LTS or Next versions supported by Scalafix, or ").append("enable ExplicitResultTypes.fetchScala3CompilerArtifactsOnVersionMismatch in .scalafix.conf in order to try to load what is needed dynamically.").toString());
            }
            PresentationCompilerTypeInferrer pcTypeInferrer = matchingMinors ? PresentationCompilerTypeInferrer$.MODULE$.static(config, (PresentationCompiler)new ScalaPresentationCompiler()) : PresentationCompilerTypeInferrer$.MODULE$.dynamic(config);
            return Configured.Ok$.MODULE$.apply((Object)new ExplicitResultTypes((ExplicitResultTypesConfig)conf, (Option<PresentationCompilerTypeInferrer>)Some$.MODULE$.apply((Object)pcTypeInferrer)));
        });
    }

    public Patch fix(SemanticDocument ctx) {
        Patch patch;
        try {
            Scala3Printer printer = new Scala3Printer(this.pcTypeInferrer);
            patch = this.unsafeFix(ctx, printer);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                if (!this.config().fatalWarnings()) {
                    patch = Patch$.MODULE$.empty();
                }
            }
            throw throwable;
        }
        return patch;
    }
}

