/*
 * Decompiled with CFR 0.152.
 */
package scalafix.testkit;

import java.io.File;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordered$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scalafix.config.ScalafixConfig;
import scalafix.config.ScalafixConfig$;
import scalafix.testkit.DiffTest;
import scalafix.util.FileOps$;

public final class DiffTest$
implements Serializable {
    public static DiffTest$ MODULE$;

    static {
        new DiffTest$();
    }

    public Seq<DiffTest> fromFile(File directory) {
        Seq tests = (Seq)this.getTestFiles(directory).flatMap((Function1 & java.io.Serializable & Serializable)filename -> {
            String content = FileOps$.MODULE$.readFile(filename);
            return (Seq)MODULE$.apply(directory, content, (String)filename).map((Function1 & java.io.Serializable & Serializable)test -> test, Seq$.MODULE$.canBuildFrom());
        }, Vector$.MODULE$.canBuildFrom());
        boolean onlyOne = tests.exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.only()));
        return (Seq)tests.filter((Function1 & java.io.Serializable & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DiffTest$.testShouldRun$1(t, onlyOne)));
    }

    private boolean isOnly(String name) {
        return name.startsWith("ONLY ");
    }

    private boolean isSkip(String name) {
        return name.startsWith("SKIP ");
    }

    private String stripPrefix(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(name)).stripPrefix("SKIP "))).stripPrefix("ONLY ").trim();
    }

    private Seq<DiffTest> apply(File testDir, String content, String filename) {
        String spec = new StringOps(Predef$.MODULE$.augmentString(filename)).stripPrefix(testDir.getPath() + File.separator);
        boolean moduleOnly = this.isOnly(content);
        boolean moduleSkip = this.isSkip(content);
        String[] split = content.split("\n<<< ");
        String firstLine = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split)).head();
        ScalafixConfig style = (ScalafixConfig)ScalafixConfig$.MODULE$.fromString(firstLine).get();
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split)).tail())).map((Function1 & java.io.Serializable & Serializable)t -> {
            String original;
            String name;
            String expected;
            block7: {
                List list;
                block6: {
                    String expected2;
                    String before;
                    block5: {
                        List list2;
                        block4: {
                            list2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])t.split("\n>>>\n", 2))).toList();
                            if (!(list2 instanceof .colon.colon)) break block4;
                            .colon.colon colon2 = (.colon.colon)list2;
                            before = (String)colon2.head();
                            List list3 = colon2.tl$access$1();
                            if (!(list3 instanceof .colon.colon)) break block4;
                            .colon.colon colon3 = (.colon.colon)list3;
                            expected2 = (String)colon3.head();
                            List list4 = colon3.tl$access$1();
                            if (Nil$.MODULE$.equals(list4)) break block5;
                        }
                        throw new MatchError((Object)list2);
                    }
                    Tuple2 tuple2 = new Tuple2((Object)before, (Object)expected2);
                    Tuple2 tuple22 = tuple2;
                    String before2 = (String)tuple22._1();
                    expected = (String)tuple22._2();
                    list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])before2.split("\n", 2))).toList();
                    if (!(list instanceof .colon.colon)) break block6;
                    .colon.colon colon4 = (.colon.colon)list;
                    name = (String)colon4.head();
                    List list5 = colon4.tl$access$1();
                    if (!(list5 instanceof .colon.colon)) break block6;
                    .colon.colon colon5 = (.colon.colon)list5;
                    original = (String)colon5.head();
                    List list6 = colon5.tl$access$1();
                    if (Nil$.MODULE$.equals(list6)) break block7;
                }
                throw new MatchError((Object)list);
            }
            Tuple2 tuple2 = new Tuple2((Object)name, (Object)original);
            Tuple2 tuple23 = tuple2;
            String name2 = (String)tuple23._1();
            String original2 = (String)tuple23._2();
            String actualName = this.stripPrefix(name2);
            return new DiffTest(spec, actualName, filename, original2, expected, moduleSkip || this.isSkip(name2), moduleOnly || this.isOnly(name2), style);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DiffTest.class))))).toList();
    }

    /*
     * WARNING - void declaration
     */
    private Vector<String> getTestFiles(File directory) {
        void var2_2;
        Vector testsFiles = (Vector)FileOps$.MODULE$.listFiles(directory).filter((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.endsWith(".source")));
        Vector onlyTests = (Vector)testsFiles.filter((Function1 & java.io.Serializable & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains("\n<<< ONLY")));
        return onlyTests.nonEmpty() ? onlyTests : var2_2;
    }

    private boolean bySpecThenName(DiffTest left, DiffTest right) {
        return Ordered$.MODULE$.orderingToOrdered((Object)new Tuple2((Object)left.spec(), (Object)left.name()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$)).compare((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)right.spec()), (Object)right.name())) < 0;
    }

    public DiffTest apply(String spec, String name, String filename, String original, String expected, boolean skip, boolean only, ScalafixConfig config) {
        return new DiffTest(spec, name, filename, original, expected, skip, only, config);
    }

    public Option<Tuple8<String, String, String, String, String, Object, Object, ScalafixConfig>> unapply(DiffTest x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.spec(), (Object)x$0.name(), (Object)x$0.filename(), (Object)x$0.original(), (Object)x$0.expected(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.skip()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.only()), (Object)x$0.config()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final boolean testShouldRun$1(DiffTest t, boolean onlyOne$1) {
        return !onlyOne$1 || t.only();
    }

    private DiffTest$() {
        MODULE$ = this;
    }
}

