/*
 * Decompiled with CFR 0.152.
 */
package scalafix.testkit;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.meta.inputs.Input;
import scala.meta.internal.io.FileIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.package$;
import scala.util.Either;
import scalafix.testkit.TestkitPath$;
import scalafix.testkit.TestkitProperties;

public final class TestkitPath {
    private final AbsolutePath input;
    private final RelativePath testPath;
    private final RelativePath semanticdbPath;

    public static List<TestkitPath> fromProperties(TestkitProperties testkitProperties) {
        return TestkitPath$.MODULE$.fromProperties(testkitProperties);
    }

    public TestkitPath(AbsolutePath input, RelativePath testPath, RelativePath semanticdbPath) {
        this.input = input;
        this.testPath = testPath;
        this.semanticdbPath = semanticdbPath;
    }

    public AbsolutePath input() {
        return this.input;
    }

    public RelativePath testPath() {
        return this.testPath;
    }

    public RelativePath semanticdbPath() {
        return this.semanticdbPath;
    }

    public String testName() {
        return this.testPath().toURI(false).toString();
    }

    public Input toInput() {
        return Input.VirtualFile$.MODULE$.apply(this.testName(), FileIO$.MODULE$.slurp(this.input(), StandardCharsets.UTF_8));
    }

    public Either<String, AbsolutePath> resolveOutput(TestkitProperties props) {
        RelativePath testPathStripped = RelativePath$.MODULE$.apply(this.testPath().toNIO().subpath(1, this.testPath().toNIO().getNameCount()));
        List candidates = (List)props.outputSourceDirectories().map((Function1 & Serializable)dir -> dir.resolve(testPathStripped)).$plus$plus((IterableOnce)props.outputSourceDirectories().map((Function1 & Serializable)dir -> dir.resolve(this.testPath())));
        List list = candidates.filter((Function1 & Serializable)_$1 -> _$1.isFile());
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            AbsolutePath head = (AbsolutePath)colon2.head();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list2;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                return package$.MODULE$.Right().apply((Object)head);
            }
        }
        Nil$ nil$ = package$.MODULE$.Nil();
        List list4 = list;
        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(26).append("Missing output file for ").append(this.testPath()).append(": ").append(TestkitPath.tried$1(candidates)).toString());
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(28).append("Ambiguous output file for ").append(this.testPath()).append(": ").append(TestkitPath.tried$1(candidates)).toString());
    }

    private static final String tried$1(List candidates$1) {
        return candidates$1.mkString("\n  ", "\n  ", "");
    }
}

