/*
 * Decompiled with CFR 0.152.
 */
package scalafix.testkit;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.Assertions$;
import org.scalatest.Suite;
import org.scalatest.exceptions.TestFailedException;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scalafix.testkit.DiffAssertions$;
import scalafix.testkit.DiffAssertions$DiffFailure$;

public interface DiffAssertions
extends Suite {
    public static void assertEqual$(DiffAssertions $this, Object a, Object b) {
        $this.assertEqual(a, b);
    }

    default public <A> void assertEqual(A a, A b) {
        Position pos$proxy1 = Position$.MODULE$.apply("DiffAssertions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42);
        Position position = Position$.MODULE$.apply("DiffAssertions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42);
        A a2 = a;
        A a3 = b;
        boolean bl = this.convertToEqualizer(a2).$eq$eq$eq(a3, Equality$.MODULE$.default());
        Bool bool = Bool$.MODULE$.binaryMacroBool(a2, "===", a3, bl, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert(bool, (Object)"", position);
    }

    public static String header$(DiffAssertions $this, Object t) {
        return $this.header(t);
    }

    default public <T> String header(T t) {
        String line = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("="), t.toString().length() + 3);
        return new StringBuilder(5).append(line).append("\n=> ").append(t).append("\n").append(line).toString();
    }

    public static DiffAssertions$DiffFailure$ DiffFailure$(DiffAssertions $this) {
        return $this.DiffFailure();
    }

    default public DiffAssertions$DiffFailure$ DiffFailure() {
        return new DiffAssertions$DiffFailure$(this);
    }

    public static String error2message$(DiffAssertions $this, String obtained, String expected) {
        return $this.error2message(obtained, expected);
    }

    default public String error2message(String obtained, String expected) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        if (obtained.length() < 1000) {
            String x$proxy1 = new StringBuilder(30).append("\n        #").append(this.header("Obtained")).append("\n        #").append(this.trailingSpace(obtained)).append("\n         ").toString();
            sb.append(StringOps$.MODULE$.stripMargin$extension(x$proxy1, '#'));
        }
        String x$proxy2 = new StringBuilder(26).append("\n      #").append(this.header("Diff")).append("\n      #").append(this.trailingSpace(this.compareContents(obtained, expected))).append("\n         ").toString();
        sb.append(StringOps$.MODULE$.stripMargin$extension(x$proxy2, '#'));
        return sb.toString();
    }

    public static boolean assertNoDiffOrPrintExpected$(DiffAssertions $this, String obtained, String expected) {
        return $this.assertNoDiffOrPrintExpected(obtained, expected);
    }

    default public boolean assertNoDiffOrPrintExpected(String obtained, String expected) {
        return this.assertNoDiff(obtained, expected, this.assertNoDiff$default$3(), true);
    }

    public static boolean assertNoDiff$(DiffAssertions $this, String obtained, String expected, String title, boolean printObtained) {
        return $this.assertNoDiff(obtained, expected, title, printObtained);
    }

    default public boolean assertNoDiff(String obtained, String expected, String title, boolean printObtained) {
        String result = this.compareContents(obtained, expected);
        if (result.isEmpty()) {
            return true;
        }
        List list = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(obtained)).toList();
        List list2 = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(expected)).toList();
        if (!(list != null ? !list.equals(list2) : list2 != null)) {
            return true;
        }
        if (printObtained) {
            Predef$.MODULE$.println((Object)"\"\"\"|");
            StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(obtained)).foreach((Function1)(JProcedure1 & Serializable)line -> {
                Predef$.MODULE$.print((Object)"   |");
                Predef$.MODULE$.println(line);
            });
        }
        throw this.DiffFailure().apply(title, expected, obtained, result);
    }

    public static String assertNoDiff$default$3$(DiffAssertions $this) {
        return $this.assertNoDiff$default$3();
    }

    default public String assertNoDiff$default$3() {
        return "";
    }

    public static boolean assertNoDiff$default$4$(DiffAssertions $this) {
        return $this.assertNoDiff$default$4();
    }

    default public boolean assertNoDiff$default$4() {
        return false;
    }

    public static String trailingSpace$(DiffAssertions $this, String str) {
        return $this.trailingSpace(str);
    }

    default public String trailingSpace(String str) {
        return str.replaceAll(" \n", "\u2219\n");
    }

    public static String compareContents$(DiffAssertions $this, String original, String revised) {
        return $this.compareContents(original, revised);
    }

    default public String compareContents(String original, String revised) {
        return DiffAssertions$.MODULE$.compareContents(original, revised);
    }

    public static String compareContents$(DiffAssertions $this, Seq original, Seq revised) {
        return $this.compareContents((Seq<String>)original, (Seq<String>)revised);
    }

    default public String compareContents(Seq<String> original, Seq<String> revised) {
        return DiffAssertions$.MODULE$.compareContents(original, revised);
    }

    public static String fileModificationTimeOrEpoch$(DiffAssertions $this, File file) {
        return $this.fileModificationTimeOrEpoch(file);
    }

    default public String fileModificationTimeOrEpoch(File file) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss Z");
        if (file.exists()) {
            return format.format(new Date(file.lastModified()));
        }
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format.format(new Date(0L));
    }

    public class DiffFailure
    extends TestFailedException
    implements Product {
        private final String title;
        private final String expected;
        private final String obtained;
        private final String diff;
        private final /* synthetic */ DiffAssertions $outer;

        public DiffFailure(DiffAssertions $outer, String title, String expected, String obtained, String diff) {
            this.title = title;
            this.expected = expected;
            this.obtained = obtained;
            this.diff = diff;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(new StringBuilder(27).append(title).append("\n--- obtained\n+++ expected\n").append($outer.error2message(obtained, expected)).toString(), 3);
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "DiffFailure";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "title";
                }
                case 1: {
                    return "expected";
                }
                case 2: {
                    return "obtained";
                }
                case 3: {
                    return "diff";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String title() {
            return this.title;
        }

        public String expected() {
            return this.expected;
        }

        public String obtained() {
            return this.obtained;
        }

        public String diff() {
            return this.diff;
        }

        public DiffFailure copy(String title, String expected, String obtained, String diff) {
            return new DiffFailure(this.$outer, title, expected, obtained, diff);
        }

        public String copy$default$1() {
            return this.title();
        }

        public String copy$default$2() {
            return this.expected();
        }

        public String copy$default$3() {
            return this.obtained();
        }

        public String copy$default$4() {
            return this.diff();
        }

        public String _1() {
            return this.title();
        }

        public String _2() {
            return this.expected();
        }

        public String _3() {
            return this.obtained();
        }

        public String _4() {
            return this.diff();
        }

        public final /* synthetic */ DiffAssertions scalafix$testkit$DiffAssertions$DiffFailure$$$outer() {
            return this.$outer;
        }
    }
}

