/*
 * Decompiled with CFR 0.152.
 */
package scalafix.testkit;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.List;
import scala.meta.io.AbsolutePath;
import scala.meta.io.Classpath;
import scala.meta.io.RelativePath;
import scalafix.testkit.TestkitProperties$;

public final class TestkitProperties {
    private final Classpath inputClasspath;
    private final List<AbsolutePath> inputSourceDirectories;
    private final List<AbsolutePath> outputSourceDirectories;
    private final AbsolutePath sourceroot;
    private final String scalaVersion;
    private final List<String> scalacOptions;

    public static TestkitProperties loadFromResources() {
        return TestkitProperties$.MODULE$.loadFromResources();
    }

    public TestkitProperties(Classpath inputClasspath, List<AbsolutePath> inputSourceDirectories, List<AbsolutePath> outputSourceDirectories, AbsolutePath sourceroot, String scalaVersion, List<String> scalacOptions) {
        this.inputClasspath = inputClasspath;
        this.inputSourceDirectories = inputSourceDirectories;
        this.outputSourceDirectories = outputSourceDirectories;
        this.sourceroot = sourceroot;
        this.scalaVersion = scalaVersion;
        this.scalacOptions = scalacOptions;
    }

    public Classpath inputClasspath() {
        return this.inputClasspath;
    }

    public List<AbsolutePath> inputSourceDirectories() {
        return this.inputSourceDirectories;
    }

    public List<AbsolutePath> outputSourceDirectories() {
        return this.outputSourceDirectories;
    }

    public AbsolutePath sourceroot() {
        return this.sourceroot;
    }

    public String scalaVersion() {
        return this.scalaVersion;
    }

    public List<String> scalacOptions() {
        return this.scalacOptions;
    }

    public AbsolutePath resolveInput(RelativePath path) {
        return this.resolveFrom(this.inputSourceDirectories(), path);
    }

    public AbsolutePath resolveOutput(RelativePath path) {
        return this.resolveFrom(this.outputSourceDirectories(), path);
    }

    private AbsolutePath resolveFrom(List<AbsolutePath> directories, RelativePath path) {
        return (AbsolutePath)directories.collectFirst((PartialFunction)new Serializable(path){
            private final RelativePath path$1;
            {
                this.path$1 = path$3;
            }

            public final boolean isDefinedAt(AbsolutePath x) {
                AbsolutePath absolutePath = x;
                AbsolutePath dir = absolutePath;
                return Files.exists(dir.resolve(this.path$1).toNIO(), new LinkOption[0]);
            }

            public final Object applyOrElse(AbsolutePath x, Function1 function1) {
                AbsolutePath absolutePath = x;
                AbsolutePath dir = absolutePath;
                if (Files.exists(dir.resolve(this.path$1).toNIO(), new LinkOption[0])) {
                    return dir.resolve(this.path$1);
                }
                return function1.apply((Object)x);
            }
        }).getOrElse(() -> TestkitProperties.resolveFrom$$anonfun$1(path));
    }

    private static final AbsolutePath resolveFrom$$anonfun$1(RelativePath path$2) {
        throw new NoSuchElementException(path$2.toString());
    }
}

