/*
 * Decompiled with CFR 0.152.
 */
package scalafix.internal.testkit;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scalafix.internal.testkit.AssertDelta;
import scalafix.internal.testkit.AssertDiff$;
import scalafix.internal.testkit.CommentAssertion;
import scalafix.internal.util.LintSyntax$;
import scalafix.lint.RuleDiagnostic;

public class AssertDiff
implements Product,
Serializable {
    private final List<CommentAssertion> unreported;
    private final List<RuleDiagnostic> unexpected;
    private final List<AssertDelta> mismatch;

    public static AssertDiff apply(List<RuleDiagnostic> list, List<CommentAssertion> list2) {
        return AssertDiff$.MODULE$.apply(list, list2);
    }

    public static AssertDiff apply(List<CommentAssertion> list, List<RuleDiagnostic> list2, List<AssertDelta> list3) {
        return AssertDiff$.MODULE$.apply(list, list2, list3);
    }

    public static AssertDiff fromProduct(Product product) {
        return AssertDiff$.MODULE$.fromProduct(product);
    }

    public static AssertDiff unapply(AssertDiff assertDiff) {
        return AssertDiff$.MODULE$.unapply(assertDiff);
    }

    public AssertDiff(List<CommentAssertion> unreported, List<RuleDiagnostic> unexpected, List<AssertDelta> mismatch) {
        this.unreported = unreported;
        this.unexpected = unexpected;
        this.mismatch = mismatch;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AssertDiff)) return false;
        AssertDiff assertDiff = (AssertDiff)object;
        List<CommentAssertion> list = this.unreported();
        List<CommentAssertion> list2 = assertDiff.unreported();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<RuleDiagnostic> list3 = this.unexpected();
        List<RuleDiagnostic> list4 = assertDiff.unexpected();
        if (list3 == null) {
            if (list4 != null) {
                return false;
            }
        } else if (!list3.equals(list4)) return false;
        List<AssertDelta> list5 = this.mismatch();
        List<AssertDelta> list6 = assertDiff.mismatch();
        if (list5 == null) {
            if (list6 != null) {
                return false;
            }
        } else if (!list5.equals(list6)) return false;
        if (!assertDiff.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof AssertDiff;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "AssertDiff";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "unreported";
            }
            case 1: {
                return "unexpected";
            }
            case 2: {
                return "mismatch";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public List<CommentAssertion> unreported() {
        return this.unreported;
    }

    public List<RuleDiagnostic> unexpected() {
        return this.unexpected;
    }

    public List<AssertDelta> mismatch() {
        return this.mismatch;
    }

    public boolean isFailure() {
        return !this.unreported().isEmpty() || !this.unexpected().isEmpty() || !this.mismatch().isEmpty();
    }

    public String toString() {
        String nl = "\n";
        String elementSeparator = new StringBuilder(39).append(nl).append(nl).append("---------------------------------------").append(nl).append(nl).toString();
        String mismatchBanner = this.mismatch().isEmpty() ? "" : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|===========> Mismatch  <===========\n          |\n          |"));
        String showMismatchs = ((List)this.mismatch().sortBy((Function1 & Serializable)_$10 -> _$10.lintDiagnostic().position().startLine(), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)delta -> ((IterableOnceOps)new .colon.colon((Object)new StringBuilder(10).append("Obtained: ").append(AssertDiff.formatDiagnostic$1(delta.lintDiagnostic())).toString(), (List)new .colon.colon((Object)new StringBuilder(10).append("Expected: ").append(delta.assert().formattedMessage()).toString(), (List)new .colon.colon((Object)"Diff:", (List)new .colon.colon((Object)delta.similarity(), (List)Nil$.MODULE$))))).mkString("", nl, "")).mkString(mismatchBanner, elementSeparator, nl);
        String unexpectedBanner = this.unexpected().isEmpty() ? "" : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|===========> Unexpected <===========\n          |\n          |"));
        String showUnexpected = ((List)this.unexpected().sortBy((Function1 & Serializable)_$11 -> _$11.position().startLine(), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)diag -> AssertDiff.formatDiagnostic$1(diag)).mkString(unexpectedBanner, elementSeparator, nl);
        String unreportedBanner = this.unreported().isEmpty() ? "" : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|===========> Unreported <===========\n          |\n          |"));
        String showUnreported = ((List)this.unreported().sortBy((Function1 & Serializable)_$12 -> _$12.anchorPosition().startLine(), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)_$13 -> _$13.formattedMessage()).mkString(unreportedBanner, elementSeparator, nl);
        return ((IterableOnceOps)new .colon.colon((Object)showMismatchs, (List)new .colon.colon((Object)showUnexpected, (List)new .colon.colon((Object)showUnreported, (List)Nil$.MODULE$)))).mkString(nl);
    }

    public AssertDiff copy(List<CommentAssertion> unreported, List<RuleDiagnostic> unexpected, List<AssertDelta> mismatch) {
        return new AssertDiff(unreported, unexpected, mismatch);
    }

    public List<CommentAssertion> copy$default$1() {
        return this.unreported();
    }

    public List<RuleDiagnostic> copy$default$2() {
        return this.unexpected();
    }

    public List<AssertDelta> copy$default$3() {
        return this.mismatch();
    }

    public List<CommentAssertion> _1() {
        return this.unreported();
    }

    public List<RuleDiagnostic> _2() {
        return this.unexpected();
    }

    public List<AssertDelta> _3() {
        return this.mismatch();
    }

    private static final String formatDiagnostic$1(RuleDiagnostic diag) {
        return LintSyntax$.MODULE$.XtensionRuleDiagnostic(diag).withMessage(new StringBuilder(1).append("\n").append(diag.message()).toString()).formattedMessage();
    }
}

