/*
 * Decompiled with CFR 0.152.
 */
package bsp.traits;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class DataKindTrait
extends AbstractTrait
implements ToSmithyBuilder<DataKindTrait> {
    public static final ShapeId ID = ShapeId.from((String)"jsonrpc#dataKind");
    private final String kind;
    private final ShapeId polymorphicData;

    private DataKindTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.kind = builder.kind;
        this.polymorphicData = builder.polymorphicData;
    }

    public ShapeId getPolymorphicData() {
        return this.polymorphicData;
    }

    public String getKind() {
        return this.kind;
    }

    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        builder.withMember("extends", this.getPolymorphicData().toString());
        builder.withMember("kind", this.getKind());
        return builder.build();
    }

    public SmithyBuilder<DataKindTrait> toBuilder() {
        return DataKindTrait.builder().polymorphicData(this.polymorphicData).kind(this.kind).sourceLocation((FromSourceLocation)this.getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Provider
    implements TraitService {
        public ShapeId getShapeId() {
            return ID;
        }

        public DataKindTrait createTrait(ShapeId shapeId, Node node) {
            ObjectNode objectNode = node.expectObjectNode();
            ShapeId shapeId2 = ShapeId.fromNode((Node)objectNode.expectMember("extends").expectStringNode());
            String string = objectNode.expectMember("kind").expectStringNode().getValue();
            return DataKindTrait.builder().kind(string).polymorphicData(shapeId2).build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<DataKindTrait, Builder> {
        private String kind;
        private ShapeId polymorphicData;

        public Builder kind(String string) {
            this.kind = string;
            return this;
        }

        public Builder polymorphicData(ShapeId shapeId) {
            this.polymorphicData = shapeId;
            return this;
        }

        public DataKindTrait build() {
            return new DataKindTrait(this);
        }
    }
}

