/*
 * Decompiled with CFR 0.152.
 */
package bsp.traits;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class DataKindTrait
extends AbstractTrait
implements ToSmithyBuilder<DataKindTrait> {
    public static final ShapeId ID = ShapeId.from((String)"jsonrpc#dataKind");
    private final String kind;
    private final List<ShapeId> polymorphicData;

    private DataKindTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.kind = builder.kind;
        this.polymorphicData = builder.polymorphicData;
    }

    public List<ShapeId> getPolymorphicData() {
        return this.polymorphicData;
    }

    public String getKind() {
        return this.kind;
    }

    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        List list = this.getPolymorphicData().stream().map(ShapeId::toString).map(Node::from).collect(Collectors.toList());
        ArrayNode arrayNode = Node.fromNodes(list);
        builder.withMember("extends", (ToNode)Node.arrayNode());
        builder.withMember("kind", this.getKind());
        return builder.build();
    }

    public SmithyBuilder<DataKindTrait> toBuilder() {
        return DataKindTrait.builder().polymorphicData(this.polymorphicData).kind(this.kind).sourceLocation((FromSourceLocation)this.getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Provider
    implements TraitService {
        public ShapeId getShapeId() {
            return ID;
        }

        public DataKindTrait createTrait(ShapeId shapeId, Node node) {
            ObjectNode objectNode = node.expectObjectNode();
            List list = objectNode.expectMember("extends").expectArrayNode().getElementsAs(ShapeId::fromNode);
            String string = objectNode.expectMember("kind").expectStringNode().getValue();
            return DataKindTrait.builder().kind(string).polymorphicData(list).build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<DataKindTrait, Builder> {
        private String kind;
        private List<ShapeId> polymorphicData;

        public Builder kind(String string) {
            this.kind = string;
            return this;
        }

        public Builder polymorphicData(List<ShapeId> list) {
            this.polymorphicData = list;
            return this;
        }

        public DataKindTrait build() {
            return new DataKindTrait(this);
        }
    }
}

