/*
 * Decompiled with CFR 0.152.
 */
package bsp.traits;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public class DocsPriorityTrait
extends AbstractTrait
implements ToSmithyBuilder<DocsPriorityTrait> {
    public static final ShapeId ID = ShapeId.from((String)"traits#docsPriority");
    private final int priority;

    private DocsPriorityTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.priority = builder.priority;
    }

    public int getPriority() {
        return this.priority;
    }

    protected Node createNode() {
        return Node.from((Number)this.priority);
    }

    public static Builder builder() {
        return new Builder();
    }

    public SmithyBuilder<DocsPriorityTrait> toBuilder() {
        return DocsPriorityTrait.builder().priority(this.priority).sourceLocation((FromSourceLocation)this.getSourceLocation());
    }

    public static final class Provider
    implements TraitService {
        public ShapeId getShapeId() {
            return ID;
        }

        public DocsPriorityTrait createTrait(ShapeId shapeId, Node node) {
            int n = node.expectNumberNode().getValue().intValue();
            return ((Builder)DocsPriorityTrait.builder().priority(n).sourceLocation((FromSourceLocation)node)).build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<DocsPriorityTrait, Builder> {
        private int priority;

        public Builder priority(int n) {
            this.priority = n;
            return this;
        }

        public DocsPriorityTrait build() {
            return new DocsPriorityTrait(this);
        }
    }
}

