/*
 * Decompiled with CFR 0.152.
 */
package bsp.traits;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public class EnumKindTrait
extends AbstractTrait
implements ToSmithyBuilder<EnumKindTrait> {
    public static final ShapeId ID = ShapeId.from((String)"traits#enumKind");
    private final EnumKind enumKind;

    private EnumKindTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.enumKind = builder.enumKind;
        if (this.enumKind == null) {
            throw new SourceException("An enumKind must be provided", (FromSourceLocation)this.getSourceLocation());
        }
    }

    public EnumKind getEnumKind() {
        return this.enumKind;
    }

    protected Node createNode() {
        return Node.from((String)this.getEnumKind().value);
    }

    public SmithyBuilder<EnumKindTrait> toBuilder() {
        return EnumKindTrait.builder().enumKind(this.enumKind).sourceLocation((FromSourceLocation)this.getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Provider
    implements TraitService {
        public ShapeId getShapeId() {
            return ID;
        }

        public EnumKindTrait createTrait(ShapeId shapeId, Node node) {
            EnumKind enumKind = EnumKind.valueOf(node.expectStringNode().getValue().toUpperCase());
            Builder builder = new Builder().enumKind(enumKind);
            return new EnumKindTrait(builder);
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<EnumKindTrait, Builder> {
        private EnumKind enumKind;

        public Builder enumKind(EnumKind enumKind) {
            this.enumKind = enumKind;
            return this;
        }

        public EnumKindTrait build() {
            return new EnumKindTrait(this);
        }
    }

    public static enum EnumKind {
        OPEN("open"),
        CLOSED("closed");

        private String value;

        private EnumKind(String string2) {
            this.value = string2;
        }
    }
}

