/*
 * Decompiled with CFR 0.152.
 */
package tastymima;

import java.io.Serializable;
import java.util.IdentityHashMap;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import tastyquery.Contexts;
import tastyquery.Exceptions;
import tastyquery.Symbols;
import tastyquery.Types;

public final class TypeTranslator {
    private final Contexts.Context oldCtx;
    private final Contexts.Context newCtx;
    private final IdentityHashMap<Types.Type, Types.Type> translatedRecTypes;

    public TypeTranslator(Contexts.Context oldCtx, Contexts.Context newCtx) {
        this.oldCtx = oldCtx;
        this.newCtx = newCtx;
        this.translatedRecTypes = new IdentityHashMap();
    }

    public Types.Type translateType(Types.Type oldType) {
        Types.Type type;
        block39: {
            Types.Type type2;
            TypeTranslator typeTranslator = this;
            Types.Type type3 = oldType;
            while (true) {
                Types.Type alreadyTranslated;
                if ((alreadyTranslated = typeTranslator.translatedRecTypes.get(type3)) != null) {
                    type = alreadyTranslated;
                    break block39;
                }
                type2 = type3;
                if (type2 instanceof Types.NamedType) {
                    Types.NamedType oldType2 = (Types.NamedType)type2;
                    Types.Prefix prefix = oldType2.prefix();
                    if (prefix instanceof Types.Type) {
                        Types.Type oldPrefix = (Types.Type)prefix;
                        Types.Type translatedPrefix = typeTranslator.translateType(oldPrefix);
                        Symbols.TermOrTypeSymbol termOrTypeSymbol = oldType2.symbol(typeTranslator.oldCtx);
                        if (termOrTypeSymbol instanceof Symbols.ClassTypeParamSymbol) {
                            Symbols.ClassTypeParamSymbol oldSym = (Symbols.ClassTypeParamSymbol)termOrTypeSymbol;
                            type = typeTranslator.translateClassTypeParamRef(translatedPrefix, oldSym);
                        } else {
                            type = Types.NamedType$.MODULE$.apply((Types.Prefix)translatedPrefix, oldType2.name(), typeTranslator.newCtx);
                        }
                        break block39;
                    }
                    if (Types.NoPrefix$.MODULE$.equals(prefix)) {
                        throw new Exceptions.InvalidProgramStructureException(new StringBuilder(21).append("Unexpected local ref ").append(oldType2).toString());
                    }
                    throw new MatchError((Object)prefix);
                }
                if (type2 instanceof Types.PackageRef) {
                    Types.PackageRef oldType3 = (Types.PackageRef)type2;
                    type = new Types.PackageRef(oldType3.fullyQualifiedName());
                    break block39;
                }
                if (type2 instanceof Types.ThisType) {
                    Types.ThisType oldType4 = (Types.ThisType)type2;
                    type = new Types.ThisType((Types.TypeRef)typeTranslator.translateType((Types.Type)oldType4.tref()));
                    break block39;
                }
                if (type2 instanceof Types.SuperType) {
                    Types.SuperType oldType5 = (Types.SuperType)type2;
                    Types.ThisType translatedThistpe = (Types.ThisType)typeTranslator.translateType((Types.Type)oldType5.thistpe());
                    Option translatedExplicitSupertpe = oldType5.explicitSupertpe().map((Function1 & Serializable)_$1 -> typeTranslator.translateType((Types.Type)_$1));
                    type = new Types.SuperType(translatedThistpe, translatedExplicitSupertpe);
                    break block39;
                }
                if (type2 instanceof Types.ConstantType) {
                    Types.ConstantType oldType6 = (Types.ConstantType)type2;
                    type = new Types.ConstantType(oldType6.value());
                    break block39;
                }
                if (type2 instanceof Types.AppliedType) {
                    Types.AppliedType oldType7 = (Types.AppliedType)type2;
                    type = new Types.AppliedType(typeTranslator.translateType(oldType7.tycon()), oldType7.args().map((Function1 & Serializable)_$2 -> typeTranslator.translateType((Types.Type)_$2)));
                    break block39;
                }
                if (type2 instanceof Types.ExprType) {
                    Types.ExprType oldType8 = (Types.ExprType)type2;
                    type = new Types.ExprType(typeTranslator.translateType(oldType8.resultType()));
                    break block39;
                }
                if (type2 instanceof Types.TermLambdaType) {
                    Types.TermLambdaType oldType9 = (Types.TermLambdaType)type2;
                    type = (Types.Type)((Types.TermLambdaType)oldType9.companion().apply(oldType9.paramNames(), (Function1 & Serializable)lt -> {
                        $this$3.translatedRecTypes.put((Types.Type)oldType9, (Types.Type)lt);
                        return oldType9.paramInfos().map((Function1 & Serializable)_$3 -> typeTranslator.translateType((Types.Type)_$3));
                    }, (Function1 & Serializable)lt -> typeTranslator.translateType(oldType9.resultType())));
                    break block39;
                }
                if (type2 instanceof Types.TypeLambdaType) {
                    Types.TypeLambdaType oldType10 = (Types.TypeLambdaType)type2;
                    type = (Types.Type)((Types.TypeLambdaType)oldType10.companion().apply(oldType10.paramNames(), (Function1 & Serializable)lt -> {
                        $this$6.translatedRecTypes.put((Types.Type)oldType10, (Types.Type)lt);
                        return oldType10.paramInfos().map((Function1 & Serializable)_$4 -> typeTranslator.translateTypeBounds((Types.TypeBounds)_$4));
                    }, (Function1 & Serializable)lt -> typeTranslator.translateType(oldType10.resultType())));
                    break block39;
                }
                if (type2 instanceof Types.ParamRef) {
                    Types.ParamRef oldType11 = (Types.ParamRef)type2;
                    Types.Type x$proxy1 = typeTranslator.translatedRecTypes.get(oldType11.binders());
                    Types.ParamRefBinders translatedBinders = (Types.ParamRefBinders)((Types.Type)Scala3RunTime$.MODULE$.nn((Object)x$proxy1));
                    type = (Types.Type)translatedBinders.paramRefs().apply(oldType11.paramNum());
                    break block39;
                }
                if (!(type2 instanceof Types.AnnotatedType)) break;
                Types.AnnotatedType oldType12 = (Types.AnnotatedType)type2;
                TypeTranslator typeTranslator2 = typeTranslator;
                Types.Type type4 = oldType12.typ();
                typeTranslator = typeTranslator2;
                type3 = type4;
            }
            if (type2 instanceof Types.TypeRefinement) {
                Types.TypeRefinement oldType13 = (Types.TypeRefinement)type2;
                type = new Types.TypeRefinement(typeTranslator.translateType(oldType13.parent()), oldType13.refinedName(), typeTranslator.translateTypeBounds(oldType13.refinedBounds()));
            } else if (type2 instanceof Types.TermRefinement) {
                Types.TermRefinement oldType14 = (Types.TermRefinement)type2;
                type = new Types.TermRefinement(typeTranslator.translateType(oldType14.parent()), oldType14.refinedName(), typeTranslator.translateType(oldType14.refinedType()));
            } else if (type2 instanceof Types.RecType) {
                Types.RecType oldType15 = (Types.RecType)type2;
                type = Types.RecType$.MODULE$.apply((Function1 & Serializable)rt -> {
                    $this$9.translatedRecTypes.put((Types.Type)oldType15, (Types.Type)rt);
                    return typeTranslator.translateType(oldType15.parent());
                });
            } else if (type2 instanceof Types.RecThis) {
                Types.RecThis oldType16 = (Types.RecThis)type2;
                Types.Type x$proxy2 = typeTranslator.translatedRecTypes.get(oldType16.binders());
                Types.RecType translatedBinders = (Types.RecType)((Types.Type)Scala3RunTime$.MODULE$.nn((Object)x$proxy2));
                type = translatedBinders.recThis();
            } else if (type2 instanceof Types.MatchTypeCase) {
                Types.MatchTypeCase oldType17 = (Types.MatchTypeCase)type2;
                type = new Types.MatchTypeCase(typeTranslator.translateType(oldType17.pattern()), typeTranslator.translateType(oldType17.result()));
            } else if (type2 instanceof Types.MatchType) {
                Types.MatchType oldType18 = (Types.MatchType)type2;
                Types.Type translatedBound = typeTranslator.translateType(oldType18.bound());
                Types.Type translatedScrutinee = typeTranslator.translateType(oldType18.scrutinee());
                List translatedCases = oldType18.cases().map((Function1 & Serializable)x$1 -> {
                    Types.MatchTypeCase matchTypeCase;
                    Types.Type type = x$1;
                    if (type instanceof Types.MatchTypeCase) {
                        Types.MatchTypeCase tpCase = (Types.MatchTypeCase)type;
                        matchTypeCase = (Types.MatchTypeCase)typeTranslator.translateType((Types.Type)tpCase);
                    } else if (type instanceof Types.TypeLambda) {
                        Types.TypeLambda tpCase = (Types.TypeLambda)type;
                        matchTypeCase = (Types.TypeLambda)typeTranslator.translateType((Types.Type)tpCase);
                    } else {
                        throw new MatchError((Object)type);
                    }
                    return matchTypeCase;
                });
                type = new Types.MatchType(translatedBound, translatedScrutinee, translatedCases);
            } else if (type2 instanceof Types.BoundedType) {
                Types.BoundedType oldType19 = (Types.BoundedType)type2;
                type = new Types.BoundedType(typeTranslator.translateTypeBounds(oldType19.bounds()), oldType19.alias().map((Function1 & Serializable)_$5 -> typeTranslator.translateType((Types.Type)_$5)));
            } else if (type2 instanceof Types.NamedTypeBounds) {
                Types.NamedTypeBounds oldType20 = (Types.NamedTypeBounds)type2;
                type = new Types.NamedTypeBounds(oldType20.name(), typeTranslator.translateTypeBounds(oldType20.bounds()));
            } else if (type2 instanceof Types.WildcardTypeBounds) {
                Types.WildcardTypeBounds oldType21 = (Types.WildcardTypeBounds)type2;
                type = new Types.WildcardTypeBounds(typeTranslator.translateTypeBounds(oldType21.bounds()));
            } else if (type2 instanceof Types.OrType) {
                Types.OrType oldType22 = (Types.OrType)type2;
                type = new Types.OrType(typeTranslator.translateType(oldType22.first()), typeTranslator.translateType(oldType22.second()));
            } else if (type2 instanceof Types.AndType) {
                Types.AndType oldType23 = (Types.AndType)type2;
                type = new Types.AndType(typeTranslator.translateType(oldType23.first()), typeTranslator.translateType(oldType23.second()));
            } else {
                if (type2 instanceof Types.CustomTransientGroundType) {
                    Types.CustomTransientGroundType oldType24 = (Types.CustomTransientGroundType)type2;
                    throw new Exceptions.InvalidProgramStructureException(new StringBuilder(33).append("Unexpected custom transient type ").append(oldType24).toString());
                }
                throw new MatchError((Object)type2);
            }
        }
        return type;
    }

    public Types.TypeBounds translateTypeBounds(Types.TypeBounds oldBounds) {
        Types.TypeAlias typeAlias;
        Types.TypeBounds typeBounds = oldBounds;
        if (typeBounds instanceof Types.RealTypeBounds) {
            Types.RealTypeBounds realTypeBounds = Types.RealTypeBounds$.MODULE$.unapply((Types.RealTypeBounds)typeBounds);
            Types.Type type = realTypeBounds._1();
            Types.Type type2 = realTypeBounds._2();
            Types.Type low = type;
            Types.Type high = type2;
            typeAlias = Types.RealTypeBounds$.MODULE$.apply(this.translateType(low), this.translateType(high));
        } else if (typeBounds instanceof Types.TypeAlias) {
            Types.Type type;
            Types.TypeAlias typeAlias2 = Types.TypeAlias$.MODULE$.unapply((Types.TypeAlias)typeBounds);
            Types.Type alias = type = typeAlias2._1();
            typeAlias = Types.TypeAlias$.MODULE$.apply(this.translateType(alias));
        } else {
            throw new MatchError((Object)typeBounds);
        }
        return (Types.TypeBounds)typeAlias;
    }

    private Types.TypeRef translateClassTypeParamRef(Types.Type translatedPrefix, Symbols.ClassTypeParamSymbol oldSym) {
        int typeParamIndex = BoxesRunTime.unboxToInt(this.withOldCtx((Function1 & Serializable)evidence$1 -> oldSym.owner().typeParams(evidence$1).indexOf((Object)oldSym)));
        Symbols.ClassTypeParamSymbol translatedSym = (Symbols.ClassTypeParamSymbol)this.withNewCtx((Function1 & Serializable)evidence$2 -> {
            Types.Type type = translatedPrefix;
            if (!(type instanceof Types.ThisType)) {
                throw new NotImplementedError(new StringBuilder(59).append("cannot translate class type param ref with non-this prefix ").append(translatedPrefix).toString());
            }
            Types.ThisType translatedPrefix = (Types.ThisType)type;
            return (Symbols.ClassTypeParamSymbol)translatedPrefix.cls(evidence$2).typeParams(evidence$2).apply(typeParamIndex);
        });
        return Types.TypeRef$.MODULE$.apply((Types.Prefix)translatedPrefix, (Symbols.TypeSymbol)translatedSym);
    }

    private <A> A withOldCtx(Function1<Contexts.Context, A> f) {
        return (A)f.apply((Object)this.oldCtx);
    }

    private <A> A withNewCtx(Function1<Contexts.Context, A> f) {
        return (A)f.apply((Object)this.newCtx);
    }
}

