/*
 * Decompiled with CFR 0.152.
 */
package tastymima;

import java.io.Serializable;
import java.util.IdentityHashMap;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import tastyquery.Contexts;
import tastyquery.Exceptions;
import tastyquery.Symbols;
import tastyquery.Types;

public final class TypeTranslator {
    private final Contexts.Context oldCtx;
    private final Contexts.Context newCtx;
    private final IdentityHashMap<Types.Binders, Types.Binders> translatedBinders;

    public TypeTranslator(Contexts.Context oldCtx, Contexts.Context newCtx) {
        this.oldCtx = oldCtx;
        this.newCtx = newCtx;
        this.translatedBinders = new IdentityHashMap();
    }

    public Types.Type translateType(Types.Type oldType) {
        Types.Type type;
        while (true) {
            if ((type = oldType) instanceof Types.NamedType) {
                Types.NamedType oldType2 = (Types.NamedType)type;
                Types.Prefix prefix = oldType2.prefix();
                if (prefix instanceof Types.Type) {
                    Symbols.TermOrTypeSymbol termOrTypeSymbol;
                    Types.Type oldPrefix = (Types.Type)prefix;
                    Types.Type translatedPrefix = this.translateType(oldPrefix);
                    Option option = oldType2.optSymbol(this.oldCtx);
                    if (option instanceof Some && (termOrTypeSymbol = (Symbols.TermOrTypeSymbol)((Some)option).value()) instanceof Symbols.ClassTypeParamSymbol) {
                        Symbols.ClassTypeParamSymbol oldSym = (Symbols.ClassTypeParamSymbol)termOrTypeSymbol;
                        return this.translateClassTypeParamRef(translatedPrefix, oldSym);
                    }
                    return Types.NamedType$.MODULE$.apply(translatedPrefix, oldType2.name(), this.newCtx);
                }
                if (Types.NoPrefix$.MODULE$.equals(prefix)) {
                    throw new Exceptions.InvalidProgramStructureException(new StringBuilder(21).append("Unexpected local ref ").append(oldType2).toString());
                }
                throw new MatchError((Object)prefix);
            }
            if (type instanceof Types.PackageRef) {
                Types.PackageRef oldType3 = (Types.PackageRef)type;
                return new Types.PackageRef(oldType3.fullyQualifiedName());
            }
            if (type instanceof Types.ThisType) {
                Types.ThisType oldType4 = (Types.ThisType)type;
                return new Types.ThisType((Types.TypeRef)this.translateType((Types.Type)oldType4.tref()));
            }
            if (type instanceof Types.SuperType) {
                Types.SuperType oldType5 = (Types.SuperType)type;
                Types.ThisType translatedThistpe = (Types.ThisType)this.translateType((Types.Type)oldType5.thistpe());
                Option translatedExplicitSupertpe = oldType5.explicitSupertpe().map((Function1 & Serializable)_$1 -> this.translateType((Types.Type)_$1));
                return new Types.SuperType(translatedThistpe, translatedExplicitSupertpe);
            }
            if (type instanceof Types.ConstantType) {
                Types.ConstantType oldType6 = (Types.ConstantType)type;
                return new Types.ConstantType(oldType6.value());
            }
            if (type instanceof Types.AppliedType) {
                Types.AppliedType oldType7 = (Types.AppliedType)type;
                return new Types.AppliedType(this.translateType(oldType7.tycon()), oldType7.args().map((Function1 & Serializable)_$2 -> this.translateType((Types.Type)_$2)));
            }
            if (type instanceof Types.ByNameType) {
                Types.ByNameType oldType8 = (Types.ByNameType)type;
                return new Types.ByNameType(this.translateType(oldType8.resultType()));
            }
            if (type instanceof Types.TermLambdaType) {
                Types.TermLambdaType oldType9 = (Types.TermLambdaType)type;
                return (Types.Type)((Types.TermLambdaType)oldType9.companion().apply(oldType9.paramNames(), (Function1 & Serializable)lt -> {
                    this.translatedBinders.put((Types.Binders)oldType9, (Types.Binders)lt);
                    return oldType9.paramInfos().map((Function1 & Serializable)_$3 -> this.translateType((Types.Type)_$3));
                }, (Function1 & Serializable)lt -> this.translateType(oldType9.resultType())));
            }
            if (type instanceof Types.TypeLambdaType) {
                Types.TypeLambdaType oldType10 = (Types.TypeLambdaType)type;
                return (Types.Type)((Types.TypeLambdaType)oldType10.companion().apply(oldType10.paramNames(), (Function1 & Serializable)lt -> {
                    this.translatedBinders.put((Types.Binders)oldType10, (Types.Binders)lt);
                    return oldType10.paramInfos().map((Function1 & Serializable)_$4 -> this.translateTypeBounds((Types.TypeBounds)_$4));
                }, (Function1 & Serializable)lt -> this.translateType(oldType10.resultType())));
            }
            if (type instanceof Types.ParamRef) {
                Types.ParamRef oldType11 = (Types.ParamRef)type;
                Types.Binders x$proxy1 = this.translatedBinders.get(oldType11.binders());
                if (x$proxy1 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Types.ParamRefBinders translatedParamBinders = (Types.ParamRefBinders)x$proxy1;
                return (Types.Type)translatedParamBinders.paramRefs().apply(oldType11.paramNum());
            }
            if (!(type instanceof Types.AnnotatedType)) break;
            Types.AnnotatedType oldType12 = (Types.AnnotatedType)type;
            oldType = oldType12.typ();
        }
        if (type instanceof Types.TypeRefinement) {
            Types.TypeRefinement oldType13 = (Types.TypeRefinement)type;
            return new Types.TypeRefinement(this.translateType(oldType13.parent()), oldType13.refinedName(), this.translateTypeBounds(oldType13.refinedBounds()));
        }
        if (type instanceof Types.TermRefinement) {
            Types.TermRefinement oldType14 = (Types.TermRefinement)type;
            return new Types.TermRefinement(this.translateType(oldType14.parent()), oldType14.refinedName(), this.translateType(oldType14.refinedType()));
        }
        if (type instanceof Types.RecType) {
            Types.RecType oldType15 = (Types.RecType)type;
            return Types.RecType$.MODULE$.apply((Function1 & Serializable)rt -> {
                this.translatedBinders.put((Types.Binders)oldType15, (Types.Binders)rt);
                return this.translateType(oldType15.parent());
            });
        }
        if (type instanceof Types.RecThis) {
            Types.RecThis oldType16 = (Types.RecThis)type;
            Types.Binders x$proxy2 = this.translatedBinders.get(oldType16.binders());
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            Types.RecType translatedRecType = (Types.RecType)x$proxy2;
            return translatedRecType.recThis();
        }
        if (type instanceof Types.MatchType) {
            Types.MatchType oldType17 = (Types.MatchType)type;
            Types.Type translatedBound = this.translateType(oldType17.bound());
            Types.Type translatedScrutinee = this.translateType(oldType17.scrutinee());
            List translatedCases = oldType17.cases().map((Function1 & Serializable)_$5 -> this.translateMatchTypeCase((Types.MatchTypeCase)_$5));
            return new Types.MatchType(translatedBound, translatedScrutinee, translatedCases);
        }
        if (type instanceof Types.WildcardTypeBounds) {
            Types.WildcardTypeBounds oldType18 = (Types.WildcardTypeBounds)type;
            return new Types.WildcardTypeBounds(this.translateTypeBounds(oldType18.bounds()));
        }
        if (type instanceof Types.OrType) {
            Types.OrType oldType19 = (Types.OrType)type;
            return new Types.OrType(this.translateType(oldType19.first()), this.translateType(oldType19.second()));
        }
        if (type instanceof Types.AndType) {
            Types.AndType oldType20 = (Types.AndType)type;
            return new Types.AndType(this.translateType(oldType20.first()), this.translateType(oldType20.second()));
        }
        if (type instanceof Types.CustomTransientGroundType) {
            Types.CustomTransientGroundType oldType21 = (Types.CustomTransientGroundType)type;
            throw new Exceptions.InvalidProgramStructureException(new StringBuilder(33).append("Unexpected custom transient type ").append(oldType21).toString());
        }
        throw new MatchError((Object)type);
    }

    public Types.TypeBounds translateTypeBounds(Types.TypeBounds oldBounds) {
        Types.TypeAlias typeAlias;
        Types.TypeBounds typeBounds = oldBounds;
        if (typeBounds instanceof Types.RealTypeBounds) {
            Types.RealTypeBounds realTypeBounds = Types.RealTypeBounds$.MODULE$.unapply((Types.RealTypeBounds)typeBounds);
            Types.Type type = realTypeBounds._1();
            Types.Type type2 = realTypeBounds._2();
            Types.Type low = type;
            Types.Type high = type2;
            typeAlias = Types.RealTypeBounds$.MODULE$.apply(this.translateType(low), this.translateType(high));
        } else if (typeBounds instanceof Types.TypeAlias) {
            Types.Type type;
            Types.TypeAlias typeAlias2 = Types.TypeAlias$.MODULE$.unapply((Types.TypeAlias)typeBounds);
            Types.Type alias = type = typeAlias2._1();
            typeAlias = Types.TypeAlias$.MODULE$.apply(this.translateType(alias));
        } else {
            throw new MatchError((Object)typeBounds);
        }
        return (Types.TypeBounds)typeAlias;
    }

    private Types.TypeRef translateClassTypeParamRef(Types.Type translatedPrefix, Symbols.ClassTypeParamSymbol oldSym) {
        int typeParamIndex = BoxesRunTime.unboxToInt(this.withOldCtx((Function1 & Serializable)evidence$1 -> oldSym.owner().typeParams(evidence$1).indexOf((Object)oldSym)));
        Symbols.ClassTypeParamSymbol translatedSym = (Symbols.ClassTypeParamSymbol)this.withNewCtx((Function1 & Serializable)evidence$2 -> {
            Types.Type type = translatedPrefix;
            if (type instanceof Types.ThisType) {
                Types.ThisType translatedPrefix = (Types.ThisType)type;
                return (Symbols.ClassTypeParamSymbol)translatedPrefix.cls(evidence$2).typeParams(evidence$2).apply(typeParamIndex);
            }
            throw new NotImplementedError(new StringBuilder(59).append("cannot translate class type param ref with non-this prefix ").append(translatedPrefix).toString());
        });
        return Types.TypeRef$.MODULE$.apply((Types.Prefix)translatedPrefix, (Symbols.TypeSymbol)translatedSym);
    }

    private Types.MatchTypeCase translateMatchTypeCase(Types.MatchTypeCase oldCase) {
        return Types.MatchTypeCase$.MODULE$.apply(oldCase.paramNames(), (Function1 & Serializable)tmc -> {
            this.translatedBinders.put((Types.Binders)oldCase, (Types.Binders)tmc);
            return oldCase.paramTypeBounds().map((Function1 & Serializable)_$6 -> this.translateTypeBounds((Types.TypeBounds)_$6));
        }, (Function1 & Serializable)tmc -> this.translateType(oldCase.pattern()), (Function1 & Serializable)tmc -> this.translateType(oldCase.result()));
    }

    private <A> A withOldCtx(Function1<Contexts.Context, A> f) {
        return (A)f.apply((Object)this.oldCtx);
    }

    private <A> A withNewCtx(Function1<Contexts.Context, A> f) {
        return (A)f.apply((Object)this.newCtx);
    }
}

