/*
 * Decompiled with CFR 0.152.
 */
package tastymima;

import java.io.Serializable;
import java.util.IdentityHashMap;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.runtime.Scala3RunTime$;
import tastyquery.Contexts;
import tastyquery.Exceptions;
import tastyquery.Symbols;
import tastyquery.Types;

public final class TypeTranslator {
    private final Contexts.Context oldCtx;
    private final Contexts.Context newCtx;
    private final IdentityHashMap<Types.Binders, Types.Binders> translatedBinders;

    public TypeTranslator(Contexts.Context oldCtx, Contexts.Context newCtx) {
        this.oldCtx = oldCtx;
        this.newCtx = newCtx;
        this.translatedBinders = new IdentityHashMap();
    }

    public Types.Type translateType(Types.Type oldType) {
        Types.Type type;
        while (true) {
            if ((type = oldType) instanceof Types.NamedType) {
                Types.NamedType oldType2 = (Types.NamedType)type;
                Types.Prefix prefix = oldType2.prefix();
                if (prefix instanceof Types.PackageRef) {
                    Types.PackageRef oldPrefix = (Types.PackageRef)prefix;
                    Types.PackageRef translatedPrefix = this.newCtx.findPackageFromRoot(oldPrefix.fullyQualifiedName()).packageRef();
                    return Types.NamedType$.MODULE$.apply((Types.NonEmptyPrefix)translatedPrefix, oldType2.name());
                }
                if (prefix instanceof Types.Type) {
                    Symbols.TermOrTypeSymbol termOrTypeSymbol;
                    Types.Type oldPrefix = (Types.Type)prefix;
                    Types.Type translatedPrefix = this.translateType(oldPrefix);
                    Option option = oldType2.optSymbol(this.oldCtx);
                    if (option instanceof Some && (termOrTypeSymbol = (Symbols.TermOrTypeSymbol)((Some)option).value()) instanceof Symbols.ClassTypeParamSymbol) {
                        Symbols.ClassTypeParamSymbol oldSym = (Symbols.ClassTypeParamSymbol)termOrTypeSymbol;
                        return this.translateClassTypeParamRef(translatedPrefix, oldSym);
                    }
                    return Types.NamedType$.MODULE$.apply((Types.NonEmptyPrefix)translatedPrefix, oldType2.name());
                }
                if (Types.NoPrefix$.MODULE$.equals(prefix)) {
                    throw new Exceptions.InvalidProgramStructureException(new StringBuilder(21).append("Unexpected local ref ").append(oldType2).toString());
                }
                throw new MatchError((Object)prefix);
            }
            if (type instanceof Types.ThisType) {
                Types.ThisType oldType3 = (Types.ThisType)type;
                return new Types.ThisType((Types.TypeRef)this.translateType((Types.Type)oldType3.tref()));
            }
            if (type instanceof Types.SuperType) {
                Types.SuperType oldType4 = (Types.SuperType)type;
                Types.ThisType translatedThistpe = (Types.ThisType)this.translateType((Types.Type)oldType4.thistpe());
                Option translatedExplicitSupertpe = oldType4.explicitSupertpe().map((Function1 & Serializable)_$1 -> this.translateType((Types.Type)_$1));
                return new Types.SuperType(translatedThistpe, translatedExplicitSupertpe);
            }
            if (type instanceof Types.ConstantType) {
                Types.ConstantType oldType5 = (Types.ConstantType)type;
                return new Types.ConstantType(oldType5.value());
            }
            if (type instanceof Types.AppliedType) {
                Types.AppliedType oldType6 = (Types.AppliedType)type;
                Types.Type translatedTycon = this.translateType(oldType6.tycon());
                List translatedArgs = oldType6.args().map((Function1 & Serializable)arg -> {
                    Types.TypeOrWildcard typeOrWildcard = arg;
                    if (typeOrWildcard instanceof Types.Type) {
                        Types.Type arg2 = (Types.Type)typeOrWildcard;
                        return this.translateType(arg2);
                    }
                    if (typeOrWildcard instanceof Types.WildcardTypeArg) {
                        Types.WildcardTypeArg arg3 = (Types.WildcardTypeArg)typeOrWildcard;
                        return new Types.WildcardTypeArg(this.translateTypeBounds(arg3.bounds()));
                    }
                    throw new MatchError((Object)typeOrWildcard);
                });
                return new Types.AppliedType(translatedTycon, translatedArgs);
            }
            if (type instanceof Types.ByNameType) {
                Types.ByNameType oldType7 = (Types.ByNameType)type;
                return new Types.ByNameType(this.translateType(oldType7.resultType()));
            }
            if (type instanceof Types.TypeLambda) {
                Types.TypeLambda oldType8 = (Types.TypeLambda)type;
                return Types.TypeLambda$.MODULE$.apply(oldType8.paramNames(), (Function1 & Serializable)lt -> {
                    this.translatedBinders.put((Types.Binders)oldType8, (Types.Binders)lt);
                    return oldType8.paramInfos().map((Function1 & Serializable)_$2 -> this.translateTypeBounds((Types.TypeBounds)_$2));
                }, (Function1 & Serializable)lt -> this.translateType(oldType8.resultType()));
            }
            if (type instanceof Types.ParamRef) {
                Types.ParamRef oldType9 = (Types.ParamRef)type;
                Types.Binders x$proxy1 = this.translatedBinders.get(oldType9.binders());
                if (x$proxy1 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Types.ParamRefBinders translatedParamBinders = (Types.ParamRefBinders)x$proxy1;
                return (Types.Type)translatedParamBinders.paramRefs().apply(oldType9.paramNum());
            }
            if (!(type instanceof Types.AnnotatedType)) break;
            Types.AnnotatedType oldType10 = (Types.AnnotatedType)type;
            oldType = oldType10.typ();
        }
        if (type instanceof Types.TypeRefinement) {
            Types.TypeRefinement oldType11 = (Types.TypeRefinement)type;
            return new Types.TypeRefinement(this.translateType(oldType11.parent()), oldType11.refinedName(), this.translateTypeBounds(oldType11.refinedBounds()));
        }
        if (type instanceof Types.TermRefinement) {
            Types.TermRefinement oldType12 = (Types.TermRefinement)type;
            return new Types.TermRefinement(this.translateType(oldType12.parent()), oldType12.isStable(), oldType12.refinedName(), this.translateTypeOrMethodic(oldType12.refinedType()));
        }
        if (type instanceof Types.RecType) {
            Types.RecType oldType13 = (Types.RecType)type;
            return Types.RecType$.MODULE$.apply((Function1 & Serializable)rt -> {
                this.translatedBinders.put((Types.Binders)oldType13, (Types.Binders)rt);
                return this.translateType(oldType13.parent());
            });
        }
        if (type instanceof Types.RecThis) {
            Types.RecThis oldType14 = (Types.RecThis)type;
            Types.Binders x$proxy2 = this.translatedBinders.get(oldType14.binders());
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            Types.RecType translatedRecType = (Types.RecType)x$proxy2;
            return translatedRecType.recThis();
        }
        if (type instanceof Types.MatchType) {
            Types.MatchType oldType15 = (Types.MatchType)type;
            Types.Type translatedBound = this.translateType(oldType15.bound());
            Types.Type translatedScrutinee = this.translateType(oldType15.scrutinee());
            List translatedCases = oldType15.cases().map((Function1 & Serializable)_$3 -> this.translateMatchTypeCase((Types.MatchTypeCase)_$3));
            return new Types.MatchType(translatedBound, translatedScrutinee, translatedCases);
        }
        if (type instanceof Types.NothingType) {
            return this.newCtx.defn().NothingType();
        }
        if (type instanceof Types.AnyKindType) {
            return this.newCtx.defn().AnyKindType();
        }
        if (type instanceof Types.OrType) {
            Types.OrType oldType16 = (Types.OrType)type;
            return new Types.OrType(this.translateType(oldType16.first()), this.translateType(oldType16.second()));
        }
        if (type instanceof Types.AndType) {
            Types.AndType oldType17 = (Types.AndType)type;
            return new Types.AndType(this.translateType(oldType17.first()), this.translateType(oldType17.second()));
        }
        if (type instanceof Types.SkolemType) {
            Types.SkolemType oldType18 = (Types.SkolemType)type;
            throw new Exceptions.InvalidProgramStructureException(new StringBuilder(23).append("Unexpected skolem type ").append(oldType18).toString());
        }
        if (type instanceof Types.CustomTransientGroundType) {
            Types.CustomTransientGroundType oldType19 = (Types.CustomTransientGroundType)type;
            throw new Exceptions.InvalidProgramStructureException(new StringBuilder(33).append("Unexpected custom transient type ").append(oldType19).toString());
        }
        throw new MatchError((Object)type);
    }

    public Types.TypeOrMethodic translateTypeOrMethodic(Types.TypeOrMethodic oldType) {
        Types.TypeOrMethodic typeOrMethodic = oldType;
        if (typeOrMethodic instanceof Types.Type) {
            Types.Type oldType2 = (Types.Type)typeOrMethodic;
            return this.translateType(oldType2);
        }
        if (typeOrMethodic instanceof Types.MethodType) {
            Types.MethodType oldType3 = (Types.MethodType)typeOrMethodic;
            return oldType3.companion().apply(oldType3.paramNames(), (Function1 & Serializable)lt -> {
                this.translatedBinders.put((Types.Binders)oldType3, (Types.Binders)lt);
                return oldType3.paramInfos().map((Function1 & Serializable)_$4 -> this.translateType((Types.Type)_$4));
            }, (Function1 & Serializable)lt -> this.translateTypeOrMethodic(oldType3.resultType()));
        }
        if (typeOrMethodic instanceof Types.PolyType) {
            Types.PolyType oldType4 = (Types.PolyType)typeOrMethodic;
            return Types.PolyType$.MODULE$.apply(oldType4.paramNames(), (Function1 & Serializable)lt -> {
                this.translatedBinders.put((Types.Binders)oldType4, (Types.Binders)lt);
                return oldType4.paramInfos().map((Function1 & Serializable)_$5 -> this.translateTypeBounds((Types.TypeBounds)_$5));
            }, (Function1 & Serializable)lt -> this.translateTypeOrMethodic(oldType4.resultType()));
        }
        throw new MatchError((Object)typeOrMethodic);
    }

    public Types.TypeBounds translateTypeBounds(Types.TypeBounds oldBounds) {
        Types.TypeAlias typeAlias;
        Types.TypeBounds typeBounds = oldBounds;
        if (typeBounds instanceof Types.RealTypeBounds) {
            Types.RealTypeBounds realTypeBounds = Types.RealTypeBounds$.MODULE$.unapply((Types.RealTypeBounds)typeBounds);
            Types.Type type = realTypeBounds._1();
            Types.Type type2 = realTypeBounds._2();
            Types.Type low = type;
            Types.Type high = type2;
            typeAlias = Types.RealTypeBounds$.MODULE$.apply(this.translateType(low), this.translateType(high));
        } else if (typeBounds instanceof Types.TypeAlias) {
            Types.Type type;
            Types.TypeAlias typeAlias2 = Types.TypeAlias$.MODULE$.unapply((Types.TypeAlias)typeBounds);
            Types.Type alias = type = typeAlias2._1();
            typeAlias = Types.TypeAlias$.MODULE$.apply(this.translateType(alias));
        } else {
            throw new MatchError((Object)typeBounds);
        }
        return (Types.TypeBounds)typeAlias;
    }

    private Types.TypeRef translateClassTypeParamRef(Types.Type translatedPrefix, Symbols.ClassTypeParamSymbol oldSym) {
        int typeParamIndex = oldSym.owner().typeParams().indexOf((Object)oldSym);
        Types.Type type = translatedPrefix;
        if (!(type instanceof Types.ThisType)) {
            throw new NotImplementedError(new StringBuilder(59).append("cannot translate class type param ref with non-this prefix ").append(translatedPrefix).toString());
        }
        Types.ThisType translatedPrefix2 = (Types.ThisType)type;
        Symbols.ClassTypeParamSymbol translatedSym = (Symbols.ClassTypeParamSymbol)translatedPrefix2.cls(this.newCtx).typeParams().apply(typeParamIndex);
        return Types.TypeRef$.MODULE$.apply((Types.Prefix)translatedPrefix, (Symbols.TypeSymbol)translatedSym);
    }

    private Types.MatchTypeCase translateMatchTypeCase(Types.MatchTypeCase oldCase) {
        return Types.MatchTypeCase$.MODULE$.apply(oldCase.paramNames(), (Function1 & Serializable)tmc -> {
            this.translatedBinders.put((Types.Binders)oldCase, (Types.Binders)tmc);
            return oldCase.paramTypeBounds().map((Function1 & Serializable)_$6 -> this.translateTypeBounds((Types.TypeBounds)_$6));
        }, (Function1 & Serializable)tmc -> this.translateType(oldCase.pattern()), (Function1 & Serializable)tmc -> this.translateType(oldCase.result()));
    }
}

