/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.tasties;

import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyBuffer$Addr$;
import dotty.tools.tasty.TastyHeaderUnpickler;
import dotty.tools.tasty.TastyReader;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import tastyquery.Contexts;
import tastyquery.Exceptions;
import tastyquery.Names;
import tastyquery.Names$;
import tastyquery.Names$FullyQualifiedName$;
import tastyquery.Names$nme$;
import tastyquery.Signatures;
import tastyquery.Signatures$ParamSig$Term$;
import tastyquery.Signatures$ParamSig$TypeLen$;
import tastyquery.Signatures$Signature$;
import tastyquery.reader.UTF8Utils$;
import tastyquery.reader.tasties.PositionUnpickler;
import tastyquery.reader.tasties.TreeUnpickler;

public class TastyUnpickler {
    private final TastyReader reader;
    private final HashMap<String, TastyReader> sectionReader;
    private final NameTable nameAtRef;

    public TastyUnpickler(TastyReader reader) {
        this.reader = reader;
        this.sectionReader = new HashMap();
        this.nameAtRef = new NameTable();
        new TastyHeaderUnpickler(reader).readHeader();
        reader.until(reader.readEnd(), (Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        while (!reader.isAtEnd()) {
            String secName = this.readString();
            int secEnd = reader.readEnd();
            this.sectionReader.update((Object)secName, (Object)new TastyReader(this.bytes(), reader.currentAddr(), secEnd, reader.currentAddr()));
            reader.goto(secEnd);
        }
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    public TastyUnpickler(byte[] bytes) {
        this(new TastyReader(bytes));
    }

    public NameTable nameAtRef() {
        return this.nameAtRef;
    }

    private Names.TermName readName() {
        return this.nameAtRef().simple(this.reader.readNameRef());
    }

    private Names.FullyQualifiedName readFullyQualifiedName() {
        return this.nameAtRef().fullyQualified(this.reader.readNameRef());
    }

    private Object readEitherName() {
        return this.nameAtRef().apply(this.reader.readNameRef());
    }

    private String readString() {
        return this.readName().toString();
    }

    private Signatures.ParamSig readParamSig() {
        int ref = this.reader.readInt();
        return ref < 0 ? Signatures$ParamSig$TypeLen$.MODULE$.apply(RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(ref))) : Signatures$ParamSig$Term$.MODULE$.apply(this.nameAtRef().fullyQualified(ref).mapLast((Function1<Names.Name, Names.Name>)(Function1 & Serializable)_$1 -> _$1.toTypeName()));
    }

    private Object readNameContents() {
        Product product;
        int tag = this.reader.readByte();
        int length = this.reader.readNat();
        int start = this.reader.currentAddr();
        int end = TastyBuffer$Addr$.MODULE$.$plus$extension(start, length);
        int n = tag;
        switch (n) {
            case 1: {
                this.reader.goto(end);
                product = Names$.MODULE$.termName(UTF8Utils$.MODULE$.decode(this.bytes(), start, length));
                break;
            }
            case 2: {
                Names.FullyQualifiedName qual = this.readFullyQualifiedName();
                Names.TermName item = this.readName();
                product = Names$FullyQualifiedName$.MODULE$.apply((List<Names.Name>)((List)qual.path().$colon$plus((Object)item)));
                break;
            }
            case 3: 
            case 4: {
                product = new Names.ExpandedName(tag, this.readName(), this.readName().asSimpleName());
                break;
            }
            case 10: {
                String separator = this.readName().toString();
                int num = this.reader.readNat();
                List originals = this.reader.until(end, this::$anonfun$1);
                Names.TermName original = originals.isEmpty() ? Names$nme$.MODULE$.EmptyTermName() : (Names.TermName)originals.head();
                product = new Names.UniqueName(separator, original, num);
                break;
            }
            case 11: {
                product = new Names.DefaultGetterName(this.readName(), this.reader.readNat());
                break;
            }
            case 62: 
            case 63: {
                Names.TermName original = this.readName();
                Names.TermName target = tag == 62 ? this.readName() : original;
                Names.FullyQualifiedName result = this.readFullyQualifiedName().mapLast((Function1<Names.Name, Names.Name>)(Function1 & Serializable)_$2 -> _$2.toTypeName());
                List paramsSig = this.reader.until(end, this::$anonfun$3);
                Signatures.Signature sig = Signatures$Signature$.MODULE$.apply(paramsSig, result);
                product = new Names.SignedName(original, sig, target);
                break;
            }
            case 20: 
            case 21: {
                product = new Names.PrefixedName(tag, this.readName());
                break;
            }
            case 22: {
                product = new Names.SuffixedName(tag, this.readName());
                break;
            }
            case 23: {
                Object object = this.readEitherName();
                if (object instanceof Names.TermName) {
                    Names.TermName simple = (Names.TermName)object;
                    product = simple.withObjectSuffix();
                    break;
                }
                if (object instanceof Names.FullyQualifiedName) {
                    Names.FullyQualifiedName qualified = (Names.FullyQualifiedName)object;
                    product = qualified.mapLast((Function1<Names.Name, Names.Name>)(Function1 & Serializable)_$3 -> _$3.asSimpleName().withObjectSuffix());
                    break;
                }
                throw new MatchError(object);
            }
            default: {
                throw new Exceptions.TastyFormatException(new StringBuilder(16).append("unexpected tag: ").append(tag).toString());
            }
        }
        Names.DerivedName result = product;
        if (!TastyBuffer$Addr$.MODULE$.$eq$eq$extension(this.reader.currentAddr(), end)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(12).append("bad name ").append(result).append(" ").append(new TastyBuffer.Addr(start)).append(" ").append(new TastyBuffer.Addr(this.reader.currentAddr())).append(" ").append(new TastyBuffer.Addr(end)).toString());
        }
        return result;
    }

    public <R> Option<R> unpickle(SectionUnpickler<R> sec, Contexts.Context x$2) {
        return this.sectionReader.get((Object)sec.name()).map((Function1 & Serializable)reader -> sec.unpickle((TastyReader)reader, this.nameAtRef(), x$2));
    }

    public byte[] bytes() {
        return this.reader.bytes();
    }

    private final void $init$$$anonfun$1() {
        this.nameAtRef().add(this.readNameContents());
    }

    private final Names.TermName $anonfun$1() {
        return this.readName();
    }

    private final Signatures.ParamSig $anonfun$3() {
        return this.readParamSig();
    }

    public static final class NameTable {
        private final ArrayBuffer<Object> names = new ArrayBuffer();

        public void add(Object name) {
            this.names.$plus$eq(name);
        }

        public Object apply(int ref) {
            return this.names.apply(ref);
        }

        public Names.TermName simple(int ref) {
            Object object = this.apply(ref);
            if (!(object instanceof Names.TermName)) {
                if (object instanceof Names.FullyQualifiedName) {
                    Names.FullyQualifiedName name = (Names.FullyQualifiedName)object;
                    throw new Exceptions.TastyFormatException(new StringBuilder(26).append("Expected TermName but got ").append(name.toDebugString()).toString());
                }
                throw new MatchError(object);
            }
            Names.TermName name = (Names.TermName)object;
            return name;
        }

        public Names.FullyQualifiedName fullyQualified(int ref) {
            Names.FullyQualifiedName fullyQualifiedName;
            Object object = this.apply(ref);
            if (object instanceof Names.FullyQualifiedName) {
                Names.FullyQualifiedName name;
                fullyQualifiedName = name = (Names.FullyQualifiedName)object;
            } else if (object instanceof Names.TermName) {
                Names.TermName name = (Names.TermName)object;
                fullyQualifiedName = Names$FullyQualifiedName$.MODULE$.apply((List<Names.Name>)package$.MODULE$.Nil().$colon$colon((Object)name));
            } else {
                throw new MatchError(object);
            }
            return fullyQualifiedName;
        }
    }

    public static class PositionSectionUnpickler
    extends SectionUnpickler<PositionUnpickler> {
        public PositionSectionUnpickler() {
            super("Positions");
        }

        @Override
        public PositionUnpickler unpickle(TastyReader reader, NameTable nameAtRef, Contexts.Context x$3) {
            return new PositionUnpickler(reader, nameAtRef);
        }
    }

    public static abstract class SectionUnpickler<R> {
        private final String name;

        public SectionUnpickler(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract R unpickle(TastyReader var1, NameTable var2, Contexts.Context var3);
    }

    public static class TreeSectionUnpickler
    extends SectionUnpickler<TreeUnpickler> {
        private final Option<PositionUnpickler> posUnpickler;

        public TreeSectionUnpickler(Option<PositionUnpickler> posUnpickler) {
            this.posUnpickler = posUnpickler;
            super("ASTs");
        }

        @Override
        public TreeUnpickler unpickle(TastyReader reader, NameTable nameAtRef, Contexts.Context x$3) {
            return new TreeUnpickler(reader, nameAtRef, this.posUnpickler, x$3);
        }
    }
}

