/*
 * Decompiled with CFR 0.152.
 */
package tastyquery;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.Scala3RunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import tastyquery.Classpaths;
import tastyquery.Contexts$;
import tastyquery.Definitions;
import tastyquery.Exceptions;
import tastyquery.Names;
import tastyquery.Names$;
import tastyquery.Names$FullyQualifiedName$;
import tastyquery.Names$nme$;
import tastyquery.Symbols;
import tastyquery.Symbols$PackageSymbol$;
import tastyquery.Types;
import tastyquery.reader.Loaders;

public final class Contexts {
    public static Context init(Classpaths.Classpath classpath) {
        return Contexts$.MODULE$.init(classpath);
    }

    public static boolean initialisedRoot(Loaders.Loader.Root root) {
        return Contexts$.MODULE$.initialisedRoot(root);
    }

    public static final class Context {
        private final Loaders.Loader classloader;
        private Context given_Context$lzy1;
        private boolean given_Contextbitmap$1;
        private final Symbols.PackageSymbol RootPackage;
        private final Symbols.PackageSymbol EmptyPackage;
        private final Definitions defn;

        public Context(Loaders.Loader classloader) {
            this.classloader = classloader;
            Tuple2<Symbols.PackageSymbol, Symbols.PackageSymbol> tuple2 = Symbols$PackageSymbol$.MODULE$.createRoots();
            Symbols.PackageSymbol RootPackage = (Symbols.PackageSymbol)tuple2._1();
            Symbols.PackageSymbol EmptyPackage = (Symbols.PackageSymbol)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)RootPackage, (Object)EmptyPackage);
            this.RootPackage = (Symbols.PackageSymbol)tuple22._1();
            this.EmptyPackage = (Symbols.PackageSymbol)tuple22._2();
            this.defn = new Definitions(this, this.RootPackage, this.EmptyPackage);
        }

        public Loaders.Loader classloader() {
            return this.classloader;
        }

        private final Context given_Context() {
            if (!this.given_Contextbitmap$1) {
                this.given_Context$lzy1 = this;
                this.given_Contextbitmap$1 = true;
            }
            return this.given_Context$lzy1;
        }

        public Definitions defn() {
            return this.defn;
        }

        public Either<Exceptions.MemberNotFoundException, Symbols.ClassSymbol> getClassFromBinaryName(String binaryName) {
            return this.getRootIfDefined(binaryName).flatMap((Function1 & Serializable)root -> root.pkg().getDecl(root.rootName().toTypeName(), this.given_Context()).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Symbols.Symbol x) {
                    boolean bl;
                    Symbols.Symbol symbol = x;
                    if (symbol instanceof Symbols.ClassSymbol) {
                        Symbols.ClassSymbol cls = (Symbols.ClassSymbol)symbol;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(Symbols.Symbol x, Function1 function1) {
                    Object object;
                    Symbols.Symbol symbol = x;
                    if (symbol instanceof Symbols.ClassSymbol) {
                        Symbols.ClassSymbol cls = (Symbols.ClassSymbol)symbol;
                        object = cls;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            }).toRight(() -> this.getClassFromBinaryName$$anonfun$2$$anonfun$1(root)));
        }

        public boolean existsRoot(String binaryName) {
            return this.getRootIfDefined(binaryName).isRight();
        }

        public List<Symbols.Symbol> rootSymbolsIfDefined(String binaryName) {
            Nil$ nil$;
            Either<Exceptions.MemberNotFoundException, Loaders.Loader.Root> either = this.getRootIfDefined(binaryName);
            if (either instanceof Right) {
                Loaders.Loader.Root root = (Loaders.Loader.Root)((Right)either).value();
                nil$ = (List)((IterableOps)root.pkg().getDecl(root.rootName().toTypeName(), this.given_Context()).toList().$plus$plus((IterableOnce)root.pkg().getDecl(root.rootName(), this.given_Context()).toList())).$plus$plus((IterableOnce)root.pkg().getDecl(root.rootName().withObjectSuffix().toTypeName(), this.given_Context()).toList());
            } else if (either instanceof Left) {
                nil$ = package$.MODULE$.Nil();
            } else {
                throw new MatchError(either);
            }
            return nil$;
        }

        private Either<Exceptions.MemberNotFoundException, Loaders.Loader.Root> getRootIfDefined(String binaryName) {
            Either either;
            Tuple2 tuple2;
            int lastSep = binaryName.lastIndexOf(46);
            if (lastSep == -1) {
                Names.SimpleName rootName = Names$.MODULE$.termName(binaryName);
                Names.SimpleName simpleName = Names$nme$.MODULE$.EmptyPackageName();
                tuple2 = Tuple2$.MODULE$.apply((Object)Names$FullyQualifiedName$.MODULE$.apply((List<Names.Name>)package$.MODULE$.Nil().$colon$colon((Object)simpleName)), (Object)rootName);
            } else {
                String packageName = binaryName.substring(0, lastSep);
                Names.SimpleName rootName = Names$.MODULE$.termName(binaryName.substring(lastSep + 1));
                tuple2 = Tuple2$.MODULE$.apply((Object)this.classloader().toPackageName(packageName), (Object)rootName);
            }
            Tuple2 tuple22 = tuple2;
            Names.FullyQualifiedName packageName = (Names.FullyQualifiedName)tuple22._1();
            Names.SimpleName rootName = (Names.SimpleName)tuple22._2();
            try {
                Symbols.PackageSymbol pkg = new Types.PackageRef(packageName).symbol(this.given_Context());
                either = pkg.possibleRoot(rootName, this.given_Context()).toRight(() -> this.getRootIfDefined$$anonfun$1(packageName, rootName, pkg));
            }
            catch (Exceptions.MemberNotFoundException e) {
                either = package$.MODULE$.Left().apply((Object)new Exceptions.MemberNotFoundException(e.prefix(), e.name(), new StringBuilder(16).append("unknown package ").append(packageName).toString()));
            }
            return either;
        }

        public Symbols.PackageSymbol findPackageFromRoot(Names.FullyQualifiedName fullyQualifiedName) {
            return this.rec$1(this.RootPackage, fullyQualifiedName.path());
        }

        public Symbols.Symbol findSymbolFromRoot(List<Names.Name> path) {
            return this.rec$2(this.RootPackage, path);
        }

        public Symbols.PackageSymbol createPackageSymbolIfNew(Names.SimpleName name, Symbols.PackageSymbol owner) {
            Symbols.PackageSymbol packageSymbol;
            Symbols.PackageSymbol packageSymbol2 = owner;
            Symbols.PackageSymbol packageSymbol3 = this.EmptyPackage;
            if (!(packageSymbol2 != null ? !packageSymbol2.equals(packageSymbol3) : packageSymbol3 != null)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(34).append("Trying to create a subpackage ").append(name).append(" of ").append(owner).toString());
            }
            Option<Symbols.PackageSymbol> option = owner.getPackageDeclInternal(name);
            if (option instanceof Some) {
                Symbols.PackageSymbol pkg;
                packageSymbol = pkg = (Symbols.PackageSymbol)((Some)option).value();
            } else if (None$.MODULE$.equals(option)) {
                packageSymbol = Symbols$PackageSymbol$.MODULE$.create(name, owner);
            } else {
                throw new MatchError(option);
            }
            return packageSymbol;
        }

        public Symbols.PackageSymbol createPackageSymbolIfNew(Names.FullyQualifiedName fullyQualifiedName) {
            return (Symbols.PackageSymbol)fullyQualifiedName.path().foldLeft((Object)this.RootPackage, (Function2 & Serializable)(owner, name) -> this.createPackageSymbolIfNew(name.asSimpleName(), (Symbols.PackageSymbol)owner));
        }

        private final Exceptions.MemberNotFoundException getClassFromBinaryName$$anonfun$2$$anonfun$1(Loaders.Loader.Root root$1) {
            return new Exceptions.MemberNotFoundException(root$1.pkg(), root$1.rootName(), new StringBuilder(48).append("no root ").append(root$1.rootName()).append(" in ").append(root$1.pkg().fullName()).append("; perhaps it is not on the classpath").toString());
        }

        private final Exceptions.MemberNotFoundException getRootIfDefined$$anonfun$1(Names.FullyQualifiedName packageName$1, Names.SimpleName rootName$1, Symbols.PackageSymbol pkg$1) {
            return new Exceptions.MemberNotFoundException(pkg$1, rootName$1, new StringBuilder(27).append("no root ").append(rootName$1).append(" exists in package ").append(packageName$1).toString());
        }

        private final Symbols.PackageSymbol $anonfun$1(Names.SimpleName name$1, Symbols.PackageSymbol owner$tailLocal1$1) {
            throw new Exceptions.MemberNotFoundException(owner$tailLocal1$1, name$1, new StringBuilder(31).append("cannot find package member ").append(name$1).append(" of ").append(owner$tailLocal1$1).toString());
        }

        private final Symbols.PackageSymbol rec$1(Symbols.PackageSymbol owner, List path) {
            Symbols.PackageSymbol packageSymbol;
            block1: {
                List list;
                block2: {
                    List list2;
                    Names.Name name;
                    List list3 = path;
                    packageSymbol = owner;
                    while (true) {
                        Symbols.PackageSymbol next;
                        list = list3;
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list4 = list;
                        if (!(nil$ == null ? list4 != null : !nil$.equals(list4))) break block1;
                        if (!(list instanceof .colon.colon)) break block2;
                        .colon.colon colon2 = (.colon.colon)list;
                        name = (Names.Name)colon2.head();
                        list2 = colon2.next$access$1();
                        if (!(name instanceof Names.SimpleName)) break;
                        Names.SimpleName name2 = (Names.SimpleName)name;
                        List pathRest = list2;
                        Symbols.PackageSymbol packageSymbol2 = next = (Symbols.PackageSymbol)packageSymbol.getPackageDecl(name2, this.given_Context()).getOrElse(() -> this.$anonfun$1(name2, packageSymbol));
                        List list5 = pathRest;
                        packageSymbol = packageSymbol2;
                        list3 = list5;
                    }
                    Names.Name name3 = name;
                    List pathRest = list2;
                    throw new Exceptions.MemberNotFoundException(packageSymbol, name3, new StringBuilder(31).append("cannot find package member ").append(name3).append(" of ").append(packageSymbol).toString());
                }
                throw new MatchError((Object)list);
            }
            return packageSymbol;
        }

        private final Symbols.Symbol $anonfun$2(Names.Name name$2, Symbols.Symbol symbol$tailLocal1$1) {
            throw new IllegalArgumentException(new StringBuilder(23).append("cannot find member ").append(name$2.toDebugString()).append(" in ").append(symbol$tailLocal1$1).toString());
        }

        private final Symbols.Symbol rec$2(Symbols.Symbol symbol, List path) {
            Symbols.Symbol symbol2;
            block2: {
                List list;
                List list2 = path;
                symbol2 = symbol;
                while (true) {
                    Symbols.Symbol next;
                    list = list2;
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list3 = list;
                    if (!(nil$ == null ? list3 != null : !nil$.equals(list3))) break block2;
                    if (!(list instanceof .colon.colon)) break;
                    .colon.colon colon2 = (.colon.colon)list;
                    List list4 = colon2.next$access$1();
                    Names.Name name = (Names.Name)colon2.head();
                    List pathRest = list4;
                    Symbols.Symbol symbol3 = symbol2;
                    if (!(symbol3 instanceof Symbols.DeclaringSymbol)) {
                        throw new IllegalArgumentException(new StringBuilder(46).append(symbol2).append(" does not declare a scope, cannot find member ").append(name.toDebugString()).toString());
                    }
                    Symbols.DeclaringSymbol owner = (Symbols.DeclaringSymbol)((Object)symbol3);
                    Symbols.DeclaringSymbol owner2 = owner;
                    Symbols.Symbol symbol4 = next = (Symbols.Symbol)owner2.getDecl(name, this.given_Context()).getOrElse(() -> this.$anonfun$2(name, symbol2));
                    List list5 = pathRest;
                    symbol2 = symbol4;
                    list2 = list5;
                }
                throw new MatchError((Object)list);
            }
            return symbol2;
        }
    }
}

