/*
 * Decompiled with CFR 0.152.
 */
package tastyquery;

import tastyquery.Names;

public final class Exceptions {

    public static final class ClassfileFormatException
    extends UnpickleFormatException {
        public ClassfileFormatException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public ClassfileFormatException(String msg) {
            this(msg, null);
        }
    }

    public static final class CyclicReferenceException
    extends InvalidProgramStructureException {
        public CyclicReferenceException(String kind) {
            super(new StringBuilder(21).append("cyclic evaluation of ").append(kind).toString());
        }
    }

    public static abstract class InvalidProgramStructureException
    extends Exception {
        public InvalidProgramStructureException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public InvalidProgramStructureException(String msg) {
            this(msg, null);
        }
    }

    public static final class MemberNotFoundException
    extends InvalidProgramStructureException {
        private final Object prefix;
        private final Names.Name name;

        public MemberNotFoundException(Object prefix, Names.Name name, String msg) {
            this.prefix = prefix;
            this.name = name;
            super(msg);
        }

        public Object prefix() {
            return this.prefix;
        }

        public Names.Name name() {
            return this.name;
        }

        public MemberNotFoundException(Object prefix, Names.Name name) {
            this(prefix, name, new StringBuilder(21).append("Member ").append(name.toDebugString()).append(" not found in ").append(prefix).toString());
        }
    }

    public static final class NonMethodReferenceException
    extends InvalidProgramStructureException {
        public NonMethodReferenceException(String kind) {
            super(new StringBuilder(32).append("reference to non method type in ").append(kind).toString());
        }
    }

    public static final class Scala2PickleFormatException
    extends UnpickleFormatException {
        public Scala2PickleFormatException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public Scala2PickleFormatException(String msg) {
            this(msg, null);
        }
    }

    public static final class TastyFormatException
    extends UnpickleFormatException {
        public TastyFormatException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public TastyFormatException(String msg) {
            this(msg, null);
        }
    }

    public static abstract class UnpickleFormatException
    extends Exception {
        public UnpickleFormatException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

