/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.tasties;

import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyBuffer$Addr$;
import dotty.tools.tasty.TastyReader;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.Scala3RunTime$;
import tastyquery.Contexts;
import tastyquery.SourceFile;
import tastyquery.SourceFile$;
import tastyquery.SourcePosition;
import tastyquery.SourcePosition$;
import tastyquery.Spans$;
import tastyquery.reader.tasties.TastyUnpickler;

public class PositionUnpickler {
    private final TastyReader reader;
    private final TastyUnpickler.NameTable nameAtRef;
    private final Contexts.Context x$3;
    private final HashMap<TastyBuffer.Addr, SourcePosition> mySourcePositions;
    private boolean isDefined;

    public PositionUnpickler(TastyReader reader, TastyUnpickler.NameTable nameAtRef, Contexts.Context x$3) {
        this.reader = reader;
        this.nameAtRef = nameAtRef;
        this.x$3 = x$3;
        this.mySourcePositions = HashMap$.MODULE$.empty();
        this.isDefined = false;
    }

    public void ensureDefined() {
        if (!this.isDefined) {
            int lines = this.reader.readNat();
            int[] myLineSizes = new int[lines];
            int i = 0;
            while (i < lines) {
                int n = i++;
                myLineSizes[n] = myLineSizes[n] + this.reader.readNat();
            }
            boolean noSourceSeenYet = true;
            SourceFile curSource = SourceFile$.MODULE$.NoSource();
            int curAddress = 0;
            int curStart = 0;
            int curEnd = 0;
            boolean eof = false;
            int header = this.reader.readInt();
            while (!eof) {
                long span;
                boolean hasPoint;
                int addressDelta = header >> 3;
                boolean hasStart = (header & 4) != 0;
                boolean hasEnd = (header & 2) != 0;
                boolean bl = hasPoint = (header & 1) != 0;
                if ((curAddress += addressDelta) < 0) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                if (hasStart) {
                    curStart += this.reader.readInt();
                }
                if (hasEnd) {
                    curEnd += this.reader.readInt();
                }
                long l = span = hasPoint ? Spans$.MODULE$.Span(curStart, curEnd, curStart + this.reader.readInt()) : Spans$.MODULE$.Span(curStart, curEnd);
                if (this.reader.isAtEnd()) {
                    eof = true;
                } else {
                    header = this.reader.readInt();
                    if (header == 4) {
                        String path = this.nameAtRef.simple(this.reader.readNameRef()).toString();
                        curSource = this.x$3.getSourceFile(path);
                        if (noSourceSeenYet) {
                            curSource.setLineSizes(myLineSizes);
                            noSourceSeenYet = false;
                        }
                        if (this.reader.isAtEnd()) {
                            eof = true;
                        } else {
                            header = this.reader.readInt();
                        }
                    }
                }
                this.mySourcePositions.update((Object)new TastyBuffer.Addr(TastyBuffer$Addr$.MODULE$.apply(curAddress)), (Object)new SourcePosition(curSource, span));
            }
            this.isDefined = true;
            return;
        }
    }

    public SourcePosition sourcePositionAt(int addr) {
        this.ensureDefined();
        return (SourcePosition)this.mySourcePositions.getOrElse((Object)new TastyBuffer.Addr(addr), PositionUnpickler::sourcePositionAt$$anonfun$1);
    }

    private static final SourcePosition sourcePositionAt$$anonfun$1() {
        return SourcePosition$.MODULE$.NoPosition();
    }
}

