/*
 * Decompiled with CFR 0.152.
 */
package tastyquery;

import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import tastyquery.SourceFile$;

public final class SourceFile {
    private final String _path;
    private int[] lineStartOffsets;

    public static SourceFile NoSource() {
        return SourceFile$.MODULE$.NoSource();
    }

    public SourceFile(String _path) {
        this._path = _path;
        this.lineStartOffsets = null;
    }

    public String path() {
        return this._path;
    }

    public String name() {
        String x$proxy1 = this.path().substring(this.path().lastIndexOf(47) + 1);
        if (x$proxy1 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        return x$proxy1;
    }

    public String toString() {
        return this.path();
    }

    public boolean hasLineColumnInformation() {
        return this.lineStartOffsets != null;
    }

    public void setLineSizes(int[] lineSizes) {
        if (this.lineStartOffsets == null) {
            int[] startOffsets = new int[lineSizes.length + 1];
            startOffsets[0] = 0;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), startOffsets.length).foreach((Function1 & Serializable)v1 -> {
                startOffsets[BoxesRunTime.unboxToInt((Object)v1)] = startOffsets[BoxesRunTime.unboxToInt((Object)v1) - 1] + lineSizes[BoxesRunTime.unboxToInt((Object)v1) - 1] + 1;
                return BoxedUnit.UNIT;
            });
            this.lineStartOffsets = startOffsets;
            return;
        }
    }

    private int[] ensureLineStartOffsets() {
        int[] startOffsets = this.lineStartOffsets;
        if (startOffsets != null) {
            return startOffsets;
        }
        throw new UnsupportedOperationException(new StringBuilder(50).append("Source file ").append(this.path()).append(" does not have line/column information").toString());
    }

    private int lineToOffset(int line) {
        return this.ensureLineStartOffsets()[line];
    }

    public int offsetToLine(int offset) {
        int[] startOffsets = this.ensureLineStartOffsets();
        int p = Arrays.binarySearch(startOffsets, offset);
        if (p >= 0) {
            return p;
        }
        return -p - 1 - 1;
    }

    public int offsetToColumn(int offset) {
        return offset - this.lineToOffset(this.offsetToLine(offset));
    }
}

