/*
 * Decompiled with CFR 0.152.
 */
package tastyquery;

import java.util.Objects;
import scala.MatchError;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;
import tastyquery.Constants$;
import tastyquery.Constants$Constant$;
import tastyquery.Contexts;
import tastyquery.Types;

public final class Constants {
    public static int BooleanTag() {
        return Constants$.MODULE$.BooleanTag();
    }

    public static int ByteTag() {
        return Constants$.MODULE$.ByteTag();
    }

    public static int CharTag() {
        return Constants$.MODULE$.CharTag();
    }

    public static int ClazzTag() {
        return Constants$.MODULE$.ClazzTag();
    }

    public static int DoubleTag() {
        return Constants$.MODULE$.DoubleTag();
    }

    public static int FloatTag() {
        return Constants$.MODULE$.FloatTag();
    }

    public static int IntTag() {
        return Constants$.MODULE$.IntTag();
    }

    public static int LongTag() {
        return Constants$.MODULE$.LongTag();
    }

    public static int NoTag() {
        return Constants$.MODULE$.NoTag();
    }

    public static int NullTag() {
        return Constants$.MODULE$.NullTag();
    }

    public static int ShortTag() {
        return Constants$.MODULE$.ShortTag();
    }

    public static int StringTag() {
        return Constants$.MODULE$.StringTag();
    }

    public static int UnitTag() {
        return Constants$.MODULE$.UnitTag();
    }

    public static class Constant {
        private final Object value;
        private final int tag;

        public static Constant apply(boolean bl) {
            return Constants$Constant$.MODULE$.apply(bl);
        }

        public static Constant apply(BoxedUnit boxedUnit) {
            return Constants$Constant$.MODULE$.apply(boxedUnit);
        }

        public static Constant apply(byte by) {
            return Constants$Constant$.MODULE$.apply(by);
        }

        public static Constant apply(char c) {
            return Constants$Constant$.MODULE$.apply(c);
        }

        public static Constant apply(double d) {
            return Constants$Constant$.MODULE$.apply(d);
        }

        public static Constant apply(float f) {
            return Constants$Constant$.MODULE$.apply(f);
        }

        public static Constant apply(int n) {
            return Constants$Constant$.MODULE$.apply(n);
        }

        public static Constant apply(long l) {
            return Constants$Constant$.MODULE$.apply(l);
        }

        public static Constant apply(Null$ null$) {
            return Constants$Constant$.MODULE$.apply(null$);
        }

        public static Constant apply(short s) {
            return Constants$Constant$.MODULE$.apply(s);
        }

        public static Constant apply(String string) {
            return Constants$Constant$.MODULE$.apply(string);
        }

        public static Constant apply(Types.Type type) {
            return Constants$Constant$.MODULE$.apply(type);
        }

        public static Constant unapply(Constant constant) {
            return Constants$Constant$.MODULE$.unapply(constant);
        }

        public Constant(Object value, int tag) {
            this.value = value;
            this.tag = tag;
        }

        public Object value() {
            return this.value;
        }

        public int tag() {
            return this.tag;
        }

        public Types.Type wideType(Contexts.Context x$1) {
            Types.TypeProxy typeProxy;
            int n = this.tag();
            switch (n) {
                case 1: {
                    typeProxy = x$1.defn().UnitType();
                    break;
                }
                case 2: {
                    typeProxy = x$1.defn().BooleanType();
                    break;
                }
                case 5: {
                    typeProxy = x$1.defn().CharType();
                    break;
                }
                case 3: {
                    typeProxy = x$1.defn().ByteType();
                    break;
                }
                case 4: {
                    typeProxy = x$1.defn().ShortType();
                    break;
                }
                case 6: {
                    typeProxy = x$1.defn().IntType();
                    break;
                }
                case 7: {
                    typeProxy = x$1.defn().LongType();
                    break;
                }
                case 8: {
                    typeProxy = x$1.defn().FloatType();
                    break;
                }
                case 9: {
                    typeProxy = x$1.defn().DoubleType();
                    break;
                }
                case 10: {
                    typeProxy = x$1.defn().StringType();
                    break;
                }
                case 11: {
                    typeProxy = x$1.defn().NullType();
                    break;
                }
                case 12: {
                    typeProxy = x$1.defn().ClassTypeOf(this.typeValue());
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            return typeProxy;
        }

        public boolean isByteRange() {
            return this.isIntRange() && -128 <= this.intValue() && this.intValue() <= 127;
        }

        public boolean isShortRange() {
            return this.isIntRange() && Short.MIN_VALUE <= this.intValue() && this.intValue() <= Short.MAX_VALUE;
        }

        public boolean isCharRange() {
            return this.isIntRange() && 0 <= this.intValue() && this.intValue() <= 65535;
        }

        public boolean isIntRange() {
            return 3 <= this.tag() && this.tag() <= 6;
        }

        public boolean isLongRange() {
            return 3 <= this.tag() && this.tag() <= 7;
        }

        public boolean isFloatRange() {
            return 3 <= this.tag() && this.tag() <= 8;
        }

        public boolean isNumeric() {
            return 3 <= this.tag() && this.tag() <= 9;
        }

        public boolean isNonUnitAnyVal() {
            return 2 <= this.tag() && this.tag() <= 9;
        }

        public boolean isAnyVal() {
            return 1 <= this.tag() && this.tag() <= 9;
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof Constant) {
                Constant that = (Constant)object;
                bl = this.tag() == that.tag() && Objects.equals(this.value(), that.value());
            } else {
                bl = false;
            }
            return bl;
        }

        public boolean isNaN() {
            boolean bl;
            Object object = this.value();
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                bl = Predef$.MODULE$.float2Float(f).isNaN();
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                bl = Predef$.MODULE$.double2Double(d).isNaN();
            } else {
                bl = false;
            }
            return bl;
        }

        public boolean booleanValue() {
            if (this.tag() != 2) {
                throw new Error(new StringBuilder(23).append("value ").append(this.value()).append(" is not a boolean").toString());
            }
            return BoxesRunTime.unboxToBoolean((Object)this.value());
        }

        public byte byteValue() {
            byte by;
            int n = this.tag();
            switch (n) {
                case 3: {
                    by = BoxesRunTime.unboxToByte((Object)this.value());
                    break;
                }
                case 4: {
                    by = (byte)BoxesRunTime.unboxToShort((Object)this.value());
                    break;
                }
                case 5: {
                    by = (byte)BoxesRunTime.unboxToChar((Object)this.value());
                    break;
                }
                case 6: {
                    by = (byte)BoxesRunTime.unboxToInt((Object)this.value());
                    break;
                }
                case 7: {
                    by = (byte)BoxesRunTime.unboxToLong((Object)this.value());
                    break;
                }
                case 8: {
                    by = (byte)BoxesRunTime.unboxToFloat((Object)this.value());
                    break;
                }
                case 9: {
                    by = (byte)BoxesRunTime.unboxToDouble((Object)this.value());
                    break;
                }
                default: {
                    throw new Error(new StringBuilder(20).append("value ").append(this.value()).append(" is not a Byte").toString());
                }
            }
            return by;
        }

        public short shortValue() {
            short s;
            int n = this.tag();
            switch (n) {
                case 3: {
                    s = BoxesRunTime.unboxToByte((Object)this.value());
                    break;
                }
                case 4: {
                    s = BoxesRunTime.unboxToShort((Object)this.value());
                    break;
                }
                case 5: {
                    s = (short)BoxesRunTime.unboxToChar((Object)this.value());
                    break;
                }
                case 6: {
                    s = (short)BoxesRunTime.unboxToInt((Object)this.value());
                    break;
                }
                case 7: {
                    s = (short)BoxesRunTime.unboxToLong((Object)this.value());
                    break;
                }
                case 8: {
                    s = (short)BoxesRunTime.unboxToFloat((Object)this.value());
                    break;
                }
                case 9: {
                    s = (short)BoxesRunTime.unboxToDouble((Object)this.value());
                    break;
                }
                default: {
                    throw new Error(new StringBuilder(21).append("value ").append(this.value()).append(" is not a Short").toString());
                }
            }
            return s;
        }

        public char charValue() {
            char c;
            int n = this.tag();
            switch (n) {
                case 3: {
                    c = (char)BoxesRunTime.unboxToByte((Object)this.value());
                    break;
                }
                case 4: {
                    c = (char)BoxesRunTime.unboxToShort((Object)this.value());
                    break;
                }
                case 5: {
                    c = BoxesRunTime.unboxToChar((Object)this.value());
                    break;
                }
                case 6: {
                    c = (char)BoxesRunTime.unboxToInt((Object)this.value());
                    break;
                }
                case 7: {
                    c = (char)BoxesRunTime.unboxToLong((Object)this.value());
                    break;
                }
                case 8: {
                    c = (char)BoxesRunTime.unboxToFloat((Object)this.value());
                    break;
                }
                case 9: {
                    c = (char)BoxesRunTime.unboxToDouble((Object)this.value());
                    break;
                }
                default: {
                    throw new Error(new StringBuilder(20).append("value ").append(this.value()).append(" is not a Char").toString());
                }
            }
            return c;
        }

        public int intValue() {
            int n;
            int n2 = this.tag();
            switch (n2) {
                case 3: {
                    n = BoxesRunTime.unboxToByte((Object)this.value());
                    break;
                }
                case 4: {
                    n = BoxesRunTime.unboxToShort((Object)this.value());
                    break;
                }
                case 5: {
                    n = BoxesRunTime.unboxToChar((Object)this.value());
                    break;
                }
                case 6: {
                    n = BoxesRunTime.unboxToInt((Object)this.value());
                    break;
                }
                case 7: {
                    n = (int)BoxesRunTime.unboxToLong((Object)this.value());
                    break;
                }
                case 8: {
                    n = (int)BoxesRunTime.unboxToFloat((Object)this.value());
                    break;
                }
                case 9: {
                    n = (int)BoxesRunTime.unboxToDouble((Object)this.value());
                    break;
                }
                default: {
                    throw new Error(new StringBuilder(20).append("value ").append(this.value()).append(" is not an Int").toString());
                }
            }
            return n;
        }

        public long longValue() {
            long l;
            int n = this.tag();
            switch (n) {
                case 3: {
                    l = BoxesRunTime.unboxToByte((Object)this.value());
                    break;
                }
                case 4: {
                    l = BoxesRunTime.unboxToShort((Object)this.value());
                    break;
                }
                case 5: {
                    l = BoxesRunTime.unboxToChar((Object)this.value());
                    break;
                }
                case 6: {
                    l = BoxesRunTime.unboxToInt((Object)this.value());
                    break;
                }
                case 7: {
                    l = BoxesRunTime.unboxToLong((Object)this.value());
                    break;
                }
                case 8: {
                    l = (long)BoxesRunTime.unboxToFloat((Object)this.value());
                    break;
                }
                case 9: {
                    l = (long)BoxesRunTime.unboxToDouble((Object)this.value());
                    break;
                }
                default: {
                    throw new Error(new StringBuilder(20).append("value ").append(this.value()).append(" is not a Long").toString());
                }
            }
            return l;
        }

        public float floatValue() {
            float f;
            int n = this.tag();
            switch (n) {
                case 3: {
                    f = BoxesRunTime.unboxToByte((Object)this.value());
                    break;
                }
                case 4: {
                    f = BoxesRunTime.unboxToShort((Object)this.value());
                    break;
                }
                case 5: {
                    f = BoxesRunTime.unboxToChar((Object)this.value());
                    break;
                }
                case 6: {
                    f = BoxesRunTime.unboxToInt((Object)this.value());
                    break;
                }
                case 7: {
                    f = BoxesRunTime.unboxToLong((Object)this.value());
                    break;
                }
                case 8: {
                    f = BoxesRunTime.unboxToFloat((Object)this.value());
                    break;
                }
                case 9: {
                    f = (float)BoxesRunTime.unboxToDouble((Object)this.value());
                    break;
                }
                default: {
                    throw new Error(new StringBuilder(21).append("value ").append(this.value()).append(" is not a Float").toString());
                }
            }
            return f;
        }

        public double doubleValue() {
            double d;
            int n = this.tag();
            switch (n) {
                case 3: {
                    d = BoxesRunTime.unboxToByte((Object)this.value());
                    break;
                }
                case 4: {
                    d = BoxesRunTime.unboxToShort((Object)this.value());
                    break;
                }
                case 5: {
                    d = BoxesRunTime.unboxToChar((Object)this.value());
                    break;
                }
                case 6: {
                    d = BoxesRunTime.unboxToInt((Object)this.value());
                    break;
                }
                case 7: {
                    d = BoxesRunTime.unboxToLong((Object)this.value());
                    break;
                }
                case 8: {
                    d = BoxesRunTime.unboxToFloat((Object)this.value());
                    break;
                }
                case 9: {
                    d = BoxesRunTime.unboxToDouble((Object)this.value());
                    break;
                }
                default: {
                    throw new Error(new StringBuilder(22).append("value ").append(this.value()).append(" is not a Double").toString());
                }
            }
            return d;
        }

        public String stringValue() {
            return this.value().toString();
        }

        public Types.Type typeValue() {
            return (Types.Type)this.value();
        }

        public int hashCode() {
            int seed;
            int h = seed = 17;
            h = MurmurHash3$.MODULE$.mix(h, Statics.anyHash((Object)BoxesRunTime.boxToInteger((int)this.tag())));
            h = MurmurHash3$.MODULE$.mix(h, this.value().hashCode());
            return MurmurHash3$.MODULE$.finalizeHash(h, 2);
        }

        public String toString() {
            return new StringBuilder(10).append("Constant(").append(this.value()).append(")").toString();
        }

        public boolean canEqual(Object x) {
            return true;
        }

        public Object get() {
            return this.value();
        }

        public boolean isEmpty() {
            return false;
        }

        public Object _1() {
            return this.value();
        }
    }
}

