/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.classfiles;

import java.io.Serializable;
import scala.Array$;
import scala.CanEqual;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.IArray;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.Enum;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import tastyquery.Classpaths;
import tastyquery.Contexts;
import tastyquery.Exceptions;
import tastyquery.Flags$;
import tastyquery.Names;
import tastyquery.Names$;
import tastyquery.Names$SimpleName$;
import tastyquery.Names$annot$;
import tastyquery.Names$attr$;
import tastyquery.Symbols;
import tastyquery.reader.classfiles.ClassfileReader;
import tastyquery.reader.classfiles.ClassfileReader$;
import tastyquery.reader.classfiles.ClassfileReader$Access$AccessFlags$;
import tastyquery.reader.classfiles.ClassfileReader$Annotation$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$Arr$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$Const$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$Unknown$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Class$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Double$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Dynamic$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Fieldref$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Float$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Integer$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$InterfaceMethodref$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$InvokeDynamic$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Long$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$MethodHandle$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$MethodType$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Methodref$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Module$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$NameAndType$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Package$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$String$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Utf8$;
import tastyquery.reader.classfiles.ClassfileReader$Indexing$;
import tastyquery.reader.classfiles.ClassfileReader$SigOrDesc$;
import tastyquery.reader.classfiles.ClassfileReader$SigOrDesc$Desc$;
import tastyquery.reader.classfiles.ClassfileReader$SigOrDesc$Sig$;
import tastyquery.reader.classfiles.ClassfileReader$SigOrSupers$;
import tastyquery.reader.classfiles.Forked;
import tastyquery.reader.pickles.ByteCodecs$;

public final class ClassfileReader {
    public static <T> T unpickle(Classpaths.ClassData classData, Function1<ClassfileReader, Function1<DataStream, T>> function1) {
        return ClassfileReader$.MODULE$.unpickle(classData, function1);
    }

    public void acceptHeader(Symbols.DeclaringSymbol classOwner, Classpaths.ClassData classRoot, DataStream x$3) {
        this.acceptMagicNumber(classOwner, classRoot, x$3);
        this.acceptVersion(classOwner, classRoot, x$3);
    }

    private String rootName(Symbols.DeclaringSymbol classOwner, Classpaths.ClassData classRoot) {
        return new StringBuilder(1).append(((Symbols.Symbol)((Object)classOwner)).fullName()).append(".").append(classRoot.binaryName()).toString();
    }

    private void acceptMagicNumber(Symbols.DeclaringSymbol classOwner, Classpaths.ClassData classRoot, DataStream x$3) {
        int magic = x$3.readU4();
        if (magic != -889275714) {
            String root = this.rootName(classOwner, classRoot);
            throw new Exceptions.ClassfileFormatException(new StringBuilder(37).append("Invalid magic number ").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(magic))).append(", should be ").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(-889275714))).append(" in ").append(root).toString());
        }
    }

    private void acceptVersion(Symbols.DeclaringSymbol classOwner, Classpaths.ClassData classRoot, DataStream x$3) {
        int minor = x$3.readU2();
        int major = x$3.readU2();
        if (major < 45 || major == 45 && minor < 3) {
            String root = this.rootName(classOwner, classRoot);
            throw new Exceptions.ClassfileFormatException(new StringBuilder(77).append("Invalid class file version ").append(major).append(".").append(minor).append(", should be at least ").append(45).append(".").append(3).append(" in ").append(root).toString());
        }
    }

    public ConstantPool readConstantPool(DataStream x$1) {
        LazyRef lazyRef = new LazyRef();
        int count = x$1.readU2();
        ConstantPool cp = new ConstantPool(this, count);
        boolean doAdd = true;
        while (doAdd) {
            doAdd = ClassfileReader.given_ConstantPool$1(cp, lazyRef).add(this.acceptConstantInfo(x$1, ClassfileReader.given_ConstantPool$1(cp, lazyRef)));
        }
        return ClassfileReader.given_ConstantPool$1(cp, lazyRef);
    }

    public int readAccessFlags(DataStream x$1) {
        return ClassfileReader$Access$AccessFlags$.MODULE$.read(x$1.readU2());
    }

    public ConstantInfo.Class<ConstantPool> readThisClass(DataStream x$1, ConstantPool x$2) {
        return x$2.cls(x$2.idx(x$1.readU2()));
    }

    public Option<ConstantInfo.Class<ConstantPool>> readSuperClass(DataStream x$1, ConstantPool x$2) {
        int idx = x$1.readU2();
        None$ entry = idx == 0 ? None$.MODULE$ : Some$.MODULE$.apply(x$2.cls(x$2.idx(idx)));
        return entry;
    }

    public ConstantInfo.Class<ConstantPool>[] readInterfaces(DataStream x$1, ConstantPool x$2) {
        int count = x$1.readU2();
        IndexedSeq interfaces = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)i -> x$2.cls(x$2.idx(x$1.readU2())));
        return (ConstantInfo.Class[])IArray.package.IArray$.MODULE$.from((IterableOnce)interfaces, ClassTag$.MODULE$.apply(ConstantInfo.Class.class));
    }

    public Forked<DataStream> skipMethods(DataStream x$1) {
        return this.skipMembers(x$1);
    }

    public Forked<DataStream> skipFields(DataStream x$1) {
        return this.skipMembers(x$1);
    }

    /*
     * WARNING - void declaration
     */
    public Forked<DataStream> skipAttributes(DataStream x$1) {
        void var3_3;
        DataStream DataStream_this = x$1;
        Forked<DataStream> forked = DataStream_this.fork();
        this.skipOp$proxy1$1(x$1);
        return var3_3;
    }

    private void skipAttributesInternal(DataStream x$1) {
        int count = x$1.readU2();
        for (int i = 0; i < count; ++i) {
            x$1.skip(2);
            x$1.skip(x$1.readU4());
        }
    }

    /*
     * WARNING - void declaration
     */
    private Forked<DataStream> skipMembers(DataStream x$1) {
        void var2_2;
        Forked<DataStream> reader = x$1.fork();
        int count = x$1.readU2();
        for (int i = 0; i < count; ++i) {
            x$1.skip(6);
            this.skipAttributesInternal(x$1);
        }
        return var2_2;
    }

    public void readFields(Function3<Names.SimpleName, SigOrDesc, Object, BoxedUnit> op, DataStream x$2, ConstantPool x$3, Contexts.Context x$4) {
        this.readMembers(false, op, x$2, x$3, x$4);
    }

    public void readMethods(Function3<Names.SimpleName, SigOrDesc, Object, BoxedUnit> op, DataStream x$2, ConstantPool x$3, Contexts.Context x$4) {
        this.readMembers(true, op, x$2, x$3, x$4);
    }

    private void readMembers(boolean isMethod, Function3<Names.SimpleName, SigOrDesc, Object, BoxedUnit> op, DataStream x$3, ConstantPool x$4, Contexts.Context x$5) {
        int count = x$3.readU2();
        for (int i = 0; i < count; ++i) {
            int accessFlags = this.readAccessFlags(x$3);
            int nameIdx = x$4.idx(x$3.readU2());
            Names.SimpleName name = x$4.utf8(nameIdx);
            int descriptorIdx = x$4.idx(x$3.readU2());
            String desc = x$4.utf8(descriptorIdx).name();
            ObjectRef sigOrNull = ObjectRef.create(null);
            this.scanAttributes((Function1<DataStream, Function1<Names.SimpleName, Object>>)(Function1 & Serializable)evidence$3 -> (Function1 & Serializable)x$1 -> {
                boolean bl;
                Names.SimpleName simpleName = x$1;
                Names.SimpleName simpleName2 = Names$attr$.MODULE$.Signature();
                Names.SimpleName simpleName3 = simpleName;
                if (!(simpleName2 != null ? !((Object)simpleName2).equals(simpleName3) : simpleName3 != null)) {
                    evidence$3.fork().use((Function1 & Serializable)evidence$4 -> {
                        this.readMembers$$anonfun$2$$anonfun$1$$anonfun$1(x$4, sigOrNull, (DataStream)evidence$4);
                        return BoxedUnit.UNIT;
                    });
                    bl = false;
                } else {
                    bl = false;
                }
                return bl;
            }, x$3, x$4);
            String sig = (String)sigOrNull.elem;
            if (ClassfileReader$Access$AccessFlags$.MODULE$.isSynthetic(accessFlags)) continue;
            if (sig == null) {
                op.apply((Object)name, (Object)ClassfileReader$SigOrDesc$Desc$.MODULE$.apply(desc), (Object)BoxesRunTime.boxToInteger((int)accessFlags));
                continue;
            }
            op.apply((Object)name, (Object)ClassfileReader$SigOrDesc$Sig$.MODULE$.apply(sig), (Object)BoxesRunTime.boxToInteger((int)accessFlags));
        }
    }

    public String readSignature(DataStream x$1, ConstantPool x$2) {
        int sigIdx = x$2.idx(x$1.readU2());
        return x$2.utf8(sigIdx).name();
    }

    public void scanAttributes(Function1<DataStream, Function1<Names.SimpleName, Object>> onName, DataStream x$2, ConstantPool x$3) {
        int count = x$2.readU2();
        for (int i = 0; i < count; ++i) {
            int attrNameIdx = x$3.idx(x$2.readU2());
            Names.SimpleName attrName = x$3.utf8(attrNameIdx);
            int attrLen = x$2.readU4();
            if (BoxesRunTime.unboxToBoolean((Object)((Function1)onName.apply((Object)x$2)).apply((Object)attrName))) {
                return;
            }
            x$2.skip(attrLen);
        }
    }

    public Option<Annotation<ConstantPool>> readAnnotation(Set<Names.SimpleName> typeDescriptors, DataStream x$2, ConstantPool x$3) {
        int numAnnots = x$2.readU2();
        for (int i = 0; i < numAnnots; ++i) {
            int typeIdx = x$3.idx(x$2.readU2());
            Names.SimpleName typeName = x$3.utf8(typeIdx);
            if (typeDescriptors.contains((Object)typeName)) {
                return Some$.MODULE$.apply((Object)ClassfileReader.readAnnotationArgs$1(x$2, x$3, typeName));
            }
            ClassfileReader.skipAnnotationArgs$1(x$2);
        }
        return None$.MODULE$;
    }

    public void readInnerClasses(Function4<Names.SimpleName, Names.SimpleName, Names.SimpleName, Object, BoxedUnit> op, DataStream x$2, ConstantPool x$3) {
        int numberOfClasses = x$2.readU2();
        for (int i = 0; i < numberOfClasses; ++i) {
            int innerClassIdx = x$3.idx(x$2.readU2());
            int outerClassId = x$2.readU2();
            int innerNameId = x$2.readU2();
            long accessFlags = ClassfileReader$Access$AccessFlags$.MODULE$.toFlags(this.readAccessFlags(x$2));
            if (outerClassId == 0 || innerNameId == 0 || Flags$.MODULE$.is(accessFlags, Flags$.MODULE$.Synthetic())) continue;
            Names.SimpleName innerClass = x$3.utf8(x$3.cls(innerClassIdx).nameIdx());
            Names.SimpleName innerName = x$3.utf8(x$3.idx(innerNameId));
            Names.SimpleName outerClass = x$3.utf8(x$3.cls(x$3.idx(outerClassId)).nameIdx());
            op.apply((Object)innerName, (Object)innerClass, (Object)outerClass, (Object)BoxesRunTime.boxToLong((long)accessFlags));
        }
    }

    private ConstantInfo<ConstantPool> acceptConstantInfo(DataStream x$1, ConstantPool x$2) {
        ConstantInfo constantInfo;
        int tag;
        int n = tag = x$1.readU1();
        switch (n) {
            case 7: {
                constantInfo = ClassfileReader$ConstantInfo$Class$.MODULE$.apply(x$2.idx(x$1.readU2()));
                break;
            }
            case 9: {
                constantInfo = ClassfileReader$ConstantInfo$Fieldref$.MODULE$.apply(x$2.idx(x$1.readU2()), x$2.idx(x$1.readU2()));
                break;
            }
            case 10: {
                constantInfo = ClassfileReader$ConstantInfo$Methodref$.MODULE$.apply(x$2.idx(x$1.readU2()), x$2.idx(x$1.readU2()));
                break;
            }
            case 11: {
                constantInfo = ClassfileReader$ConstantInfo$InterfaceMethodref$.MODULE$.apply(x$2.idx(x$1.readU2()), x$2.idx(x$1.readU2()));
                break;
            }
            case 8: {
                constantInfo = ClassfileReader$ConstantInfo$String$.MODULE$.apply(x$2.idx(x$1.readU2()));
                break;
            }
            case 3: {
                constantInfo = ClassfileReader$ConstantInfo$Integer$.MODULE$.apply(x$1.readU4());
                break;
            }
            case 4: {
                constantInfo = ClassfileReader$ConstantInfo$Float$.MODULE$.apply(x$1.readU4f());
                break;
            }
            case 5: {
                constantInfo = ClassfileReader$ConstantInfo$Long$.MODULE$.apply(x$1.readU8());
                break;
            }
            case 6: {
                constantInfo = ClassfileReader$ConstantInfo$Double$.MODULE$.apply(x$1.readU8f());
                break;
            }
            case 12: {
                constantInfo = ClassfileReader$ConstantInfo$NameAndType$.MODULE$.apply(x$2.idx(x$1.readU2()), x$2.idx(x$1.readU2()));
                break;
            }
            case 1: {
                DataStream DataStream_this = x$1;
                Forked<DataStream> forked = DataStream_this.fork();
                ClassfileReader.skipOp$proxy2$1(x$1);
                constantInfo = ClassfileReader$ConstantInfo$Utf8$.MODULE$.apply(forked);
                break;
            }
            case 15: {
                constantInfo = ClassfileReader$ConstantInfo$MethodHandle$.MODULE$.apply(x$2.idx(x$1.readU1()), x$2.idx(x$1.readU2()));
                break;
            }
            case 16: {
                constantInfo = ClassfileReader$ConstantInfo$MethodType$.MODULE$.apply(x$2.idx(x$1.readU2()));
                break;
            }
            case 17: {
                constantInfo = ClassfileReader$ConstantInfo$Dynamic$.MODULE$.apply(x$2.idx(x$1.readU2()), x$2.idx(x$1.readU2()));
                break;
            }
            case 18: {
                constantInfo = ClassfileReader$ConstantInfo$InvokeDynamic$.MODULE$.apply(x$2.idx(x$1.readU2()), x$2.idx(x$1.readU2()));
                break;
            }
            case 19: {
                constantInfo = ClassfileReader$ConstantInfo$Module$.MODULE$.apply(x$2.idx(x$1.readU2()));
                break;
            }
            case 20: {
                constantInfo = ClassfileReader$ConstantInfo$Package$.MODULE$.apply(x$2.idx(x$1.readU2()));
                break;
            }
            default: {
                throw new Exceptions.ClassfileFormatException(new StringBuilder(21).append("Invalid constant tag ").append(tag).toString());
            }
        }
        return constantInfo;
    }

    private static final ConstantPool given_ConstantPool$lzyINIT1$1(ConstantPool cp$1, LazyRef given_ConstantPool$lzy1$1) {
        ConstantPool constantPool;
        LazyRef lazyRef = given_ConstantPool$lzy1$1;
        synchronized (lazyRef) {
            constantPool = (ConstantPool)(given_ConstantPool$lzy1$1.initialized() ? given_ConstantPool$lzy1$1.value() : given_ConstantPool$lzy1$1.initialize((Object)cp$1));
        }
        return constantPool;
    }

    private static final ConstantPool given_ConstantPool$1(ConstantPool cp$2, LazyRef given_ConstantPool$lzy1$2) {
        return (ConstantPool)(given_ConstantPool$lzy1$2.initialized() ? given_ConstantPool$lzy1$2.value() : ClassfileReader.given_ConstantPool$lzyINIT1$1(cp$2, given_ConstantPool$lzy1$2));
    }

    public static final /* synthetic */ String tastyquery$reader$classfiles$ClassfileReader$ConstantPool$$_$_$$anonfun$1(DataStream evidence$1) {
        return evidence$1.readUTF8();
    }

    public static final /* synthetic */ byte[] tastyquery$reader$classfiles$ClassfileReader$ConstantPool$$_$encodedSigbytes$$anonfun$1(DataStream evidence$2) {
        return evidence$2.readSlice(evidence$2.readU2());
    }

    private final void skipOp$proxy1$1(DataStream x$1$2) {
        this.skipAttributesInternal(x$1$2);
    }

    private final /* synthetic */ void readMembers$$anonfun$2$$anonfun$1$$anonfun$1(ConstantPool x$4$3, ObjectRef sigOrNull$3, DataStream evidence$4) {
        String string = this.readSignature(evidence$4, x$4$3);
        sigOrNull$3.elem = string;
    }

    private static final void skipAnnotationArgument$1(DataStream x$2$2) {
        char tag;
        char c = tag = (char)x$2$2.readU1();
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 'c': 
            case 's': {
                x$2$2.skip(2);
                break;
            }
            case 'e': {
                x$2$2.skip(3);
                break;
            }
            case '@': {
                ClassfileReader.skipAnnotation$1(x$2$2);
                break;
            }
            case '[': {
                int count = x$2$2.readU2();
                for (int i = 0; i < count; ++i) {
                    ClassfileReader.skipAnnotationArgument$1(x$2$2);
                }
                break;
            }
            default: {
                throw new Exceptions.ClassfileFormatException(new StringBuilder(32).append("Invalid annotation argument tag ").append(tag).toString());
            }
        }
    }

    private static final void skipAnnotation$1(DataStream x$2$3) {
        x$2$3.skip(2);
        ClassfileReader.skipAnnotationArgs$1(x$2$3);
    }

    private static final void skipAnnotationArgs$1(DataStream x$2$4) {
        int numPairs = x$2$4.readU2();
        for (int i = 0; i < numPairs; ++i) {
            x$2$4.skip(2);
            ClassfileReader.skipAnnotationArgument$1(x$2$4);
        }
    }

    private static final AnnotationValue readAnnotationArgument$1(DataStream x$2$5, ConstantPool x$3$1) {
        AnnotationValue annotationValue;
        char tag;
        char c = tag = (char)x$2$5.readU1();
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 's': {
                annotationValue = ClassfileReader$AnnotationValue$Const$.MODULE$.apply(x$3$1.idx(x$2$5.readU2()));
                break;
            }
            case 'e': {
                x$2$5.skip(1);
                x$2$5.skip(2);
                annotationValue = ClassfileReader$AnnotationValue$Unknown$.MODULE$.apply();
                break;
            }
            case 'c': {
                x$2$5.skip(2);
                annotationValue = ClassfileReader$AnnotationValue$Unknown$.MODULE$.apply();
                break;
            }
            case '@': {
                ClassfileReader.skipAnnotation$1(x$2$5);
                annotationValue = ClassfileReader$AnnotationValue$Unknown$.MODULE$.apply();
                break;
            }
            case '[': {
                int count = x$2$5.readU2();
                AnnotationValue[] arr = new AnnotationValue[count];
                for (int i = 0; i < count; ++i) {
                    arr[i] = ClassfileReader.readAnnotationArgument$1(x$2$5, x$3$1);
                }
                AnnotationValue[] values = (AnnotationValue[])IArray.package.IArray$.MODULE$.unsafeFromArray((Object)arr);
                annotationValue = ClassfileReader$AnnotationValue$Arr$.MODULE$.apply(values);
                break;
            }
            default: {
                throw new Exceptions.ClassfileFormatException(new StringBuilder(32).append("Invalid annotation argument tag ").append(tag).toString());
            }
        }
        return annotationValue;
    }

    private static final Annotation readAnnotationArgs$1(DataStream x$2$6, ConstantPool x$3$2, Names.SimpleName tpe) {
        int numPairs = x$2$6.readU2();
        AnnotationValue[] arr = new AnnotationValue[numPairs];
        for (int i = 0; i < numPairs; ++i) {
            x$2$6.skip(2);
            arr[i] = ClassfileReader.readAnnotationArgument$1(x$2$6, x$3$2);
        }
        AnnotationValue[] args = (AnnotationValue[])IArray.package.IArray$.MODULE$.unsafeFromArray((Object)arr);
        return ClassfileReader$Annotation$.MODULE$.apply(tpe, args);
    }

    private static final void skipOp$proxy2$1(DataStream x$1$3) {
        x$1$3.skip(x$1$3.readU2());
    }

    public static class Annotation<P extends ConstantPool>
    implements Product,
    Serializable {
        private final Names.SimpleName tpe;
        private final AnnotationValue[] values;

        public static <P extends ConstantPool> Annotation<P> apply(Names.SimpleName simpleName, AnnotationValue<P>[] annotationValueArray) {
            return ClassfileReader$Annotation$.MODULE$.apply(simpleName, annotationValueArray);
        }

        public static Annotation fromProduct(Product product) {
            return ClassfileReader$Annotation$.MODULE$.fromProduct(product);
        }

        public static <P extends ConstantPool> Annotation<P> unapply(Annotation<P> annotation) {
            return ClassfileReader$Annotation$.MODULE$.unapply(annotation);
        }

        public Annotation(Names.SimpleName tpe, AnnotationValue<P>[] values) {
            this.tpe = tpe;
            this.values = values;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Annotation)) return false;
            Annotation annotation = (Annotation)object;
            Names.SimpleName simpleName = this.tpe();
            Names.SimpleName simpleName2 = annotation.tpe();
            if (simpleName == null) {
                if (simpleName2 != null) {
                    return false;
                }
            } else if (!((Object)simpleName).equals(simpleName2)) return false;
            if (this.values() != annotation.values()) return false;
            if (!annotation.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Annotation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Annotation";
        }

        public Object productElement(int n) {
            AnnotationValue<P>[] annotationValueArray;
            int n2 = n;
            if (0 == n2) {
                annotationValueArray = this._1();
            } else if (1 == n2) {
                annotationValueArray = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return annotationValueArray;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "tpe";
            } else if (1 == n2) {
                string = "values";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Names.SimpleName tpe() {
            return this.tpe;
        }

        public AnnotationValue<P>[] values() {
            return this.values;
        }

        public <P extends ConstantPool> Annotation<P> copy(Names.SimpleName tpe, AnnotationValue<P>[] values) {
            return new Annotation<P>(tpe, values);
        }

        public <P extends ConstantPool> Names.SimpleName copy$default$1() {
            return this.tpe();
        }

        public <P extends ConstantPool> AnnotationValue<P>[] copy$default$2() {
            return this.values();
        }

        public Names.SimpleName _1() {
            return this.tpe();
        }

        public AnnotationValue<P>[] _2() {
            return this.values();
        }
    }

    public static abstract class AnnotationValue<C extends ConstantPool>
    implements Enum {
        public static AnnotationValue<?> fromOrdinal(int n) {
            return ClassfileReader$AnnotationValue$.MODULE$.fromOrdinal(n);
        }
    }

    public static abstract class ConstantInfo<C extends ConstantPool>
    implements Enum {
        public static <C_$_L extends ConstantPool, C_$_R extends ConstantPool> CanEqual<ConstantInfo<C_$_L>, ConstantInfo<C_$_R>> derived$CanEqual(CanEqual<C_$_L, C_$_R> canEqual) {
            return ClassfileReader$ConstantInfo$.MODULE$.derived$CanEqual(canEqual);
        }

        public static ConstantInfo<?> fromOrdinal(int n) {
            return ClassfileReader$ConstantInfo$.MODULE$.fromOrdinal(n);
        }
    }

    public class ConstantPool {
        private final int count;
        private final ConstantInfo<ConstantPool>[] infos;
        private int index;
        private boolean seensigbytes;
        private final ClassfileReader $outer;

        public ConstantPool(ClassfileReader $outer, int count) {
            this.count = count;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.infos = new ConstantInfo[count];
            this.index = 1;
            this.seensigbytes = false;
        }

        public ConstantInfo.Class<ConstantPool> cls(int idx) {
            return (ConstantInfo.Class)this.infos[idx];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Names.SimpleName utf8(int idx) {
            Names.SimpleName simpleName;
            ConstantInfo<ConstantPool> constantInfo = this.apply(idx);
            if (!(constantInfo instanceof ConstantInfo.Utf8)) throw new Exceptions.ClassfileFormatException(new StringBuilder(23).append("Expected UTF8 at index ").append(idx).toString());
            ConstantInfo.Utf8 utf8 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo);
            Object object = utf8._1();
            if (object instanceof Names.SimpleName) {
                Names.SimpleName name;
                simpleName = name = (Names.SimpleName)object;
                return simpleName;
            } else {
                if (!(object instanceof Forked)) throw new Exceptions.ClassfileFormatException(new StringBuilder(23).append("Expected UTF8 at index ").append(idx).toString());
                Forked forked = (Forked)object;
                Names.SimpleName name = Names$.MODULE$.termName((String)forked.use(ClassfileReader::tastyquery$reader$classfiles$ClassfileReader$ConstantPool$$_$_$$anonfun$1));
                this.infos[idx] = ClassfileReader$ConstantInfo$Utf8$.MODULE$.apply(name);
                simpleName = name;
            }
            return simpleName;
        }

        public byte[] sigbytes(int idx) {
            return this.decodeSigBytes(this.encodedSigbytes(idx));
        }

        public byte[] sigbytes(int[] idxs) {
            return this.decodeSigBytes((byte[])IArray.package.IArray$.MODULE$.flatMap((Object)idxs, (Function1 & Serializable)idx -> this.sigbytes$$anonfun$1(BoxesRunTime.unboxToInt((Object)idx)), ClassTag$.MODULE$.apply(Byte.TYPE)));
        }

        private byte[] encodedSigbytes(int idx) {
            ConstantInfo.Utf8 utf8;
            Object object;
            ConstantInfo<ConstantPool> constantInfo = this.apply(idx);
            if (!(constantInfo instanceof ConstantInfo.Utf8) || !((object = (utf8 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo))._1()) instanceof Forked)) {
                throw new Exceptions.ClassfileFormatException(new StringBuilder(41).append("Expected unforced UTF8 constant at index ").append(idx).toString());
            }
            Forked forked = (Forked)object;
            return (byte[])forked.use(ClassfileReader::tastyquery$reader$classfiles$ClassfileReader$ConstantPool$$_$encodedSigbytes$$anonfun$1);
        }

        private byte[] decodeSigBytes(byte[] bytes) {
            byte[] buffer = (byte[])Array$.MODULE$.from((IterableOnce)IArray.package.IArray$.MODULE$.wrapByteIArray(bytes), ClassTag$.MODULE$.apply(Byte.TYPE));
            int decodedLength = ByteCodecs$.MODULE$.decode(buffer);
            return (byte[])IArray.package.IArray$.MODULE$.take(IArray.package.IArray$.MODULE$.unsafeFromArray((Object)buffer), decodedLength);
        }

        public int idx(int i) {
            return ClassfileReader$Indexing$.MODULE$.idx(this, i);
        }

        /*
         * Unable to fully structure code
         */
        public boolean add(ConstantInfo<ConstantPool> info) {
            block2: {
                this.infos[this.index] = info;
                var3_2 = info;
                if (!(var3_2 instanceof ConstantInfo.Long)) break block2;
                var4_3 = ClassfileReader$ConstantInfo$Long$.MODULE$.unapply((ConstantInfo.Long)var3_2);
                var5_4 = var4_3._1();
                ** GOTO lbl11
            }
            if (var3_2 instanceof ConstantInfo.Double) {
                var7_5 = ClassfileReader$ConstantInfo$Double$.MODULE$.unapply((ConstantInfo.Double)var3_2);
                var8_6 = var7_5._1();
lbl11:
                // 2 sources

                v0 = 2;
            } else {
                v0 = 1;
            }
            jump = v0;
            this.index += jump;
            return this.index < this.count;
        }

        public ConstantInfo<ConstantPool> apply(int index) {
            if (index < 1 || index >= this.infos.length) {
                throw new Exceptions.ClassfileFormatException(new StringBuilder(28).append("Invalid constant pool index ").append(index).toString());
            }
            return this.infos[index];
        }

        public ConstantInfo<ConstantPool> force(int index) {
            ConstantInfo<ConstantPool> constantInfo;
            ConstantInfo<ConstantPool> constantInfo2 = this.apply(index);
            if (constantInfo2 instanceof ConstantInfo.Utf8) {
                ConstantInfo.Utf8 utf8 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo2);
                Object object = utf8._1();
                this.utf8(index);
                constantInfo = this.infos[index];
            } else {
                ConstantInfo<ConstantPool> info;
                constantInfo = info = constantInfo2;
            }
            return constantInfo;
        }

        public final ClassfileReader tastyquery$reader$classfiles$ClassfileReader$ConstantPool$$$outer() {
            return this.$outer;
        }

        private final /* synthetic */ IterableOnce sigbytes$$anonfun$1(int idx) {
            return IArray.package.IArray$.MODULE$.wrapByteIArray(this.encodedSigbytes(idx));
        }

        private final ConstantInfo forced$1() {
            return this.force(this.idx(this.index));
        }

        private final void doprint$1() {
            Predef$.MODULE$.println((Object)new StringBuilder(7).append("pool ").append(this.index).append(": ").append(this.forced$1()).toString());
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void debug$1() {
            block4: {
                block5: {
                    Names.SimpleName simpleName;
                    String string;
                    ConstantInfo.Utf8 utf8;
                    Object object;
                    ConstantInfo constantInfo;
                    block7: {
                        Object object2;
                        block8: {
                            Object object3;
                            Names.SimpleName simpleName2;
                            block6: {
                                ConstantInfo<ConstantPool> constantInfo2 = this.infos[this.index];
                                if (!(constantInfo2 instanceof ConstantInfo.Utf8)) break block4;
                                ConstantInfo.Utf8 utf82 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo2);
                                Object object4 = utf82._1();
                                if (this.seensigbytes || this.index <= 3) break block4;
                                Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.force(this.idx(this.index - 2)), this.force(this.idx(this.index - 1)));
                                ConstantInfo constantInfo3 = (ConstantInfo)tuple2._1();
                                constantInfo = (ConstantInfo)tuple2._2();
                                if (!(constantInfo3 instanceof ConstantInfo.Utf8)) break block5;
                                ConstantInfo.Utf8 utf83 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo3);
                                object2 = utf83._1();
                                simpleName2 = Names$annot$.MODULE$.ScalaLongSignature();
                                object3 = object2;
                                if (simpleName2 != null) break block6;
                                if (object3 == null) break block7;
                                break block8;
                            }
                            if (((Object)simpleName2).equals(object3)) break block7;
                        }
                        Names.SimpleName simpleName3 = Names$annot$.MODULE$.ScalaSignature();
                        Object object5 = object2;
                        if (simpleName3 != null ? !((Object)simpleName3).equals(object5) : object5 != null) break block5;
                    }
                    if (constantInfo instanceof ConstantInfo.Utf8 && (object = (utf8 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo))._1()) instanceof Names.SimpleName && "bytes".equals(string = (simpleName = Names$SimpleName$.MODULE$.unapply((Names.SimpleName)object))._1())) {
                        this.seensigbytes = true;
                        Predef$.MODULE$.println((Object)new StringBuilder(33).append("pool ").append(this.index).append(": Utf8/<ScalaSignatureBytes>").toString());
                        return;
                    }
                }
                this.doprint$1();
                return;
            }
            this.doprint$1();
        }
    }

    public static interface DataStream {
        public int readU1();

        public int readU2();

        public int readU4();

        public float readU4f();

        public long readU8();

        public double readU8f();

        public String readUTF8();

        public byte[] readSlice(int var1);

        public void skip(int var1);

        public Forked<DataStream> fork();
    }

    public static abstract class SigOrDesc
    implements Product,
    Enum {
        public static SigOrDesc fromOrdinal(int n) {
            return ClassfileReader$SigOrDesc$.MODULE$.fromOrdinal(n);
        }
    }

    public static abstract class SigOrSupers
    implements Product,
    Enum {
        public static SigOrSupers fromOrdinal(int n) {
            return ClassfileReader$SigOrSupers$.MODULE$.fromOrdinal(n);
        }
    }
}

