/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.nodejs;

import java.io.Serializable;
import scala.Function1;
import scala.IArray;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.ArrayOps$;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.Error;
import scala.scalajs.js.Function2;
import scala.scalajs.js.JavaScriptException;
import scala.scalajs.js.Thenable;
import scala.scalajs.js.Thenable$;
import scala.scalajs.js.typedarray.Int8Array;
import scala.scalajs.js.typedarray.Int8Array$;
import scala.scalajs.js.typedarray.Uint8Array;
import scala.scalajs.js.typedarray.package;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;
import tastyquery.Classpaths;
import tastyquery.Classpaths$Classpath$;
import tastyquery.nodejs.ClasspathLoaders;
import tastyquery.nodejs.ClasspathLoaders$JSZip$;
import tastyquery.nodejs.ClasspathLoaders$JSZipInterop$;
import tastyquery.nodejs.ClasspathLoaders$MatchableJSException$;
import tastyquery.nodejs.NodeFS;
import tastyquery.nodejs.NodeFS$;
import tastyquery.nodejs.NodeFS$ReadDirOpt$;

public final class ClasspathLoaders$
implements Serializable {
    private static final ClasspathLoaders$MatchableJSException$ MatchableJSException;
    private static final ClasspathLoaders$JSZipInterop$ JSZipInterop;
    private static final ClasspathLoaders$JSZip$ JSZip;
    public static final ClasspathLoaders$ MODULE$;

    private ClasspathLoaders$() {
    }

    static {
        MODULE$ = new ClasspathLoaders$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClasspathLoaders$.class);
    }

    public Future<Classpaths.Classpath> read(List<String> classpath, ExecutionContext x$2) {
        Future allEntriesFuture = Future$.MODULE$.traverse(classpath, (Function1 & Serializable)entry -> NodeFS$.MODULE$.cbFuture((Function1 & Serializable)_$1 -> {
            this.$anonfun$3$$anonfun$1((String)entry, (Function2)_$1);
            return BoxedUnit.UNIT;
        }).transformWith((Function1 & Serializable)x$1 -> {
            Future future;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                NodeFS.Stats stat = (NodeFS.Stats)((Success)try_).value();
                if (stat.isDirectory()) {
                    future = this.fromDirectory((String)entry, "", x$2);
                    return future;
                } else {
                    if (!entry.endsWith(".jar")) throw new IllegalArgumentException(new StringBuilder(25).append("Illegal classpath entry: ").append((String)entry).toString());
                    future = this.fromJarFile((String)entry, x$2);
                }
                return future;
            } else {
                Error e;
                Object object;
                Object object2;
                Some<Object> some;
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Throwable throwable = ((Failure)try_).exception();
                if (throwable instanceof JavaScriptException && !(some = ClasspathLoaders$MatchableJSException$.MODULE$.unapply((JavaScriptException)throwable)).isEmpty() && (object2 = (object = some.get())) instanceof Error && this.isNotFound(e = (Error)object2)) {
                    future = Future$.MODULE$.successful((Object)package$.MODULE$.Nil());
                    return future;
                } else {
                    Throwable t = throwable;
                    throw t;
                }
            }
        }, x$2), BuildFrom$.MODULE$.buildFromIterableOps(), x$2);
        return allEntriesFuture.map((Function1 & Serializable)allEntries -> {
            List compressedEntries = allEntries.map(((Function1 & Serializable)(Function1 & Serializable)allFiles -> this.compressPackages$6((Seq)allFiles)).andThen((Function1 & Serializable)it -> (Classpaths.PackageData[])IArray.package.IArray$.MODULE$.from((IterableOnce)it, ClassTag$.MODULE$.apply(Classpaths.PackageData.class))));
            return Classpaths$Classpath$.MODULE$.from((Seq<Classpaths.PackageData[]>)compressedEntries);
        }, x$2);
    }

    private Future<Seq<ClasspathLoaders.FileContent>> fromDirectory(String dir, String relPath, ExecutionContext ec) {
        return NodeFS$.MODULE$.cbFuture((Function1 & Serializable)_$5 -> {
            this.fromDirectory$$anonfun$2(dir, (Function2)_$5);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)entries -> {
            Array array = Any$.MODULE$.jsArrayOps(entries);
            Tuple2 tuple2 = ArrayOps$.MODULE$.toSeq$extension(array).partition((Function1 & Serializable)_$6 -> _$6.isDirectory());
            Seq dirs = (Seq)tuple2._1();
            Seq files = (Seq)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)dirs, (Object)files);
            Seq dirs2 = (Seq)tuple22._1();
            Seq files2 = (Seq)tuple22._2();
            Future subdirFiles = Future$.MODULE$.traverse((IterableOnce)dirs2, (Function1 & Serializable)e -> this.fromDirectory(NodeFS$.MODULE$.join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dir, e.name()})), NodeFS$.MODULE$.join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{relPath, e.name()})), ec), BuildFrom$.MODULE$.buildFromIterableOps(), ec);
            Seq irFileNames = (Seq)((IterableOps)files2.map((Function1 & Serializable)_$7 -> _$7.name())).filter((Function1 & Serializable)name -> this.isClassOrTasty((String)name));
            Future directFiles = Future$.MODULE$.traverse((IterableOnce)irFileNames, (Function1 & Serializable)n -> {
                String path = NodeFS$.MODULE$.join((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dir, n}));
                return NodeFS$.MODULE$.cbFuture((Function1 & Serializable)_$8 -> {
                    this.$anonfun$13$$anonfun$1(path, (Function2)_$8);
                    return BoxedUnit.UNIT;
                }).map((Function1 & Serializable)content -> {
                    Int8Array contentAsInt8Array = new Int8Array(content.buffer(), Int8Array$.MODULE$.$lessinit$greater$default$2(), Int8Array$.MODULE$.$lessinit$greater$default$3());
                    return new ClasspathLoaders.FileContent(relPath, (String)n, path, (byte[])IArray.package.IArray$.MODULE$.from((IterableOnce)Predef$.MODULE$.wrapByteArray(package.TA2AB$.MODULE$.toArray$extension(scala.scalajs.js.typedarray.package$.MODULE$.TA2AB(contentAsInt8Array))), ClassTag$.MODULE$.apply(Byte.TYPE)));
                }, ec);
            }, BuildFrom$.MODULE$.buildFromIterableOps(), ec);
            return subdirFiles.flatMap((Function1 & Serializable)sdf -> directFiles.map((Function1 & Serializable)df -> (Seq)((IterableOps)sdf.flatten(Predef$.MODULE$.$conforms())).$plus$plus((IterableOnce)df), ec), ec);
        }, ec);
    }

    private boolean isNotFound(Error e) {
        Dynamic dynamic = ((Dynamic)e).selectDynamic("code");
        String string = "ENOENT";
        return !(dynamic != null ? !dynamic.equals(string) : string != null);
    }

    private Future<List<ClasspathLoaders.FileContent>> fromJarFile(String path, ExecutionContext x$2) {
        return NodeFS$.MODULE$.cbFuture((Function1 & Serializable)_$9 -> {
            this.fromJarFile$$anonfun$2(path, (Function2)_$9);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)arr -> {
            Thenable thenable = Thenable$.MODULE$.ThenableOps(ClasspathLoaders$JSZip$.MODULE$.loadAsync((Uint8Array)arr));
            return Thenable.ThenableOps$.MODULE$.toFuture$extension(thenable).flatMap((Function1 & Serializable)zip -> this.loadFromZip(path, (ClasspathLoaders.JSZip.JSZip)zip, x$2).map((Function1 & Serializable)files -> files.toList(), x$2), x$2);
        }, x$2);
    }

    private Future<Iterator<ClasspathLoaders.FileContent>> loadFromZip(String jarPath, ClasspathLoaders.JSZip.JSZip obj, ExecutionContext ec) {
        Iterator entries = Any$.MODULE$.wrapDictionary(obj.files()).valuesIterator().filter((Function1 & Serializable)e -> this.isClassOrTasty(e.name()) && !e.dir());
        return Future$.MODULE$.traverse((IterableOnce)entries, (Function1 & Serializable)entry -> {
            Thenable thenable = Thenable$.MODULE$.ThenableOps(entry.async(ClasspathLoaders$JSZipInterop$.MODULE$.arrayBuffer()));
            return Thenable.ThenableOps$.MODULE$.toFuture$extension(thenable).map((Function1 & Serializable)buf -> {
                Tuple2 tuple2 = this.splitPackagePathAndName$1(entry.name());
                String packagePath = (String)tuple2._1();
                String name = (String)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)packagePath, (Object)name);
                String packagePath2 = (String)tuple22._1();
                String name2 = (String)tuple22._2();
                return new ClasspathLoaders.FileContent(packagePath2, name2, new StringBuilder(1).append(jarPath).append(":").append(entry.name()).toString(), (byte[])IArray.package.IArray$.MODULE$.from((IterableOnce)Predef$.MODULE$.wrapByteArray(package.TA2AB$.MODULE$.toArray$extension(scala.scalajs.js.typedarray.package$.MODULE$.TA2AB(new Int8Array(buf, Int8Array$.MODULE$.$lessinit$greater$default$2(), Int8Array$.MODULE$.$lessinit$greater$default$3())))), ClassTag$.MODULE$.apply(Byte.TYPE)));
            }, ec);
        }, BuildFrom$.MODULE$.buildFromIterator(), ec);
    }

    private boolean isClassOrTasty(String name) {
        return name.endsWith(".class") || name.endsWith(".tasty");
    }

    private final /* synthetic */ void $anonfun$3$$anonfun$1(String entry$1, Function2 _$1) {
        NodeFS$.MODULE$.stat(entry$1, _$1);
    }

    private final String packagePath$1(Tuple2 x$1$1) {
        return (String)x$1$1._1();
    }

    private final Seq classAndTastys$1(Tuple2 x$1$2) {
        return (Seq)x$1$2._2();
    }

    private final Iterable compressPackages$6(Seq allFiles) {
        return (Iterable)allFiles.groupMap((Function1 & Serializable)_$2 -> _$2.packagePath(), (Function1 & Serializable)fileContent -> {
            boolean isClassFile = fileContent.name().endsWith(".class");
            String binaryName = isClassFile ? StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(fileContent.name()), ".class") : StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(fileContent.name()), ".tasty");
            return isClassFile ? new Classpaths.ClassData(binaryName, fileContent.debugPath(), fileContent.content()) : new Classpaths.TastyData(binaryName, fileContent.debugPath(), fileContent.content());
        }).map((Function1 & Serializable)x$12 -> {
            String x$proxy1 = this.packagePath$1((Tuple2)x$12).replace('/', '.');
            String packageName = (String)Scala3RunTime$.MODULE$.nn((Object)x$proxy1);
            Tuple2 tuple2 = this.classAndTastys$1((Tuple2)x$12).partitionMap((Function1 & Serializable)x$1 -> {
                Left left;
                Object object = x$1;
                if (object instanceof Classpaths.ClassData) {
                    Classpaths.ClassData classData = (Classpaths.ClassData)object;
                    left = Left$.MODULE$.apply((Object)classData);
                } else if (object instanceof Classpaths.TastyData) {
                    Classpaths.TastyData tastyData = (Classpaths.TastyData)object;
                    left = Right$.MODULE$.apply((Object)tastyData);
                } else {
                    throw new MatchError(object);
                }
                return left;
            });
            Seq classes = (Seq)tuple2._1();
            Seq tastys = (Seq)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)classes, (Object)tastys);
            Seq classes2 = (Seq)tuple22._1();
            Seq tastys2 = (Seq)tuple22._2();
            return new Classpaths.PackageData(packageName, (Classpaths.ClassData[])IArray.package.IArray$.MODULE$.from((IterableOnce)classes2.sortBy((Function1 & Serializable)_$3 -> _$3.binaryName(), (Ordering)Ordering.String$.MODULE$), ClassTag$.MODULE$.apply(Classpaths.ClassData.class)), (Classpaths.TastyData[])IArray.package.IArray$.MODULE$.from((IterableOnce)tastys2.sortBy((Function1 & Serializable)_$4 -> _$4.binaryName(), (Ordering)Ordering.String$.MODULE$), ClassTag$.MODULE$.apply(Classpaths.TastyData.class)));
        });
    }

    private final /* synthetic */ void fromDirectory$$anonfun$2(String dir$1, Function2 _$5) {
        NodeFS$.MODULE$.readdir(dir$1, NodeFS$ReadDirOpt$.MODULE$, (Function2<Error, Array<NodeFS.Dirent>, BoxedUnit>)_$5);
    }

    private final /* synthetic */ void $anonfun$13$$anonfun$1(String path$1, Function2 _$8) {
        NodeFS$.MODULE$.readFile(path$1, _$8);
    }

    private final /* synthetic */ void fromJarFile$$anonfun$2(String path$3, Function2 _$9) {
        NodeFS$.MODULE$.readFile(path$3, _$9);
    }

    private final Tuple2 splitPackagePathAndName$1(String relPath) {
        Tuple2 tuple2;
        int lastSlash = relPath.lastIndexOf(47);
        if (lastSlash < 0) {
            tuple2 = Tuple2$.MODULE$.apply((Object)"", (Object)relPath);
        } else {
            String x$proxy2 = relPath.substring(0, lastSlash);
            String x$proxy3 = relPath.substring(lastSlash + 1);
            tuple2 = Tuple2$.MODULE$.apply((Object)((String)Scala3RunTime$.MODULE$.nn((Object)x$proxy2)), (Object)((String)Scala3RunTime$.MODULE$.nn((Object)x$proxy3)));
        }
        return tuple2;
    }
}

