/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.tasty;

import dotty.tools.tasty.TastyBuffer$Addr$;
import dotty.tools.tasty.TastyFormat$;
import dotty.tools.tasty.TastyHeader;
import dotty.tools.tasty.TastyHeaderUnpickler$;
import dotty.tools.tasty.TastyReader;
import dotty.tools.tasty.UnpickleException;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class TastyHeaderUnpickler {
    private final TastyReader reader;

    public TastyHeaderUnpickler(TastyReader reader) {
        this.reader = reader;
    }

    public TastyHeaderUnpickler(byte[] bytes) {
        this(new TastyReader(bytes));
    }

    public UUID readHeader() {
        return this.readFullHeader().uuid();
    }

    public TastyHeader readFullHeader() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), TastyFormat$.MODULE$.header().length).foreach((Function1 & Serializable)v1 -> {
            this.readFullHeader$$anonfun$1(BoxesRunTime.unboxToInt((Object)v1));
            return BoxedUnit.UNIT;
        });
        int fileMajor = this.reader.readNat();
        if (fileMajor <= 27) {
            int fileMinor = this.reader.readNat();
            String signature = TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$signatureString(fileMajor, fileMinor, 0);
            throw new UnpickleException(new StringBuilder(0).append(signature).append(TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$backIncompatAddendum()).append(TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$toolingAddendum()).toString());
        }
        int fileMinor = this.reader.readNat();
        int fileExperimental = this.reader.readNat();
        int length = this.reader.readNat();
        int start = this.reader.currentAddr();
        int end = TastyBuffer$Addr$.MODULE$.$plus$extension(start, length);
        this.reader.goto(end);
        String toolingVersion = new String(this.reader.bytes(), start, length);
        boolean validVersion = TastyFormat$.MODULE$.isVersionCompatible(fileMajor, fileMinor, fileExperimental, TastyFormat$.MODULE$.MajorVersion(), TastyFormat$.MODULE$.MinorVersion(), TastyFormat$.MODULE$.ExperimentalVersion());
        this.check(validVersion, (Function0<String>)((Function0 & Serializable)() -> TastyHeaderUnpickler.readFullHeader$$anonfun$2(fileMajor, fileMinor, fileExperimental, toolingVersion)));
        UUID uuid = new UUID(this.reader.readUncompressedLong(), this.reader.readUncompressedLong());
        return new TastyHeader(fileMajor, fileMinor, fileExperimental, toolingVersion, uuid){};
    }

    public boolean isAtEnd() {
        return this.reader.isAtEnd();
    }

    private void check(boolean cond, Function0<String> msg) {
        if (!cond) {
            throw new UnpickleException((String)msg.apply());
        }
    }

    private static final String readFullHeader$$anonfun$1$$anonfun$1() {
        return "not a TASTy file";
    }

    private final /* synthetic */ void readFullHeader$$anonfun$1(int i) {
        this.check(this.reader.readByte() == TastyFormat$.MODULE$.header()[i], (Function0<String>)((Function0 & Serializable)TastyHeaderUnpickler::readFullHeader$$anonfun$1$$anonfun$1));
    }

    private static final String readFullHeader$$anonfun$2(int fileMajor$1, int fileMinor$1, int fileExperimental$1, String toolingVersion$1) {
        String signature = TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$signatureString(fileMajor$1, fileMinor$1, fileExperimental$1);
        String producedByAddendum = new StringBuilder(33).append("\nThe TASTy file was produced by ").append(toolingVersion$1).append(".").append(TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$toolingAddendum()).toString();
        String msg = fileExperimental$1 != 0 ? TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$unstableAddendum() : (fileMajor$1 < TastyFormat$.MODULE$.MajorVersion() ? TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$backIncompatAddendum() : TastyHeaderUnpickler$.MODULE$.dotty$tools$tasty$TastyHeaderUnpickler$$$forwardIncompatAddendum());
        return new StringBuilder(0).append(signature).append(msg).append(producedByAddendum).toString();
    }
}

