/*
 * Decompiled with CFR 0.152.
 */
package tastyquery;

import java.io.Serializable;
import java.io.Writer;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import tastyquery.Annotations;
import tastyquery.Constants;
import tastyquery.Names;
import tastyquery.Names$SuffixedName$;
import tastyquery.Names$TypeName$;
import tastyquery.Printers$;
import tastyquery.Symbols;
import tastyquery.Types;
import tastyquery.Types$NoPrefix$;
import tastyquery.Types$RealTypeBounds$;
import tastyquery.Types$TypeAlias$;
import tastyquery.Variances$;
import tastyquery.Variances$Variance$;

public final class Printers {
    public static String withWriterToString(Function1<Writer, BoxedUnit> function1) {
        return Printers$.MODULE$.withWriterToString(function1);
    }

    public static class Printer {
        private final Writer out;

        public Printer(Writer out) {
            this.out = out;
        }

        public void printPrefix(Types.Prefix prefix) {
            Types.Prefix prefix2 = prefix;
            if (Types$NoPrefix$.MODULE$.equals(prefix2)) {
                return;
            }
            if (prefix2 instanceof Types.PackageRef) {
                Types.PackageRef prefix3 = (Types.PackageRef)prefix2;
                this.print(prefix3);
                this.print(".");
                return;
            }
            if (prefix2 instanceof Types.TermRef) {
                Types.TermRef prefix4 = (Types.TermRef)prefix2;
                this.printPrefix(prefix4.prefix());
                this.print(prefix4.name());
                this.print(".");
                return;
            }
            if (prefix2 instanceof Types.TermParamRef) {
                Types.TermParamRef tpe = (Types.TermParamRef)prefix2;
                this.print(tpe.paramName());
                this.print(".");
                return;
            }
            if (prefix2 instanceof Types.ThisType) {
                Types.ThisType tpe = (Types.ThisType)prefix2;
                this.print(tpe.tref().name());
                this.print(".this.");
                return;
            }
            if (prefix2 instanceof Types.SuperType) {
                Types.SuperType tpe = (Types.SuperType)prefix2;
                this.print(tpe.thistpe().tref().name());
                this.print(".super");
                tpe.explicitSupertpe().foreach((Function1 & Serializable)explicitSupertpe -> {
                    this.printPrefix$$anonfun$1((Types.Type)explicitSupertpe);
                    return BoxedUnit.UNIT;
                });
                this.print(".");
                return;
            }
            if (prefix2 instanceof Types.RecThis) {
                Types.RecThis tpe = (Types.RecThis)prefix2;
                this.print(tpe.binders().debugID());
                this.print(".");
                return;
            }
            if (prefix2 instanceof Types.Type) {
                Types.Type prefix5 = (Types.Type)prefix2;
                this.print(prefix5);
                this.print("#");
                return;
            }
            throw new MatchError((Object)prefix2);
        }

        public void print(Types.TypeMappable tpe) {
            Types.TypeMappable typeMappable = tpe;
            if (Types$NoPrefix$.MODULE$.equals(typeMappable)) {
                this.print("\u03b5");
                return;
            }
            if (typeMappable instanceof Types.PackageRef) {
                Types.PackageRef tpe2 = (Types.PackageRef)typeMappable;
                this.print(tpe2.fullyQualifiedName().toString());
                return;
            }
            if (typeMappable instanceof Types.TermRef || typeMappable instanceof Types.TermParamRef || typeMappable instanceof Types.ThisType || typeMappable instanceof Types.SuperType || typeMappable instanceof Types.RecThis) {
                Types.SingletonType tpe3 = (Types.SingletonType)((Object)typeMappable);
                this.printPrefix((Types.Prefix)((Object)tpe3));
                this.print("type");
                return;
            }
            if (typeMappable instanceof Types.TypeRef) {
                Types.TypeRef tpe4 = (Types.TypeRef)typeMappable;
                this.printPrefix(tpe4.prefix());
                this.print(tpe4.name());
                return;
            }
            if (typeMappable instanceof Types.ConstantType) {
                Types.ConstantType tpe5 = (Types.ConstantType)typeMappable;
                this.print(tpe5.value());
                return;
            }
            if (typeMappable instanceof Types.AppliedType) {
                Types.AppliedType tpe6 = (Types.AppliedType)typeMappable;
                this.print(tpe6.tycon());
                this.print("[");
                this.print((Types.TypeMappable)tpe6.args().head());
                ((List)tpe6.args().tail()).foreach((Function1 & Serializable)arg -> {
                    this.print$$anonfun$1((Types.Type)arg);
                    return BoxedUnit.UNIT;
                });
                this.print("]");
                return;
            }
            if (typeMappable instanceof Types.ByNameType) {
                Types.ByNameType tpe7 = (Types.ByNameType)typeMappable;
                this.print("=> ");
                this.print(tpe7.resultType());
                return;
            }
            if (typeMappable instanceof Types.TypeLambda) {
                Types.TypeLambda tpe8 = (Types.TypeLambda)typeMappable;
                this.print("([");
                this.print((Types.TypeConstructorParam)tpe8.typeLambdaParams().head());
                ((List)tpe8.typeLambdaParams().tail()).foreach((Function1 & Serializable)tparam -> {
                    this.print$$anonfun$2((Types.TypeLambdaParam)tparam);
                    return BoxedUnit.UNIT;
                });
                this.print("] =>> ");
                this.print(tpe8.resultType());
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.TypeParamRef) {
                Types.TypeParamRef tpe9 = (Types.TypeParamRef)typeMappable;
                this.print(tpe9.paramName());
                return;
            }
            if (typeMappable instanceof Types.AnnotatedType) {
                Types.AnnotatedType tpe10 = (Types.AnnotatedType)typeMappable;
                this.print("(");
                this.print(tpe10.annotation());
                this.print(" ");
                this.print(tpe10.typ());
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.TypeRefinement) {
                Types.TypeRefinement tpe11 = (Types.TypeRefinement)typeMappable;
                this.print("(");
                this.print(tpe11.parent());
                this.print(" { type ");
                this.print(tpe11.refinedName());
                this.print(tpe11.refinedBounds());
                this.print(" })");
                return;
            }
            if (typeMappable instanceof Types.TermRefinement) {
                Types.TermRefinement tpe12 = (Types.TermRefinement)typeMappable;
                this.print("(");
                this.print(tpe12.parent());
                if (tpe12.isStable()) {
                    this.print(" { val ");
                } else {
                    this.print(" { def ");
                }
                this.print(tpe12.refinedName());
                if (tpe12.refinedType() instanceof Types.Type) {
                    this.print(": ");
                }
                this.print(tpe12.refinedType());
                this.print(" })");
                return;
            }
            if (typeMappable instanceof Types.RecType) {
                Types.RecType tpe13 = (Types.RecType)typeMappable;
                this.print("{ ");
                this.print(tpe13.debugID());
                this.print(" => ");
                this.print(tpe13.parent());
                this.print(" }");
                return;
            }
            if (typeMappable instanceof Types.MatchType) {
                Types.MatchType tpe14 = (Types.MatchType)typeMappable;
                this.print("(");
                this.print(tpe14.scrutinee());
                if (!Printers$.MODULE$.tastyquery$Printers$$$isSyntacticAny(tpe14.bound())) {
                    this.print(" <: ");
                    this.print(tpe14.bound());
                }
                this.print(" match { ");
                BooleanRef first = BooleanRef.create((boolean)true);
                tpe14.cases().foreach((Function1 & Serializable)caze -> {
                    this.print$$anonfun$3(first, (Types.MatchTypeCase)caze);
                    return BoxedUnit.UNIT;
                });
                this.print(" })");
                return;
            }
            if (typeMappable instanceof Types.SkolemType) {
                Types.SkolemType tpe15 = (Types.SkolemType)typeMappable;
                this.print("(\u2203");
                this.print(tpe15.debugID());
                this.print(": ");
                this.print(tpe15.tpe());
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.OrType) {
                Types.OrType tpe16 = (Types.OrType)typeMappable;
                this.print("(");
                this.print(tpe16.first());
                this.print(" | ");
                this.print(tpe16.second());
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.AndType) {
                Types.AndType tpe17 = (Types.AndType)typeMappable;
                this.print("(");
                this.print(tpe17.first());
                this.print(" & ");
                this.print(tpe17.second());
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.CustomTransientGroundType) {
                Types.CustomTransientGroundType tpe18 = (Types.CustomTransientGroundType)typeMappable;
                this.print("<");
                this.print(tpe18.toString());
                this.print(">");
                return;
            }
            if (typeMappable instanceof Types.MethodType) {
                Types.MethodType tpe19 = (Types.MethodType)typeMappable;
                this.print("(");
                BooleanRef first = BooleanRef.create((boolean)true);
                tpe19.paramNames().lazyZip(tpe19.paramTypes()).foreach((Function2 & Serializable)(argName, argType) -> {
                    this.print$$anonfun$4(first, (Names.TermName)argName, (Types.Type)argType);
                    return BoxedUnit.UNIT;
                });
                this.print(")");
                this.print(tpe19.resultType());
                return;
            }
            if (typeMappable instanceof Types.PolyType) {
                Types.PolyType tpe20 = (Types.PolyType)typeMappable;
                this.print("[");
                BooleanRef first = BooleanRef.create((boolean)true);
                tpe20.paramNames().lazyZip(tpe20.paramTypeBounds()).foreach((Function2 & Serializable)(argName, argBounds) -> {
                    this.print$$anonfun$5(first, (Names.TypeName)argName, (Types.TypeBounds)argBounds);
                    return BoxedUnit.UNIT;
                });
                this.print("]");
                this.print(tpe20.resultType());
                return;
            }
            if (typeMappable instanceof Types.WildcardTypeBounds) {
                Types.WildcardTypeBounds tpe21 = (Types.WildcardTypeBounds)typeMappable;
                this.print("?");
                this.print(tpe21.bounds());
                return;
            }
            if (typeMappable instanceof Types.TypeAlias) {
                Types.Type type;
                Types.TypeAlias typeAlias = Types$TypeAlias$.MODULE$.unapply((Types.TypeAlias)typeMappable);
                Types.Type alias = type = typeAlias._1();
                this.print(" = ");
                this.print(alias);
                return;
            }
            if (typeMappable instanceof Types.RealTypeBounds) {
                Types.RealTypeBounds realTypeBounds = Types$RealTypeBounds$.MODULE$.unapply((Types.RealTypeBounds)typeMappable);
                Types.Type type = realTypeBounds._1();
                Types.Type type2 = realTypeBounds._2();
                Types.Type low = type;
                Types.Type high = type2;
                if (!Printers$.MODULE$.tastyquery$Printers$$$isSyntacticNothing(low)) {
                    this.print(" >: ");
                    this.print(low);
                }
                if (!Printers$.MODULE$.tastyquery$Printers$$$isSyntacticAny(high)) {
                    this.print(" <: ");
                    this.print(high);
                    return;
                }
                return;
            }
            throw new MatchError((Object)typeMappable);
        }

        public void print(Names.Name name) {
            Names.TypeName typeName;
            Names.TermName termName;
            this.print(name.toString());
            Names.Name name2 = name;
            if (name2 instanceof Names.TypeName && (termName = (typeName = Names$TypeName$.MODULE$.unapply((Names.TypeName)name2))._1()) instanceof Names.SuffixedName) {
                Names.SuffixedName suffixedName = Names$SuffixedName$.MODULE$.unapply((Names.SuffixedName)termName);
                int n = suffixedName._1();
                Names.TermName termName2 = suffixedName._2();
                if (23 == n) {
                    Names.TermName rest = termName2;
                    this.print("$");
                    return;
                }
            }
        }

        public void print(Constants.Constant constant) {
            int n = constant.tag();
            switch (n) {
                case 1: {
                    this.print("()");
                    return;
                }
                case 3: {
                    this.print(new StringBuilder(1).append(constant.value()).append("b").toString());
                    return;
                }
                case 4: {
                    this.print(new StringBuilder(1).append(constant.value()).append("s").toString());
                    return;
                }
                case 5: {
                    this.print("'");
                    this.printEscaped(BoxesRunTime.boxToCharacter((char)constant.charValue()).toString());
                    this.print("'");
                    return;
                }
                case 7: {
                    this.print(new StringBuilder(1).append(constant.value()).append("L").toString());
                    return;
                }
                case 8: {
                    this.print(new StringBuilder(1).append(constant.value()).append("f").toString());
                    return;
                }
                case 10: {
                    this.print("\"");
                    this.printEscaped(constant.stringValue());
                    this.print("\"");
                    return;
                }
                case 11: {
                    this.print("null");
                    return;
                }
                case 12: {
                    this.print("classOf[");
                    this.print(constant.typeValue());
                    this.print("]");
                    return;
                }
            }
            this.print(constant.value().toString());
        }

        public void printEscaped(String str) {
            StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)v1 -> {
                this.printEscaped$$anonfun$1(BoxesRunTime.unboxToChar((Object)v1));
                return BoxedUnit.UNIT;
            });
        }

        public void print(Annotations.Annotation annot) {
            this.print("@<annot>");
        }

        public void print(Types.TypeConstructorParam tparam) {
            Types.TypeConstructorParam typeConstructorParam = tparam;
            if (typeConstructorParam instanceof Types.TypeLambdaParam) {
                Types.TypeLambdaParam tparam2 = (Types.TypeLambdaParam)typeConstructorParam;
            } else if (typeConstructorParam instanceof Symbols.ClassTypeParamSymbol) {
                Symbols.ClassTypeParamSymbol tparam3 = (Symbols.ClassTypeParamSymbol)typeConstructorParam;
                this.print(Variances$Variance$.MODULE$.fromFlags(tparam3.flags()));
            } else {
                throw new MatchError((Object)typeConstructorParam);
            }
            this.print(tparam.name());
            Types.TypeConstructorParam typeConstructorParam2 = tparam;
            if (typeConstructorParam2 instanceof Types.TypeLambdaParam) {
                Types.TypeLambdaParam tparam4 = (Types.TypeLambdaParam)typeConstructorParam2;
                this.print(tparam4.boundsDirect());
                return;
            }
            if (typeConstructorParam2 instanceof Symbols.ClassTypeParamSymbol) {
                Symbols.ClassTypeParamSymbol tparam5 = (Symbols.ClassTypeParamSymbol)typeConstructorParam2;
                this.print(tparam5.boundsDirect());
                return;
            }
            throw new MatchError((Object)typeConstructorParam2);
        }

        public void print(long variance) {
            if (Variances$.MODULE$.isCovariant(variance)) {
                this.print("+");
                return;
            }
            if (Variances$.MODULE$.isContravariant(variance)) {
                this.print("-");
                return;
            }
        }

        public void print(int i) {
            this.print(BoxesRunTime.boxToInteger((int)i).toString());
        }

        public void print(String str) {
            this.out.write(str);
        }

        private final /* synthetic */ void printPrefix$$anonfun$1(Types.Type explicitSupertpe) {
            this.print("[");
            this.print(explicitSupertpe);
            this.print("]");
        }

        private final /* synthetic */ void print$$anonfun$1(Types.Type arg) {
            this.print(", ");
            this.print(arg);
        }

        private final /* synthetic */ void print$$anonfun$2(Types.TypeLambdaParam tparam) {
            this.print(", ");
            this.print(tparam);
        }

        private final /* synthetic */ void print$$anonfun$3(BooleanRef first$1, Types.MatchTypeCase caze) {
            if (first$1.elem) {
                boolean bl;
                first$1.elem = bl = false;
            } else {
                this.print("; ");
            }
            this.print("case ");
            this.print(caze.pattern());
            this.print(" => ");
            this.print(caze.result());
        }

        private final /* synthetic */ void print$$anonfun$4(BooleanRef first$2, Names.TermName argName, Types.Type argType) {
            if (first$2.elem) {
                boolean bl;
                first$2.elem = bl = false;
            } else {
                this.print(", ");
            }
            this.print(argName);
            this.print(": ");
            this.print(argType);
        }

        private final /* synthetic */ void print$$anonfun$5(BooleanRef first$3, Names.TypeName argName, Types.TypeBounds argBounds) {
            if (first$3.elem) {
                boolean bl;
                first$3.elem = bl = false;
            } else {
                this.print(", ");
            }
            this.print(argName);
            this.print(argBounds);
        }

        private final /* synthetic */ void printEscaped$$anonfun$1(char c) {
            char c2 = c;
            switch (c2) {
                case '\'': {
                    this.print("\\'");
                    return;
                }
                case '\"': {
                    this.print("\\\"");
                    return;
                }
                case '\n': {
                    this.print("\\n");
                    return;
                }
            }
            if (c >= ' ' && c < '\u0080') {
                this.print(BoxesRunTime.boxToCharacter((char)c).toString());
                return;
            }
            this.print(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
        }
    }
}

