/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.classfiles;

import scala.Function1;
import scala.IArray;
import tastyquery.reader.UTF8Utils$;
import tastyquery.reader.classfiles.ClassfileReader;
import tastyquery.reader.classfiles.Forked;

public final class ClassfileBuffer {

    public static final class Child
    implements ClassfileReader.DataStream {
        private final byte[] bytes;
        private int bp;

        public Child(byte[] bytes, int init) {
            this.bytes = bytes;
            this.bp = init;
        }

        @Override
        public int readU1() {
            int r = IArray.package.IArray$.MODULE$.apply(this.bytes, this.bp) & 0xFF;
            ++this.bp;
            return r;
        }

        @Override
        public int readU2() {
            return this.readU1() << 8 | this.readU1();
        }

        @Override
        public int readU4() {
            return this.readU1() << 24 | this.readU1() << 16 | this.readU1() << 8 | this.readU1();
        }

        @Override
        public float readU4f() {
            return Float.intBitsToFloat(this.readU4());
        }

        @Override
        public long readU8() {
            return (long)this.readU4() << 32 | (long)this.readU4();
        }

        @Override
        public double readU8f() {
            return Double.longBitsToDouble(this.readU8());
        }

        @Override
        public String readUTF8() {
            int size = this.readU2();
            int start = this.bp;
            this.bp += size;
            return UTF8Utils$.MODULE$.decodeFromIArray(this.bytes, start, size);
        }

        public Root fork() {
            return new Root(this.bytes, this.bp);
        }

        @Override
        public byte[] readSlice(int length) {
            int start = this.bp;
            this.bp += length;
            return (byte[])IArray.package.IArray$.MODULE$.slice((Object)this.bytes, start, start + length);
        }

        @Override
        public final void skip(int bytes) {
            this.bp += bytes;
        }

        public final boolean consumedFully() {
            return this.bp == IArray.package.IArray$.MODULE$.length(this.bytes);
        }
    }

    public static final class Root
    implements Forked<ClassfileReader.DataStream> {
        private final byte[] bytes;
        private final int offset;

        public Root(byte[] bytes, int offset) {
            this.bytes = bytes;
            this.offset = offset;
        }

        @Override
        public <T> T use(Function1<ClassfileReader.DataStream, T> op) {
            return (T)op.apply((Object)new Child(this.bytes, this.offset));
        }
    }
}

