/*
 * Decompiled with CFR 0.152.
 */
package tastyquery;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import tastyquery.Classpaths;
import tastyquery.Contexts$;
import tastyquery.Definitions;
import tastyquery.Exceptions;
import tastyquery.Names;
import tastyquery.Names$;
import tastyquery.Names$FullyQualifiedName$;
import tastyquery.Symbols;
import tastyquery.Symbols$PackageSymbol$;
import tastyquery.reader.Loaders;

public final class Contexts {
    public static Context init(Classpaths.Classpath classpath) {
        return Contexts$.MODULE$.init(classpath);
    }

    public static final class Context {
        private final Loaders.Loader classloader;
        private final Symbols.PackageSymbol RootPackage;
        private final Symbols.PackageSymbol EmptyPackage;
        private final Definitions defn;

        public Context(Loaders.Loader classloader) {
            this.classloader = classloader;
            Tuple2<Symbols.PackageSymbol, Symbols.PackageSymbol> tuple2 = Symbols$PackageSymbol$.MODULE$.createRoots();
            Symbols.PackageSymbol RootPackage = (Symbols.PackageSymbol)tuple2._1();
            Symbols.PackageSymbol EmptyPackage = (Symbols.PackageSymbol)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)RootPackage, (Object)EmptyPackage);
            this.RootPackage = (Symbols.PackageSymbol)tuple22._1();
            this.EmptyPackage = (Symbols.PackageSymbol)tuple22._2();
            this.defn = new Definitions(this, this.RootPackage, this.EmptyPackage);
        }

        public Loaders.Loader classloader() {
            return this.classloader;
        }

        private final Context given_Context() {
            return this;
        }

        public Definitions defn() {
            return this.defn;
        }

        public Iterable<Symbols.TermOrTypeSymbol> findSymbolsByClasspathEntry(Classpaths.Classpath.Entry entry) {
            return (Iterable)this.classloader().lookupByEntry(entry, this.given_Context()).getOrElse(() -> this.findSymbolsByClasspathEntry$$anonfun$1(entry));
        }

        public Symbols.PackageSymbol findPackageFromRoot(Names.FullyQualifiedName fullyQualifiedName) {
            return this.rec$1(this.RootPackage, fullyQualifiedName.path());
        }

        public Symbols.Symbol findSymbolFromRoot(List<Names.Name> path) {
            return this.rec$2(this.RootPackage, path);
        }

        public Symbols.PackageSymbol findPackage(String fullyQualifiedName) {
            return this.findPackageFromRoot(Names$FullyQualifiedName$.MODULE$.apply((List<Names.Name>)Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(fullyQualifiedName), '.')).toList().map((Function1 & Serializable)_$1 -> Names$.MODULE$.termName((String)_$1))));
        }

        public Symbols.ClassSymbol findTopLevelClass(String fullyQualifiedName) {
            Symbols.Symbol symbol;
            String nameStr;
            Names.TypeName name;
            String nameStr2;
            Tuple2<Symbols.PackageSymbol, String> tuple2 = this.splitPackageAndName(fullyQualifiedName);
            Symbols.PackageSymbol pkg = (Symbols.PackageSymbol)tuple2._1();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)pkg, (Object)(nameStr2 = (String)tuple2._2()));
            Symbols.PackageSymbol pkg2 = (Symbols.PackageSymbol)tuple22._1();
            Option<Symbols.Symbol> option = pkg2.getDecl(name = Names$.MODULE$.typeName(nameStr = (String)tuple22._2()), this.given_Context());
            if (option instanceof Some && (symbol = (Symbols.Symbol)((Some)option).value()) instanceof Symbols.ClassSymbol) {
                Symbols.ClassSymbol cls = (Symbols.ClassSymbol)symbol;
                return cls;
            }
            throw new Exceptions.MemberNotFoundException(pkg2, name, new StringBuilder(22).append("cannot find class ").append(nameStr).append(" in ").append(pkg2).toString());
        }

        public Symbols.ClassSymbol findTopLevelModuleClass(String fullyQualifiedName) {
            Symbols.Symbol symbol;
            String nameStr;
            Names.TypeName name;
            String nameStr2;
            Tuple2<Symbols.PackageSymbol, String> tuple2 = this.splitPackageAndName(fullyQualifiedName);
            Symbols.PackageSymbol pkg = (Symbols.PackageSymbol)tuple2._1();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)pkg, (Object)(nameStr2 = (String)tuple2._2()));
            Symbols.PackageSymbol pkg2 = (Symbols.PackageSymbol)tuple22._1();
            Option<Symbols.Symbol> option = pkg2.getDecl(name = Names$.MODULE$.termName(nameStr = (String)tuple22._2()).withObjectSuffix().toTypeName(), this.given_Context());
            if (option instanceof Some && (symbol = (Symbols.Symbol)((Some)option).value()) instanceof Symbols.ClassSymbol) {
                Symbols.ClassSymbol cls = (Symbols.ClassSymbol)symbol;
                return cls;
            }
            throw new Exceptions.MemberNotFoundException(pkg2, name, new StringBuilder(29).append("cannot find module class ").append(nameStr).append(" in ").append(pkg2).toString());
        }

        public Symbols.ClassSymbol findStaticClass(String fullyQualifiedName) {
            Symbols.TypeSymbol typeSymbol = this.findStaticType(fullyQualifiedName);
            if (typeSymbol instanceof Symbols.ClassSymbol) {
                Symbols.ClassSymbol cls = (Symbols.ClassSymbol)typeSymbol;
                return cls;
            }
            Symbols.TypeSymbol sym = typeSymbol;
            throw new Exceptions.InvalidProgramStructureException(new StringBuilder(30).append("expected class symbol but got ").append(sym).toString());
        }

        public Symbols.ClassSymbol findStaticModuleClass(String fullyQualifiedName) {
            Symbols.TermSymbol termSymbol = this.findStaticTerm(fullyQualifiedName);
            Symbols.TermSymbol sym = termSymbol;
            if (sym.isModuleVal()) {
                return (Symbols.ClassSymbol)sym.moduleClass(this.given_Context()).get();
            }
            Symbols.TermSymbol sym2 = termSymbol;
            throw new Exceptions.InvalidProgramStructureException(new StringBuilder(31).append("expected module symbol but got ").append(sym2).toString());
        }

        public Symbols.TypeSymbol findStaticType(String fullyQualifiedName) {
            Tuple2<Symbols.DeclaringSymbol, String> tuple2 = this.findStaticOwnerAndName(fullyQualifiedName);
            Symbols.DeclaringSymbol owner = (Symbols.DeclaringSymbol)tuple2._1();
            String nameStr = (String)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)owner, (Object)nameStr);
            Symbols.DeclaringSymbol owner2 = (Symbols.DeclaringSymbol)tuple22._1();
            String nameStr2 = (String)tuple22._2();
            Names.TypeName name = Names$.MODULE$.typeName(nameStr2);
            return ((Symbols.Symbol)owner2.getDecl(name, this.given_Context()).getOrElse(() -> this.findStaticType$$anonfun$1(owner2, name))).asType();
        }

        public Symbols.TermSymbol findStaticTerm(String fullyQualifiedName) {
            Tuple2<Symbols.DeclaringSymbol, String> tuple2 = this.findStaticOwnerAndName(fullyQualifiedName);
            Symbols.DeclaringSymbol owner = (Symbols.DeclaringSymbol)tuple2._1();
            String nameStr = (String)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)owner, (Object)nameStr);
            Symbols.DeclaringSymbol owner2 = (Symbols.DeclaringSymbol)tuple22._1();
            String nameStr2 = (String)tuple22._2();
            Names.SimpleName name = Names$.MODULE$.termName(nameStr2);
            return ((Symbols.Symbol)owner2.getDecl(name, this.given_Context()).getOrElse(() -> this.findStaticTerm$$anonfun$1(owner2, name))).asTerm();
        }

        private Tuple2<Symbols.DeclaringSymbol, String> findStaticOwnerAndName(String fullyQualifiedName) {
            List path = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(fullyQualifiedName), '.')).toList();
            return Tuple2$.MODULE$.apply((Object)this.findStaticOwner((List<String>)((List)path.init())), path.last());
        }

        private Symbols.DeclaringSymbol findStaticOwner(List<String> path) {
            if (path.isEmpty()) {
                return this.EmptyPackage;
            }
            return this.loop$1(this.RootPackage, path);
        }

        private Tuple2<Symbols.PackageSymbol, String> splitPackageAndName(String fullyQualifiedName) {
            List list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(fullyQualifiedName), '.')).toList();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list2 = colon2.next$access$1();
                String name = (String)colon2.head();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list3 = list2;
                if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                    return Tuple2$.MODULE$.apply((Object)this.EmptyPackage, (Object)name);
                }
            }
            List path = list;
            return Tuple2$.MODULE$.apply((Object)this.findPackageFromRoot(Names$FullyQualifiedName$.MODULE$.apply((List<Names.Name>)((List)path.init()).map((Function1 & Serializable)_$2 -> Names$.MODULE$.termName((String)_$2)))), path.last());
        }

        public Symbols.PackageSymbol findPackageFromRootOrCreate(Names.FullyQualifiedName fullyQualifiedName) {
            return (Symbols.PackageSymbol)fullyQualifiedName.path().foldLeft((Object)this.RootPackage, (Function2 & Serializable)(owner, name) -> owner.getPackageDeclOrCreate(name.asSimpleName()));
        }

        private final Iterable findSymbolsByClasspathEntry$$anonfun$1(Classpaths.Classpath.Entry entry$1) {
            throw new Exceptions.UnknownClasspathEntry(entry$1);
        }

        private final Symbols.PackageSymbol $anonfun$1(Names.SimpleName name$1, Symbols.PackageSymbol owner$tailLocal1$1) {
            throw new Exceptions.MemberNotFoundException(owner$tailLocal1$1, name$1, new StringBuilder(31).append("cannot find package member ").append(name$1).append(" of ").append(owner$tailLocal1$1).toString());
        }

        private final Symbols.PackageSymbol rec$1(Symbols.PackageSymbol owner, List path) {
            List list;
            block2: {
                List list2;
                Names.Name name;
                while (true) {
                    Symbols.PackageSymbol next;
                    list = path;
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list3 = list;
                    if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                        return owner;
                    }
                    if (!(list instanceof .colon.colon)) break block2;
                    .colon.colon colon2 = (.colon.colon)list;
                    name = (Names.Name)colon2.head();
                    list2 = colon2.next$access$1();
                    if (!(name instanceof Names.SimpleName)) break;
                    Names.SimpleName name2 = (Names.SimpleName)name;
                    List pathRest = list2;
                    Symbols.PackageSymbol packageSymbol = next = (Symbols.PackageSymbol)owner.getPackageDecl(name2).getOrElse(() -> this.$anonfun$1(name2, owner));
                    List list4 = pathRest;
                    owner = packageSymbol;
                    path = list4;
                }
                Names.Name name3 = name;
                List pathRest = list2;
                throw new Exceptions.MemberNotFoundException(owner, name3, new StringBuilder(31).append("cannot find package member ").append(name3).append(" of ").append(owner).toString());
            }
            throw new MatchError((Object)list);
        }

        private final Symbols.Symbol $anonfun$2(Names.Name name$2, Symbols.DeclaringSymbol owner$1, Symbols.Symbol symbol$tailLocal1$1) {
            throw new Exceptions.MemberNotFoundException(owner$1, name$2, new StringBuilder(23).append("cannot find member ").append(name$2.toDebugString()).append(" in ").append(symbol$tailLocal1$1).toString());
        }

        private final Symbols.Symbol rec$2(Symbols.Symbol symbol, List path) {
            List list;
            while (true) {
                Symbols.Symbol next;
                list = path;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    return symbol;
                }
                if (!(list instanceof .colon.colon)) break;
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                Names.Name name = (Names.Name)colon2.head();
                List pathRest = list3;
                Symbols.Symbol symbol2 = symbol;
                if (!(symbol2 instanceof Symbols.DeclaringSymbol)) {
                    throw new Exceptions.MemberNotFoundException(symbol, name, new StringBuilder(46).append(symbol).append(" does not declare a scope, cannot find member ").append(name.toDebugString()).toString());
                }
                Symbols.DeclaringSymbol owner = (Symbols.DeclaringSymbol)((Object)symbol2);
                Symbols.DeclaringSymbol owner2 = owner;
                Symbols.Symbol symbol3 = next = (Symbols.Symbol)owner2.getDecl(name, this.given_Context()).getOrElse(() -> this.$anonfun$2(name, owner2, symbol));
                List list4 = pathRest;
                symbol = symbol3;
                path = list4;
            }
            throw new MatchError((Object)list);
        }

        private final Symbols.Symbol findStaticType$$anonfun$1(Symbols.DeclaringSymbol owner$2, Names.TypeName name$3) {
            throw new Exceptions.MemberNotFoundException(owner$2, name$3);
        }

        private final Symbols.Symbol findStaticTerm$$anonfun$1(Symbols.DeclaringSymbol owner$3, Names.SimpleName name$4) {
            throw new Exceptions.MemberNotFoundException(owner$3, name$4);
        }

        private final Symbols.DeclaringSymbol loop$1(Symbols.DeclaringSymbol owner, List path) {
            List list;
            block4: {
                Option<Symbols.Symbol> option;
                Names.SimpleName name;
                block5: {
                    Symbols.Symbol symbol;
                    while (true) {
                        Symbols.TermSymbol moduleSymbol;
                        list = path;
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list2 = list;
                        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                            return owner;
                        }
                        if (!(list instanceof .colon.colon)) break block4;
                        .colon.colon colon2 = (.colon.colon)list;
                        List list3 = colon2.next$access$1();
                        String nameStr = (String)colon2.head();
                        List rest = list3;
                        name = Names$.MODULE$.termName(nameStr);
                        option = owner.getDecl(name, this.given_Context());
                        if (!(option instanceof Some)) break block5;
                        symbol = (Symbols.Symbol)((Some)option).value();
                        if (symbol instanceof Symbols.PackageSymbol) {
                            Symbols.PackageSymbol pkg;
                            Symbols.PackageSymbol packageSymbol = pkg = (Symbols.PackageSymbol)symbol;
                            List list4 = rest;
                            owner = packageSymbol;
                            path = list4;
                            continue;
                        }
                        if (!(symbol instanceof Symbols.TermSymbol) || !(moduleSymbol = (Symbols.TermSymbol)symbol).isModuleVal()) break;
                        Symbols.DeclaringSymbol declaringSymbol = (Symbols.DeclaringSymbol)moduleSymbol.moduleClass(this.given_Context()).get();
                        List list5 = rest;
                        owner = declaringSymbol;
                        path = list5;
                    }
                    Symbols.Symbol sym = symbol;
                    throw new Exceptions.InvalidProgramStructureException(new StringBuilder(22).append(sym).append(" is not a static owner").toString());
                }
                if (None$.MODULE$.equals(option)) {
                    throw new Exceptions.MemberNotFoundException(owner, name);
                }
                throw new MatchError(option);
            }
            throw new MatchError((Object)list);
        }
    }
}

