/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.tasties;

import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyBuffer$Addr$;
import dotty.tools.tasty.TastyReader;
import java.io.Serializable;
import scala.Function0;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import tastyquery.Spans;
import tastyquery.Spans$;
import tastyquery.reader.tasties.TastyUnpickler;

public class PositionUnpickler {
    private final TastyReader reader;
    private final TastyUnpickler.NameTable nameAtRef;
    private int[] myLineSizes;
    private HashMap<TastyBuffer.Addr, Spans.Span> mySpans;
    private HashMap<TastyBuffer.Addr, String> mySourcePaths;
    private boolean isDefined;

    public PositionUnpickler(TastyReader reader, TastyUnpickler.NameTable nameAtRef) {
        this.reader = reader;
        this.nameAtRef = nameAtRef;
        this.isDefined = false;
    }

    public void ensureDefined() {
        if (!this.isDefined) {
            int lines = this.reader.readNat();
            this.myLineSizes = new int[lines];
            int i = 0;
            while (i < lines) {
                int[] nArray = this.myLineSizes;
                int n = i++;
                nArray[n] = nArray[n] + this.reader.readNat();
            }
            this.mySpans = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            this.mySourcePaths = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            int curIndex = 0;
            int curStart = 0;
            int curEnd = 0;
            while (!this.reader.isAtEnd()) {
                boolean hasPoint;
                int header = this.reader.readInt();
                if (header == 4) {
                    String path = this.nameAtRef.simple(this.reader.readNameRef()).toString();
                    this.mySourcePaths.update((Object)new TastyBuffer.Addr(TastyBuffer$Addr$.MODULE$.apply(curIndex)), (Object)path);
                    continue;
                }
                int addrDelta = header >> 3;
                boolean hasStart = (header & 4) != 0;
                boolean hasEnd = (header & 2) != 0;
                boolean bl = hasPoint = (header & 1) != 0;
                if ((curIndex += addrDelta) < 0) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                if (hasStart) {
                    curStart += this.reader.readInt();
                }
                if (hasEnd) {
                    curEnd += this.reader.readInt();
                }
                this.mySpans.update((Object)new TastyBuffer.Addr(TastyBuffer$Addr$.MODULE$.apply(curIndex)), (Object)(hasPoint ? new Spans.Span(Spans$.MODULE$.Span(curStart, curEnd, curStart + this.reader.readInt())) : new Spans.Span(Spans$.MODULE$.Span(curStart, curEnd))));
            }
            this.isDefined = true;
            return;
        }
    }

    private HashMap<TastyBuffer.Addr, Spans.Span> spans() {
        this.ensureDefined();
        return this.mySpans;
    }

    private HashMap<TastyBuffer.Addr, String> sourcePaths() {
        this.ensureDefined();
        return this.mySourcePaths;
    }

    private int[] lineSizes() {
        this.ensureDefined();
        return this.myLineSizes;
    }

    public long spanAt(int addr) {
        Object object = this.spans().getOrElse((Object)new TastyBuffer.Addr(addr), (Function0 & Serializable)() -> new Spans.Span(PositionUnpickler.spanAt$$anonfun$1()));
        if (object == null) {
            return BoxesRunTime.unboxToLong(null);
        }
        return ((Spans.Span)object).tastyquery$Spans$Span$$coords();
    }

    public String sourcePathAt(int addr) {
        return (String)this.sourcePaths().getOrElse((Object)new TastyBuffer.Addr(addr), PositionUnpickler::sourcePathAt$$anonfun$1);
    }

    private static final long spanAt$$anonfun$1() {
        return Spans$.MODULE$.NoSpan();
    }

    private static final String sourcePathAt$$anonfun$1() {
        return "";
    }
}

