/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.tasties;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.IArray;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import tastyquery.Exceptions;
import tastyquery.Names;
import tastyquery.Names$;
import tastyquery.Names$BodyRetainerName$;
import tastyquery.Names$ExpandPrefixName$;
import tastyquery.Names$ExpandedName$;
import tastyquery.Names$InlineAccessorName$;
import tastyquery.Names$PackageFullName$;
import tastyquery.Names$SignatureName$;
import tastyquery.Names$SuperAccessorName$;
import tastyquery.Names$nme$;
import tastyquery.Signatures;
import tastyquery.Signatures$ParamSig$Term$;
import tastyquery.Signatures$ParamSig$TypeLen$;
import tastyquery.Signatures$Signature$;
import tastyquery.reader.ReaderContext;
import tastyquery.reader.UTF8Utils$;
import tastyquery.reader.tasties.PositionUnpickler;
import tastyquery.reader.tasties.TastyHeaderUnpickler;
import tastyquery.reader.tasties.TastyReader;
import tastyquery.reader.tasties.TastyReader$Addr$;
import tastyquery.reader.tasties.TreeUnpickler;

public class TastyUnpickler {
    private final TastyReader reader;
    private final HashMap<String, TastyReader> sectionReader;
    private final NameTable nameAtRef;

    public TastyUnpickler(TastyReader reader) {
        this.reader = reader;
        this.sectionReader = new HashMap();
        this.nameAtRef = new NameTable();
        new TastyHeaderUnpickler(reader).readHeader();
        reader.until(reader.readEnd(), (Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        while (!reader.isAtEnd()) {
            String secName = this.readString();
            int secEnd = reader.readEnd();
            this.sectionReader.update((Object)secName, (Object)new TastyReader(this.bytes(), reader.currentAddr(), secEnd, reader.currentAddr()));
            reader.goto(secEnd);
        }
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    public TastyUnpickler(byte[] bytes) {
        this(new TastyReader(IArray.package.IArray$.MODULE$.wrapByteIArray(bytes).unsafeArray()));
    }

    public NameTable nameAtRef() {
        return this.nameAtRef;
    }

    private Names.TermName readName() {
        return this.nameAtRef().simple(this.reader.readNameRef());
    }

    private Names.UnsignedTermName readUnsignedName() {
        Names.TermName termName = this.readName();
        if (termName instanceof Names.UnsignedTermName) {
            Names.UnsignedTermName name = (Names.UnsignedTermName)termName;
            return name;
        }
        if (termName instanceof Names.SignedName) {
            Names.SignedName name = (Names.SignedName)termName;
            throw new Exceptions.TastyFormatException(new StringBuilder(39).append("Expected an unsigned name item but got ").append(name.toDebugString()).toString());
        }
        throw new MatchError((Object)termName);
    }

    private Names.SimpleName readSimpleName() {
        Names.TermName termName = this.readName();
        if (termName instanceof Names.SimpleName) {
            Names.SimpleName name = (Names.SimpleName)termName;
            return name;
        }
        Names.TermName name = termName;
        throw new Exceptions.TastyFormatException(new StringBuilder(31).append("Expected a simple name but got ").append(name.toDebugString()).toString());
    }

    private Names.SignatureNameItem readSignatureNameItem() {
        Names.TermName termName = this.readName();
        if (termName instanceof Names.SignatureNameItem) {
            Names.SignatureNameItem name = (Names.SignatureNameItem)((Object)termName);
            return name;
        }
        Names.TermName name = termName;
        throw new Exceptions.TastyFormatException(new StringBuilder(39).append("Expected a signature name item but got ").append(name.toDebugString()).toString());
    }

    private Names.PackageFullName readPackageFullName() {
        return this.nameAtRef().packageFullName(this.reader.readNameRef());
    }

    private Names.SignatureName readSignatureName() {
        return this.nameAtRef().signatureName(this.reader.readNameRef());
    }

    private Object readEitherName() {
        return this.nameAtRef().apply(this.reader.readNameRef());
    }

    private String readString() {
        return this.readName().toString();
    }

    private Signatures.ParamSig readParamSig() {
        int ref = this.reader.readInt();
        if (ref < 0) {
            return Signatures$ParamSig$TypeLen$.MODULE$.apply(RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(ref)));
        }
        return Signatures$ParamSig$Term$.MODULE$.apply(this.nameAtRef().signatureName(ref));
    }

    private Object readNameContents() {
        Product product;
        int tag = this.reader.readByte();
        int length = this.reader.readNat();
        int start = this.reader.currentAddr();
        int end = TastyReader$Addr$.MODULE$.$plus$extension(start, length);
        int n = tag;
        switch (n) {
            case 1: {
                this.reader.goto(end);
                product = Names$.MODULE$.termName(UTF8Utils$.MODULE$.decode(this.bytes(), start, length));
                break;
            }
            case 2: {
                Names.SignatureName qual = this.readSignatureName();
                Names.SignatureNameItem item = this.readSignatureNameItem();
                product = qual.appendItem(item);
                break;
            }
            case 3: {
                product = Names$ExpandedName$.MODULE$.apply(this.readUnsignedName(), this.readSimpleName());
                break;
            }
            case 4: {
                product = Names$ExpandPrefixName$.MODULE$.apply(this.readUnsignedName(), this.readSimpleName());
                break;
            }
            case 10: {
                String separator = this.readName().toString();
                int num = this.reader.readNat();
                List originals = this.reader.until(end, this::$anonfun$1);
                Names.UnsignedTermName original = originals.isEmpty() ? Names$nme$.MODULE$.EmptyTermName() : (Names.UnsignedTermName)originals.head();
                product = new Names.UniqueName(original, separator, num);
                break;
            }
            case 11: {
                product = new Names.DefaultGetterName(this.readUnsignedName(), this.reader.readNat());
                break;
            }
            case 62: 
            case 63: {
                Names.UnsignedTermName original = this.readUnsignedName();
                Names.UnsignedTermName target = tag == 62 ? this.readUnsignedName() : original;
                Names.SignatureName result = this.readSignatureName();
                List paramsSig = this.reader.until(end, this::$anonfun$2);
                Signatures.Signature sig = Signatures$Signature$.MODULE$.apply(paramsSig, result);
                product = new Names.SignedName(original, sig, target);
                break;
            }
            case 20: {
                product = Names$SuperAccessorName$.MODULE$.apply(this.readUnsignedName());
                break;
            }
            case 21: {
                product = Names$InlineAccessorName$.MODULE$.apply(this.readUnsignedName());
                break;
            }
            case 22: {
                product = Names$BodyRetainerName$.MODULE$.apply(this.readUnsignedName());
                break;
            }
            case 23: {
                Object object = this.readEitherName();
                if (object instanceof Names.SimpleName) {
                    Names.SimpleName simple = (Names.SimpleName)object;
                    product = simple.withObjectSuffix();
                    break;
                }
                if (object instanceof Names.SignatureName) {
                    Names.SignatureName signatureName = Names$SignatureName$.MODULE$.unapply((Names.SignatureName)object);
                    List<Names.SignatureNameItem> list = signatureName._1();
                    List<Names.SignatureNameItem> items = list;
                    Names.SignatureNameItem signatureNameItem = (Names.SignatureNameItem)items.last();
                    if (signatureNameItem instanceof Names.SimpleName) {
                        Names.SimpleName last = (Names.SimpleName)signatureNameItem;
                        product = Names$SignatureName$.MODULE$.apply((List<Names.SignatureNameItem>)((List)((SeqOps)items.init()).$colon$plus((Object)last.withObjectSuffix())));
                        break;
                    }
                    Names.SignatureNameItem last = signatureNameItem;
                    throw new Exceptions.TastyFormatException(new StringBuilder(23).append("Invalid OBJECTCLASS of ").append(((Names.Name)((Object)last)).toDebugString()).toString());
                }
                if (object instanceof Names.TermName) {
                    Names.TermName other = (Names.TermName)object;
                    throw new Exceptions.TastyFormatException(new StringBuilder(23).append("Invalid OBJECTCLASS of ").append(other.toDebugString()).toString());
                }
                throw new MatchError(object);
            }
            default: {
                throw new Exceptions.TastyFormatException(new StringBuilder(16).append("unexpected tag: ").append(tag).toString());
            }
        }
        Names.UnsignedTermName result = product;
        if (!TastyReader$Addr$.MODULE$.$eq$eq$extension(this.reader.currentAddr(), end)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(12).append("bad name ").append(result).append(" ").append(new TastyReader.Addr(start)).append(" ").append(new TastyReader.Addr(this.reader.currentAddr())).append(" ").append(new TastyReader.Addr(end)).toString());
        }
        return result;
    }

    public <R> Option<R> unpickle(String filename, SectionUnpickler<R> sec, ReaderContext x$3) {
        return this.sectionReader.get((Object)sec.name()).map((Function1 & Serializable)reader -> sec.unpickle(filename, (TastyReader)reader, this.nameAtRef(), x$3));
    }

    public byte[] bytes() {
        return this.reader.bytes();
    }

    private final void $init$$$anonfun$1() {
        this.nameAtRef().add(this.readNameContents());
    }

    private final Names.UnsignedTermName $anonfun$1() {
        return this.readUnsignedName();
    }

    private final Signatures.ParamSig $anonfun$2() {
        return this.readParamSig();
    }

    public static final class NameTable {
        private final ArrayBuffer<Object> names = new ArrayBuffer();

        public void add(Object name) {
            this.names.$plus$eq(name);
        }

        public Object apply(int ref) {
            return this.names.apply(ref);
        }

        public Names.TermName simple(int ref) {
            Object object = this.apply(ref);
            if (object instanceof Names.TermName) {
                Names.TermName name = (Names.TermName)object;
                return name;
            }
            if (object instanceof Names.SignatureName) {
                Names.SignatureName name = (Names.SignatureName)object;
                throw new Exceptions.TastyFormatException(new StringBuilder(26).append("Expected TermName but got ").append(name.toDebugString()).toString());
            }
            throw new MatchError(object);
        }

        public Names.PackageFullName packageFullName(int ref) {
            Object object = this.apply(ref);
            if (object instanceof Names.SignatureName) {
                Names.SignatureName name = (Names.SignatureName)object;
                List<Names.SignatureNameItem> list = name.items();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    Names.SimpleName simpleName = Names$nme$.MODULE$.UserLandRootPackageName();
                    Object object2 = colon2.head();
                    if (!(simpleName != null ? !((Object)simpleName).equals(object2) : object2 != null)) {
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list3 = list2;
                        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                            return Names$PackageFullName$.MODULE$.rootPackageName();
                        }
                    }
                }
                List<Names.SignatureNameItem> items = list;
                List path = items.map((Function1 & Serializable)x$1 -> {
                    Names.SignatureNameItem signatureNameItem = x$1;
                    if (signatureNameItem instanceof Names.SimpleName) {
                        Names.SimpleName simpleName = (Names.SimpleName)signatureNameItem;
                        return simpleName;
                    }
                    if (signatureNameItem instanceof Names.ObjectClassName) {
                        throw this.invalid$1(name.toDebugString());
                    }
                    throw new MatchError((Object)signatureNameItem);
                });
                return Names$PackageFullName$.MODULE$.apply((List<Names.SimpleName>)path);
            }
            Names.SimpleName simpleName = Names$nme$.MODULE$.UserLandRootPackageName();
            Object object3 = object;
            if (!(simpleName != null ? !((Object)simpleName).equals(object3) : object3 != null)) {
                return Names$PackageFullName$.MODULE$.rootPackageName();
            }
            if (object instanceof Names.SimpleName) {
                Names.SimpleName name = (Names.SimpleName)object;
                return Names$PackageFullName$.MODULE$.apply((List<Names.SimpleName>)package$.MODULE$.Nil().$colon$colon((Object)name));
            }
            if (object instanceof Names.TermName) {
                Names.TermName name = (Names.TermName)object;
                throw this.invalid$1(name.toDebugString());
            }
            throw new MatchError(object);
        }

        public Names.SignatureName signatureName(int ref) {
            Object object = this.apply(ref);
            if (object instanceof Names.SignatureName) {
                Names.SignatureName name = (Names.SignatureName)object;
                return name;
            }
            if (object instanceof Names.SignatureNameItem) {
                Names.SignatureNameItem name = (Names.SignatureNameItem)object;
                return Names$SignatureName$.MODULE$.apply((List<Names.SignatureNameItem>)package$.MODULE$.Nil().$colon$colon((Object)name));
            }
            if (object instanceof Names.TermName) {
                Names.TermName name = (Names.TermName)object;
                throw new Exceptions.TastyFormatException(new StringBuilder(34).append("Expected a signature name but got ").append(name.toDebugString()).toString());
            }
            throw new MatchError(object);
        }

        private final Nothing$ invalid$1(String actualDebugString) {
            throw new Exceptions.TastyFormatException(new StringBuilder(37).append("Excepted a package full name but got ").append(actualDebugString).toString());
        }
    }

    public static class PositionSectionUnpickler
    extends SectionUnpickler<PositionUnpickler> {
        public PositionSectionUnpickler() {
            super("Positions");
        }

        @Override
        public PositionUnpickler unpickle(String filename, TastyReader reader, NameTable nameAtRef, ReaderContext x$4) {
            return new PositionUnpickler(reader, nameAtRef, x$4);
        }
    }

    public static abstract class SectionUnpickler<R> {
        private final String name;

        public SectionUnpickler(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract R unpickle(String var1, TastyReader var2, NameTable var3, ReaderContext var4);
    }

    public static class TreeSectionUnpickler
    extends SectionUnpickler<TreeUnpickler> {
        private final Option<PositionUnpickler> posUnpickler;

        public TreeSectionUnpickler(Option<PositionUnpickler> posUnpickler) {
            this.posUnpickler = posUnpickler;
            super("ASTs");
        }

        @Override
        public TreeUnpickler unpickle(String filename, TastyReader reader, NameTable nameAtRef, ReaderContext x$4) {
            return new TreeUnpickler(filename, reader, nameAtRef, this.posUnpickler, x$4);
        }
    }
}

