/*
 * Decompiled with CFR 0.152.
 */
package tastyquery;

import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import tastyquery.Annotations;
import tastyquery.Constants;
import tastyquery.Modifiers;
import tastyquery.Modifiers$TermSymbolKind$;
import tastyquery.Modifiers$Variance$;
import tastyquery.Names;
import tastyquery.Names$SignedName$;
import tastyquery.Names$nme$;
import tastyquery.Printers$;
import tastyquery.Signatures;
import tastyquery.Symbols;
import tastyquery.Trees;
import tastyquery.Trees$Alternative$;
import tastyquery.Trees$AnnotatedTypeTree$;
import tastyquery.Trees$AppliedTypeTree$;
import tastyquery.Trees$Apply$;
import tastyquery.Trees$Assign$;
import tastyquery.Trees$Bind$;
import tastyquery.Trees$Block$;
import tastyquery.Trees$ByNameTypeTree$;
import tastyquery.Trees$ClassDef$;
import tastyquery.Trees$DefDef$;
import tastyquery.Trees$ExplicitTypeBoundsTree$;
import tastyquery.Trees$Export$;
import tastyquery.Trees$ExprPattern$;
import tastyquery.Trees$Ident$;
import tastyquery.Trees$If$;
import tastyquery.Trees$Import$;
import tastyquery.Trees$InferredTypeBoundsTree$;
import tastyquery.Trees$InlineIf$;
import tastyquery.Trees$InlineMatch$;
import tastyquery.Trees$Inlined$;
import tastyquery.Trees$Lambda$;
import tastyquery.Trees$Literal$;
import tastyquery.Trees$Match$;
import tastyquery.Trees$MatchTypeTree$;
import tastyquery.Trees$NamedArg$;
import tastyquery.Trees$NamedTypeBoundsTree$;
import tastyquery.Trees$New$;
import tastyquery.Trees$OpaqueTypeAliasDefinitionTree$;
import tastyquery.Trees$PackageDef$;
import tastyquery.Trees$PolyTypeDefinitionTree$;
import tastyquery.Trees$RefinedTypeTree$;
import tastyquery.Trees$Return$;
import tastyquery.Trees$Select$;
import tastyquery.Trees$SelectOuter$;
import tastyquery.Trees$SelectTypeTree$;
import tastyquery.Trees$SeqLiteral$;
import tastyquery.Trees$SingletonTypeTree$;
import tastyquery.Trees$Super$;
import tastyquery.Trees$Template$;
import tastyquery.Trees$TermRefTypeTree$;
import tastyquery.Trees$This$;
import tastyquery.Trees$Throw$;
import tastyquery.Trees$Try$;
import tastyquery.Trees$TypeAliasDefinitionTree$;
import tastyquery.Trees$TypeApply$;
import tastyquery.Trees$TypeBindingsTree$;
import tastyquery.Trees$TypeIdent$;
import tastyquery.Trees$TypeLambdaTree$;
import tastyquery.Trees$TypeMember$;
import tastyquery.Trees$TypeParam$;
import tastyquery.Trees$TypeTest$;
import tastyquery.Trees$TypeTreeBind$;
import tastyquery.Trees$TypeWrapper$;
import tastyquery.Trees$Typed$;
import tastyquery.Trees$Unapply$;
import tastyquery.Trees$ValDef$;
import tastyquery.Trees$While$;
import tastyquery.Trees$WildcardPattern$;
import tastyquery.Types;
import tastyquery.Types$AbstractTypeBounds$;
import tastyquery.Types$NoPrefix$;
import tastyquery.Types$TypeAlias$;

public final class Printers {
    public static String withWriterToString(Function1<Writer, BoxedUnit> function1) {
        return Printers$.MODULE$.withWriterToString(function1);
    }

    public static class MultilinePrinter
    extends Printer {
        private final Writer out;
        private String spaces;
        private int currentIndent;

        public MultilinePrinter(Writer out) {
            this.out = out;
            super(out);
            this.spaces = "                                        ";
            this.currentIndent = 0;
            int IndentWidth = 2;
        }

        public final void printNewLine() {
            this.print("\n");
            this.out.write(this.spaces, 0, this.currentIndent);
        }

        public final void printNewLineAndIndent() {
            this.currentIndent += 2;
            if (this.spaces.length() < this.currentIndent) {
                this.spaces = new StringBuilder(0).append(this.spaces).append(this.spaces).toString();
            }
            this.printNewLine();
        }

        public final void printNewLineAndOutdent() {
            if (this.currentIndent < 2) {
                throw new IllegalStateException("Trying to outdent more than indent");
            }
            this.currentIndent -= 2;
            this.printNewLine();
        }

        @Override
        public <A> void printBlock(List<A> elems, Function1<A, BoxedUnit> printElem) {
            if (elems.isEmpty()) {
                this.print(" {}");
                return;
            }
            this.print(" {");
            this.printNewLineAndIndent();
            printElem.apply(elems.head());
            ((List)elems.tail()).foreach((Function1 & Serializable)elem -> {
                this.printBlock$$anonfun$2(printElem, elem);
                return BoxedUnit.UNIT;
            });
            this.printNewLineAndOutdent();
            this.print("}");
        }

        private final /* synthetic */ void printBlock$$anonfun$2(Function1 printElem$3, Object elem) {
            this.printNewLine();
            printElem$3.apply(elem);
        }
    }

    public static class Printer {
        private final Writer out;

        public Printer(Writer out) {
            this.out = out;
        }

        public void printPrefix(Types.Prefix prefix) {
            Types.Prefix prefix2 = prefix;
            if (Types$NoPrefix$.MODULE$.equals(prefix2)) {
                return;
            }
            if (prefix2 instanceof Types.PackageRef) {
                Types.PackageRef prefix3 = (Types.PackageRef)prefix2;
                this.print(prefix3);
                this.print(".");
                return;
            }
            if (prefix2 instanceof Types.TermRef) {
                Types.TermRef prefix4 = (Types.TermRef)prefix2;
                this.printPrefix(prefix4.prefix());
                this.print(prefix4.name());
                this.print(".");
                return;
            }
            if (prefix2 instanceof Types.TermParamRef) {
                Types.TermParamRef tpe = (Types.TermParamRef)prefix2;
                this.print(tpe.paramName());
                this.print(".");
                return;
            }
            if (prefix2 instanceof Types.ThisType) {
                Types.ThisType tpe = (Types.ThisType)prefix2;
                this.print(tpe.tref().name());
                this.print(".this.");
                return;
            }
            if (prefix2 instanceof Types.SuperType) {
                Types.SuperType tpe = (Types.SuperType)prefix2;
                this.print(tpe.thistpe().tref().name());
                this.print(".super");
                tpe.explicitSupertpe().foreach((Function1 & Serializable)explicitSupertpe -> {
                    this.printPrefix$$anonfun$1((Types.Type)explicitSupertpe);
                    return BoxedUnit.UNIT;
                });
                this.print(".");
                return;
            }
            if (prefix2 instanceof Types.RecThis) {
                Types.RecThis tpe = (Types.RecThis)prefix2;
                this.print(tpe.binder().debugID());
                this.print(".");
                return;
            }
            if (prefix2 instanceof Types.Type) {
                Types.Type prefix5 = (Types.Type)prefix2;
                this.print(prefix5);
                this.print("#");
                return;
            }
            throw new MatchError((Object)prefix2);
        }

        public void print(Types.TypeMappable tpe) {
            Types.TypeMappable typeMappable = tpe;
            if (Types$NoPrefix$.MODULE$.equals(typeMappable)) {
                this.print("\u03b5");
                return;
            }
            if (typeMappable instanceof Types.PackageRef) {
                Types.PackageRef tpe2 = (Types.PackageRef)typeMappable;
                this.print(tpe2.fullyQualifiedName().toString());
                return;
            }
            if (typeMappable instanceof Types.NothingType) {
                Types.NothingType tpe3 = (Types.NothingType)typeMappable;
                this.print("Nothing");
                return;
            }
            if (typeMappable instanceof Types.AnyKindType) {
                Types.AnyKindType tpe4 = (Types.AnyKindType)typeMappable;
                this.print("AnyKind");
                return;
            }
            if (typeMappable instanceof Types.TermRef || typeMappable instanceof Types.TermParamRef || typeMappable instanceof Types.ThisType || typeMappable instanceof Types.SuperType || typeMappable instanceof Types.RecThis) {
                Types.SingletonType tpe5 = (Types.SingletonType)((Object)typeMappable);
                this.printPrefix((Types.Prefix)((Object)tpe5));
                this.print("type");
                return;
            }
            if (typeMappable instanceof Types.TypeRef) {
                Types.TypeRef tpe6 = (Types.TypeRef)typeMappable;
                this.printPrefix(tpe6.prefix());
                this.print(tpe6.name());
                return;
            }
            if (typeMappable instanceof Types.ConstantType) {
                Types.ConstantType tpe7 = (Types.ConstantType)typeMappable;
                this.print(tpe7.value());
                return;
            }
            if (typeMappable instanceof Types.AppliedType) {
                Types.AppliedType tpe8 = (Types.AppliedType)typeMappable;
                this.print(tpe8.tycon());
                this.print("[");
                this.printCommaSeparatedList(tpe8.args(), (Function1 & Serializable)_$1 -> {
                    this.print$$anonfun$1((Types.TypeOrWildcard)_$1);
                    return BoxedUnit.UNIT;
                });
                this.print("]");
                return;
            }
            if (typeMappable instanceof Types.ByNameType) {
                Types.ByNameType tpe9 = (Types.ByNameType)typeMappable;
                this.print("=> ");
                this.print(tpe9.resultType());
                return;
            }
            if (typeMappable instanceof Types.RepeatedType) {
                Types.RepeatedType tpe10 = (Types.RepeatedType)typeMappable;
                this.print(tpe10.elemType());
                this.print("*");
                return;
            }
            if (typeMappable instanceof Types.TypeLambda) {
                Types.TypeLambda tpe11 = (Types.TypeLambda)typeMappable;
                this.print("([");
                this.printCommaSeparatedList(tpe11.typeLambdaParams(), (Function1 & Serializable)_$2 -> {
                    this.print$$anonfun$2((Types.TypeLambdaParam)_$2);
                    return BoxedUnit.UNIT;
                });
                this.print("] =>> ");
                this.print(tpe11.resultType());
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.TypeParamRef) {
                Types.TypeParamRef tpe12 = (Types.TypeParamRef)typeMappable;
                this.print(tpe12.paramName());
                return;
            }
            if (typeMappable instanceof Types.AnnotatedType) {
                Types.AnnotatedType tpe13 = (Types.AnnotatedType)typeMappable;
                this.print("(");
                this.print(tpe13.annotation());
                this.print(" ");
                this.print(tpe13.typ());
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.TypeRefinement) {
                Types.TypeRefinement tpe14 = (Types.TypeRefinement)typeMappable;
                this.print("(");
                this.print(tpe14.parent());
                this.print(" { type ");
                this.print(tpe14.refinedName());
                this.print(tpe14.refinedBounds());
                this.print(" })");
                return;
            }
            if (typeMappable instanceof Types.TermRefinement) {
                Types.TermRefinement tpe15 = (Types.TermRefinement)typeMappable;
                this.print("(");
                this.print(tpe15.parent());
                if (tpe15.isStable()) {
                    this.print(" { val ");
                } else {
                    this.print(" { def ");
                }
                this.print(tpe15.refinedName());
                if (tpe15.refinedType() instanceof Types.Type) {
                    this.print(": ");
                }
                this.print(tpe15.refinedType());
                this.print(" })");
                return;
            }
            if (typeMappable instanceof Types.RecType) {
                Types.RecType tpe16 = (Types.RecType)typeMappable;
                this.print("{ ");
                this.print(tpe16.debugID());
                this.print(" => ");
                this.print(tpe16.parent());
                this.print(" }");
                return;
            }
            if (typeMappable instanceof Types.MatchType) {
                Types.MatchType tpe17 = (Types.MatchType)typeMappable;
                this.print("(");
                this.print(tpe17.scrutinee());
                this.print(" match");
                if (!Printers$.MODULE$.tastyquery$Printers$$$isSyntacticAny(tpe17.bound())) {
                    this.print(" <: ");
                    this.print(tpe17.bound());
                }
                this.printBlock(tpe17.cases(), (Function1 & Serializable)caze -> {
                    this.print$$anonfun$3((Types.MatchTypeCase)caze);
                    return BoxedUnit.UNIT;
                });
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.SkolemType) {
                Types.SkolemType tpe18 = (Types.SkolemType)typeMappable;
                this.print("(\u2203");
                this.print(tpe18.debugID());
                this.print(": ");
                this.print(tpe18.tpe());
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.OrType) {
                Types.OrType tpe19 = (Types.OrType)typeMappable;
                this.print("(");
                this.print(tpe19.first());
                this.print(" | ");
                this.print(tpe19.second());
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.AndType) {
                Types.AndType tpe20 = (Types.AndType)typeMappable;
                this.print("(");
                this.print(tpe20.first());
                this.print(" & ");
                this.print(tpe20.second());
                this.print(")");
                return;
            }
            if (typeMappable instanceof Types.CustomTransientGroundType) {
                Types.CustomTransientGroundType tpe21 = (Types.CustomTransientGroundType)typeMappable;
                this.print("<");
                this.print(tpe21.toString());
                this.print(">");
                return;
            }
            if (typeMappable instanceof Types.MethodType) {
                Types.MethodType tpe22 = (Types.MethodType)typeMappable;
                this.print("(");
                if (tpe22.isContextual()) {
                    this.print("using ");
                } else if (tpe22.isImplicit()) {
                    this.print("implicit ");
                }
                this.printCommaSeparatedList((List)tpe22.paramNames().zip(tpe22.paramTypes()), (Function1 & Serializable)x$1 -> {
                    this.print$$anonfun$4((Tuple2)x$1);
                    return BoxedUnit.UNIT;
                });
                this.print(")");
                this.print(tpe22.resultType());
                return;
            }
            if (typeMappable instanceof Types.PolyType) {
                Types.PolyType tpe23 = (Types.PolyType)typeMappable;
                this.print("[");
                this.printCommaSeparatedList((List)tpe23.paramNames().zip(tpe23.paramTypeBounds()), (Function1 & Serializable)x$1 -> {
                    this.print$$anonfun$5((Tuple2)x$1);
                    return BoxedUnit.UNIT;
                });
                this.print("]");
                this.print(tpe23.resultType());
                return;
            }
            if (typeMappable instanceof Types.WildcardTypeArg) {
                Types.WildcardTypeArg tpe24 = (Types.WildcardTypeArg)typeMappable;
                this.print("?");
                this.print(tpe24.bounds());
                return;
            }
            if (typeMappable instanceof Types.TypeAlias) {
                Types.Type type;
                Types.TypeAlias typeAlias = Types$TypeAlias$.MODULE$.unapply((Types.TypeAlias)typeMappable);
                Types.Type alias = type = typeAlias._1();
                this.print(" = ");
                this.print(alias);
                return;
            }
            if (typeMappable instanceof Types.AbstractTypeBounds) {
                Types.AbstractTypeBounds abstractTypeBounds = Types$AbstractTypeBounds$.MODULE$.unapply((Types.AbstractTypeBounds)typeMappable);
                Types.Type type = abstractTypeBounds._1();
                Types.Type type2 = abstractTypeBounds._2();
                Types.Type low = type;
                Types.Type high = type2;
                if (!Printers$.MODULE$.tastyquery$Printers$$$isSyntacticNothing(low)) {
                    this.print(" >: ");
                    this.print(low);
                }
                if (!Printers$.MODULE$.tastyquery$Printers$$$isSyntacticAny(high)) {
                    this.print(" <: ");
                    this.print(high);
                    return;
                }
                return;
            }
            throw new MatchError((Object)typeMappable);
        }

        public final void printAnyTree(Trees.Tree tree) {
            Trees.Tree tree2 = tree;
            if (tree2 instanceof Trees.TopLevelTree) {
                Trees.TopLevelTree tree3 = (Trees.TopLevelTree)tree2;
                this.printTopLevel(tree3);
                return;
            }
            if (tree2 instanceof Trees.TypeTree) {
                Trees.TypeTree tree4 = (Trees.TypeTree)tree2;
                this.print(tree4);
                return;
            }
            if (tree2 instanceof Trees.PatternTree) {
                Trees.PatternTree tree5 = (Trees.PatternTree)tree2;
                this.print(tree5);
                return;
            }
            if (tree2 instanceof Trees.TypeDefinitionTree) {
                Trees.TypeDefinitionTree tree6 = (Trees.TypeDefinitionTree)tree2;
                this.print(tree6);
                return;
            }
            if (tree2 instanceof Trees.Template) {
                Trees.Template tree7 = (Trees.Template)tree2;
                this.print(tree7);
                return;
            }
            if (tree2 instanceof Trees.ImportIdent) {
                Trees.ImportIdent tree8 = (Trees.ImportIdent)tree2;
                this.print(tree8.name());
                return;
            }
            if (tree2 instanceof Trees.ImportSelector) {
                Trees.ImportSelector tree9 = (Trees.ImportSelector)tree2;
                this.print(tree9);
                return;
            }
            if (tree2 instanceof Trees.CaseDef) {
                Trees.CaseDef tree10 = (Trees.CaseDef)tree2;
                this.print(tree10);
                return;
            }
            if (tree2 instanceof Trees.TypeCaseDef) {
                Trees.TypeCaseDef tree11 = (Trees.TypeCaseDef)tree2;
                this.print(tree11);
                return;
            }
            if (tree2 instanceof Trees.WildcardTypeArgTree) {
                Trees.WildcardTypeArgTree tree12 = (Trees.WildcardTypeArgTree)tree2;
                this.print(tree12);
                return;
            }
            if (tree2 instanceof Trees.SelfDef) {
                Trees.SelfDef tree13 = (Trees.SelfDef)tree2;
                this.print(tree13);
                return;
            }
            throw new MatchError((Object)tree2);
        }

        public void printTopLevel(Trees.TopLevelTree tree) {
            Trees.TopLevelTree topLevelTree = tree;
            if (topLevelTree instanceof Trees.PackageDef) {
                Trees.PackageDef packageDef = Trees$PackageDef$.MODULE$.unapply((Trees.PackageDef)topLevelTree);
                Symbols.PackageSymbol packageSymbol = packageDef._1();
                List<Trees.TopLevelTree> list = packageDef._2();
                Symbols.PackageSymbol sym = packageSymbol;
                List<Trees.TopLevelTree> stats = list;
                this.print("package ");
                this.print(sym.displayFullName());
                this.printBlock(stats, (Function1 & Serializable)_$3 -> {
                    this.printTopLevel$$anonfun$1((Trees.TopLevelTree)_$3);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (topLevelTree instanceof Trees.StatementTree) {
                Trees.StatementTree tree2 = (Trees.StatementTree)topLevelTree;
                this.print(tree2);
                return;
            }
            throw new MatchError((Object)topLevelTree);
        }

        public void print(Trees.StatementTree tree) {
            Trees.StatementTree statementTree = tree;
            if (statementTree instanceof Trees.Import) {
                Trees.Import import_ = Trees$Import$.MODULE$.unapply((Trees.Import)statementTree);
                Trees.TermTree termTree = import_._1();
                List<Trees.ImportSelector> list = import_._2();
                Trees.TermTree expr = termTree;
                List<Trees.ImportSelector> selectors = list;
                this.print("import ");
                this.print(expr);
                this.print(".");
                List<Trees.ImportSelector> list2 = selectors;
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list2;
                    List list3 = colon2.next$access$1();
                    Trees.ImportSelector selector = (Trees.ImportSelector)colon2.head();
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list4 = list3;
                    if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                        this.print(selector);
                        return;
                    }
                }
                this.print("{");
                this.printCommaSeparatedList(selectors, (Function1 & Serializable)_$4 -> {
                    this.print$$anonfun$6((Trees.ImportSelector)_$4);
                    return BoxedUnit.UNIT;
                });
                this.print("}");
                return;
            }
            if (statementTree instanceof Trees.Export) {
                Trees.Export export = Trees$Export$.MODULE$.unapply((Trees.Export)statementTree);
                Trees.TermTree termTree = export._1();
                List<Trees.ImportSelector> list = export._2();
                Trees.TermTree expr = termTree;
                List<Trees.ImportSelector> selectors = list;
                this.print("export ");
                this.print(expr);
                this.print(".");
                List<Trees.ImportSelector> list5 = selectors;
                if (list5 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list5;
                    List list6 = colon3.next$access$1();
                    Trees.ImportSelector selector = (Trees.ImportSelector)colon3.head();
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list7 = list6;
                    if (!(nil$ != null ? !nil$.equals(list7) : list7 != null)) {
                        this.print(selector);
                        return;
                    }
                }
                this.print("{");
                this.printCommaSeparatedList(selectors, (Function1 & Serializable)_$5 -> {
                    this.print$$anonfun$7((Trees.ImportSelector)_$5);
                    return BoxedUnit.UNIT;
                });
                this.print("}");
                return;
            }
            if (statementTree instanceof Trees.ClassDef) {
                Trees.ClassDef classDef = Trees$ClassDef$.MODULE$.unapply((Trees.ClassDef)statementTree);
                Names.TypeName typeName = classDef._1();
                Trees.Template template = classDef._2();
                Symbols.ClassSymbol classSymbol = classDef._3();
                Names.TypeName name = typeName;
                Trees.Template rhs = template;
                Symbols.ClassSymbol symbol = classSymbol;
                if (symbol.isTrait()) {
                    this.print("trait ");
                } else if (symbol.isModuleClass()) {
                    this.print("object class ");
                } else {
                    this.print("class ");
                }
                this.print(name);
                this.print(rhs);
                return;
            }
            if (statementTree instanceof Trees.TypeMember) {
                Trees.TypeMember typeMember = Trees$TypeMember$.MODULE$.unapply((Trees.TypeMember)statementTree);
                Names.TypeName typeName = typeMember._1();
                Trees.TypeDefinitionTree typeDefinitionTree = typeMember._2();
                Symbols.TypeMemberSymbol typeMemberSymbol = typeMember._3();
                Names.TypeName name = typeName;
                Trees.TypeDefinitionTree rhs = typeDefinitionTree;
                Symbols.TypeMemberSymbol symbol = typeMemberSymbol;
                this.print("type ");
                this.print(name);
                this.print(rhs);
                return;
            }
            if (statementTree instanceof Trees.TypeParam) {
                Trees.TypeParam typeParam = Trees$TypeParam$.MODULE$.unapply((Trees.TypeParam)statementTree);
                Names.TypeName typeName = typeParam._1();
                Trees.TypeDefinitionTree typeDefinitionTree = typeParam._2();
                Symbols.TypeParamSymbol typeParamSymbol = typeParam._3();
                Names.TypeName name = typeName;
                Trees.TypeDefinitionTree bounds = typeDefinitionTree;
                Symbols.TypeParamSymbol symbol = typeParamSymbol;
                Symbols.TypeParamSymbol typeParamSymbol2 = symbol;
                if (typeParamSymbol2 instanceof Symbols.ClassTypeParamSymbol) {
                    Symbols.ClassTypeParamSymbol symbol2 = (Symbols.ClassTypeParamSymbol)typeParamSymbol2;
                    this.print(symbol2.declaredVariance());
                } else if (typeParamSymbol2 instanceof Symbols.LocalTypeParamSymbol) {
                    Symbols.LocalTypeParamSymbol symbol3 = (Symbols.LocalTypeParamSymbol)typeParamSymbol2;
                } else {
                    throw new MatchError((Object)typeParamSymbol2);
                }
                this.print(name);
                this.print(bounds);
                return;
            }
            if (statementTree instanceof Trees.ValDef) {
                Trees.ValDef valDef = Trees$ValDef$.MODULE$.unapply((Trees.ValDef)statementTree);
                Names.UnsignedTermName unsignedTermName = valDef._1();
                Trees.TypeTree typeTree = valDef._2();
                Option<Trees.TermTree> option = valDef._3();
                Symbols.TermSymbol termSymbol = valDef._4();
                Names.UnsignedTermName name = unsignedTermName;
                Trees.TypeTree tpt = typeTree;
                Option<Trees.TermTree> rhs = option;
                Symbols.TermSymbol symbol = termSymbol;
                Modifiers.TermSymbolKind termSymbolKind = symbol.kind();
                Modifiers.TermSymbolKind termSymbolKind2 = Modifiers$TermSymbolKind$.Module;
                Modifiers.TermSymbolKind termSymbolKind3 = termSymbolKind;
                if (!(termSymbolKind2 != null ? !termSymbolKind2.equals(termSymbolKind3) : termSymbolKind3 != null)) {
                    this.print("object lazy val ");
                } else {
                    Modifiers.TermSymbolKind termSymbolKind4 = Modifiers$TermSymbolKind$.Val;
                    Modifiers.TermSymbolKind termSymbolKind5 = termSymbolKind;
                    if (!(termSymbolKind4 != null ? !termSymbolKind4.equals(termSymbolKind5) : termSymbolKind5 != null)) {
                        this.print("val ");
                    } else {
                        Modifiers.TermSymbolKind termSymbolKind6 = Modifiers$TermSymbolKind$.LazyVal;
                        Modifiers.TermSymbolKind termSymbolKind7 = termSymbolKind;
                        if (!(termSymbolKind6 != null ? !termSymbolKind6.equals(termSymbolKind7) : termSymbolKind7 != null)) {
                            this.print("lazy val ");
                        } else {
                            Modifiers.TermSymbolKind termSymbolKind8 = Modifiers$TermSymbolKind$.Var;
                            Modifiers.TermSymbolKind termSymbolKind9 = termSymbolKind;
                            if (!(termSymbolKind8 != null ? !termSymbolKind8.equals(termSymbolKind9) : termSymbolKind9 != null)) {
                                this.print("var ");
                            } else {
                                Modifiers.TermSymbolKind termSymbolKind10 = Modifiers$TermSymbolKind$.Def;
                                Modifiers.TermSymbolKind termSymbolKind11 = termSymbolKind;
                                if (!(termSymbolKind10 != null ? !termSymbolKind10.equals(termSymbolKind11) : termSymbolKind11 != null)) {
                                    this.print("def ");
                                } else {
                                    throw new MatchError((Object)termSymbolKind);
                                }
                            }
                        }
                    }
                }
                this.print(name);
                this.print(": ");
                this.print(tpt);
                rhs.foreach((Function1 & Serializable)r -> {
                    this.print$$anonfun$8((Trees.TermTree)r);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (statementTree instanceof Trees.DefDef) {
                Trees.DefDef defDef = Trees$DefDef$.MODULE$.unapply((Trees.DefDef)statementTree);
                Names.UnsignedTermName unsignedTermName = defDef._1();
                List<Either<List<Trees.ValDef>, List<Trees.TypeParam>>> list = defDef._2();
                Trees.TypeTree typeTree = defDef._3();
                Option<Trees.TermTree> option = defDef._4();
                Symbols.TermSymbol termSymbol = defDef._5();
                Names.UnsignedTermName name = unsignedTermName;
                List<Either<List<Trees.ValDef>, List<Trees.TypeParam>>> paramLists = list;
                Trees.TypeTree resultTpt = typeTree;
                Option<Trees.TermTree> rhs = option;
                Symbols.TermSymbol symbol = termSymbol;
                this.print("def ");
                this.print(name);
                paramLists.foreach((Function1 & Serializable)paramList -> {
                    this.print$$anonfun$9((Either)paramList);
                    return BoxedUnit.UNIT;
                });
                this.print(": ");
                this.print(resultTpt);
                rhs.foreach((Function1 & Serializable)body -> {
                    this.print$$anonfun$10((Trees.TermTree)body);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (statementTree instanceof Trees.Ident) {
                Names.UnsignedTermName unsignedTermName;
                Trees.Ident ident = Trees$Ident$.MODULE$.unapply((Trees.Ident)statementTree);
                Names.UnsignedTermName name = unsignedTermName = ident._1();
                this.print(name);
                return;
            }
            if (statementTree instanceof Trees.Select) {
                Trees.Select select = Trees$Select$.MODULE$.unapply((Trees.Select)statementTree);
                Trees.TermTree termTree = select._1();
                Names.TermName termName = select._2();
                Trees.TermTree qualifier = termTree;
                Names.TermName name = termName;
                this.print(qualifier);
                this.print(".");
                this.print(name);
                return;
            }
            if (statementTree instanceof Trees.SelectOuter) {
                Trees.SelectOuter selectOuter = Trees$SelectOuter$.MODULE$.unapply((Trees.SelectOuter)statementTree);
                Trees.TermTree termTree = selectOuter._1();
                int n = selectOuter._2();
                Trees.TermTree qualifier = termTree;
                int levels = n;
                this.print(qualifier);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), levels).foreach((Function1 & Serializable)v1 -> {
                    this.print$$anonfun$11(BoxesRunTime.unboxToInt((Object)v1));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (statementTree instanceof Trees.This) {
                Trees.TypeIdent typeIdent;
                Trees.This this_ = Trees$This$.MODULE$.unapply((Trees.This)statementTree);
                Trees.TypeIdent qualifier = typeIdent = this_._1();
                this.print(qualifier);
                this.print(".this");
                return;
            }
            if (statementTree instanceof Trees.Super) {
                Trees.Super super_ = Trees$Super$.MODULE$.unapply((Trees.Super)statementTree);
                Trees.TermTree termTree = super_._1();
                Option<Trees.TypeIdent> option = super_._2();
                Trees.TermTree qual = termTree;
                Option<Trees.TypeIdent> optMix = option;
                this.print(qual);
                this.print(".super");
                optMix.foreach((Function1 & Serializable)mix -> {
                    this.print$$anonfun$12((Trees.TypeIdent)mix);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (statementTree instanceof Trees.Apply) {
                Trees.Apply tree2 = (Trees.Apply)statementTree;
                this.printApplication(tree2, false);
                return;
            }
            if (statementTree instanceof Trees.TypeApply) {
                Trees.TypeApply tree3 = (Trees.TypeApply)statementTree;
                this.printApplication(tree3, false);
                return;
            }
            if (statementTree instanceof Trees.New) {
                Trees.TypeTree typeTree;
                Trees.New new_ = Trees$New$.MODULE$.unapply((Trees.New)statementTree);
                Trees.TypeTree tpt = typeTree = new_._1();
                this.print("new ");
                this.print(tpt);
                return;
            }
            if (statementTree instanceof Trees.Typed) {
                Trees.Typed typed = Trees$Typed$.MODULE$.unapply((Trees.Typed)statementTree);
                Trees.TermTree termTree = typed._1();
                Trees.TypeTree typeTree = typed._2();
                Trees.TermTree expr = termTree;
                Trees.TypeTree tpt = typeTree;
                this.print("(");
                this.print(expr);
                this.print(": ");
                this.print(tpt);
                this.print(")");
                return;
            }
            if (statementTree instanceof Trees.Assign) {
                Trees.Assign assign = Trees$Assign$.MODULE$.unapply((Trees.Assign)statementTree);
                Trees.TermTree termTree = assign._1();
                Trees.TermTree termTree2 = assign._2();
                Trees.TermTree lhs = termTree;
                Trees.TermTree rhs = termTree2;
                this.print(lhs);
                this.print(" = ");
                this.print(rhs);
                return;
            }
            if (statementTree instanceof Trees.NamedArg) {
                Trees.NamedArg namedArg = Trees$NamedArg$.MODULE$.unapply((Trees.NamedArg)statementTree);
                Names.UnsignedTermName unsignedTermName = namedArg._1();
                Trees.TermTree termTree = namedArg._2();
                Names.UnsignedTermName name = unsignedTermName;
                Trees.TermTree arg = termTree;
                this.print(name);
                this.print(" = ");
                this.print(arg);
                return;
            }
            if (statementTree instanceof Trees.Block) {
                Trees.Block block = Trees$Block$.MODULE$.unapply((Trees.Block)statementTree);
                List<Trees.StatementTree> list = block._1();
                Trees.TermTree termTree = block._2();
                List<Trees.StatementTree> stats = list;
                Trees.TermTree expr = termTree;
                this.printBlock(stats, expr, (Function1 & Serializable)_$6 -> {
                    this.print$$anonfun$13((Trees.StatementTree)_$6);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (statementTree instanceof Trees.If) {
                Trees.If if_ = Trees$If$.MODULE$.unapply((Trees.If)statementTree);
                Trees.TermTree termTree = if_._1();
                Trees.TermTree termTree3 = if_._2();
                Trees.TermTree termTree4 = if_._3();
                Trees.TermTree cond = termTree;
                Trees.TermTree thenPart = termTree3;
                Trees.TermTree elsePart = termTree4;
                this.print("if ");
                this.print(cond);
                this.print(" then ");
                this.print(thenPart);
                this.print(" else ");
                this.print(elsePart);
                return;
            }
            if (statementTree instanceof Trees.InlineIf) {
                Trees.InlineIf inlineIf = Trees$InlineIf$.MODULE$.unapply((Trees.InlineIf)statementTree);
                Trees.TermTree termTree = inlineIf._1();
                Trees.TermTree termTree5 = inlineIf._2();
                Trees.TermTree termTree6 = inlineIf._3();
                Trees.TermTree cond = termTree;
                Trees.TermTree thenPart = termTree5;
                Trees.TermTree elsePart = termTree6;
                this.print("inline ");
                this.print(Trees$If$.MODULE$.apply(cond, thenPart, elsePart, tree.pos()));
                return;
            }
            if (statementTree instanceof Trees.Lambda) {
                Trees.Lambda lambda = Trees$Lambda$.MODULE$.unapply((Trees.Lambda)statementTree);
                Trees.TermReferenceTree termReferenceTree = lambda._1();
                Option<Trees.TypeTree> option = lambda._2();
                Trees.TermReferenceTree meth = termReferenceTree;
                Option<Trees.TypeTree> tpt = option;
                this.print("(");
                this.print(meth);
                this.print(": ");
                Option<Trees.TypeTree> option2 = tpt;
                if (option2 instanceof Some) {
                    Trees.TypeTree tpt2 = (Trees.TypeTree)((Some)option2).value();
                    this.print(tpt2);
                } else if (None$.MODULE$.equals(option2)) {
                    this.print("<function>");
                } else {
                    throw new MatchError(option2);
                }
                this.print(")");
                return;
            }
            if (statementTree instanceof Trees.Match) {
                Trees.Match match = Trees$Match$.MODULE$.unapply((Trees.Match)statementTree);
                Trees.TermTree termTree = match._1();
                List<Trees.CaseDef> list = match._2();
                Trees.TermTree selector = termTree;
                List<Trees.CaseDef> cases = list;
                this.print("(");
                this.print(selector);
                this.print(" match");
                this.printBlock(cases, (Function1 & Serializable)_$7 -> {
                    this.print$$anonfun$14((Trees.CaseDef)_$7);
                    return BoxedUnit.UNIT;
                });
                this.print(")");
                return;
            }
            if (statementTree instanceof Trees.InlineMatch) {
                Trees.InlineMatch inlineMatch = Trees$InlineMatch$.MODULE$.unapply((Trees.InlineMatch)statementTree);
                Option<Trees.TermTree> option = inlineMatch._1();
                List<Trees.CaseDef> list = inlineMatch._2();
                Option<Trees.TermTree> selector = option;
                List<Trees.CaseDef> cases = list;
                this.print("inline ");
                this.print(Trees$InlineMatch$.MODULE$.apply(selector, cases, tree.pos()));
                return;
            }
            if (statementTree instanceof Trees.SeqLiteral) {
                Trees.SeqLiteral seqLiteral = Trees$SeqLiteral$.MODULE$.unapply((Trees.SeqLiteral)statementTree);
                List<Trees.TermTree> list = seqLiteral._1();
                Trees.TypeTree typeTree = seqLiteral._2();
                List<Trees.TermTree> elems = list;
                Trees.TypeTree elemtpt = typeTree;
                this.print("[");
                this.printCommaSeparatedList(elems, (Function1 & Serializable)_$8 -> {
                    this.print$$anonfun$15((Trees.TermTree)_$8);
                    return BoxedUnit.UNIT;
                });
                this.print(": ");
                this.print(elemtpt);
                this.print("]");
                return;
            }
            if (statementTree instanceof Trees.While) {
                Trees.While while_ = Trees$While$.MODULE$.unapply((Trees.While)statementTree);
                Trees.TermTree termTree = while_._1();
                Trees.TermTree termTree7 = while_._2();
                Trees.TermTree cond = termTree;
                Trees.TermTree body2 = termTree7;
                this.print("while ");
                this.print(cond);
                this.print(" do ");
                this.print(body2);
                return;
            }
            if (statementTree instanceof Trees.Throw) {
                Trees.TermTree termTree;
                Trees.Throw throw_ = Trees$Throw$.MODULE$.unapply((Trees.Throw)statementTree);
                Trees.TermTree expr = termTree = throw_._1();
                this.print("throw ");
                this.print(expr);
                return;
            }
            if (statementTree instanceof Trees.Try) {
                Trees.Try try_ = Trees$Try$.MODULE$.unapply((Trees.Try)statementTree);
                Trees.TermTree termTree = try_._1();
                List<Trees.CaseDef> list = try_._2();
                Option<Trees.TermTree> option = try_._3();
                Trees.TermTree expr = termTree;
                List<Trees.CaseDef> cases = list;
                Option<Trees.TermTree> finalizer = option;
                this.print("try ");
                this.print(expr);
                if (cases.nonEmpty()) {
                    this.print(" catch");
                    this.printBlock(cases, (Function1 & Serializable)_$9 -> {
                        this.print$$anonfun$16((Trees.CaseDef)_$9);
                        return BoxedUnit.UNIT;
                    });
                }
                finalizer.foreach((Function1 & Serializable)fin -> {
                    this.print$$anonfun$17((Trees.TermTree)fin);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (statementTree instanceof Trees.Literal) {
                Constants.Constant constant;
                Trees.Literal literal = Trees$Literal$.MODULE$.unapply((Trees.Literal)statementTree);
                Constants.Constant constant2 = constant = literal._1();
                this.print(constant2);
                return;
            }
            if (statementTree instanceof Trees.Return) {
                Trees.Return return_ = Trees$Return$.MODULE$.unapply((Trees.Return)statementTree);
                Option<Trees.TermTree> option = return_._1();
                Symbols.TermSymbol termSymbol = return_._2();
                Option<Trees.TermTree> expr = option;
                Symbols.TermSymbol from = termSymbol;
                Option<Trees.TermTree> option3 = expr;
                if (option3 instanceof Some) {
                    Trees.TermTree expr2 = (Trees.TermTree)((Some)option3).value();
                    this.print("return ");
                    this.print(expr2);
                    return;
                }
                if (None$.MODULE$.equals(option3)) {
                    this.print("return");
                    return;
                }
                throw new MatchError(option3);
            }
            if (statementTree instanceof Trees.Inlined) {
                Trees.Inlined inlined = Trees$Inlined$.MODULE$.unapply((Trees.Inlined)statementTree);
                Trees.TermTree termTree = inlined._1();
                Option<Serializable> option = inlined._2();
                List<Trees.ValOrDefDef> list = inlined._3();
                Trees.TermTree expr = termTree;
                Option<Serializable> caller = option;
                List<Trees.ValOrDefDef> bindings = list;
                caller.foreach((Function1 & Serializable)c -> {
                    this.print$$anonfun$18((Serializable)c);
                    return BoxedUnit.UNIT;
                });
                this.printBlock(bindings, expr, (Function1 & Serializable)_$10 -> {
                    this.print$$anonfun$19((Trees.StatementTree)_$10);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError((Object)statementTree);
        }

        public void print(Trees.CaseDef caze) {
            this.print("case ");
            this.print(caze.pattern());
            caze.guard().foreach((Function1 & Serializable)guard -> {
                this.print$$anonfun$20((Trees.TermTree)guard);
                return BoxedUnit.UNIT;
            });
            this.print(" => ");
            this.print(caze.body());
        }

        public void printApplication(Trees.TermTree tree, boolean hideNew) {
            Trees.TermTree termTree = tree;
            if (termTree instanceof Trees.Apply) {
                Trees.Apply apply = Trees$Apply$.MODULE$.unapply((Trees.Apply)termTree);
                Trees.TermTree termTree2 = apply._1();
                List<Trees.TermTree> list = apply._2();
                Trees.TermTree fun = termTree2;
                List<Trees.TermTree> args = list;
                this.printApplication(fun, hideNew);
                this.print("(");
                this.printCommaSeparatedList(args, (Function1 & Serializable)_$11 -> {
                    this.printApplication$$anonfun$1((Trees.TermTree)_$11);
                    return BoxedUnit.UNIT;
                });
                this.print(")");
                return;
            }
            if (termTree instanceof Trees.TypeApply) {
                Trees.TypeApply typeApply = Trees$TypeApply$.MODULE$.unapply((Trees.TypeApply)termTree);
                Trees.TermTree termTree3 = typeApply._1();
                List<Trees.TypeTree> list = typeApply._2();
                Trees.TermTree fun = termTree3;
                List<Trees.TypeTree> args = list;
                this.printApplication(fun, hideNew);
                this.print("[");
                this.printCommaSeparatedList(args, (Function1 & Serializable)_$12 -> {
                    this.printApplication$$anonfun$2((Trees.TypeTree)_$12);
                    return BoxedUnit.UNIT;
                });
                this.print("]");
                return;
            }
            if (termTree instanceof Trees.Select) {
                Trees.Select select = Trees$Select$.MODULE$.unapply((Trees.Select)termTree);
                Trees.TermTree termTree4 = select._1();
                Names.TermName termName = select._2();
                if (termTree4 instanceof Trees.New) {
                    Trees.TypeTree typeTree;
                    Trees.New new_ = Trees$New$.MODULE$.unapply((Trees.New)termTree4);
                    Trees.TypeTree tpt = typeTree = new_._1();
                    if (termName instanceof Names.SignedName) {
                        Names.SignedName signedName = Names$SignedName$.MODULE$.unapply((Names.SignedName)termName);
                        Names.UnsignedTermName unsignedTermName = signedName._1();
                        Signatures.Signature signature = signedName._2();
                        Names.UnsignedTermName unsignedTermName2 = signedName._3();
                        Names.SimpleName simpleName = Names$nme$.MODULE$.Constructor();
                        Names.UnsignedTermName unsignedTermName3 = unsignedTermName;
                        if (!(simpleName != null ? !((Object)simpleName).equals(unsignedTermName3) : unsignedTermName3 != null)) {
                            if (!hideNew) {
                                this.print("new ");
                            }
                            this.print(tpt);
                            return;
                        }
                    }
                    Trees.TypeTree tpt2 = typeTree;
                    Names.SimpleName simpleName = Names$nme$.MODULE$.Constructor();
                    Names.TermName termName2 = termName;
                    if (!(simpleName != null ? !((Object)simpleName).equals(termName2) : termName2 != null)) {
                        if (!hideNew) {
                            this.print("new ");
                        }
                        this.print(tpt2);
                        return;
                    }
                }
                Trees.TermTree qual = termTree4;
                if (termName instanceof Names.SignedName) {
                    Names.SignedName signedName = Names$SignedName$.MODULE$.unapply((Names.SignedName)termName);
                    Names.UnsignedTermName unsignedTermName = signedName._1();
                    Signatures.Signature signature = signedName._2();
                    Names.UnsignedTermName unsignedTermName4 = signedName._3();
                    Names.UnsignedTermName underlying = unsignedTermName;
                    this.print(qual);
                    this.print(".");
                    this.print(underlying);
                    return;
                }
            }
            if (termTree instanceof Trees.New) {
                Trees.TypeTree typeTree;
                Trees.New new_ = Trees$New$.MODULE$.unapply((Trees.New)termTree);
                Trees.TypeTree tpt = typeTree = new_._1();
                if (hideNew) {
                    this.print(tpt);
                    return;
                }
            }
            this.print(tree);
        }

        public void print(Trees.ImportSelector tree) {
            if (tree.isGiven()) {
                Option<Trees.TypeTree> option = tree.bound();
                if (option instanceof Some) {
                    Trees.TypeTree bound = (Trees.TypeTree)((Some)option).value();
                    this.print("given ");
                    this.print(bound);
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    this.print("given");
                    return;
                }
                throw new MatchError(option);
            }
            this.print(tree.name());
            tree.renamed().foreach((Function1 & Serializable)renamed -> {
                this.print$$anonfun$21((Trees.ImportIdent)renamed);
                return BoxedUnit.UNIT;
            });
        }

        public void print(Trees.Template tree) {
            Trees.Template template = tree;
            Trees.Template template2 = Trees$Template$.MODULE$.unapply(template);
            Trees.DefDef defDef = template2._1();
            List<Object> list = template2._2();
            Option<Trees.SelfDef> option = template2._3();
            List<Trees.StatementTree> list2 = template2._4();
            Trees.DefDef constr = defDef;
            List<Object> parents = list;
            Option<Trees.SelfDef> self = option;
            List<Trees.StatementTree> body = list2;
            Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)constr, parents, self, body);
            Trees.DefDef constr2 = (Trees.DefDef)tuple4._1();
            List parents2 = (List)tuple4._2();
            Option self2 = (Option)tuple4._3();
            List body2 = (List)tuple4._4();
            Tuple2 tuple2 = body2.partition((Function1 & Serializable)_$13 -> _$13 instanceof Trees.TypeParam);
            List typeParams = (List)tuple2._1();
            List otherStats = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)typeParams, (Object)otherStats);
            List typeParams2 = (List)tuple22._1();
            List otherStats2 = (List)tuple22._2();
            if (typeParams2.nonEmpty()) {
                this.print("[");
                this.printCommaSeparatedList(typeParams2, (Function1 & Serializable)_$14 -> {
                    this.print$$anonfun$22((Trees.StatementTree)_$14);
                    return BoxedUnit.UNIT;
                });
                this.print("]");
            }
            this.print(" extends ");
            Object object = parents2.head();
            if (object instanceof Trees.TermTree) {
                Trees.TermTree parent2 = (Trees.TermTree)object;
                this.printApplication(parent2, true);
            } else if (object instanceof Trees.TypeTree) {
                Trees.TypeTree parent3 = (Trees.TypeTree)object;
                this.print(parent3);
            } else {
                throw new MatchError(object);
            }
            ((List)parents2.tail()).foreach((Function1 & Serializable)parent -> {
                this.print$$anonfun$23(parent);
                return BoxedUnit.UNIT;
            });
            List list3 = self2.toList();
            this.printBlock(otherStats2.$colon$colon((Object)constr2).$colon$colon$colon(list3), (Function1 & Serializable)stat -> {
                this.print$$anonfun$24((Trees.Tree)stat);
                return BoxedUnit.UNIT;
            });
        }

        public void print(Trees.SelfDef tree) {
            this.print(tree.name());
            this.print(": ");
            this.print(tree.tpt());
            this.print(" =>");
        }

        /*
         * Unable to fully structure code
         */
        public void print(Trees.PatternTree tree) {
            block8: {
                var2_2 = tree;
                if (var2_2 instanceof Trees.WildcardPattern) {
                    var3_3 = Trees$WildcardPattern$.MODULE$.unapply((Trees.WildcardPattern)var2_2);
                    tpe = var4_4 = var3_3._1();
                    this.print("_");
                    return;
                }
                if (var2_2 instanceof Trees.TypeTest) {
                    var6_6 = Trees$TypeTest$.MODULE$.unapply((Trees.TypeTest)var2_2);
                    var7_7 = var6_6._1();
                    var8_8 = var6_6._2();
                    body = var7_7;
                    tpt = var8_8;
                    this.print(body);
                    this.print(": ");
                    this.print(tpt);
                    return;
                }
                if (var2_2 instanceof Trees.Bind) {
                    var11_11 = Trees$Bind$.MODULE$.unapply((Trees.Bind)var2_2);
                    var12_12 = var11_11._1();
                    var13_13 = var11_11._2();
                    var14_14 = var11_11._3();
                    name = var12_12;
                    body = var13_13;
                    symbol = var14_14;
                    this.print(name);
                    this.print(" @ ");
                    this.print(body);
                    return;
                }
                if (var2_2 instanceof Trees.Alternative) {
                    var18_18 = Trees$Alternative$.MODULE$.unapply((Trees.Alternative)var2_2);
                    trees = var19_19 = var18_18._1();
                    this.print((Trees.PatternTree)trees.head());
                    trees.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, print$$anonfun$adapted$25(tastyquery.Trees$PatternTree ), (Ltastyquery/Trees$PatternTree;)Ljava/lang/Object;)((Printer)this));
                    return;
                }
                if (!(var2_2 instanceof Trees.Unapply)) break block8;
                var21_21 = Trees$Unapply$.MODULE$.unapply((Trees.Unapply)var2_2);
                var22_22 = var21_21._1();
                var23_23 = var21_21._2();
                var24_24 = var21_21._3();
                fun = var22_22;
                implicits = var23_23;
                patterns = var24_24;
                var28_28 = fun;
                if (!(var28_28 instanceof Trees.Select)) ** GOTO lbl-1000
                var29_29 = Trees$Select$.MODULE$.unapply((Trees.Select)var28_28);
                var30_30 = var29_29._1();
                var31_31 = var29_29._2();
                extractor = var30_30;
                if (!(var31_31 instanceof Names.SignedName)) ** GOTO lbl-1000
                var33_33 = Names$SignedName$.MODULE$.unapply((Names.SignedName)var31_31);
                var34_34 = var33_33._1();
                var35_35 = var33_33._2();
                var36_36 = var33_33._3();
                v0 = Names$nme$.MODULE$.m_unapply();
                var37_37 = var34_34;
                if (!(v0 != null ? v0.equals(var37_37) == false : var37_37 != null)) {
                    this.print(extractor);
                } else lbl-1000:
                // 3 sources

                {
                    this.printApplication(fun, false);
                }
                this.print("(");
                this.printCommaSeparatedList(patterns, (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, print$$anonfun$adapted$26(tastyquery.Trees$PatternTree ), (Ltastyquery/Trees$PatternTree;)Ljava/lang/Object;)((Printer)this));
                this.print(")");
                if (implicits.nonEmpty()) {
                    this.print("(");
                    this.printCommaSeparatedList(implicits, (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, print$$anonfun$adapted$27(tastyquery.Trees$TermTree ), (Ltastyquery/Trees$TermTree;)Ljava/lang/Object;)((Printer)this));
                    this.print(")");
                    return;
                }
                return;
            }
            if (var2_2 instanceof Trees.ExprPattern) {
                var38_38 = Trees$ExprPattern$.MODULE$.unapply((Trees.ExprPattern)var2_2);
                expr = var39_39 = var38_38._1();
                this.print(expr);
                return;
            }
            throw new MatchError((Object)var2_2);
        }

        public void print(Trees.TypeTree tree) {
            Trees.TypeTree typeTree = tree;
            if (typeTree instanceof Trees.TypeIdent) {
                Names.TypeName typeName;
                Trees.TypeIdent typeIdent = Trees$TypeIdent$.MODULE$.unapply((Trees.TypeIdent)typeTree);
                Names.TypeName name = typeName = typeIdent._1();
                this.print(name);
                return;
            }
            if (typeTree instanceof Trees.TypeWrapper) {
                Types.NonEmptyPrefix nonEmptyPrefix;
                Trees.TypeWrapper typeWrapper = Trees$TypeWrapper$.MODULE$.unapply((Trees.TypeWrapper)typeTree);
                Types.NonEmptyPrefix tp = nonEmptyPrefix = typeWrapper._1();
                this.print((Types.TypeMappable)((Object)tp));
                return;
            }
            if (typeTree instanceof Trees.SingletonTypeTree) {
                Trees.TermTree termTree;
                Trees.SingletonTypeTree singletonTypeTree = Trees$SingletonTypeTree$.MODULE$.unapply((Trees.SingletonTypeTree)typeTree);
                Trees.TermTree ref = termTree = singletonTypeTree._1();
                this.print(ref);
                this.print(".type");
                return;
            }
            if (typeTree instanceof Trees.RefinedTypeTree) {
                Trees.RefinedTypeTree refinedTypeTree = Trees$RefinedTypeTree$.MODULE$.unapply((Trees.RefinedTypeTree)typeTree);
                Trees.TypeTree typeTree2 = refinedTypeTree._1();
                List<Trees.DefTree> list = refinedTypeTree._2();
                Symbols.ClassSymbol classSymbol = refinedTypeTree._3();
                Trees.TypeTree underlying = typeTree2;
                List<Trees.DefTree> refinements = list;
                Symbols.ClassSymbol refinedCls = classSymbol;
                this.print("(");
                this.print(underlying);
                this.printBlock(refinements, (Function1 & Serializable)refinement -> {
                    this.print$$anonfun$28((Trees.DefTree)refinement);
                    return BoxedUnit.UNIT;
                });
                this.print(")");
                return;
            }
            if (typeTree instanceof Trees.ByNameTypeTree) {
                Trees.TypeTree typeTree3;
                Trees.ByNameTypeTree byNameTypeTree = Trees$ByNameTypeTree$.MODULE$.unapply((Trees.ByNameTypeTree)typeTree);
                Trees.TypeTree result = typeTree3 = byNameTypeTree._1();
                this.print("=> ");
                this.print(result);
                return;
            }
            if (typeTree instanceof Trees.AppliedTypeTree) {
                Trees.AppliedTypeTree appliedTypeTree = Trees$AppliedTypeTree$.MODULE$.unapply((Trees.AppliedTypeTree)typeTree);
                Trees.TypeTree typeTree4 = appliedTypeTree._1();
                List<Trees.TypeArgTree> list = appliedTypeTree._2();
                Trees.TypeTree tycon = typeTree4;
                List<Trees.TypeArgTree> args = list;
                this.print(tycon);
                this.print("[");
                this.printCommaSeparatedList(args, (Function1 & Serializable)arg -> {
                    this.print$$anonfun$29((Trees.TypeArgTree)arg);
                    return BoxedUnit.UNIT;
                });
                this.print("]");
                return;
            }
            if (typeTree instanceof Trees.SelectTypeTree) {
                Trees.SelectTypeTree selectTypeTree = Trees$SelectTypeTree$.MODULE$.unapply((Trees.SelectTypeTree)typeTree);
                Trees.TypeTree typeTree5 = selectTypeTree._1();
                Names.TypeName typeName = selectTypeTree._2();
                Trees.TypeTree qualifier = typeTree5;
                Names.TypeName name = typeName;
                this.print(qualifier);
                this.print(".");
                this.print(name);
                return;
            }
            if (typeTree instanceof Trees.TermRefTypeTree) {
                Trees.TermRefTypeTree termRefTypeTree = Trees$TermRefTypeTree$.MODULE$.unapply((Trees.TermRefTypeTree)typeTree);
                Trees.TermTree termTree = termRefTypeTree._1();
                Names.TermName termName = termRefTypeTree._2();
                Trees.TermTree qualifier = termTree;
                Names.TermName name = termName;
                this.print(qualifier);
                this.print(".");
                this.print(name);
                return;
            }
            if (typeTree instanceof Trees.AnnotatedTypeTree) {
                Trees.AnnotatedTypeTree annotatedTypeTree = Trees$AnnotatedTypeTree$.MODULE$.unapply((Trees.AnnotatedTypeTree)typeTree);
                Trees.TypeTree typeTree6 = annotatedTypeTree._1();
                Trees.TermTree termTree = annotatedTypeTree._2();
                Trees.TypeTree tpt = typeTree6;
                Trees.TermTree annotation = termTree;
                this.print("(");
                this.print(tpt);
                this.print(" ");
                this.print(annotation);
                this.print(")");
                return;
            }
            if (typeTree instanceof Trees.MatchTypeTree) {
                Trees.MatchTypeTree matchTypeTree = Trees$MatchTypeTree$.MODULE$.unapply((Trees.MatchTypeTree)typeTree);
                Trees.TypeTree typeTree7 = matchTypeTree._1();
                Trees.TypeTree typeTree8 = matchTypeTree._2();
                List<Trees.TypeCaseDef> list = matchTypeTree._3();
                Trees.TypeTree bound = typeTree7;
                Trees.TypeTree selector = typeTree8;
                List<Trees.TypeCaseDef> cases = list;
                this.print("(");
                this.print(selector);
                this.print(" match");
                if (!Printers$.MODULE$.tastyquery$Printers$$$isSyntacticAny(bound.toType())) {
                    this.print(" <: ");
                    this.print(bound);
                }
                this.printBlock(cases, (Function1 & Serializable)_$17 -> {
                    this.print$$anonfun$30((Trees.TypeCaseDef)_$17);
                    return BoxedUnit.UNIT;
                });
                this.print(")");
                return;
            }
            if (typeTree instanceof Trees.TypeTreeBind) {
                Trees.TypeTreeBind typeTreeBind = Trees$TypeTreeBind$.MODULE$.unapply((Trees.TypeTreeBind)typeTree);
                Names.TypeName typeName = typeTreeBind._1();
                Trees.TypeDefinitionTree typeDefinitionTree = typeTreeBind._2();
                Symbols.LocalTypeParamSymbol localTypeParamSymbol = typeTreeBind._3();
                Names.TypeName name = typeName;
                Trees.TypeDefinitionTree body = typeDefinitionTree;
                Symbols.LocalTypeParamSymbol symbol = localTypeParamSymbol;
                this.print(name);
                return;
            }
            if (typeTree instanceof Trees.TypeLambdaTree) {
                Trees.TypeLambdaTree typeLambdaTree = Trees$TypeLambdaTree$.MODULE$.unapply((Trees.TypeLambdaTree)typeTree);
                List<Trees.TypeParam> list = typeLambdaTree._1();
                Trees.TypeTree typeTree9 = typeLambdaTree._2();
                List<Trees.TypeParam> tparams = list;
                Trees.TypeTree body = typeTree9;
                this.print("([");
                this.printCommaSeparatedList(tparams, (Function1 & Serializable)_$18 -> {
                    this.print$$anonfun$31((Trees.TypeParam)_$18);
                    return BoxedUnit.UNIT;
                });
                this.print("] =>> ");
                this.print(body);
                this.print(")");
                return;
            }
            if (typeTree instanceof Trees.TypeBindingsTree) {
                Trees.TypeBindingsTree typeBindingsTree = Trees$TypeBindingsTree$.MODULE$.unapply((Trees.TypeBindingsTree)typeTree);
                List<Trees.TypeMember> list = typeBindingsTree._1();
                Trees.TypeTree typeTree10 = typeBindingsTree._2();
                List<Trees.TypeMember> bindings = list;
                Trees.TypeTree body = typeTree10;
                this.printBlock(bindings, body, (Function1 & Serializable)elem -> {
                    this.print$$anonfun$32((Trees.Tree)elem);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError((Object)typeTree);
        }

        public void print(Trees.WildcardTypeArgTree tree) {
            this.print("?");
            this.print(tree.bounds());
        }

        public void print(Trees.TypeCaseDef tree) {
            this.print("case ");
            this.print(tree.pattern());
            this.print(" => ");
            this.print(tree.body());
        }

        public void print(Trees.TypeDefinitionTree tree) {
            Trees.TypeDefinitionTree typeDefinitionTree = tree;
            if (typeDefinitionTree instanceof Trees.InferredTypeBoundsTree) {
                Types.TypeBounds typeBounds;
                Trees.InferredTypeBoundsTree inferredTypeBoundsTree = Trees$InferredTypeBoundsTree$.MODULE$.unapply((Trees.InferredTypeBoundsTree)typeDefinitionTree);
                Types.TypeBounds bounds = typeBounds = inferredTypeBoundsTree._1();
                this.print(bounds);
                return;
            }
            if (typeDefinitionTree instanceof Trees.ExplicitTypeBoundsTree) {
                Trees.ExplicitTypeBoundsTree explicitTypeBoundsTree = Trees$ExplicitTypeBoundsTree$.MODULE$.unapply((Trees.ExplicitTypeBoundsTree)typeDefinitionTree);
                Trees.TypeTree typeTree = explicitTypeBoundsTree._1();
                Trees.TypeTree typeTree2 = explicitTypeBoundsTree._2();
                Trees.TypeTree low = typeTree;
                Trees.TypeTree high = typeTree2;
                if (!Printers$.MODULE$.tastyquery$Printers$$$isSyntacticNothing(low.toType())) {
                    this.print(" >: ");
                    this.print(low);
                }
                if (!Printers$.MODULE$.tastyquery$Printers$$$isSyntacticAny(high.toType())) {
                    this.print(" <: ");
                    this.print(high);
                    return;
                }
                return;
            }
            if (typeDefinitionTree instanceof Trees.TypeAliasDefinitionTree) {
                Trees.TypeAliasDefinitionTree typeAliasDefinitionTree = Trees$TypeAliasDefinitionTree$.MODULE$.unapply((Trees.TypeAliasDefinitionTree)typeDefinitionTree);
                Trees.TypeTree typeTree = typeAliasDefinitionTree._1();
                Trees.TypeTree alias = typeTree;
                Trees.TypeTree typeTree3 = alias;
                if (typeTree3 instanceof Trees.MatchTypeTree) {
                    Trees.MatchTypeTree matchTypeTree = Trees$MatchTypeTree$.MODULE$.unapply((Trees.MatchTypeTree)typeTree3);
                    Trees.TypeTree typeTree4 = matchTypeTree._1();
                    Trees.TypeTree typeTree5 = matchTypeTree._2();
                    List<Trees.TypeCaseDef> list = matchTypeTree._3();
                    Trees.TypeTree bound = typeTree4;
                    Trees.TypeTree selector = typeTree5;
                    List<Trees.TypeCaseDef> cases = list;
                    if (!Printers$.MODULE$.tastyquery$Printers$$$isSyntacticAny(bound.toType())) {
                        this.print(" <: ");
                        this.print(bound);
                    }
                    this.print(" = ");
                    this.print(selector);
                    this.print(" match");
                    this.printBlock(cases, (Function1 & Serializable)caze -> {
                        this.print$$anonfun$33((Trees.TypeCaseDef)caze);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
                this.print(" = ");
                this.print(alias);
                return;
            }
            if (typeDefinitionTree instanceof Trees.OpaqueTypeAliasDefinitionTree) {
                Trees.OpaqueTypeAliasDefinitionTree opaqueTypeAliasDefinitionTree = Trees$OpaqueTypeAliasDefinitionTree$.MODULE$.unapply((Trees.OpaqueTypeAliasDefinitionTree)typeDefinitionTree);
                Trees.TypeBoundsTree typeBoundsTree = opaqueTypeAliasDefinitionTree._1();
                Trees.TypeTree typeTree = opaqueTypeAliasDefinitionTree._2();
                Trees.TypeBoundsTree bounds = typeBoundsTree;
                Trees.TypeTree alias = typeTree;
                this.print(bounds);
                this.print(alias);
                return;
            }
            if (typeDefinitionTree instanceof Trees.PolyTypeDefinitionTree) {
                Trees.PolyTypeDefinitionTree polyTypeDefinitionTree = Trees$PolyTypeDefinitionTree$.MODULE$.unapply((Trees.PolyTypeDefinitionTree)typeDefinitionTree);
                List<Trees.TypeParam> list = polyTypeDefinitionTree._1();
                Trees.TypeDefinitionTree typeDefinitionTree2 = polyTypeDefinitionTree._2();
                List<Trees.TypeParam> tparams = list;
                Trees.TypeDefinitionTree body = typeDefinitionTree2;
                this.print("[");
                this.printCommaSeparatedList(tparams, (Function1 & Serializable)_$19 -> {
                    this.print$$anonfun$34((Trees.TypeParam)_$19);
                    return BoxedUnit.UNIT;
                });
                this.print("]");
                this.print(body);
                return;
            }
            if (typeDefinitionTree instanceof Trees.NamedTypeBoundsTree) {
                Trees.NamedTypeBoundsTree namedTypeBoundsTree = Trees$NamedTypeBoundsTree$.MODULE$.unapply((Trees.NamedTypeBoundsTree)typeDefinitionTree);
                Names.TypeName typeName = namedTypeBoundsTree._1();
                Types.TypeBounds typeBounds = namedTypeBoundsTree._2();
                Names.TypeName name = typeName;
                Types.TypeBounds bounds = typeBounds;
                this.print(name);
                return;
            }
            throw new MatchError((Object)typeDefinitionTree);
        }

        public <A> void printCommaSeparatedList(List<A> elems, Function1<A, BoxedUnit> printElem) {
            if (elems.nonEmpty()) {
                printElem.apply(elems.head());
                ((List)elems.tail()).foreach((Function1 & Serializable)elem -> {
                    this.printCommaSeparatedList$$anonfun$1(printElem, elem);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }

        public final <A> void printBlock(List<A> initElems, A lastElem, Function1<A, BoxedUnit> printElem) {
            this.printBlock((List)initElems.$colon$plus(lastElem), printElem);
        }

        public <A> void printBlock(List<A> elems, Function1<A, BoxedUnit> printElem) {
            if (elems.isEmpty()) {
                this.print(" {}");
                return;
            }
            this.print(" { ");
            printElem.apply(elems.head());
            ((List)elems.tail()).foreach((Function1 & Serializable)elem -> {
                this.printBlock$$anonfun$1(printElem, elem);
                return BoxedUnit.UNIT;
            });
            this.print(" }");
        }

        public void print(Names.Name name) {
            this.print(name.toString());
        }

        public void print(Constants.Constant constant) {
            int n = constant.tag();
            switch (n) {
                case 1: {
                    this.print("()");
                    return;
                }
                case 3: {
                    this.print(new StringBuilder(1).append(constant.value()).append("b").toString());
                    return;
                }
                case 4: {
                    this.print(new StringBuilder(1).append(constant.value()).append("s").toString());
                    return;
                }
                case 5: {
                    this.print("'");
                    this.printEscaped(BoxesRunTime.boxToCharacter((char)constant.charValue()).toString());
                    this.print("'");
                    return;
                }
                case 7: {
                    this.print(new StringBuilder(1).append(constant.value()).append("L").toString());
                    return;
                }
                case 8: {
                    this.print(new StringBuilder(1).append(constant.value()).append("f").toString());
                    return;
                }
                case 10: {
                    this.print("\"");
                    this.printEscaped(constant.stringValue());
                    this.print("\"");
                    return;
                }
                case 11: {
                    this.print("null");
                    return;
                }
                case 12: {
                    this.print("classOf[");
                    this.print(constant.typeValue());
                    this.print("]");
                    return;
                }
            }
            this.print(constant.value().toString());
        }

        public void printEscaped(String str) {
            StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)v1 -> {
                this.printEscaped$$anonfun$1(BoxesRunTime.unboxToChar((Object)v1));
                return BoxedUnit.UNIT;
            });
        }

        public void print(Annotations.Annotation annot) {
            this.print("@");
            this.printApplication(annot.tree(), true);
        }

        public void print(Types.TypeConstructorParam tparam) {
            this.print(tparam.declaredVariance());
            this.print(tparam.name());
            this.print(tparam.declaredBounds());
        }

        public void print(Modifiers.Variance variance) {
            Modifiers.Variance variance2 = variance;
            Modifiers.Variance variance3 = Modifiers$Variance$.Invariant;
            Modifiers.Variance variance4 = variance2;
            if (!(variance3 != null ? !variance3.equals(variance4) : variance4 != null)) {
                return;
            }
            Modifiers.Variance variance5 = Modifiers$Variance$.Covariant;
            Modifiers.Variance variance6 = variance2;
            if (!(variance5 != null ? !variance5.equals(variance6) : variance6 != null)) {
                Predef$.MODULE$.println((Object)"+");
                return;
            }
            Modifiers.Variance variance7 = Modifiers$Variance$.Contravariant;
            Modifiers.Variance variance8 = variance2;
            if (!(variance7 != null ? !variance7.equals(variance8) : variance8 != null)) {
                Predef$.MODULE$.println((Object)"-");
                return;
            }
            throw new MatchError((Object)variance2);
        }

        public void print(int i) {
            this.print(BoxesRunTime.boxToInteger((int)i).toString());
        }

        public void print(String str) {
            this.out.write(str);
        }

        private final /* synthetic */ void printPrefix$$anonfun$1(Types.Type explicitSupertpe) {
            this.print("[");
            this.print(explicitSupertpe);
            this.print("]");
        }

        private final /* synthetic */ void print$$anonfun$1(Types.TypeOrWildcard _$1) {
            this.print((Types.TypeMappable)((Object)_$1));
        }

        private final /* synthetic */ void print$$anonfun$2(Types.TypeLambdaParam _$2) {
            this.print(_$2);
        }

        private final /* synthetic */ void print$$anonfun$3(Types.MatchTypeCase caze) {
            this.print("case ");
            this.print(caze.pattern());
            this.print(" => ");
            this.print(caze.result());
        }

        private final /* synthetic */ void print$$anonfun$4(Tuple2 x$1) {
            Names.UnsignedTermName unsignedTermName = (Names.UnsignedTermName)x$1._1();
            Types.Type type = (Types.Type)x$1._2();
            this.print(unsignedTermName);
            this.print(": ");
            this.print(type);
        }

        private final /* synthetic */ void print$$anonfun$5(Tuple2 x$1) {
            Names.TypeName typeName = (Names.TypeName)x$1._1();
            Types.TypeBounds typeBounds = (Types.TypeBounds)x$1._2();
            this.print(typeName);
            this.print(typeBounds);
        }

        private final /* synthetic */ void printTopLevel$$anonfun$1(Trees.TopLevelTree _$3) {
            this.printTopLevel(_$3);
        }

        private final /* synthetic */ void print$$anonfun$6(Trees.ImportSelector _$4) {
            this.print(_$4);
        }

        private final /* synthetic */ void print$$anonfun$7(Trees.ImportSelector _$5) {
            this.print(_$5);
        }

        private final /* synthetic */ void print$$anonfun$8(Trees.TermTree r) {
            this.print(" = ");
            this.print(r);
        }

        private final /* synthetic */ void print$$anonfun$9$$anonfun$1(Trees.ValDef valDef) {
            this.print(valDef.name());
            this.print(": ");
            this.print(valDef.tpt());
        }

        private final /* synthetic */ void print$$anonfun$9$$anonfun$2(Trees.TypeParam typeDef) {
            this.print(typeDef.name());
            this.print(typeDef.bounds());
        }

        private final /* synthetic */ void print$$anonfun$9(Either paramList) {
            Either either = paramList;
            if (either instanceof Left) {
                List valDefs = (List)((Left)either).value();
                if (valDefs.isEmpty()) {
                    this.print("()");
                    return;
                }
                this.print("(");
                Trees.ValDef first = (Trees.ValDef)valDefs.head();
                if (first.symbol().isGivenOrUsing()) {
                    this.print("using ");
                } else if (first.symbol().isImplicit()) {
                    this.print("implicit ");
                }
                this.printCommaSeparatedList(valDefs, (Function1 & Serializable)valDef -> {
                    this.print$$anonfun$9$$anonfun$1((Trees.ValDef)valDef);
                    return BoxedUnit.UNIT;
                });
                this.print(")");
                return;
            }
            if (either instanceof Right) {
                List typeDefs = (List)((Right)either).value();
                this.print("[");
                this.printCommaSeparatedList(typeDefs, (Function1 & Serializable)typeDef -> {
                    this.print$$anonfun$9$$anonfun$2((Trees.TypeParam)typeDef);
                    return BoxedUnit.UNIT;
                });
                this.print("]");
                return;
            }
            throw new MatchError((Object)either);
        }

        private final /* synthetic */ void print$$anonfun$10(Trees.TermTree body) {
            this.print(" = ");
            this.print(body);
        }

        private final /* synthetic */ void print$$anonfun$11(int x$1) {
            int n = x$1;
            this.print(".<outer>");
        }

        private final /* synthetic */ void print$$anonfun$12(Trees.TypeIdent mix) {
            this.print("[");
            this.print(mix);
            this.print("]");
        }

        private final /* synthetic */ void print$$anonfun$13(Trees.StatementTree _$6) {
            this.print(_$6);
        }

        private final /* synthetic */ void print$$anonfun$14(Trees.CaseDef _$7) {
            this.print(_$7);
        }

        private final /* synthetic */ void print$$anonfun$15(Trees.TermTree _$8) {
            this.print(_$8);
        }

        private final /* synthetic */ void print$$anonfun$16(Trees.CaseDef _$9) {
            this.print(_$9);
        }

        private final /* synthetic */ void print$$anonfun$17(Trees.TermTree fin) {
            this.print(" finally ");
            this.print(fin);
        }

        private final /* synthetic */ void print$$anonfun$18(Serializable c) {
            this.print("<inlined: ");
            this.print((Trees.TypeTree)((Object)c));
            this.print(">");
        }

        private final /* synthetic */ void print$$anonfun$19(Trees.StatementTree _$10) {
            this.print(_$10);
        }

        private final /* synthetic */ void print$$anonfun$20(Trees.TermTree guard) {
            this.print(" if ");
            this.print(guard);
        }

        private final /* synthetic */ void printApplication$$anonfun$1(Trees.TermTree _$11) {
            this.print(_$11);
        }

        private final /* synthetic */ void printApplication$$anonfun$2(Trees.TypeTree _$12) {
            this.print(_$12);
        }

        private final /* synthetic */ void print$$anonfun$21(Trees.ImportIdent renamed) {
            this.print(" as ");
            this.print(renamed.name());
        }

        private final /* synthetic */ void print$$anonfun$22(Trees.StatementTree _$14) {
            this.print(_$14);
        }

        private final /* synthetic */ void print$$anonfun$23(Object parent) {
            this.print(" with ");
            Object object = parent;
            if (object instanceof Trees.TermTree) {
                Trees.TermTree parent2 = (Trees.TermTree)object;
                this.printApplication(parent2, true);
                return;
            }
            if (object instanceof Trees.TypeTree) {
                Trees.TypeTree parent3 = (Trees.TypeTree)object;
                this.print(parent3);
                return;
            }
            throw new MatchError(object);
        }

        private final /* synthetic */ void print$$anonfun$24(Trees.Tree stat) {
            Trees.Tree tree = stat;
            if (tree instanceof Trees.SelfDef) {
                Trees.SelfDef stat2 = (Trees.SelfDef)tree;
                this.print(stat2);
                return;
            }
            if (tree instanceof Trees.StatementTree) {
                Trees.StatementTree stat3 = (Trees.StatementTree)tree;
                this.print(stat3);
                return;
            }
            throw new MatchError((Object)tree);
        }

        private final /* synthetic */ void print$$anonfun$25(Trees.PatternTree tree) {
            this.print(" | ");
            this.print(tree);
        }

        private final /* synthetic */ void print$$anonfun$26(Trees.PatternTree _$15) {
            this.print(_$15);
        }

        private final /* synthetic */ void print$$anonfun$27(Trees.TermTree _$16) {
            this.print(_$16);
        }

        private final /* synthetic */ void print$$anonfun$28(Trees.DefTree refinement) {
            this.print((Trees.StatementTree)((Object)refinement));
        }

        private final /* synthetic */ void print$$anonfun$29(Trees.TypeArgTree arg) {
            Trees.TypeArgTree typeArgTree = arg;
            if (typeArgTree instanceof Trees.TypeTree) {
                Trees.TypeTree arg2 = (Trees.TypeTree)typeArgTree;
                this.print(arg2);
                return;
            }
            if (typeArgTree instanceof Trees.WildcardTypeArgTree) {
                Trees.WildcardTypeArgTree arg3 = (Trees.WildcardTypeArgTree)typeArgTree;
                this.print(arg3);
                return;
            }
            throw new MatchError((Object)typeArgTree);
        }

        private final /* synthetic */ void print$$anonfun$30(Trees.TypeCaseDef _$17) {
            this.print(_$17);
        }

        private final /* synthetic */ void print$$anonfun$31(Trees.TypeParam _$18) {
            this.print(_$18);
        }

        private final /* synthetic */ void print$$anonfun$32(Trees.Tree elem) {
            Trees.Tree tree = elem;
            if (tree instanceof Trees.TypeMember) {
                Trees.TypeMember elem2 = (Trees.TypeMember)tree;
                this.print(elem2);
                return;
            }
            if (tree instanceof Trees.TypeTree) {
                Trees.TypeTree elem3 = (Trees.TypeTree)tree;
                this.print(elem3);
                return;
            }
            throw new MatchError((Object)tree);
        }

        private final /* synthetic */ void print$$anonfun$33(Trees.TypeCaseDef caze) {
            this.print("case ");
            this.print(caze.pattern());
            this.print(" => ");
            this.print(caze.body());
        }

        private final /* synthetic */ void print$$anonfun$34(Trees.TypeParam _$19) {
            this.print(_$19);
        }

        private final /* synthetic */ void printCommaSeparatedList$$anonfun$1(Function1 printElem$1, Object elem) {
            this.print(", ");
            printElem$1.apply(elem);
        }

        private final /* synthetic */ void printBlock$$anonfun$1(Function1 printElem$2, Object elem) {
            this.print("; ");
            printElem$2.apply(elem);
        }

        private final /* synthetic */ void printEscaped$$anonfun$1(char c) {
            char c2 = c;
            switch (c2) {
                case '\'': {
                    this.print("\\'");
                    return;
                }
                case '\"': {
                    this.print("\\\"");
                    return;
                }
                case '\n': {
                    this.print("\\n");
                    return;
                }
            }
            if (c >= ' ' && c < '\u0080') {
                this.print(BoxesRunTime.boxToCharacter((char)c).toString());
                return;
            }
            this.print(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
        }
    }
}

