/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.classfiles;

import java.io.Serializable;
import scala.Function1;
import scala.Function4;
import scala.IArray;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ReusableBuilder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import tastyquery.Classpaths;
import tastyquery.Exceptions;
import tastyquery.Flags$;
import tastyquery.Names;
import tastyquery.Names$;
import tastyquery.Names$UniqueName$;
import tastyquery.Symbols;
import tastyquery.reader.classfiles.ClassfileBuffer;
import tastyquery.reader.classfiles.ClassfileReader;
import tastyquery.reader.classfiles.ClassfileReader$Access$;
import tastyquery.reader.classfiles.ClassfileReader$Access$AccessFlags$;
import tastyquery.reader.classfiles.ClassfileReader$Annotation$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$Arr$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$ClassConst$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$Const$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$EnumConst$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$NestedAnnotation$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Class$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Double$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Dynamic$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Fieldref$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Float$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Integer$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$InterfaceMethodref$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$InvokeDynamic$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Long$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$MethodHandle$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$MethodType$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Methodref$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Module$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$NameAndType$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Package$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$String$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Utf8$;
import tastyquery.reader.classfiles.ClassfileReader$Indexing$;
import tastyquery.reader.classfiles.Forked;

public final class ClassfileReader$
implements Serializable {
    public static final ClassfileReader$Access$ Access;
    public static final ClassfileReader$Indexing$ Indexing;
    public static final ClassfileReader$ConstantInfo$ ConstantInfo;
    public static final ClassfileReader$AnnotationValue$ AnnotationValue;
    public static final ClassfileReader$Annotation$ Annotation;
    public static final ClassfileReader$ MODULE$;

    private ClassfileReader$() {
    }

    static {
        MODULE$ = new ClassfileReader$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClassfileReader$.class);
    }

    public ClassfileReader.Structure readStructure(Symbols.DeclaringSymbol classOwner, Classpaths.ClassData classRoot) {
        return (ClassfileReader.Structure)this.unpickle(classRoot, (Function1 & Serializable)evidence$2 -> {
            this.acceptHeader(classOwner, classRoot, (ClassfileReader.DataStream)evidence$2);
            ClassfileReader.ConstantPool pool = this.readConstantPool((ClassfileReader.DataStream)evidence$2);
            int access = this.readAccessFlags((ClassfileReader.DataStream)evidence$2);
            ClassfileReader.ConstantInfo.Class thisClass = this.readThisClass((ClassfileReader.DataStream)evidence$2, this.given_ConstantPool$1(pool));
            ClassfileReader.DataStream DataStream_this = evidence$2;
            Forked<ClassfileReader.DataStream> forked = DataStream_this.fork();
            this.skipOp$proxy1$1((ClassfileReader.DataStream)evidence$2);
            Forked<ClassfileReader.DataStream> supers = forked;
            return new ClassfileReader.Structure(access, pool.utf8(thisClass.nameIdx()), supers, this.skipFields((ClassfileReader.DataStream)evidence$2), this.skipMethods((ClassfileReader.DataStream)evidence$2), this.skipAttributes((ClassfileReader.DataStream)evidence$2), this.given_ConstantPool$1(pool));
        });
    }

    private void acceptHeader(Symbols.DeclaringSymbol classOwner, Classpaths.ClassData classRoot, ClassfileReader.DataStream x$3) {
        this.acceptMagicNumber(classOwner, classRoot, x$3);
        this.acceptVersion(classOwner, classRoot, x$3);
    }

    private String rootName(Symbols.DeclaringSymbol classOwner, Classpaths.ClassData classRoot) {
        return new StringBuilder(1).append(((Symbols.Symbol)((Object)classOwner)).displayFullName()).append(".").append(classRoot.binaryName()).toString();
    }

    private void acceptMagicNumber(Symbols.DeclaringSymbol classOwner, Classpaths.ClassData classRoot, ClassfileReader.DataStream x$3) {
        int magic = x$3.readU4();
        if (magic != -889275714) {
            String root = this.rootName(classOwner, classRoot);
            throw new Exceptions.ClassfileFormatException(new StringBuilder(37).append("Invalid magic number ").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(magic))).append(", should be ").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(-889275714))).append(" in ").append(root).toString());
        }
    }

    private void acceptVersion(Symbols.DeclaringSymbol classOwner, Classpaths.ClassData classRoot, ClassfileReader.DataStream x$3) {
        int minor = x$3.readU2();
        int major = x$3.readU2();
        if (major < 45 || major == 45 && minor < 3) {
            String root = this.rootName(classOwner, classRoot);
            throw new Exceptions.ClassfileFormatException(new StringBuilder(77).append("Invalid class file version ").append(major).append(".").append(minor).append(", should be at least ").append(45).append(".").append(3).append(" in ").append(root).toString());
        }
    }

    private ClassfileReader.ConstantPool readConstantPool(ClassfileReader.DataStream ds) {
        int count = ds.readU2();
        ClassfileReader.ConstantPool pool = new ClassfileReader.ConstantPool(count);
        boolean doAdd = true;
        while (doAdd) {
            doAdd = pool.add(this.acceptConstantInfo(ds, pool));
        }
        return pool;
    }

    public int readAccessFlags(ClassfileReader.DataStream x$1) {
        return ClassfileReader$Access$AccessFlags$.MODULE$.read(x$1.readU2());
    }

    public ClassfileReader.ConstantInfo.Class readThisClass(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        return pool.cls(pool.idx(ds.readU2()));
    }

    public Option<ClassfileReader.ConstantInfo.Class> readSuperClass(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int idx = ds.readU2();
        None$ entry = idx == 0 ? None$.MODULE$ : Some$.MODULE$.apply((Object)pool.cls(pool.idx(idx)));
        return entry;
    }

    public ClassfileReader.ConstantInfo.Class[] readInterfaces(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int count = ds.readU2();
        IndexedSeq interfaces = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)i -> this.$anonfun$2(ds, pool, BoxesRunTime.unboxToInt((Object)i)));
        return (ClassfileReader.ConstantInfo.Class[])IArray.package.IArray$.MODULE$.from((IterableOnce)interfaces, ClassTag$.MODULE$.apply(ClassfileReader.ConstantInfo.Class.class));
    }

    public Forked<ClassfileReader.DataStream> skipMethods(ClassfileReader.DataStream x$1) {
        return this.skipMembers(x$1);
    }

    public Forked<ClassfileReader.DataStream> skipFields(ClassfileReader.DataStream x$1) {
        return this.skipMembers(x$1);
    }

    public Forked<ClassfileReader.DataStream> skipAttributes(ClassfileReader.DataStream x$1) {
        ClassfileReader.DataStream DataStream_this = x$1;
        Forked<ClassfileReader.DataStream> forked = DataStream_this.fork();
        this.skipOp$proxy2$1(x$1);
        return forked;
    }

    private void skipAttributesInternal(ClassfileReader.DataStream x$1) {
        int count = x$1.readU2();
        for (int i = 0; i < count; ++i) {
            x$1.skip(2);
            x$1.skip(x$1.readU4());
        }
    }

    private Forked<ClassfileReader.DataStream> skipMembers(ClassfileReader.DataStream x$1) {
        Forked<ClassfileReader.DataStream> reader = x$1.fork();
        int count = x$1.readU2();
        for (int i = 0; i < count; ++i) {
            x$1.skip(6);
            this.skipAttributesInternal(x$1);
        }
        return reader;
    }

    public void readMembers(Function4<Object, Names.SimpleName, String, Map<Names.SimpleName, Forked<ClassfileReader.DataStream>>, BoxedUnit> op, ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int count = ds.readU2();
        for (int i = 0; i < count; ++i) {
            int accessFlags = this.readAccessFlags(ds);
            int nameIdx = pool.idx(ds.readU2());
            Names.SimpleName name = pool.utf8(nameIdx);
            int descriptorIdx = pool.idx(ds.readU2());
            String desc = pool.utf8(descriptorIdx).name();
            Map<Names.SimpleName, Forked<ClassfileReader.DataStream>> attributes = this.readAttributeMap(ds, pool);
            if (ClassfileReader$Access$AccessFlags$.MODULE$.isSynthetic(accessFlags)) continue;
            op.apply((Object)BoxesRunTime.boxToInteger((int)accessFlags), (Object)name, (Object)desc, attributes);
        }
    }

    public String readSignature(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int sigIdx = pool.idx(ds.readU2());
        return pool.utf8(sigIdx).name();
    }

    public void scanAttributes(Function1<ClassfileReader.DataStream, Function1<Names.SimpleName, Object>> onName, ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int count = ds.readU2();
        for (int i = 0; i < count; ++i) {
            int attrNameIdx = pool.idx(ds.readU2());
            Names.SimpleName attrName = pool.utf8(attrNameIdx);
            int attrLen = ds.readU4();
            if (BoxesRunTime.unboxToBoolean((Object)((Function1)onName.apply((Object)ds)).apply((Object)attrName))) {
                return;
            }
            ds.skip(attrLen);
        }
    }

    public Map<Names.SimpleName, Forked<ClassfileReader.DataStream>> readAttributeMap(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        ReusableBuilder builder = HashMap$.MODULE$.newBuilder();
        this.scanAttributes((Function1<ClassfileReader.DataStream, Function1<Names.SimpleName, Object>>)(Function1 & Serializable)evidence$5 -> (Function1 & Serializable)attributeName -> {
            Names.SimpleName simpleName = (Names.SimpleName)Predef$.MODULE$.ArrowAssoc(attributeName);
            builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)simpleName, evidence$5.fork()));
            return false;
        }, ds, pool);
        return (Map)builder.result();
    }

    public Option<Forked<ClassfileReader.DataStream>> readAttribute(Names.SimpleName attributeName, ClassfileReader.DataStream x$2, ClassfileReader.ConstantPool x$3) {
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        this.scanAttributes((Function1<ClassfileReader.DataStream, Function1<Names.SimpleName, Object>>)(Function1 & Serializable)evidence$6 -> (Function1 & Serializable)x$1 -> {
            Names.SimpleName simpleName = x$1;
            Names.SimpleName simpleName2 = attributeName;
            Names.SimpleName simpleName3 = simpleName;
            if (!(simpleName2 != null ? !((Object)simpleName2).equals(simpleName3) : simpleName3 != null)) {
                Some some = Some$.MODULE$.apply(evidence$6.fork());
                result$2.elem = some;
                some = null;
                return true;
            }
            return false;
        }, x$2, x$3);
        return (Option)result.elem;
    }

    public List<Tuple2<Names.UnsignedTermName, Object>> readMethodParameters(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int numParameters = ds.readU1();
        Builder resultBuilder = package$.MODULE$.List().newBuilder();
        for (int index = 0; index != numParameters; ++index) {
            int nameIndex = ds.readU2();
            Names.UnsignedTermName name = nameIndex == 0 ? Names$UniqueName$.MODULE$.apply(Names$.MODULE$.termName("x"), "$", index) : pool.utf8(pool.idx(nameIndex));
            int accessFlags = ClassfileReader$Access$AccessFlags$.MODULE$.read(ds.readU2());
            resultBuilder.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)name, (Object)BoxesRunTime.boxToInteger((int)accessFlags)));
        }
        return (List)resultBuilder.result();
    }

    public Option<ClassfileReader.Annotation> readAnnotation(Set<Names.SimpleName> typeDescriptors, ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int numAnnots = ds.readU2();
        for (int i = 0; i < numAnnots; ++i) {
            int typeIdx = pool.idx(ds.readU2());
            Names.SimpleName typeName = pool.utf8(typeIdx);
            if (typeDescriptors.contains((Object)typeName)) {
                Tuple2<Names.SimpleName, ClassfileReader.AnnotationValue>[] args = this.readAnnotationArgs(ds, pool);
                return Some$.MODULE$.apply((Object)ClassfileReader$Annotation$.MODULE$.apply(typeName, args));
            }
            this.skipAnnotationArgs$1(ds);
        }
        return None$.MODULE$;
    }

    public List<ClassfileReader.Annotation> readAllAnnotations(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int numAnnots = ds.readU2();
        Builder resultBuilder = package$.MODULE$.List().newBuilder();
        for (int i = 0; i < numAnnots; ++i) {
            resultBuilder.$plus$eq((Object)this.readAnnotation(ds, pool));
        }
        return (List)resultBuilder.result();
    }

    public List<List<ClassfileReader.Annotation>> readAllParameterAnnotations(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int numParameters = ds.readU1();
        Builder resultBuilder = package$.MODULE$.List().newBuilder();
        for (int i = 0; i < numParameters; ++i) {
            resultBuilder.$plus$eq(this.readAllAnnotations(ds, pool));
        }
        return (List)resultBuilder.result();
    }

    private ClassfileReader.Annotation readAnnotation(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        Names.SimpleName typeName = pool.utf8(pool.idx(ds.readU2()));
        Tuple2<Names.SimpleName, ClassfileReader.AnnotationValue>[] args = this.readAnnotationArgs(ds, pool);
        return ClassfileReader$Annotation$.MODULE$.apply(typeName, args);
    }

    private Tuple2<Names.SimpleName, ClassfileReader.AnnotationValue>[] readAnnotationArgs(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int numPairs = ds.readU2();
        ClassTag evidence$1$proxy1 = ClassTag$.MODULE$.apply(Tuple2.class);
        Tuple2[] arr = (Tuple2[])Arrays$.MODULE$.newGenericArray(numPairs, evidence$1$proxy1);
        for (int i = 0; i < numPairs; ++i) {
            int nameIdx = pool.idx(ds.readU2());
            Names.SimpleName argName = pool.utf8(nameIdx);
            ClassfileReader.AnnotationValue value = this.readAnnotationArgument(ds, pool);
            Names.SimpleName simpleName = (Names.SimpleName)Predef$.MODULE$.ArrowAssoc((Object)argName);
            arr[i] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)simpleName, (Object)value);
        }
        return (Tuple2[])IArray.package.IArray$.MODULE$.unsafeFromArray((Object)arr);
    }

    private ClassfileReader.AnnotationValue readAnnotationArgument(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        char tag;
        char c = tag = (char)ds.readU1();
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 's': {
                return ClassfileReader$AnnotationValue$Const$.MODULE$.apply(tag, this.readPoolIndex$1(ds, pool));
            }
            case 'e': {
                Names.SimpleName typeName = pool.utf8(this.readPoolIndex$1(ds, pool));
                Names.SimpleName constName = pool.utf8(this.readPoolIndex$1(ds, pool));
                return ClassfileReader$AnnotationValue$EnumConst$.MODULE$.apply(typeName, constName);
            }
            case 'c': {
                Names.SimpleName descriptor = pool.utf8(this.readPoolIndex$1(ds, pool));
                return ClassfileReader$AnnotationValue$ClassConst$.MODULE$.apply(descriptor);
            }
            case '@': {
                ClassfileReader.Annotation annotation = this.readAnnotation(ds, pool);
                return ClassfileReader$AnnotationValue$NestedAnnotation$.MODULE$.apply(annotation);
            }
            case '[': {
                int count = ds.readU2();
                ClassTag evidence$1$proxy2 = ClassTag$.MODULE$.apply(ClassfileReader.AnnotationValue.class);
                ClassfileReader.AnnotationValue[] arr = (ClassfileReader.AnnotationValue[])Arrays$.MODULE$.newGenericArray(count, evidence$1$proxy2);
                for (int i = 0; i < count; ++i) {
                    arr[i] = this.readAnnotationArgument(ds, pool);
                }
                ClassfileReader.AnnotationValue[] values = (ClassfileReader.AnnotationValue[])IArray.package.IArray$.MODULE$.unsafeFromArray((Object)arr);
                return ClassfileReader$AnnotationValue$Arr$.MODULE$.apply(values);
            }
        }
        throw new Exceptions.ClassfileFormatException(new StringBuilder(32).append("Invalid annotation argument tag ").append(tag).toString());
    }

    public void readInnerClasses(Function4<Names.SimpleName, Names.SimpleName, Names.SimpleName, Object, BoxedUnit> op, ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int numberOfClasses = ds.readU2();
        for (int i = 0; i < numberOfClasses; ++i) {
            int innerClassIdx = pool.idx(ds.readU2());
            int outerClassId = ds.readU2();
            int innerNameId = ds.readU2();
            long accessFlags = ClassfileReader$Access$AccessFlags$.MODULE$.toFlags(this.readAccessFlags(ds));
            if (outerClassId == 0 || innerNameId == 0 || Flags$.MODULE$.is(accessFlags, Flags$.MODULE$.Synthetic())) continue;
            Names.SimpleName innerClass = pool.utf8(pool.cls(innerClassIdx).nameIdx());
            Names.SimpleName innerName = pool.utf8(pool.idx(innerNameId));
            Names.SimpleName outerClass = pool.utf8(pool.cls(pool.idx(outerClassId)).nameIdx());
            op.apply((Object)innerName, (Object)innerClass, (Object)outerClass, (Object)BoxesRunTime.boxToLong((long)accessFlags));
        }
    }

    private ClassfileReader.ConstantInfo acceptConstantInfo(ClassfileReader.DataStream ds, ClassfileReader.ConstantPool pool) {
        int tag;
        int n = tag = ds.readU1();
        switch (n) {
            case 7: {
                return ClassfileReader$ConstantInfo$Class$.MODULE$.apply(pool.idx(ds.readU2()));
            }
            case 9: {
                return ClassfileReader$ConstantInfo$Fieldref$.MODULE$.apply(pool.idx(ds.readU2()), pool.idx(ds.readU2()));
            }
            case 10: {
                return ClassfileReader$ConstantInfo$Methodref$.MODULE$.apply(pool.idx(ds.readU2()), pool.idx(ds.readU2()));
            }
            case 11: {
                return ClassfileReader$ConstantInfo$InterfaceMethodref$.MODULE$.apply(pool.idx(ds.readU2()), pool.idx(ds.readU2()));
            }
            case 8: {
                return ClassfileReader$ConstantInfo$String$.MODULE$.apply(pool.idx(ds.readU2()));
            }
            case 3: {
                return ClassfileReader$ConstantInfo$Integer$.MODULE$.apply(ds.readU4());
            }
            case 4: {
                return ClassfileReader$ConstantInfo$Float$.MODULE$.apply(ds.readU4f());
            }
            case 5: {
                return ClassfileReader$ConstantInfo$Long$.MODULE$.apply(ds.readU8());
            }
            case 6: {
                return ClassfileReader$ConstantInfo$Double$.MODULE$.apply(ds.readU8f());
            }
            case 12: {
                return ClassfileReader$ConstantInfo$NameAndType$.MODULE$.apply(pool.idx(ds.readU2()), pool.idx(ds.readU2()));
            }
            case 1: {
                ClassfileReader.DataStream DataStream_this = ds;
                Forked<ClassfileReader.DataStream> forked = DataStream_this.fork();
                this.skipOp$proxy3$1(ds);
                return ClassfileReader$ConstantInfo$Utf8$.MODULE$.apply(forked);
            }
            case 15: {
                return ClassfileReader$ConstantInfo$MethodHandle$.MODULE$.apply(pool.idx(ds.readU1()), pool.idx(ds.readU2()));
            }
            case 16: {
                return ClassfileReader$ConstantInfo$MethodType$.MODULE$.apply(pool.idx(ds.readU2()));
            }
            case 17: {
                return ClassfileReader$ConstantInfo$Dynamic$.MODULE$.apply(pool.idx(ds.readU2()), pool.idx(ds.readU2()));
            }
            case 18: {
                return ClassfileReader$ConstantInfo$InvokeDynamic$.MODULE$.apply(pool.idx(ds.readU2()), pool.idx(ds.readU2()));
            }
            case 19: {
                return ClassfileReader$ConstantInfo$Module$.MODULE$.apply(pool.idx(ds.readU2()));
            }
            case 20: {
                return ClassfileReader$ConstantInfo$Package$.MODULE$.apply(pool.idx(ds.readU2()));
            }
        }
        throw new Exceptions.ClassfileFormatException(new StringBuilder(21).append("Invalid constant tag ").append(tag).toString());
    }

    public <T> T unpickle(Classpaths.ClassData classRoot, Function1<ClassfileReader.DataStream, T> op) {
        return new ClassfileBuffer.Root(classRoot.readClassFileBytes(), 0).use(op);
    }

    private final ClassfileReader.ConstantPool given_ConstantPool$1(ClassfileReader.ConstantPool pool$1) {
        return pool$1;
    }

    private final void skipOp$proxy1$1(ClassfileReader.DataStream evidence$2$1) {
        evidence$2$1.skip(2);
        evidence$2$1.skip(2 * evidence$2$1.readU2());
    }

    private final /* synthetic */ ClassfileReader.ConstantInfo.Class $anonfun$2(ClassfileReader.DataStream ds$1, ClassfileReader.ConstantPool pool$2, int i) {
        return pool$2.cls(pool$2.idx(ds$1.readU2()));
    }

    private final void skipOp$proxy2$1(ClassfileReader.DataStream x$1$1) {
        this.skipAttributesInternal(x$1$1);
    }

    private final void skipAnnotationArgument$1(ClassfileReader.DataStream ds$2) {
        char tag;
        char c = tag = (char)ds$2.readU1();
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 'c': 
            case 's': {
                ds$2.skip(2);
                return;
            }
            case 'e': {
                ds$2.skip(4);
                return;
            }
            case '@': {
                this.skipAnnotation$1(ds$2);
                return;
            }
            case '[': {
                int count = ds$2.readU2();
                for (int i = 0; i < count; ++i) {
                    this.skipAnnotationArgument$1(ds$2);
                }
                return;
            }
        }
        throw new Exceptions.ClassfileFormatException(new StringBuilder(32).append("Invalid annotation argument tag ").append(tag).toString());
    }

    private final void skipAnnotation$1(ClassfileReader.DataStream ds$3) {
        ds$3.skip(2);
        this.skipAnnotationArgs$1(ds$3);
    }

    private final void skipAnnotationArgs$1(ClassfileReader.DataStream ds$4) {
        int numPairs = ds$4.readU2();
        for (int i = 0; i < numPairs; ++i) {
            ds$4.skip(2);
            this.skipAnnotationArgument$1(ds$4);
        }
    }

    private final int readPoolIndex$1(ClassfileReader.DataStream ds$5, ClassfileReader.ConstantPool pool$3) {
        return pool$3.idx(ds$5.readU2());
    }

    private final void skipOp$proxy3$1(ClassfileReader.DataStream ds$6) {
        ds$6.skip(ds$6.readU2());
    }
}

