/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.classfiles;

import java.io.Serializable;
import scala.Array$;
import scala.CanEqual;
import scala.Function1;
import scala.Function4;
import scala.IArray;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.Enum;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import tastyquery.Classpaths;
import tastyquery.Exceptions;
import tastyquery.Names;
import tastyquery.Names$;
import tastyquery.Names$SimpleName$;
import tastyquery.Symbols;
import tastyquery.reader.classfiles.ClassfileReader;
import tastyquery.reader.classfiles.ClassfileReader$;
import tastyquery.reader.classfiles.ClassfileReader$Annotation$;
import tastyquery.reader.classfiles.ClassfileReader$AnnotationValue$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Double$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Float$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Integer$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Long$;
import tastyquery.reader.classfiles.ClassfileReader$ConstantInfo$Utf8$;
import tastyquery.reader.classfiles.ClassfileReader$Indexing$;
import tastyquery.reader.classfiles.Constants$annot$;
import tastyquery.reader.classfiles.Forked;
import tastyquery.reader.pickles.ByteCodecs$;

public final class ClassfileReader {
    public static int readAccessFlags(DataStream dataStream) {
        return ClassfileReader$.MODULE$.readAccessFlags(dataStream);
    }

    public static List<Annotation> readAllAnnotations(DataStream dataStream, ConstantPool constantPool) {
        return ClassfileReader$.MODULE$.readAllAnnotations(dataStream, constantPool);
    }

    public static List<List<Annotation>> readAllParameterAnnotations(DataStream dataStream, ConstantPool constantPool) {
        return ClassfileReader$.MODULE$.readAllParameterAnnotations(dataStream, constantPool);
    }

    public static Option<Annotation> readAnnotation(Set<Names.SimpleName> set, DataStream dataStream, ConstantPool constantPool) {
        return ClassfileReader$.MODULE$.readAnnotation(set, dataStream, constantPool);
    }

    public static Option<Forked<DataStream>> readAttribute(Names.SimpleName simpleName, DataStream dataStream, ConstantPool constantPool) {
        return ClassfileReader$.MODULE$.readAttribute(simpleName, dataStream, constantPool);
    }

    public static Map<Names.SimpleName, Forked<DataStream>> readAttributeMap(DataStream dataStream, ConstantPool constantPool) {
        return ClassfileReader$.MODULE$.readAttributeMap(dataStream, constantPool);
    }

    public static void readInnerClasses(Function4<Names.SimpleName, Names.SimpleName, Names.SimpleName, Object, BoxedUnit> function4, DataStream dataStream, ConstantPool constantPool) {
        ClassfileReader$.MODULE$.readInnerClasses(function4, dataStream, constantPool);
    }

    public static ConstantInfo.Class[] readInterfaces(DataStream dataStream, ConstantPool constantPool) {
        return ClassfileReader$.MODULE$.readInterfaces(dataStream, constantPool);
    }

    public static void readMembers(Function4<Object, Names.SimpleName, String, Map<Names.SimpleName, Forked<DataStream>>, BoxedUnit> function4, DataStream dataStream, ConstantPool constantPool) {
        ClassfileReader$.MODULE$.readMembers(function4, dataStream, constantPool);
    }

    public static List<Tuple2<Names.UnsignedTermName, Object>> readMethodParameters(DataStream dataStream, ConstantPool constantPool) {
        return ClassfileReader$.MODULE$.readMethodParameters(dataStream, constantPool);
    }

    public static String readSignature(DataStream dataStream, ConstantPool constantPool) {
        return ClassfileReader$.MODULE$.readSignature(dataStream, constantPool);
    }

    public static Structure readStructure(Symbols.DeclaringSymbol declaringSymbol, Classpaths.ClassData classData) {
        return ClassfileReader$.MODULE$.readStructure(declaringSymbol, classData);
    }

    public static Option<ConstantInfo.Class> readSuperClass(DataStream dataStream, ConstantPool constantPool) {
        return ClassfileReader$.MODULE$.readSuperClass(dataStream, constantPool);
    }

    public static ConstantInfo.Class readThisClass(DataStream dataStream, ConstantPool constantPool) {
        return ClassfileReader$.MODULE$.readThisClass(dataStream, constantPool);
    }

    public static void scanAttributes(Function1<DataStream, Function1<Names.SimpleName, Object>> function1, DataStream dataStream, ConstantPool constantPool) {
        ClassfileReader$.MODULE$.scanAttributes(function1, dataStream, constantPool);
    }

    public static Forked<DataStream> skipAttributes(DataStream dataStream) {
        return ClassfileReader$.MODULE$.skipAttributes(dataStream);
    }

    public static Forked<DataStream> skipFields(DataStream dataStream) {
        return ClassfileReader$.MODULE$.skipFields(dataStream);
    }

    public static Forked<DataStream> skipMethods(DataStream dataStream) {
        return ClassfileReader$.MODULE$.skipMethods(dataStream);
    }

    public static <T> T unpickle(Classpaths.ClassData classData, Function1<DataStream, T> function1) {
        return ClassfileReader$.MODULE$.unpickle(classData, function1);
    }

    public static class Annotation
    implements Product,
    Serializable {
        private final Names.SimpleName tpe;
        private final Tuple2[] values;

        public static Annotation apply(Names.SimpleName simpleName, Tuple2<Names.SimpleName, AnnotationValue>[] tuple2Array) {
            return ClassfileReader$Annotation$.MODULE$.apply(simpleName, tuple2Array);
        }

        public static Annotation fromProduct(Product product) {
            return ClassfileReader$Annotation$.MODULE$.fromProduct(product);
        }

        public static Annotation unapply(Annotation annotation) {
            return ClassfileReader$Annotation$.MODULE$.unapply(annotation);
        }

        public Annotation(Names.SimpleName tpe, Tuple2<Names.SimpleName, AnnotationValue>[] values) {
            this.tpe = tpe;
            this.values = values;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Annotation)) return false;
            Annotation annotation = (Annotation)object;
            Names.SimpleName simpleName = this.tpe();
            Names.SimpleName simpleName2 = annotation.tpe();
            if (simpleName == null) {
                if (simpleName2 != null) {
                    return false;
                }
            } else if (!((Object)simpleName).equals(simpleName2)) return false;
            if (this.values() != annotation.values()) return false;
            if (!annotation.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Annotation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Annotation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tpe";
            }
            if (1 == n2) {
                return "values";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Names.SimpleName tpe() {
            return this.tpe;
        }

        public Tuple2<Names.SimpleName, AnnotationValue>[] values() {
            return this.values;
        }

        public Annotation copy(Names.SimpleName tpe, Tuple2<Names.SimpleName, AnnotationValue>[] values) {
            return new Annotation(tpe, values);
        }

        public Names.SimpleName copy$default$1() {
            return this.tpe();
        }

        public Tuple2<Names.SimpleName, AnnotationValue>[] copy$default$2() {
            return this.values();
        }

        public Names.SimpleName _1() {
            return this.tpe();
        }

        public Tuple2<Names.SimpleName, AnnotationValue>[] _2() {
            return this.values();
        }
    }

    public static abstract class AnnotationValue
    implements Product,
    Enum {
        public static AnnotationValue fromOrdinal(int n) {
            return ClassfileReader$AnnotationValue$.MODULE$.fromOrdinal(n);
        }
    }

    public static abstract class ConstantInfo
    implements Product,
    Enum {
        public static CanEqual<ConstantInfo, ConstantInfo> derived$CanEqual() {
            return ClassfileReader$ConstantInfo$.MODULE$.derived$CanEqual();
        }

        public static ConstantInfo fromOrdinal(int n) {
            return ClassfileReader$ConstantInfo$.MODULE$.fromOrdinal(n);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ConstantPool {
        private final int count;
        private final ConstantInfo[] infos;
        private int index;
        private boolean seensigbytes;

        public ConstantPool(int count) {
            this.count = count;
            this.infos = new ConstantInfo[count];
            this.index = 1;
            this.seensigbytes = false;
        }

        public ConstantInfo.Class cls(int idx) {
            return (ConstantInfo.Class)this.infos[idx];
        }

        public Names.SimpleName utf8(int idx) {
            ConstantInfo constantInfo = this.apply(idx);
            if (constantInfo instanceof ConstantInfo.Utf8) {
                ConstantInfo.Utf8 utf8 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo);
                Object object = utf8._1();
                if (object instanceof Names.SimpleName) {
                    Names.SimpleName name = (Names.SimpleName)object;
                    return name;
                }
                if (object instanceof Forked) {
                    Forked forked = (Forked)object;
                    Names.SimpleName name = Names$.MODULE$.termName((String)forked.use((Function1 & Serializable)evidence$3 -> evidence$3.readUTF8()));
                    this.infos[idx] = ClassfileReader$ConstantInfo$Utf8$.MODULE$.apply(name);
                    return name;
                }
            }
            throw new Exceptions.ClassfileFormatException(new StringBuilder(23).append("Expected UTF8 at index ").append(idx).toString());
        }

        public int integer(int idx) {
            ConstantInfo constantInfo = this.apply(idx);
            if (constantInfo instanceof ConstantInfo.Integer) {
                int n;
                ConstantInfo.Integer integer = ClassfileReader$ConstantInfo$Integer$.MODULE$.unapply((ConstantInfo.Integer)constantInfo);
                int value = n = integer._1();
                return value;
            }
            throw new Exceptions.ClassfileFormatException(new StringBuilder(26).append("Expected Integer at index ").append(idx).toString());
        }

        public long long(int idx) {
            ConstantInfo constantInfo = this.apply(idx);
            if (constantInfo instanceof ConstantInfo.Long) {
                long l;
                ConstantInfo.Long longVal = ClassfileReader$ConstantInfo$Long$.MODULE$.unapply((ConstantInfo.Long)constantInfo);
                long value = l = longVal._1();
                return value;
            }
            throw new Exceptions.ClassfileFormatException(new StringBuilder(23).append("Expected Long at index ").append(idx).toString());
        }

        public float float(int idx) {
            ConstantInfo constantInfo = this.apply(idx);
            if (constantInfo instanceof ConstantInfo.Float) {
                float f;
                ConstantInfo.Float float_ = ClassfileReader$ConstantInfo$Float$.MODULE$.unapply((ConstantInfo.Float)constantInfo);
                float value = f = float_._1();
                return value;
            }
            throw new Exceptions.ClassfileFormatException(new StringBuilder(24).append("Expected Float at index ").append(idx).toString());
        }

        public double double(int idx) {
            ConstantInfo constantInfo = this.apply(idx);
            if (constantInfo instanceof ConstantInfo.Double) {
                double d;
                ConstantInfo.Double double_ = ClassfileReader$ConstantInfo$Double$.MODULE$.unapply((ConstantInfo.Double)constantInfo);
                double value = d = double_._1();
                return value;
            }
            throw new Exceptions.ClassfileFormatException(new StringBuilder(25).append("Expected Double at index ").append(idx).toString());
        }

        public byte[] sigbytes(int idx) {
            return this.decodeSigBytes(this.encodedSigbytes(idx));
        }

        public byte[] sigbytes(int[] idxs) {
            return this.decodeSigBytes((byte[])IArray.package.IArray$.MODULE$.flatMap((Object)idxs, (Function1 & Serializable)idx -> this.sigbytes$$anonfun$1(BoxesRunTime.unboxToInt((Object)idx)), ClassTag$.MODULE$.apply(Byte.TYPE)));
        }

        private byte[] encodedSigbytes(int idx) {
            ConstantInfo.Utf8 utf8;
            Object object;
            ConstantInfo constantInfo = this.apply(idx);
            if (constantInfo instanceof ConstantInfo.Utf8 && (object = (utf8 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo))._1()) instanceof Forked) {
                Forked forked = (Forked)object;
                return (byte[])forked.use((Function1 & Serializable)evidence$4 -> evidence$4.readSlice(evidence$4.readU2()));
            }
            throw new Exceptions.ClassfileFormatException(new StringBuilder(41).append("Expected unforced UTF8 constant at index ").append(idx).toString());
        }

        private byte[] decodeSigBytes(byte[] bytes) {
            byte[] buffer = (byte[])Array$.MODULE$.from((IterableOnce)IArray.package.IArray$.MODULE$.wrapByteIArray(bytes), ClassTag$.MODULE$.apply(Byte.TYPE));
            int decodedLength = ByteCodecs$.MODULE$.decode(buffer);
            return (byte[])IArray.package.IArray$.MODULE$.take(IArray.package.IArray$.MODULE$.unsafeFromArray((Object)buffer), decodedLength);
        }

        public int idx(int i) {
            return ClassfileReader$Indexing$.MODULE$.idx(i);
        }

        /*
         * Unable to fully structure code
         */
        public boolean add(ConstantInfo info) {
            block2: {
                this.infos[this.index] = info;
                var3_2 = info;
                if (!(var3_2 instanceof ConstantInfo.Long)) break block2;
                var4_3 = ClassfileReader$ConstantInfo$Long$.MODULE$.unapply((ConstantInfo.Long)var3_2);
                var5_4 = var4_3._1();
                ** GOTO lbl11
            }
            if (var3_2 instanceof ConstantInfo.Double) {
                var7_5 = ClassfileReader$ConstantInfo$Double$.MODULE$.unapply((ConstantInfo.Double)var3_2);
                var8_6 = var7_5._1();
lbl11:
                // 2 sources

                v0 = 2;
            } else {
                v0 = 1;
            }
            jump = v0;
            this.index += jump;
            return this.index < this.count;
        }

        public ConstantInfo apply(int index) {
            if (index < 1 || index >= this.infos.length) {
                throw new Exceptions.ClassfileFormatException(new StringBuilder(28).append("Invalid constant pool index ").append(index).toString());
            }
            return this.infos[index];
        }

        public ConstantInfo force(int index) {
            ConstantInfo constantInfo = this.apply(index);
            if (constantInfo instanceof ConstantInfo.Utf8) {
                ConstantInfo.Utf8 utf8 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo);
                Object object = utf8._1();
                this.utf8(index);
                return this.infos[index];
            }
            ConstantInfo info = constantInfo;
            return info;
        }

        private final /* synthetic */ IterableOnce sigbytes$$anonfun$1(int idx) {
            return IArray.package.IArray$.MODULE$.wrapByteIArray(this.encodedSigbytes(idx));
        }

        private final ConstantInfo forced$1() {
            return this.force(this.idx(this.index));
        }

        private final void doprint$1() {
            Predef$.MODULE$.println((Object)new StringBuilder(7).append("pool ").append(this.index).append(": ").append(this.forced$1()).toString());
        }

        private final void debug$1() {
            block4: {
                block5: {
                    Names.SimpleName simpleName;
                    String string;
                    ConstantInfo.Utf8 utf8;
                    Object object;
                    ConstantInfo constantInfo;
                    block7: {
                        Object object2;
                        Names.SimpleName simpleName2;
                        block9: {
                            Object object3;
                            block8: {
                                Object object4;
                                Names.SimpleName simpleName3;
                                block6: {
                                    ConstantInfo constantInfo2 = this.infos[this.index];
                                    if (!(constantInfo2 instanceof ConstantInfo.Utf8)) break block4;
                                    ConstantInfo.Utf8 utf82 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo2);
                                    Object object5 = utf82._1();
                                    if (this.seensigbytes || this.index <= 3) break block4;
                                    Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this.force(this.idx(this.index - 2)), (Object)this.force(this.idx(this.index - 1)));
                                    ConstantInfo constantInfo3 = (ConstantInfo)tuple2._1();
                                    constantInfo = (ConstantInfo)tuple2._2();
                                    if (!(constantInfo3 instanceof ConstantInfo.Utf8)) break block5;
                                    ConstantInfo.Utf8 utf83 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo3);
                                    object3 = utf83._1();
                                    simpleName3 = Constants$annot$.MODULE$.ScalaLongSignature();
                                    object4 = object3;
                                    if (simpleName3 != null) break block6;
                                    if (object4 == null) break block7;
                                    break block8;
                                }
                                if (((Object)simpleName3).equals(object4)) break block7;
                            }
                            simpleName2 = Constants$annot$.MODULE$.ScalaSignature();
                            object2 = object3;
                            if (simpleName2 != null) break block9;
                            if (object2 == null) break block7;
                            break block5;
                        }
                        if (!((Object)simpleName2).equals(object2)) break block5;
                    }
                    if (constantInfo instanceof ConstantInfo.Utf8 && (object = (utf8 = ClassfileReader$ConstantInfo$Utf8$.MODULE$.unapply((ConstantInfo.Utf8)constantInfo))._1()) instanceof Names.SimpleName && "bytes".equals(string = (simpleName = Names$SimpleName$.MODULE$.unapply((Names.SimpleName)object))._1())) {
                        this.seensigbytes = true;
                        Predef$.MODULE$.println((Object)new StringBuilder(33).append("pool ").append(this.index).append(": Utf8/<ScalaSignatureBytes>").toString());
                        return;
                    }
                }
                this.doprint$1();
                return;
            }
            this.doprint$1();
        }
    }

    public static interface DataStream {
        public int readU1();

        public int readU2();

        public int readU4();

        public float readU4f();

        public long readU8();

        public double readU8f();

        public String readUTF8();

        public byte[] readSlice(int var1);

        public void skip(int var1);

        public Forked<DataStream> fork();
    }

    public static class Structure {
        private final int access;
        private final Names.SimpleName binaryName;
        private final Forked supers;
        private final Forked fields;
        private final Forked methods;
        private final Forked attributes;
        private final ConstantPool pool;

        public Structure(int access, Names.SimpleName binaryName, Forked<DataStream> supers, Forked<DataStream> fields, Forked<DataStream> methods, Forked<DataStream> attributes, ConstantPool pool) {
            this.access = access;
            this.binaryName = binaryName;
            this.supers = supers;
            this.fields = fields;
            this.methods = methods;
            this.attributes = attributes;
            this.pool = pool;
        }

        public int access() {
            return this.access;
        }

        public Names.SimpleName binaryName() {
            return this.binaryName;
        }

        public Forked<DataStream> supers() {
            return this.supers;
        }

        public Forked<DataStream> fields() {
            return this.fields;
        }

        public Forked<DataStream> methods() {
            return this.methods;
        }

        public Forked<DataStream> attributes() {
            return this.attributes;
        }

        public ConstantPool pool() {
            return this.pool;
        }
    }
}

