/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.IArray;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import tastyquery.Classpaths;
import tastyquery.Contexts;
import tastyquery.Exceptions;
import tastyquery.Names;
import tastyquery.Names$;
import tastyquery.Names$ObjectClassName$;
import tastyquery.Names$PackageFullName$;
import tastyquery.Names$nme$;
import tastyquery.Symbols;
import tastyquery.Trees;
import tastyquery.reader.ReaderContext;
import tastyquery.reader.classfiles.ClassfileParser;
import tastyquery.reader.classfiles.ClassfileParser$;
import tastyquery.reader.classfiles.ClassfileParser$ClassKind$;
import tastyquery.reader.classfiles.ClassfileReader;
import tastyquery.reader.classfiles.ClassfileReader$;
import tastyquery.reader.tasties.TastyUnpickler;
import tastyquery.reader.tasties.TreeUnpickler;

public final class Loaders {

    public static class Loader {
        private final List classpath;
        private ClassfileParser.Resolver given_Resolver$lzy1;
        private boolean given_Resolverbitmap$1;
        private boolean initialized;
        private Map<Symbols.PackageSymbol, PackageLoadingInfo> packages;
        private boolean _hasGenericTuples;
        private Map byEntry;

        public Loader(List<Classpaths.ClasspathEntry> classpath) {
            this.classpath = classpath;
            this.initialized = false;
            this.byEntry = null;
        }

        public List<Classpaths.ClasspathEntry> classpath() {
            return this.classpath;
        }

        public final ClassfileParser.Resolver given_Resolver() {
            if (!this.given_Resolverbitmap$1) {
                this.given_Resolver$lzy1 = new ClassfileParser.Resolver();
                this.given_Resolverbitmap$1 = true;
            }
            return this.given_Resolver$lzy1;
        }

        private Names.PackageFullName toPackageName(String dotSeparated) {
            List list;
            if (dotSeparated.isEmpty()) {
                Names.SimpleName simpleName = Names$nme$.MODULE$.EmptyPackageName();
                list = package$.MODULE$.Nil().$colon$colon((Object)simpleName);
            } else {
                list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(dotSeparated), '.')).toList().map((Function1 & Serializable)_$2 -> Names$.MODULE$.termName((String)_$2));
            }
            List parts = list;
            return Names$PackageFullName$.MODULE$.apply((List<Names.SimpleName>)parts);
        }

        private String topLevelSymbolNameToRootName(Names.Name name) {
            Names.Name name2;
            while (true) {
                Names.SimpleName simpleName;
                if ((name2 = name) instanceof Names.TypeName) {
                    Names.TypeName name3 = (Names.TypeName)name2;
                    name = name3.toTermName();
                    continue;
                }
                if (!(name2 instanceof Names.ObjectClassName)) break;
                Names.ObjectClassName objectClassName = Names$ObjectClassName$.MODULE$.unapply((Names.ObjectClassName)name2);
                Names.SimpleName objName = simpleName = objectClassName._1();
                name = objName;
            }
            if (name2 instanceof Names.SimpleName) {
                Names.SimpleName name4 = (Names.SimpleName)name2;
                return NameTransformer$.MODULE$.encode(name4.name());
            }
            throw new IllegalStateException(new StringBuilder(30).append("Invalid top-level symbol name ").append(name.toDebugString()).toString());
        }

        private Names.SimpleName rootNameToTopLevelTermSymbolName(String rootName) {
            return Names$.MODULE$.termName(NameTransformer$.MODULE$.decode(rootName));
        }

        public Option<List<Trees.Tree>> topLevelTasty(Symbols.Symbol rootSymbol, Contexts.Context x$2) {
            Symbols.Symbol symbol = rootSymbol.owner();
            if (symbol instanceof Symbols.PackageSymbol) {
                Symbols.PackageSymbol pkg = (Symbols.PackageSymbol)symbol;
                String rootName = this.topLevelSymbolNameToRootName((Names.Name)((Object)rootSymbol.name()));
                return this.packages.get((Object)pkg).flatMap((Function1 & Serializable)_$3 -> _$3.topLevelTastyFor(rootName));
            }
            return None$.MODULE$;
        }

        public void loadAllRoots(Symbols.PackageSymbol pkg, Contexts.Context x$2) {
            this.packages.get((Object)pkg).foreach((Function1 & Serializable)loadingInfo -> {
                this.loadAllRoots$$anonfun$2(x$2, (PackageLoadingInfo)loadingInfo);
                return BoxedUnit.UNIT;
            });
        }

        public void loadAllPackageObjectRoots(Symbols.PackageSymbol pkg, Contexts.Context x$2) {
            this.packages.get((Object)pkg).foreach((Function1 & Serializable)loadingInfo -> {
                this.loadAllPackageObjectRoots$$anonfun$2(x$2, (PackageLoadingInfo)loadingInfo);
                return BoxedUnit.UNIT;
            });
        }

        public boolean loadRoot(Symbols.PackageSymbol pkg, Names.Name name, Contexts.Context x$3) {
            Option option = this.packages.get((Object)pkg);
            if (option instanceof Some) {
                PackageLoadingInfo loadingInfo = (PackageLoadingInfo)((Some)option).value();
                String rootName = this.topLevelSymbolNameToRootName(name);
                return loadingInfo.loadOneRoot(rootName, new ReaderContext(x$3), this.given_Resolver());
            }
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            throw new MatchError((Object)option);
        }

        public Option<Iterable<Symbols.TermOrTypeSymbol>> lookupByEntry(Classpaths.ClasspathEntry src, Contexts.Context x$2) {
            Map localByEntry = this.byEntry;
            if (localByEntry == null) {
                Map<Classpaths.ClasspathEntry, Tuple2<Symbols.PackageSymbol, String[]>[]> newByEntry;
                this.byEntry = newByEntry = this.computeByEntry(x$2);
                return this.computeLookup$1(src, x$2, newByEntry);
            }
            return this.computeLookup$1(src, x$2, localByEntry);
        }

        public void initPackages(Contexts.Context ctx) {
            if (this.initialized) {
                throw new IllegalStateException("Classloader was already initialized");
            }
            this.initialized = true;
            Map rawMap = this.loadPackages$1(ctx).groupBy((Function1 & Serializable)_$4 -> (Symbols.PackageSymbol)_$4._1());
            this.packages = (Map)rawMap.map((Function1 & Serializable)x$1 -> {
                Symbols.PackageSymbol packageSymbol = (Symbols.PackageSymbol)x$1._1();
                List list = (List)x$1._2();
                Symbols.PackageSymbol packageSymbol2 = (Symbols.PackageSymbol)Predef$.MODULE$.ArrowAssoc((Object)packageSymbol);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)packageSymbol2, (Object)new PackageLoadingInfo(packageSymbol, (List<Classpaths.PackageData>)list.map((Function1 & Serializable)_$5 -> (Classpaths.PackageData)_$5._2())));
            });
            this._hasGenericTuples = rawMap.get((Object)ctx.defn().scalaPackage()).exists((Function1 & Serializable)_$6 -> _$6.exists((Function1 & Serializable)x$1 -> {
                Symbols.PackageSymbol packageSymbol = (Symbols.PackageSymbol)x$1._1();
                Classpaths.PackageData packageData = (Classpaths.PackageData)x$1._2();
                return packageData.getClassDataByBinaryName("$times$colon").isDefined();
            }));
        }

        public boolean hasGenericTuples() {
            return this._hasGenericTuples;
        }

        private Map<Classpaths.ClasspathEntry, Tuple2<Symbols.PackageSymbol, String[]>[]> computeByEntry(Contexts.Context x$1) {
            HashMap localByEntry = HashMap$.MODULE$.empty();
            HashMap localSeen = HashMap$.MODULE$.empty();
            HashMap localPackages = HashMap$.MODULE$.empty();
            this.classpath().foreach((Function1 & Serializable)entry -> {
                this.computeByEntry$$anonfun$1(x$1, localByEntry, localSeen, localPackages, (Classpaths.ClasspathEntry)entry);
                return BoxedUnit.UNIT;
            });
            return localByEntry.view().mapValues((Function1 & Serializable)entries -> (Tuple2[])IArray.package.IArray$.MODULE$.from((IterableOnce)entries.view().mapValues((Function1 & Serializable)it -> (String[])IArray.package.IArray$.MODULE$.from((IterableOnce)it, ClassTag$.MODULE$.apply(String.class))), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        private final /* synthetic */ void loadAllRoots$$anonfun$2(Contexts.Context x$2$6, PackageLoadingInfo loadingInfo) {
            loadingInfo.loadAllRoots(new ReaderContext(x$2$6), this.given_Resolver());
        }

        private final /* synthetic */ void loadAllPackageObjectRoots$$anonfun$2(Contexts.Context x$2$7, PackageLoadingInfo loadingInfo) {
            loadingInfo.loadAllPackageObjectRoots(new ReaderContext(x$2$7), this.given_Resolver());
        }

        private final void lookup$1(Contexts.Context x$2$8, Symbols.PackageSymbol pkg$1, Builder buf$1, Names.Name n) {
            pkg$1.getDecl(n, x$2$8).withFilter((Function1 & Serializable)x$1 -> {
                Symbols.Symbol symbol = x$1;
                if (symbol instanceof Symbols.TermOrTypeSymbol) {
                    Symbols.TermOrTypeSymbol t = (Symbols.TermOrTypeSymbol)symbol;
                    return true;
                }
                return false;
            }).foreach((Function1 & Serializable)x$1 -> {
                Symbols.Symbol symbol = x$1;
                if (symbol instanceof Symbols.TermOrTypeSymbol) {
                    Symbols.TermOrTypeSymbol t = (Symbols.TermOrTypeSymbol)symbol;
                    return (Builder)buf$1.$plus$eq((Object)t);
                }
                throw new MatchError((Object)symbol);
            });
        }

        private final /* synthetic */ void lookupRoots$1$$anonfun$1(Contexts.Context x$2$15, Symbols.PackageSymbol pkg$3, Builder buf$3, String rootName) {
            Names.SimpleName possibleTermName = this.rootNameToTopLevelTermSymbolName(rootName);
            this.lookup$1(x$2$15, pkg$3, buf$3, possibleTermName);
            this.lookup$1(x$2$15, pkg$3, buf$3, possibleTermName.toTypeName());
            this.lookup$1(x$2$15, pkg$3, buf$3, possibleTermName.withObjectSuffix().toTypeName());
        }

        private final Symbols.TermOrTypeSymbol[] lookupRoots$1(Contexts.Context x$2$9, Symbols.PackageSymbol pkg, String[] rootNames) {
            Builder buf = IArray.package.IArray$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(Symbols.TermOrTypeSymbol.class));
            IArray.package.IArray$.MODULE$.foreach((Object)rootNames, (Function1 & Serializable)rootName -> {
                this.lookupRoots$1$$anonfun$1(x$2$9, pkg, buf, (String)rootName);
                return BoxedUnit.UNIT;
            });
            return (Symbols.TermOrTypeSymbol[])buf.result();
        }

        private final Option computeLookup$1(Classpaths.ClasspathEntry src$1, Contexts.Context x$2$10, Map map) {
            Option option = map.get((Object)src$1);
            if (option instanceof Some) {
                Tuple2[] pkgs = (Tuple2[])((Some)option).value();
                return Some$.MODULE$.apply(IArray.package.IArray$.MODULE$.view((Object)pkgs).flatMap((Function1 & Serializable)x$1 -> {
                    Symbols.PackageSymbol packageSymbol = (Symbols.PackageSymbol)x$1._1();
                    String[] stringArray = (String[])x$1._2();
                    return IArray.package.IArray$.MODULE$.wrapRefArray((Object[])this.lookupRoots$1(x$2$10, packageSymbol, stringArray));
                }));
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        }

        private final Symbols.PackageSymbol createOrLookupPackage$1$$anonfun$1(Contexts.Context ctx$3, String pkgName$1) {
            return ctx$3.findPackageFromRootOrCreate(this.toPackageName(pkgName$1));
        }

        private final Symbols.PackageSymbol createOrLookupPackage$1(Contexts.Context ctx$1, HashMap localPackages$1, String pkgName) {
            return (Symbols.PackageSymbol)localPackages$1.getOrElseUpdate((Object)pkgName, () -> this.createOrLookupPackage$1$$anonfun$1(ctx$1, pkgName));
        }

        private final List loadPackages$1(Contexts.Context ctx$2) {
            HashMap localPackages = HashMap$.MODULE$.empty();
            return this.classpath().flatMap((Function1 & Serializable)entry -> entry.listAllPackages().map((Function1 & Serializable)pkg -> {
                Symbols.PackageSymbol packageSymbol = (Symbols.PackageSymbol)Predef$.MODULE$.ArrowAssoc((Object)this.createOrLookupPackage$1(ctx$2, localPackages, pkg.dotSeparatedName()));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)packageSymbol, pkg);
            }));
        }

        private final Symbols.PackageSymbol lookupPackage$1$$anonfun$1(Contexts.Context x$1$6, String pkgName$2) {
            return x$1$6.findPackageFromRoot(this.toPackageName(pkgName$2));
        }

        private final Symbols.PackageSymbol lookupPackage$1(Contexts.Context x$1$5, HashMap localPackages$2, String pkgName) {
            return (Symbols.PackageSymbol)localPackages$2.getOrElseUpdate((Object)pkgName, () -> this.lookupPackage$1$$anonfun$1(x$1$5, pkgName));
        }

        private final HashSet $anonfun$4() {
            return HashSet$.MODULE$.empty();
        }

        private final HashMap computeByEntry$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
            return HashMap$.MODULE$.empty();
        }

        private final HashSet computeByEntry$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2() {
            return HashSet$.MODULE$.empty();
        }

        private final /* synthetic */ void computeByEntry$$anonfun$1$$anonfun$1$$anonfun$1(HashMap localByEntry$3, Classpaths.ClasspathEntry entry$2, Symbols.PackageSymbol pkg$2, HashSet localSeenForThisPackage$1, Classpaths.ClassData classData) {
            String localBinaryName = classData.binaryName();
            if (localSeenForThisPackage$1.add((Object)localBinaryName)) {
                ((HashSet)((HashMap)localByEntry$3.getOrElseUpdate((Object)entry$2, this::computeByEntry$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1)).getOrElseUpdate((Object)pkg$2, this::computeByEntry$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2)).add((Object)localBinaryName);
                return;
            }
        }

        private final /* synthetic */ void computeByEntry$$anonfun$1$$anonfun$1(Contexts.Context x$1$8, HashMap localByEntry$2, HashMap localSeen$2, HashMap localPackages$4, Classpaths.ClasspathEntry entry$1, Classpaths.PackageData pkgData) {
            Symbols.PackageSymbol pkg = this.lookupPackage$1(x$1$8, localPackages$4, pkgData.dotSeparatedName());
            HashSet localSeenForThisPackage = (HashSet)localSeen$2.getOrElseUpdate((Object)pkg, this::$anonfun$4);
            pkgData.listAllClassDatas().foreach((Function1 & Serializable)classData -> {
                this.computeByEntry$$anonfun$1$$anonfun$1$$anonfun$1(localByEntry$2, entry$1, pkg, localSeenForThisPackage, (Classpaths.ClassData)classData);
                return BoxedUnit.UNIT;
            });
        }

        private final /* synthetic */ void computeByEntry$$anonfun$1(Contexts.Context x$1$7, HashMap localByEntry$1, HashMap localSeen$1, HashMap localPackages$3, Classpaths.ClasspathEntry entry) {
            entry.listAllPackages().foreach((Function1 & Serializable)pkgData -> {
                this.computeByEntry$$anonfun$1$$anonfun$1(x$1$7, localByEntry$1, localSeen$1, localPackages$3, entry, (Classpaths.PackageData)pkgData);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final class PackageLoadingInfo {
        private final Symbols.PackageSymbol pkg;
        private List<Classpaths.PackageData> initPackageData;
        private HashMap dataByBinaryName$lzy1;
        private boolean dataByBinaryNamebitmap$1;
        private final HashMap<String, List<Trees.Tree>> topLevelTastys;
        private String fullBinaryNamePrefix$lzy1;
        private boolean fullBinaryNamePrefixbitmap$1;

        public PackageLoadingInfo(Symbols.PackageSymbol pkg, List<Classpaths.PackageData> initPackageData) {
            this.pkg = pkg;
            this.initPackageData = initPackageData;
            this.topLevelTastys = HashMap$.MODULE$.empty();
        }

        public Symbols.PackageSymbol pkg() {
            return this.pkg;
        }

        /*
         * WARNING - void declaration
         */
        private HashMap<String, Classpaths.ClassData> dataByBinaryName() {
            if (!this.dataByBinaryNamebitmap$1) {
                void var1_1;
                HashMap localRoots = HashMap$.MODULE$.empty();
                this.initPackageData.foreach((Function1 & Serializable)packageData -> {
                    this.dataByBinaryName$$anonfun$1(localRoots, (Classpaths.PackageData)packageData);
                    return BoxedUnit.UNIT;
                });
                this.dataByBinaryName$lzy1 = var1_1;
                this.dataByBinaryNamebitmap$1 = true;
                this.initPackageData = null;
            }
            return this.dataByBinaryName$lzy1;
        }

        public Option<List<Trees.Tree>> topLevelTastyFor(String rootName) {
            return this.topLevelTastys.get((Object)rootName);
        }

        public void loadAllRoots(ReaderContext x$1, ClassfileParser.Resolver x$2) {
            List allNames = (List)this.dataByBinaryName().keysIterator().toList().sorted((Ordering)Ordering.String$.MODULE$);
            this.loadingRoots((Function1 & Serializable)loadedFiles -> {
                this.loadAllRoots$$anonfun$1(x$1, x$2, allNames, (HashSet)loadedFiles);
                return BoxedUnit.UNIT;
            });
            this.dataByBinaryName().clear();
        }

        public void loadAllPackageObjectRoots(ReaderContext x$1, ClassfileParser.Resolver x$2) {
            List candidateNames = (List)this.dataByBinaryName().keysIterator().filter((Function1 & Serializable)_$1 -> this.isPackageObjectBinaryName$1((String)_$1)).toList().sorted((Ordering)Ordering.String$.MODULE$);
            this.loadingRoots((Function1 & Serializable)loadedFiles -> {
                this.loadAllPackageObjectRoots$$anonfun$1(x$1, x$2, candidateNames, (HashSet)loadedFiles);
                return BoxedUnit.UNIT;
            });
        }

        public boolean loadOneRoot(String binaryName, ReaderContext x$2, ClassfileParser.Resolver x$3) {
            return BoxesRunTime.unboxToBoolean(this.loadingRoots((Function1 & Serializable)loadedFiles -> this.tryLoadRoot(binaryName, (HashSet<String>)loadedFiles, x$2, x$3)));
        }

        private <A> A loadingRoots(Function1<HashSet<String>, A> op) {
            HashSet loadedFiles = HashSet$.MODULE$.empty();
            Object result = op.apply((Object)loadedFiles);
            this.dataByBinaryName().$minus$minus$eq((IterableOnce)loadedFiles);
            return (A)result;
        }

        private boolean tryLoadRoot(String binaryName, HashSet<String> loadedFiles, ReaderContext x$3, ClassfileParser.Resolver x$4) {
            Option option = this.dataByBinaryName().get((Object)binaryName);
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            if (option instanceof Some) {
                Classpaths.ClassData classData = (Classpaths.ClassData)((Some)option).value();
                if (loadedFiles.add((Object)binaryName)) {
                    if (classData.hasTastyFile()) {
                        this.doLoadTasty(classData, x$3);
                        return true;
                    }
                    if (this.doLoadClassFile(classData, loadedFiles, x$3, x$4)) {
                        return true;
                    }
                    loadedFiles.$minus$eq((Object)binaryName);
                    return false;
                }
                return false;
            }
            throw new MatchError((Object)option);
        }

        private String fullBinaryNamePrefix() {
            if (!this.fullBinaryNamePrefixbitmap$1) {
                this.fullBinaryNamePrefix$lzy1 = this.pkg().isEmptyPackage() ? "" : this.pkg().fullName().path().mkString("", "/", "/");
                this.fullBinaryNamePrefixbitmap$1 = true;
            }
            return this.fullBinaryNamePrefix$lzy1;
        }

        public boolean doLoadClassFile(Classpaths.ClassData classData, HashSet<String> loadedFiles, ReaderContext x$3, ClassfileParser.Resolver x$4) {
            ClassfileParser.ClassKind kind;
            ClassfileReader.Structure structure = ClassfileReader$.MODULE$.readStructure(this.pkg(), classData);
            ClassfileParser.ClassKind classKind = kind = ClassfileParser$.MODULE$.detectClassKind(structure);
            ClassfileParser.ClassKind classKind2 = ClassfileParser$ClassKind$.Scala2;
            ClassfileParser.ClassKind classKind3 = classKind;
            if (!(classKind2 != null ? !classKind2.equals(classKind3) : classKind3 != null)) {
                ClassfileParser$.MODULE$.loadScala2Class(structure, x$3);
                return true;
            }
            ClassfileParser.ClassKind classKind4 = ClassfileParser$ClassKind$.Java;
            ClassfileParser.ClassKind classKind5 = classKind;
            if (!(classKind4 != null ? !classKind4.equals(classKind5) : classKind5 != null)) {
                List<ClassfileParser.InnerClassDecl> innerDecls = ClassfileParser$.MODULE$.loadJavaClass(this.pkg(), Names$.MODULE$.termName(classData.binaryName()), structure, x$3, x$4);
                this.doLoadJavaInnerClasses(innerDecls, loadedFiles, x$3, x$4);
                return true;
            }
            ClassfileParser.ClassKind classKind6 = ClassfileParser$ClassKind$.TASTy;
            ClassfileParser.ClassKind classKind7 = classKind;
            if (!(classKind6 != null ? !classKind6.equals(classKind7) : classKind7 != null)) {
                throw new Exceptions.TastyFormatException(new StringBuilder(41).append("Missing TASTy file for class ").append(classData.binaryName()).append(" in package ").append(this.pkg()).toString());
            }
            ClassfileParser.ClassKind classKind8 = ClassfileParser$ClassKind$.ScalaArtifact;
            ClassfileParser.ClassKind classKind9 = classKind;
            if (!(classKind8 != null ? !classKind8.equals(classKind9) : classKind9 != null)) {
                return true;
            }
            ClassfileParser.ClassKind classKind10 = ClassfileParser$ClassKind$.JavaInnerOrArtifact;
            ClassfileParser.ClassKind classKind11 = classKind;
            if (!(classKind10 != null ? !classKind10.equals(classKind11) : classKind11 != null)) {
                return false;
            }
            throw new MatchError((Object)classKind);
        }

        private void doLoadJavaInnerClasses(List<ClassfileParser.InnerClassDecl> explore, HashSet<String> loadedFiles, ReaderContext x$3, ClassfileParser.Resolver x$4) {
            List list;
            while ((list = explore) instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list2 = colon2.next$access$1();
                ClassfileParser.InnerClassDecl inner = (ClassfileParser.InnerClassDecl)colon2.head();
                List rest = list2;
                Names.SimpleName innerSimpleName = inner.innerSimpleName();
                String localBinaryName = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(inner.innerBinaryName().name()), this.fullBinaryNamePrefix());
                Option option = this.dataByBinaryName().get((Object)localBinaryName);
                if (option instanceof Some) {
                    Classpaths.ClassData innerData = (Classpaths.ClassData)((Some)option).value();
                    if (!loadedFiles.contains((Object)localBinaryName)) {
                        loadedFiles.$plus$eq((Object)localBinaryName);
                        ClassfileReader.Structure structure = ClassfileReader$.MODULE$.readStructure(inner.owner(), innerData);
                        List<ClassfileParser.InnerClassDecl> innerDecls = ClassfileParser$.MODULE$.loadJavaClass(inner.owner(), innerSimpleName, structure, x$3, x$4);
                        explore = innerDecls.$colon$colon$colon(rest);
                        continue;
                    }
                }
                throw new Exceptions.ClassfileFormatException(new StringBuilder(45).append("Inner class ").append(localBinaryName).append(" not found in package ").append(this.pkg()).append(" for owner ").append(inner.owner()).toString());
            }
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                return;
            }
            throw new MatchError(list);
        }

        private void doLoadTasty(Classpaths.ClassData classData, ReaderContext x$2) {
            TastyUnpickler unpickler = new TastyUnpickler(classData.readTastyFileBytes());
            String debugPath = classData.toString();
            List<Trees.Tree> trees = ((TreeUnpickler)unpickler.unpickle(debugPath, new TastyUnpickler.TreeSectionUnpickler(unpickler.unpickle(debugPath, new TastyUnpickler.PositionSectionUnpickler(), x$2)), x$2).get()).unpickle();
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)classData.binaryName());
            this.topLevelTastys.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, trees));
        }

        private final Classpaths.ClassData dataByBinaryName$$anonfun$1$$anonfun$1$$anonfun$1(Classpaths.ClassData classData$1) {
            return classData$1;
        }

        private final /* synthetic */ void dataByBinaryName$$anonfun$1(HashMap localRoots$1, Classpaths.PackageData packageData) {
            packageData.listAllClassDatas().foreach((Function1 & Serializable)classData -> (Classpaths.ClassData)localRoots$1.getOrElseUpdate((Object)classData.binaryName(), () -> this.dataByBinaryName$$anonfun$1$$anonfun$1$$anonfun$1(classData)));
        }

        private final /* synthetic */ void loadAllRoots$$anonfun$1(ReaderContext x$1$1, ClassfileParser.Resolver x$2$1, List allNames$1, HashSet loadedFiles) {
            allNames$1.foreach((Function1 & Serializable)rootName -> this.tryLoadRoot((String)rootName, (HashSet<String>)loadedFiles, x$1$1, x$2$1));
        }

        private final boolean isPackageObjectBinaryName$1(String name) {
            String string = name;
            String string2 = "package";
            return !(string == null ? string2 != null : !string.equals(string2)) || name.endsWith("$package");
        }

        private final /* synthetic */ void loadAllPackageObjectRoots$$anonfun$1(ReaderContext x$1$3, ClassfileParser.Resolver x$2$3, List candidateNames$1, HashSet loadedFiles) {
            candidateNames$1.foreach((Function1 & Serializable)rootName -> this.tryLoadRoot((String)rootName, (HashSet<String>)loadedFiles, x$1$3, x$2$3));
        }
    }
}

