/*
 * Decompiled with CFR 0.152.
 */
package tastyquery;

import scala.runtime.Scala3RunTime$;
import tastyquery.SourceFile;
import tastyquery.SourceFile$;
import tastyquery.SourcePosition$;
import tastyquery.Spans;
import tastyquery.Spans$Span$;

public final class SourcePosition {
    private final SourceFile sourceFile;
    private final long span;

    public static SourcePosition NoPosition() {
        return SourcePosition$.MODULE$.NoPosition();
    }

    public static SourcePosition auto(SourceFile sourceFile, long l) {
        return SourcePosition$.MODULE$.auto(sourceFile, l);
    }

    public SourcePosition(SourceFile sourceFile, long span) {
        this.sourceFile = sourceFile;
        this.span = span;
    }

    public SourceFile sourceFile() {
        return this.sourceFile;
    }

    public long span() {
        return this.span;
    }

    public String toString() {
        return new StringBuilder(1).append(this.sourceFile()).append(":").append(new Spans.Span(this.span())).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAuto() {
        if (Spans$Span$.MODULE$.exists$extension(this.span())) return false;
        SourceFile sourceFile = this.sourceFile();
        SourceFile sourceFile2 = SourceFile$.MODULE$.NoSource();
        if (sourceFile == null) {
            if (sourceFile2 == null) return false;
            return true;
        } else if (sourceFile.equals(sourceFile2)) return false;
        return true;
    }

    public boolean isUnknown() {
        return !Spans$Span$.MODULE$.exists$extension(this.span());
    }

    public boolean hasLineColumnInformation() {
        return this.sourceFile().hasLineColumnInformation();
    }

    public int pointOffset() {
        return Spans$Span$.MODULE$.point$extension(this.span());
    }

    public int pointLine() {
        return this.sourceFile().offsetToLine(this.pointOffset());
    }

    public int pointColumn() {
        return this.sourceFile().offsetToColumn(this.pointOffset());
    }

    public int startOffset() {
        return Spans$Span$.MODULE$.start$extension(this.span());
    }

    public int startLine() {
        return this.sourceFile().offsetToLine(this.startOffset());
    }

    public int startColumn() {
        return this.sourceFile().offsetToColumn(this.startOffset());
    }

    public int endOffset() {
        return Spans$Span$.MODULE$.end$extension(this.span());
    }

    public int endLine() {
        return this.sourceFile().offsetToLine(this.endOffset());
    }

    public int endColumn() {
        return this.sourceFile().offsetToColumn(this.endOffset());
    }

    public boolean isSynthetic() {
        return Spans$Span$.MODULE$.isSynthetic$extension(this.span());
    }

    public boolean isSourceDerived() {
        return Spans$Span$.MODULE$.isSourceDerived$extension(this.span());
    }

    public boolean isZeroExtent() {
        return Spans$Span$.MODULE$.isZeroExtent$extension(this.span());
    }

    public SourcePosition union(SourcePosition that) {
        if (this.isUnknown()) {
            return that;
        }
        if (that.isUnknown()) {
            return this;
        }
        SourceFile sourceFile = this.sourceFile();
        SourceFile sourceFile2 = that.sourceFile();
        if (sourceFile == null ? sourceFile2 != null : !sourceFile.equals(sourceFile2)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(4).append(this.sourceFile()).append(" != ").append(that.sourceFile()).toString());
        }
        return new SourcePosition(this.sourceFile(), Spans$Span$.MODULE$.union$extension(this.span(), that.span()));
    }
}

