/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.IArray;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.Scala3RunTime$;
import tastyquery.Classpaths;
import tastyquery.Contexts;
import tastyquery.Exceptions;
import tastyquery.Names;
import tastyquery.Names$;
import tastyquery.Names$ObjectClassName$;
import tastyquery.Names$PackageFullName$;
import tastyquery.Names$nme$;
import tastyquery.Symbols;
import tastyquery.Utils$;
import tastyquery.reader.Loaders$;
import tastyquery.reader.ReaderContext;
import tastyquery.reader.classfiles.ClassfileParser;
import tastyquery.reader.classfiles.ClassfileParser$;
import tastyquery.reader.classfiles.ClassfileParser$ClassKind$;
import tastyquery.reader.classfiles.ClassfileReader;
import tastyquery.reader.classfiles.ClassfileReader$;
import tastyquery.reader.tasties.TastyUnpickler;
import tastyquery.reader.tasties.TreeUnpickler;

public final class Loaders {

    public static class Loader {
        private final List<Classpaths.ClasspathEntry> classpath;
        private boolean initialized;
        private boolean _hasGenericTuples;
        private final AtomicReference<Map<Classpaths.ClasspathEntry, Tuple2<Symbols.PackageSymbol, String[]>[]>> byEntry;

        public Loader(List<Classpaths.ClasspathEntry> classpath) {
            Utils$ utils$;
            this.classpath = classpath;
            this.initialized = false;
            this._hasGenericTuples = false;
            Utils$ Utils$_this = utils$ = Utils$.MODULE$;
            this.byEntry = new AtomicReference();
        }

        public List<Classpaths.ClasspathEntry> classpath() {
            return this.classpath;
        }

        private Names.PackageFullName toPackageName(String dotSeparated) {
            List list;
            if (dotSeparated.isEmpty()) {
                Names.SimpleName simpleName = Names$nme$.MODULE$.EmptyPackageName();
                list = package$.MODULE$.Nil().$colon$colon((Object)simpleName);
            } else {
                list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(dotSeparated), '.')).toList().map(Loaders$::tastyquery$reader$Loaders$Loader$$_$_$$anonfun$2);
            }
            List parts = list;
            return Names$PackageFullName$.MODULE$.apply((List<Names.SimpleName>)parts);
        }

        private Names.SimpleName rootNameToTopLevelTermSymbolName(String rootName) {
            return Names$.MODULE$.termName(NameTransformer$.MODULE$.decode(rootName));
        }

        public Option<Iterable<Symbols.TermOrTypeSymbol>> lookupByEntry(Classpaths.ClasspathEntry src, Contexts.Context x$2) {
            Utils$ utils$ = Utils$.MODULE$;
            AtomicReference<Map<Classpaths.ClasspathEntry, Tuple2<Symbols.PackageSymbol, String[]>[]>> memo$proxy1 = this.byEntry;
            Map existing = memo$proxy1.get();
            Map localByEntry = existing != null ? existing : this.computeAndStore$1(x$2, memo$proxy1);
            return this.computeLookup$1(src, x$2, localByEntry);
        }

        public void initPackages(Contexts.Context ctx) {
            if (this.initialized) {
                throw new IllegalStateException("Classloader was already initialized");
            }
            this.initialized = true;
            this.loadPackages$1(ctx).groupBy(Loaders$::tastyquery$reader$Loaders$Loader$$_$initPackages$$anonfun$1).foreach((Function1 & Serializable)x$1 -> {
                this.initPackages$$anonfun$2((Tuple2)x$1);
                return BoxedUnit.UNIT;
            });
        }

        public boolean hasGenericTuples() {
            return this._hasGenericTuples;
        }

        private Map<Classpaths.ClasspathEntry, Tuple2<Symbols.PackageSymbol, String[]>[]> computeByEntry(Contexts.Context x$1) {
            HashMap localByEntry = HashMap$.MODULE$.empty();
            HashMap localSeen = HashMap$.MODULE$.empty();
            HashMap localPackages = HashMap$.MODULE$.empty();
            this.classpath().foreach((Function1 & Serializable)entry -> {
                this.computeByEntry$$anonfun$1(localSeen, localByEntry, localPackages, x$1, (Classpaths.ClasspathEntry)entry);
                return BoxedUnit.UNIT;
            });
            return localByEntry.view().mapValues(Loaders$::tastyquery$reader$Loaders$Loader$$_$computeByEntry$$anonfun$2).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        private final void lookup$1(Symbols.PackageSymbol pkg$1, Contexts.Context x$2$4, Builder buf$1, Names.Name n) {
            pkg$1.getDecl(n, x$2$4).withFilter(Loaders$::tastyquery$reader$Loaders$Loader$$_$lookup$1$$anonfun$1).foreach(arg_0 -> Loaders$.tastyquery$reader$Loaders$Loader$$_$lookup$1$$anonfun$2(buf$1, arg_0));
        }

        private final /* synthetic */ void lookupRoots$1$$anonfun$1(Symbols.PackageSymbol pkg$3, Contexts.Context x$2$9, Builder buf$3, String rootName) {
            Names.SimpleName possibleTermName = this.rootNameToTopLevelTermSymbolName(rootName);
            this.lookup$1(pkg$3, x$2$9, buf$3, possibleTermName);
            this.lookup$1(pkg$3, x$2$9, buf$3, possibleTermName.toTypeName());
            this.lookup$1(pkg$3, x$2$9, buf$3, possibleTermName.withObjectSuffix().toTypeName());
        }

        private final Symbols.TermOrTypeSymbol[] lookupRoots$1(Contexts.Context x$2$5, Symbols.PackageSymbol pkg, String[] rootNames) {
            Builder buf = IArray.package.IArray$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(Symbols.TermOrTypeSymbol.class));
            IArray.package.IArray$.MODULE$.foreach((Object)rootNames, (Function1 & Serializable)rootName -> {
                this.lookupRoots$1$$anonfun$1(pkg, x$2$5, buf, (String)rootName);
                return BoxedUnit.UNIT;
            });
            return (Symbols.TermOrTypeSymbol[])buf.result();
        }

        private final Option computeLookup$1(Classpaths.ClasspathEntry src$1, Contexts.Context x$2$6, Map map) {
            Option option = map.get((Object)src$1);
            if (option instanceof Some) {
                Tuple2[] pkgs = (Tuple2[])((Some)option).value();
                return Some$.MODULE$.apply(IArray.package.IArray$.MODULE$.view((Object)pkgs).flatMap((Function1 & Serializable)x$1 -> {
                    Symbols.PackageSymbol packageSymbol = (Symbols.PackageSymbol)x$1._1();
                    String[] stringArray = (String[])x$1._2();
                    return IArray.package.IArray$.MODULE$.wrapRefArray((Object[])this.lookupRoots$1(x$2$6, packageSymbol, stringArray));
                }));
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        }

        private final Map computeAndStore$1(Contexts.Context x$2$7, AtomicReference memo$proxy1$1) {
            Map<Classpaths.ClasspathEntry, Tuple2<Symbols.PackageSymbol, String[]>[]> computed = this.computeByEntry(x$2$7);
            if (memo$proxy1$1.compareAndSet(null, computed)) {
                return computed;
            }
            Map x$proxy1 = (Map)memo$proxy1$1.get();
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy1;
        }

        private final Symbols.PackageSymbol createOrLookupPackage$1$$anonfun$1(Contexts.Context ctx$3, String pkgName$1) {
            return ctx$3.findPackageFromRootOrCreate(this.toPackageName(pkgName$1));
        }

        private final Symbols.PackageSymbol createOrLookupPackage$1(HashMap localPackages$1, Contexts.Context ctx$1, String pkgName) {
            return (Symbols.PackageSymbol)localPackages$1.getOrElseUpdate((Object)pkgName, () -> this.createOrLookupPackage$1$$anonfun$1(ctx$1, pkgName));
        }

        private final List loadPackages$1(Contexts.Context ctx$2) {
            HashMap localPackages = HashMap$.MODULE$.empty();
            return this.classpath().flatMap((Function1 & Serializable)entry -> entry.listAllPackages().map((Function1 & Serializable)pkg -> {
                Symbols.PackageSymbol packageSymbol = (Symbols.PackageSymbol)Predef$.MODULE$.ArrowAssoc((Object)this.createOrLookupPackage$1(localPackages, ctx$2, pkg.dotSeparatedName()));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)packageSymbol, pkg);
            }));
        }

        private final /* synthetic */ void initPackages$$anonfun$2(Tuple2 x$1) {
            Tuple2 tuple2 = x$1;
            Symbols.PackageSymbol pkg = (Symbols.PackageSymbol)tuple2._1();
            List pairs = (List)tuple2._2();
            List initPackageData = pairs.map(Loaders$::tastyquery$reader$Loaders$Loader$$_$_$$anonfun$3);
            pkg.setLoadingInfo(new PackageLoadingInfo(pkg, (List<Classpaths.PackageData>)initPackageData));
            if (pkg.isScalaPackage()) {
                this._hasGenericTuples = initPackageData.exists(Loaders$::tastyquery$reader$Loaders$Loader$$_$initPackages$$anonfun$2$$anonfun$1);
                return;
            }
        }

        private final Symbols.PackageSymbol lookupPackage$1$$anonfun$1(Contexts.Context x$1$10, String pkgName$2) {
            return x$1$10.findPackageFromRoot(this.toPackageName(pkgName$2));
        }

        private final Symbols.PackageSymbol lookupPackage$1(HashMap localPackages$2, Contexts.Context x$1$9, String pkgName) {
            return (Symbols.PackageSymbol)localPackages$2.getOrElseUpdate((Object)pkgName, () -> this.lookupPackage$1$$anonfun$1(x$1$9, pkgName));
        }

        private final /* synthetic */ void computeByEntry$$anonfun$1$$anonfun$1(HashMap localSeen$2, HashMap localByEntry$2, Classpaths.ClasspathEntry entry$1, HashMap localPackages$4, Contexts.Context x$1$12, Classpaths.PackageData pkgData) {
            Symbols.PackageSymbol pkg = this.lookupPackage$1(localPackages$4, x$1$12, pkgData.dotSeparatedName());
            HashSet localSeenForThisPackage = (HashSet)localSeen$2.getOrElseUpdate((Object)pkg, Loaders$::tastyquery$reader$Loaders$Loader$$_$_$$anonfun$4);
            pkgData.listAllClassDatas().foreach(arg_0 -> Loaders$.tastyquery$reader$Loaders$Loader$$_$computeByEntry$$anonfun$1$$anonfun$1$$anonfun$adapted$1(localSeenForThisPackage, localByEntry$2, entry$1, pkg, arg_0));
        }

        private final /* synthetic */ void computeByEntry$$anonfun$1(HashMap localSeen$1, HashMap localByEntry$1, HashMap localPackages$3, Contexts.Context x$1$11, Classpaths.ClasspathEntry entry) {
            entry.listAllPackages().foreach((Function1 & Serializable)pkgData -> {
                this.computeByEntry$$anonfun$1$$anonfun$1(localSeen$1, localByEntry$1, entry, localPackages$3, x$1$11, (Classpaths.PackageData)pkgData);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final class PackageLoadingInfo {
        private final Symbols.PackageSymbol pkg;
        private List<Classpaths.PackageData> initPackageData;
        private HashMap dataByBinaryName$lzy1;
        private boolean dataByBinaryNamebitmap$1;
        private String fullBinaryNamePrefix$lzy1;
        private boolean fullBinaryNamePrefixbitmap$1;

        public PackageLoadingInfo(Symbols.PackageSymbol pkg, List<Classpaths.PackageData> initPackageData) {
            this.pkg = pkg;
            this.initPackageData = initPackageData;
        }

        /*
         * WARNING - void declaration
         */
        private HashMap<String, Classpaths.ClassData> dataByBinaryName() {
            if (!this.dataByBinaryNamebitmap$1) {
                void var1_1;
                HashMap localRoots = HashMap$.MODULE$.empty();
                this.initPackageData.foreach(arg_0 -> Loaders$.tastyquery$reader$Loaders$PackageLoadingInfo$$_$dataByBinaryName$$anonfun$adapted$1(localRoots, arg_0));
                this.dataByBinaryName$lzy1 = var1_1;
                this.dataByBinaryNamebitmap$1 = true;
                this.initPackageData = null;
            }
            return this.dataByBinaryName$lzy1;
        }

        public void loadAllRoots(Contexts.Context x$1) {
            LazyRef lazyRef = new LazyRef();
            List allNames = (List)this.dataByBinaryName().keysIterator().toList().sorted((Ordering)Ordering.String$.MODULE$);
            this.loadingRoots((Function1 & Serializable)loadedFiles -> {
                this.loadAllRoots$$anonfun$1(allNames, lazyRef, x$1, (HashSet)loadedFiles);
                return BoxedUnit.UNIT;
            });
            this.dataByBinaryName().clear();
        }

        public void loadAllPackageObjectRoots(Contexts.Context x$1) {
            LazyRef lazyRef = new LazyRef();
            List candidateNames = (List)this.dataByBinaryName().keysIterator().filter((Function1 & Serializable)_$1 -> this.isPackageObjectBinaryName$1((String)_$1)).toList().sorted((Ordering)Ordering.String$.MODULE$);
            this.loadingRoots((Function1 & Serializable)loadedFiles -> {
                this.loadAllPackageObjectRoots$$anonfun$1(candidateNames, lazyRef, x$1, (HashSet)loadedFiles);
                return BoxedUnit.UNIT;
            });
        }

        public void loadOneRoot(Names.Name name, Contexts.Context x$2) {
            LazyRef lazyRef = new LazyRef();
            this.loadingRoots((Function1 & Serializable)loadedFiles -> {
                this.loadOneRoot$$anonfun$1(name, lazyRef, x$2, (HashSet)loadedFiles);
                return BoxedUnit.UNIT;
            });
        }

        private String topLevelSymbolNameToRootName(Names.Name name) {
            Names.Name name2;
            while (true) {
                Names.SimpleName simpleName;
                if ((name2 = name) instanceof Names.TypeName) {
                    Names.TypeName name3 = (Names.TypeName)name2;
                    name = name3.toTermName();
                    continue;
                }
                if (!(name2 instanceof Names.ObjectClassName)) break;
                Names.ObjectClassName objectClassName = Names$ObjectClassName$.MODULE$.unapply((Names.ObjectClassName)name2);
                Names.SimpleName objName = simpleName = objectClassName._1();
                name = objName;
            }
            if (name2 instanceof Names.SimpleName) {
                Names.SimpleName name4 = (Names.SimpleName)name2;
                return NameTransformer$.MODULE$.encode(name4.name());
            }
            throw new IllegalStateException(new StringBuilder(30).append("Invalid top-level symbol name ").append(name.toDebugString()).toString());
        }

        private <A> A loadingRoots(Function1<HashSet<String>, A> op) {
            HashSet loadedFiles = HashSet$.MODULE$.empty();
            Object result = op.apply((Object)loadedFiles);
            this.dataByBinaryName().$minus$minus$eq((IterableOnce)loadedFiles);
            return (A)result;
        }

        private void tryLoadRoot(String binaryName, HashSet<String> loadedFiles, ReaderContext x$3) {
            Option option = this.dataByBinaryName().get((Object)binaryName);
            if (None$.MODULE$.equals(option)) {
                return;
            }
            if (option instanceof Some) {
                Classpaths.ClassData classData = (Classpaths.ClassData)((Some)option).value();
                if (loadedFiles.add((Object)binaryName)) {
                    if (classData.hasTastyFile()) {
                        this.doLoadTasty(classData, x$3);
                        return;
                    }
                    if (!this.doLoadClassFile(classData, loadedFiles, x$3)) {
                        loadedFiles.$minus$eq((Object)binaryName);
                        return;
                    }
                    return;
                }
                return;
            }
            throw new MatchError((Object)option);
        }

        private String fullBinaryNamePrefix() {
            if (!this.fullBinaryNamePrefixbitmap$1) {
                this.fullBinaryNamePrefix$lzy1 = this.pkg.isEmptyPackage() ? "" : this.pkg.fullName().path().mkString("", "/", "/");
                this.fullBinaryNamePrefixbitmap$1 = true;
            }
            return this.fullBinaryNamePrefix$lzy1;
        }

        public boolean doLoadClassFile(Classpaths.ClassData classData, HashSet<String> loadedFiles, ReaderContext x$3) {
            ClassfileParser.ClassKind kind;
            ClassfileReader.Structure structure = ClassfileReader$.MODULE$.readStructure(this.pkg, classData);
            ClassfileParser.ClassKind classKind = kind = ClassfileParser$.MODULE$.detectClassKind(structure);
            ClassfileParser.ClassKind classKind2 = ClassfileParser$ClassKind$.Scala2;
            ClassfileParser.ClassKind classKind3 = classKind;
            if (!(classKind2 != null ? !classKind2.equals(classKind3) : classKind3 != null)) {
                ClassfileParser$.MODULE$.loadScala2Class(structure, x$3);
                return true;
            }
            ClassfileParser.ClassKind classKind4 = ClassfileParser$ClassKind$.Java;
            ClassfileParser.ClassKind classKind5 = classKind;
            if (!(classKind4 != null ? !classKind4.equals(classKind5) : classKind5 != null)) {
                this.doLoadJavaTopLevelClass(classData, structure, loadedFiles, x$3);
                return true;
            }
            ClassfileParser.ClassKind classKind6 = ClassfileParser$ClassKind$.TASTy;
            ClassfileParser.ClassKind classKind7 = classKind;
            if (!(classKind6 != null ? !classKind6.equals(classKind7) : classKind7 != null)) {
                throw new Exceptions.TastyFormatException(new StringBuilder(41).append("Missing TASTy file for class ").append(classData.binaryName()).append(" in package ").append(this.pkg).toString());
            }
            ClassfileParser.ClassKind classKind8 = ClassfileParser$ClassKind$.ScalaArtifact;
            ClassfileParser.ClassKind classKind9 = classKind;
            if (!(classKind8 != null ? !classKind8.equals(classKind9) : classKind9 != null)) {
                return true;
            }
            ClassfileParser.ClassKind classKind10 = ClassfileParser$ClassKind$.JavaInnerOrArtifact;
            ClassfileParser.ClassKind classKind11 = classKind;
            if (!(classKind10 != null ? !classKind10.equals(classKind11) : classKind11 != null)) {
                return false;
            }
            throw new MatchError((Object)classKind);
        }

        private void doLoadJavaTopLevelClass(Classpaths.ClassData classData, ClassfileReader.Structure structure, HashSet<String> loadedFiles, ReaderContext x$4) {
            LazyRef lazyRef = new LazyRef();
            List<ClassfileParser.InnerClassDecl> innerDecls = ClassfileParser$.MODULE$.loadJavaClass(this.pkg, Names$.MODULE$.termName(classData.binaryName()), structure, x$4, this.given_Resolver$1(lazyRef));
            this.doLoadJavaInnerClasses(innerDecls, loadedFiles, x$4, this.given_Resolver$1(lazyRef));
        }

        private void doLoadJavaInnerClasses(List<ClassfileParser.InnerClassDecl> explore, HashSet<String> loadedFiles, ReaderContext x$3, ClassfileParser.Resolver x$4) {
            List list;
            while ((list = explore) instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list2 = colon2.next();
                ClassfileParser.InnerClassDecl inner = (ClassfileParser.InnerClassDecl)colon2.head();
                List rest = list2;
                Names.SimpleName innerSimpleName = inner.innerSimpleName();
                String localBinaryName = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(inner.innerBinaryName().name()), this.fullBinaryNamePrefix());
                Option option = this.dataByBinaryName().get((Object)localBinaryName);
                if (option instanceof Some) {
                    Classpaths.ClassData innerData = (Classpaths.ClassData)((Some)option).value();
                    if (!loadedFiles.contains((Object)localBinaryName)) {
                        loadedFiles.$plus$eq((Object)localBinaryName);
                        ClassfileReader.Structure structure = ClassfileReader$.MODULE$.readStructure(inner.owner(), innerData);
                        List<ClassfileParser.InnerClassDecl> innerDecls = ClassfileParser$.MODULE$.loadJavaClass(inner.owner(), innerSimpleName, structure, x$3, x$4);
                        explore = innerDecls.$colon$colon$colon(rest);
                        continue;
                    }
                }
                throw new Exceptions.ClassfileFormatException(new StringBuilder(45).append("Inner class ").append(localBinaryName).append(" not found in package ").append(this.pkg).append(" for owner ").append(inner.owner()).toString());
            }
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                return;
            }
            throw new MatchError(list);
        }

        private void doLoadTasty(Classpaths.ClassData classData, ReaderContext x$2) {
            TastyUnpickler unpickler = new TastyUnpickler(classData.readTastyFileBytes());
            String debugPath = classData.toString();
            ((TreeUnpickler)unpickler.unpickle(debugPath, new TastyUnpickler.TreeSectionUnpickler(unpickler.unpickle(debugPath, new TastyUnpickler.PositionSectionUnpickler(), x$2)), x$2).get()).unpickle();
        }

        private final ReaderContext given_ReaderContext$lzyINIT1$1(LazyRef given_ReaderContext$lzy1$1, Contexts.Context x$1$1) {
            ReaderContext readerContext;
            LazyRef lazyRef = given_ReaderContext$lzy1$1;
            synchronized (lazyRef) {
                readerContext = (ReaderContext)(given_ReaderContext$lzy1$1.initialized() ? given_ReaderContext$lzy1$1.value() : given_ReaderContext$lzy1$1.initialize((Object)new ReaderContext(x$1$1)));
            }
            return readerContext;
        }

        private final ReaderContext given_ReaderContext$1(LazyRef given_ReaderContext$lzy1$2, Contexts.Context x$1$2) {
            return (ReaderContext)(given_ReaderContext$lzy1$2.initialized() ? given_ReaderContext$lzy1$2.value() : this.given_ReaderContext$lzyINIT1$1(given_ReaderContext$lzy1$2, x$1$2));
        }

        private final /* synthetic */ void loadAllRoots$$anonfun$1$$anonfun$1(HashSet loadedFiles$1, LazyRef given_ReaderContext$lzy1$4, Contexts.Context x$1$4, String rootName) {
            this.tryLoadRoot(rootName, (HashSet<String>)loadedFiles$1, this.given_ReaderContext$1(given_ReaderContext$lzy1$4, x$1$4));
        }

        private final /* synthetic */ void loadAllRoots$$anonfun$1(List allNames$1, LazyRef given_ReaderContext$lzy1$3, Contexts.Context x$1$3, HashSet loadedFiles) {
            allNames$1.foreach((Function1 & Serializable)rootName -> {
                this.loadAllRoots$$anonfun$1$$anonfun$1(loadedFiles, given_ReaderContext$lzy1$3, x$1$3, (String)rootName);
                return BoxedUnit.UNIT;
            });
        }

        private final ReaderContext given_ReaderContext$lzyINIT2$1(LazyRef given_ReaderContext$lzy2$1, Contexts.Context x$1$5) {
            ReaderContext readerContext;
            LazyRef lazyRef = given_ReaderContext$lzy2$1;
            synchronized (lazyRef) {
                readerContext = (ReaderContext)(given_ReaderContext$lzy2$1.initialized() ? given_ReaderContext$lzy2$1.value() : given_ReaderContext$lzy2$1.initialize((Object)new ReaderContext(x$1$5)));
            }
            return readerContext;
        }

        private final ReaderContext given_ReaderContext$2(LazyRef given_ReaderContext$lzy2$2, Contexts.Context x$1$6) {
            return (ReaderContext)(given_ReaderContext$lzy2$2.initialized() ? given_ReaderContext$lzy2$2.value() : this.given_ReaderContext$lzyINIT2$1(given_ReaderContext$lzy2$2, x$1$6));
        }

        private final boolean isPackageObjectBinaryName$1(String name) {
            String string = name;
            String string2 = "package";
            return !(string == null ? string2 != null : !string.equals(string2)) || name.endsWith("$package");
        }

        private final /* synthetic */ void loadAllPackageObjectRoots$$anonfun$1$$anonfun$1(HashSet loadedFiles$2, LazyRef given_ReaderContext$lzy2$4, Contexts.Context x$1$8, String rootName) {
            this.tryLoadRoot(rootName, (HashSet<String>)loadedFiles$2, this.given_ReaderContext$2(given_ReaderContext$lzy2$4, x$1$8));
        }

        private final /* synthetic */ void loadAllPackageObjectRoots$$anonfun$1(List candidateNames$1, LazyRef given_ReaderContext$lzy2$3, Contexts.Context x$1$7, HashSet loadedFiles) {
            candidateNames$1.foreach((Function1 & Serializable)rootName -> {
                this.loadAllPackageObjectRoots$$anonfun$1$$anonfun$1(loadedFiles, given_ReaderContext$lzy2$3, x$1$7, (String)rootName);
                return BoxedUnit.UNIT;
            });
        }

        private final ReaderContext given_ReaderContext$lzyINIT3$1(LazyRef given_ReaderContext$lzy3$1, Contexts.Context x$2$1) {
            ReaderContext readerContext;
            LazyRef lazyRef = given_ReaderContext$lzy3$1;
            synchronized (lazyRef) {
                readerContext = (ReaderContext)(given_ReaderContext$lzy3$1.initialized() ? given_ReaderContext$lzy3$1.value() : given_ReaderContext$lzy3$1.initialize((Object)new ReaderContext(x$2$1)));
            }
            return readerContext;
        }

        private final ReaderContext given_ReaderContext$3(LazyRef given_ReaderContext$lzy3$2, Contexts.Context x$2$2) {
            return (ReaderContext)(given_ReaderContext$lzy3$2.initialized() ? given_ReaderContext$lzy3$2.value() : this.given_ReaderContext$lzyINIT3$1(given_ReaderContext$lzy3$2, x$2$2));
        }

        private final /* synthetic */ void loadOneRoot$$anonfun$1(Names.Name name$1, LazyRef given_ReaderContext$lzy3$3, Contexts.Context x$2$3, HashSet loadedFiles) {
            String binaryName = this.topLevelSymbolNameToRootName(name$1);
            this.tryLoadRoot(binaryName, (HashSet<String>)loadedFiles, this.given_ReaderContext$3(given_ReaderContext$lzy3$3, x$2$3));
        }

        private final ClassfileParser.Resolver given_Resolver$lzyINIT1$1(LazyRef given_Resolver$lzy1$1) {
            ClassfileParser.Resolver resolver;
            LazyRef lazyRef = given_Resolver$lzy1$1;
            synchronized (lazyRef) {
                resolver = (ClassfileParser.Resolver)(given_Resolver$lzy1$1.initialized() ? given_Resolver$lzy1$1.value() : given_Resolver$lzy1$1.initialize((Object)new ClassfileParser.Resolver()));
            }
            return resolver;
        }

        private final ClassfileParser.Resolver given_Resolver$1(LazyRef given_Resolver$lzy1$2) {
            return (ClassfileParser.Resolver)(given_Resolver$lzy1$2.initialized() ? given_Resolver$lzy1$2.value() : this.given_Resolver$lzyINIT1$1(given_Resolver$lzy1$2));
        }
    }
}

