/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.tasties;

import java.io.Serializable;
import scala.Byte$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import tastyquery.reader.tasties.TastyReader$;
import tastyquery.reader.tasties.TastyReader$Addr$;
import tastyquery.reader.tasties.TastyReader$NameRef$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TastyReader {
    private final byte[] bytes;
    private final int start;
    private final int end;
    private final int base;
    private int bp;

    public static int $lessinit$greater$default$4() {
        return TastyReader$.MODULE$.$lessinit$greater$default$4();
    }

    public TastyReader(byte[] bytes, int start, int end, int base) {
        this.bytes = bytes;
        this.start = start;
        this.end = end;
        this.base = base;
        this.bp = start;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int base() {
        return this.base;
    }

    public TastyReader(byte[] bytes) {
        this(bytes, 0, bytes.length, TastyReader$.MODULE$.$lessinit$greater$default$4());
    }

    public int addr(int idx) {
        return TastyReader$Addr$.MODULE$.apply(idx - this.base());
    }

    public int index(int addr) {
        return addr + this.base();
    }

    public int startAddr() {
        return this.addr(this.start);
    }

    public int currentAddr() {
        return this.addr(this.bp);
    }

    public int endAddr() {
        return this.addr(this.end);
    }

    public boolean isAtEnd() {
        return this.bp == this.end;
    }

    public TastyReader subReader(int start, int end) {
        return new TastyReader(this.bytes(), this.index(start), this.index(end), this.base());
    }

    public int readByte() {
        int result = this.bytes()[this.bp] & 0xFF;
        ++this.bp;
        return result;
    }

    public int nextByte() {
        return this.bytes()[this.bp] & 0xFF;
    }

    public byte[] readBytes(int n) {
        byte[] result = new byte[n];
        System.arraycopy(this.bytes(), this.bp, result, 0, n);
        this.bp += n;
        return result;
    }

    public int readNat() {
        return (int)this.readLongNat();
    }

    public int readInt() {
        return (int)this.readLongInt();
    }

    public long readLongNat() {
        long b = 0L;
        long x = 0L;
        do {
            b = Byte$.MODULE$.byte2long(this.bytes()[this.bp]);
            x = x << 7 | b & 0x7FL;
            ++this.bp;
        } while ((b & 0x80L) == 0L);
        return x;
    }

    public long readLongInt() {
        byte b = this.bytes()[this.bp];
        long x = Int$.MODULE$.int2long((byte)(b << 1) >> 1);
        ++this.bp;
        while ((b & 0x80) == 0) {
            b = this.bytes()[this.bp];
            x = x << 7 | (long)(b & 0x7F);
            ++this.bp;
        }
        return x;
    }

    public long readUncompressedLong() {
        LongRef x = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)v1 -> {
            this.readUncompressedLong$$anonfun$1(x, BoxesRunTime.unboxToInt((Object)v1));
            return BoxedUnit.UNIT;
        });
        return x.elem;
    }

    public int readNameRef() {
        return TastyReader$NameRef$.MODULE$.apply(this.readNat());
    }

    public int readAddr() {
        return TastyReader$Addr$.MODULE$.apply(this.readNat());
    }

    public int readEnd() {
        return this.addr(this.readNat() + this.bp);
    }

    public void goto(int addr) {
        this.bp = this.index(addr);
    }

    public boolean isBefore(int end) {
        return this.bp < this.index(end);
    }

    public <T> List<T> until(int end, Function0<T> op) {
        ListBuffer buf = new ListBuffer();
        while (this.isBefore(end)) {
            buf.$plus$eq(op.apply());
        }
        if (this.bp != this.index(end)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return buf.toList();
    }

    public <T> T ifBefore(int end, Function0<T> op, T t) {
        if (this.isBefore(end)) {
            return (T)op.apply();
        }
        return t;
    }

    public <T> List<T> collectWhile(Function0<Object> cond, Function0<T> op) {
        ListBuffer buf = new ListBuffer();
        while (BoxesRunTime.unboxToBoolean((Object)cond.apply())) {
            buf.$plus$eq(op.apply());
        }
        return buf.toList();
    }

    private final /* synthetic */ void readUncompressedLong$$anonfun$1(LongRef x$1, int i) {
        x$1.elem = x$1.elem << 8 | (long)(this.readByte() & 0xFF);
    }

    public static final class Addr
    implements Product,
    Serializable {
        private final int index;

        public static int apply(int n) {
            return TastyReader$Addr$.MODULE$.apply(n);
        }

        public static int unapply(int n) {
            return TastyReader$Addr$.MODULE$.unapply(n);
        }

        public static boolean $bang$eq$extension(int n, int n2) {
            return TastyReader$Addr$.MODULE$.$bang$eq$extension(n, n2);
        }

        public static int $plus$extension(int n, int n2) {
            return TastyReader$Addr$.MODULE$.$plus$extension(n, n2);
        }

        public static int $minus$extension(int n, int n2) {
            return TastyReader$Addr$.MODULE$.$minus$extension(n, n2);
        }

        public static boolean $eq$eq$extension(int n, int n2) {
            return TastyReader$Addr$.MODULE$.$eq$eq$extension(n, n2);
        }

        public static int _1$extension(int n) {
            return TastyReader$Addr$.MODULE$._1$extension(n);
        }

        public static boolean canEqual$extension(int n, Object object) {
            return TastyReader$Addr$.MODULE$.canEqual$extension(n, object);
        }

        public static int copy$extension(int n, int n2) {
            return TastyReader$Addr$.MODULE$.copy$extension(n, n2);
        }

        public static boolean equals$extension(int n, Object object) {
            return TastyReader$Addr$.MODULE$.equals$extension(n, object);
        }

        public static int hashCode$extension(int n) {
            return TastyReader$Addr$.MODULE$.hashCode$extension(n);
        }

        public static int productArity$extension(int n) {
            return TastyReader$Addr$.MODULE$.productArity$extension(n);
        }

        public static Object productElement$extension(int n, int n2) {
            return TastyReader$Addr$.MODULE$.productElement$extension(n, n2);
        }

        public static String productElementName$extension(int n, int n2) {
            return TastyReader$Addr$.MODULE$.productElementName$extension(n, n2);
        }

        public static String productPrefix$extension(int n) {
            return TastyReader$Addr$.MODULE$.productPrefix$extension(n);
        }

        public static String toString$extension(int n) {
            return TastyReader$Addr$.MODULE$.toString$extension(n);
        }

        public static int copy$default$1$extension(int n) {
            return TastyReader$Addr$.MODULE$.copy$default$1$extension(n);
        }

        public Addr(int index) {
            this.index = index;
        }

        public int hashCode() {
            return TastyReader$Addr$.MODULE$.hashCode$extension(this.index());
        }

        public boolean equals(Object x$0) {
            return TastyReader$Addr$.MODULE$.equals$extension(this.index(), x$0);
        }

        public String toString() {
            return TastyReader$Addr$.MODULE$.toString$extension(this.index());
        }

        public boolean canEqual(Object that) {
            return TastyReader$Addr$.MODULE$.canEqual$extension(this.index(), that);
        }

        public int productArity() {
            return TastyReader$Addr$.MODULE$.productArity$extension(this.index());
        }

        public String productPrefix() {
            return TastyReader$Addr$.MODULE$.productPrefix$extension(this.index());
        }

        public Object productElement(int n) {
            return TastyReader$Addr$.MODULE$.productElement$extension(this.index(), n);
        }

        public String productElementName(int n) {
            return TastyReader$Addr$.MODULE$.productElementName$extension(this.index(), n);
        }

        public int index() {
            return this.index;
        }

        public int $minus(int delta) {
            return TastyReader$Addr$.MODULE$.$minus$extension(this.index(), delta);
        }

        public int $plus(int delta) {
            return TastyReader$Addr$.MODULE$.$plus$extension(this.index(), delta);
        }

        public boolean $eq$eq(int that) {
            return TastyReader$Addr$.MODULE$.$eq$eq$extension(this.index(), that);
        }

        public boolean $bang$eq(int that) {
            return TastyReader$Addr$.MODULE$.$bang$eq$extension(this.index(), that);
        }

        public int copy(int index) {
            return TastyReader$Addr$.MODULE$.copy$extension(this.index(), index);
        }

        public int copy$default$1() {
            return TastyReader$Addr$.MODULE$.copy$default$1$extension(this.index());
        }

        public int _1() {
            return TastyReader$Addr$.MODULE$._1$extension(this.index());
        }
    }

    public static final class NameRef
    implements Product,
    Serializable {
        private final int index;

        public static int apply(int n) {
            return TastyReader$NameRef$.MODULE$.apply(n);
        }

        public static int unapply(int n) {
            return TastyReader$NameRef$.MODULE$.unapply(n);
        }

        public static int _1$extension(int n) {
            return TastyReader$NameRef$.MODULE$._1$extension(n);
        }

        public static boolean canEqual$extension(int n, Object object) {
            return TastyReader$NameRef$.MODULE$.canEqual$extension(n, object);
        }

        public static int copy$extension(int n, int n2) {
            return TastyReader$NameRef$.MODULE$.copy$extension(n, n2);
        }

        public static boolean equals$extension(int n, Object object) {
            return TastyReader$NameRef$.MODULE$.equals$extension(n, object);
        }

        public static int hashCode$extension(int n) {
            return TastyReader$NameRef$.MODULE$.hashCode$extension(n);
        }

        public static int productArity$extension(int n) {
            return TastyReader$NameRef$.MODULE$.productArity$extension(n);
        }

        public static Object productElement$extension(int n, int n2) {
            return TastyReader$NameRef$.MODULE$.productElement$extension(n, n2);
        }

        public static String productElementName$extension(int n, int n2) {
            return TastyReader$NameRef$.MODULE$.productElementName$extension(n, n2);
        }

        public static String productPrefix$extension(int n) {
            return TastyReader$NameRef$.MODULE$.productPrefix$extension(n);
        }

        public static String toString$extension(int n) {
            return TastyReader$NameRef$.MODULE$.toString$extension(n);
        }

        public static int copy$default$1$extension(int n) {
            return TastyReader$NameRef$.MODULE$.copy$default$1$extension(n);
        }

        public NameRef(int index) {
            this.index = index;
        }

        public int hashCode() {
            return TastyReader$NameRef$.MODULE$.hashCode$extension(this.index());
        }

        public boolean equals(Object x$0) {
            return TastyReader$NameRef$.MODULE$.equals$extension(this.index(), x$0);
        }

        public String toString() {
            return TastyReader$NameRef$.MODULE$.toString$extension(this.index());
        }

        public boolean canEqual(Object that) {
            return TastyReader$NameRef$.MODULE$.canEqual$extension(this.index(), that);
        }

        public int productArity() {
            return TastyReader$NameRef$.MODULE$.productArity$extension(this.index());
        }

        public String productPrefix() {
            return TastyReader$NameRef$.MODULE$.productPrefix$extension(this.index());
        }

        public Object productElement(int n) {
            return TastyReader$NameRef$.MODULE$.productElement$extension(this.index(), n);
        }

        public String productElementName(int n) {
            return TastyReader$NameRef$.MODULE$.productElementName$extension(this.index(), n);
        }

        public int index() {
            return this.index;
        }

        public int copy(int index) {
            return TastyReader$NameRef$.MODULE$.copy$extension(this.index(), index);
        }

        public int copy$default$1() {
            return TastyReader$NameRef$.MODULE$.copy$default$1$extension(this.index());
        }

        public int _1() {
            return TastyReader$NameRef$.MODULE$._1$extension(this.index());
        }
    }
}

