/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.tasties;

import java.io.Serializable;
import scala.Function0;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import tastyquery.SourceFile;
import tastyquery.Spans;
import tastyquery.Spans$;
import tastyquery.reader.ReaderContext;
import tastyquery.reader.ReaderContext$;
import tastyquery.reader.tasties.TastyReader;
import tastyquery.reader.tasties.TastyReader$Addr$;
import tastyquery.reader.tasties.TastyUnpickler;

public class PositionUnpickler {
    private final TastyReader reader;
    private final TastyUnpickler.NameTable nameAtRef;
    private final ReaderContext x$3;
    private final HashMap<TastyReader.Addr, Spans.Span> mySpans;
    private final HashMap<TastyReader.Addr, SourceFile> mySourceFiles;
    private boolean isDefined;

    public PositionUnpickler(TastyReader reader, TastyUnpickler.NameTable nameAtRef, ReaderContext x$3) {
        this.reader = reader;
        this.nameAtRef = nameAtRef;
        this.x$3 = x$3;
        this.mySpans = HashMap$.MODULE$.empty();
        this.mySourceFiles = HashMap$.MODULE$.empty();
        this.isDefined = false;
    }

    public void ensureDefined() {
        if (!this.isDefined) {
            int lines = this.reader.readNat();
            int[] myLineSizes = new int[lines];
            int i = 0;
            while (i < lines) {
                int n = i++;
                myLineSizes[n] = myLineSizes[n] + this.reader.readNat();
            }
            boolean noSourceSeenYet = true;
            int curAddress = 0;
            int curStart = 0;
            int curEnd = 0;
            while (!this.reader.isAtEnd()) {
                boolean hasPoint;
                int header = this.reader.readInt();
                if (header == 4) {
                    String path = this.nameAtRef.simple(this.reader.readNameRef()).toString();
                    SourceFile source = ReaderContext$.MODULE$.rctx(this.x$3).getSourceFile(path);
                    this.mySourceFiles.update((Object)new TastyReader.Addr(TastyReader$Addr$.MODULE$.apply(curAddress)), (Object)source);
                    if (!noSourceSeenYet) continue;
                    source.setLineSizes(myLineSizes);
                    noSourceSeenYet = false;
                    continue;
                }
                int addressDelta = header >> 3;
                boolean hasStart = (header & 4) != 0;
                boolean hasEnd = (header & 2) != 0;
                boolean bl = hasPoint = (header & 1) != 0;
                if ((curAddress += addressDelta) < 0) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                if (hasStart) {
                    curStart += this.reader.readInt();
                }
                if (hasEnd) {
                    curEnd += this.reader.readInt();
                }
                long span = hasPoint ? Spans$.MODULE$.Span(curStart, curEnd, curStart + this.reader.readInt()) : Spans$.MODULE$.Span(curStart, curEnd);
                this.mySpans.update((Object)new TastyReader.Addr(TastyReader$Addr$.MODULE$.apply(curAddress)), (Object)new Spans.Span(span));
            }
            this.isDefined = true;
            return;
        }
    }

    public long spanAt(int addr) {
        this.ensureDefined();
        Object object = this.mySpans.getOrElse((Object)new TastyReader.Addr(addr), (Function0 & Serializable)() -> new Spans.Span(PositionUnpickler.spanAt$$anonfun$1()));
        if (object == null) {
            return BoxesRunTime.unboxToLong(null);
        }
        return ((Spans.Span)object).tastyquery$Spans$Span$$coords();
    }

    public boolean hasSourceFileAt(int addr) {
        this.ensureDefined();
        return this.mySourceFiles.contains((Object)new TastyReader.Addr(addr));
    }

    public SourceFile sourceFileAt(int addr, SourceFile sourceFile) {
        this.ensureDefined();
        return (SourceFile)this.mySourceFiles.getOrElse((Object)new TastyReader.Addr(addr), () -> PositionUnpickler.sourceFileAt$$anonfun$1(sourceFile));
    }

    private static final long spanAt$$anonfun$1() {
        return Spans$.MODULE$.NoSpan();
    }

    private static final SourceFile sourceFileAt$$anonfun$1(SourceFile default$1) {
        return default$1;
    }
}

