/*
 * Decompiled with CFR 0.152.
 */
package tastyquery;

import java.util.Objects;
import scala.MatchError;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;
import tastyquery.Constants$;
import tastyquery.Constants$Constant$;
import tastyquery.Contexts;
import tastyquery.Types;

public final class Constants {
    public static int BooleanTag() {
        return Constants$.MODULE$.BooleanTag();
    }

    public static int ByteTag() {
        return Constants$.MODULE$.ByteTag();
    }

    public static int CharTag() {
        return Constants$.MODULE$.CharTag();
    }

    public static int ClazzTag() {
        return Constants$.MODULE$.ClazzTag();
    }

    public static int DoubleTag() {
        return Constants$.MODULE$.DoubleTag();
    }

    public static int FloatTag() {
        return Constants$.MODULE$.FloatTag();
    }

    public static int IntTag() {
        return Constants$.MODULE$.IntTag();
    }

    public static int LongTag() {
        return Constants$.MODULE$.LongTag();
    }

    public static int NoTag() {
        return Constants$.MODULE$.NoTag();
    }

    public static int NullTag() {
        return Constants$.MODULE$.NullTag();
    }

    public static int ShortTag() {
        return Constants$.MODULE$.ShortTag();
    }

    public static int StringTag() {
        return Constants$.MODULE$.StringTag();
    }

    public static int UnitTag() {
        return Constants$.MODULE$.UnitTag();
    }

    public static final class Constant {
        private final Object value;
        private final int tag;

        public static Constant apply(boolean bl) {
            return Constants$Constant$.MODULE$.apply(bl);
        }

        public static Constant apply(BoxedUnit boxedUnit) {
            return Constants$Constant$.MODULE$.apply(boxedUnit);
        }

        public static Constant apply(byte by) {
            return Constants$Constant$.MODULE$.apply(by);
        }

        public static Constant apply(char c) {
            return Constants$Constant$.MODULE$.apply(c);
        }

        public static Constant apply(double d) {
            return Constants$Constant$.MODULE$.apply(d);
        }

        public static Constant apply(float f) {
            return Constants$Constant$.MODULE$.apply(f);
        }

        public static Constant apply(int n) {
            return Constants$Constant$.MODULE$.apply(n);
        }

        public static Constant apply(long l) {
            return Constants$Constant$.MODULE$.apply(l);
        }

        public static Constant apply(Null$ null$) {
            return Constants$Constant$.MODULE$.apply(null$);
        }

        public static Constant apply(short s) {
            return Constants$Constant$.MODULE$.apply(s);
        }

        public static Constant apply(String string) {
            return Constants$Constant$.MODULE$.apply(string);
        }

        public static Constant apply(Types.Type type) {
            return Constants$Constant$.MODULE$.apply(type);
        }

        public static Constant unapply(Constant constant) {
            return Constants$Constant$.MODULE$.unapply(constant);
        }

        public Constant(Object value, int tag, boolean internal) {
            this.value = value;
            this.tag = tag;
        }

        public Object value() {
            return this.value;
        }

        public int tag() {
            return this.tag;
        }

        public Constant(Object value, int tag) {
            this(value, tag, true);
            boolean bl;
            int n = tag;
            switch (n) {
                case 1: {
                    Object object = value;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    if (!(object != null ? !object.equals(boxedUnit) : boxedUnit != null)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    bl = value instanceof Boolean;
                    break;
                }
                case 5: {
                    bl = value instanceof Character;
                    break;
                }
                case 3: {
                    bl = value instanceof Byte;
                    break;
                }
                case 4: {
                    bl = value instanceof Short;
                    break;
                }
                case 6: {
                    bl = value instanceof Integer;
                    break;
                }
                case 7: {
                    bl = value instanceof Long;
                    break;
                }
                case 8: {
                    bl = value instanceof Float;
                    break;
                }
                case 9: {
                    bl = value instanceof Double;
                    break;
                }
                case 10: {
                    bl = value instanceof String;
                    break;
                }
                case 11: {
                    if (value == null) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 12: {
                    bl = value instanceof Types.Type;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
            boolean valid = bl;
            Predef$.MODULE$.require(valid, () -> this.$init$$$anonfun$1(value, tag));
        }

        public Types.Type wideType(Contexts.Context x$1) {
            int n = this.tag();
            switch (n) {
                case 1: {
                    return x$1.defn().UnitType();
                }
                case 2: {
                    return x$1.defn().BooleanType();
                }
                case 5: {
                    return x$1.defn().CharType();
                }
                case 3: {
                    return x$1.defn().ByteType();
                }
                case 4: {
                    return x$1.defn().ShortType();
                }
                case 6: {
                    return x$1.defn().IntType();
                }
                case 7: {
                    return x$1.defn().LongType();
                }
                case 8: {
                    return x$1.defn().FloatType();
                }
                case 9: {
                    return x$1.defn().DoubleType();
                }
                case 10: {
                    return x$1.defn().StringType();
                }
                case 11: {
                    return x$1.defn().NullType();
                }
                case 12: {
                    return x$1.defn().ClassTypeOf(this.typeValue());
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }

        public boolean isByteRange() {
            return this.isIntRange() && -128 <= this.intValue() && this.intValue() <= 127;
        }

        public boolean isShortRange() {
            return this.isIntRange() && Short.MIN_VALUE <= this.intValue() && this.intValue() <= Short.MAX_VALUE;
        }

        public boolean isCharRange() {
            return this.isIntRange() && 0 <= this.intValue() && this.intValue() <= 65535;
        }

        public boolean isIntRange() {
            return 3 <= this.tag() && this.tag() <= 6;
        }

        public boolean isLongRange() {
            return 3 <= this.tag() && this.tag() <= 7;
        }

        public boolean isFloatRange() {
            return 3 <= this.tag() && this.tag() <= 8;
        }

        public boolean isNumeric() {
            return 3 <= this.tag() && this.tag() <= 9;
        }

        public boolean isNonUnitAnyVal() {
            return 2 <= this.tag() && this.tag() <= 9;
        }

        public boolean isAnyVal() {
            return 1 <= this.tag() && this.tag() <= 9;
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof Constant) {
                Constant that = (Constant)object;
                return this.tag() == that.tag() && Objects.equals(this.value(), that.value());
            }
            return false;
        }

        public boolean isNaN() {
            Object object = this.value();
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                return Predef$.MODULE$.float2Float(f).isNaN();
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                return Predef$.MODULE$.double2Double(d).isNaN();
            }
            return false;
        }

        public boolean booleanValue() {
            if (this.tag() == 2) {
                return BoxesRunTime.unboxToBoolean((Object)this.value());
            }
            throw new Error(new StringBuilder(23).append("value ").append(this.value()).append(" is not a boolean").toString());
        }

        public byte byteValue() {
            int n = this.tag();
            switch (n) {
                case 3: {
                    return BoxesRunTime.unboxToByte((Object)this.value());
                }
                case 4: {
                    return (byte)BoxesRunTime.unboxToShort((Object)this.value());
                }
                case 5: {
                    return (byte)BoxesRunTime.unboxToChar((Object)this.value());
                }
                case 6: {
                    return (byte)BoxesRunTime.unboxToInt((Object)this.value());
                }
                case 7: {
                    return (byte)BoxesRunTime.unboxToLong((Object)this.value());
                }
                case 8: {
                    return (byte)BoxesRunTime.unboxToFloat((Object)this.value());
                }
                case 9: {
                    return (byte)BoxesRunTime.unboxToDouble((Object)this.value());
                }
            }
            throw new Error(new StringBuilder(20).append("value ").append(this.value()).append(" is not a Byte").toString());
        }

        public short shortValue() {
            int n = this.tag();
            switch (n) {
                case 3: {
                    return BoxesRunTime.unboxToByte((Object)this.value());
                }
                case 4: {
                    return BoxesRunTime.unboxToShort((Object)this.value());
                }
                case 5: {
                    return (short)BoxesRunTime.unboxToChar((Object)this.value());
                }
                case 6: {
                    return (short)BoxesRunTime.unboxToInt((Object)this.value());
                }
                case 7: {
                    return (short)BoxesRunTime.unboxToLong((Object)this.value());
                }
                case 8: {
                    return (short)BoxesRunTime.unboxToFloat((Object)this.value());
                }
                case 9: {
                    return (short)BoxesRunTime.unboxToDouble((Object)this.value());
                }
            }
            throw new Error(new StringBuilder(21).append("value ").append(this.value()).append(" is not a Short").toString());
        }

        public char charValue() {
            int n = this.tag();
            switch (n) {
                case 3: {
                    return (char)BoxesRunTime.unboxToByte((Object)this.value());
                }
                case 4: {
                    return (char)BoxesRunTime.unboxToShort((Object)this.value());
                }
                case 5: {
                    return BoxesRunTime.unboxToChar((Object)this.value());
                }
                case 6: {
                    return (char)BoxesRunTime.unboxToInt((Object)this.value());
                }
                case 7: {
                    return (char)BoxesRunTime.unboxToLong((Object)this.value());
                }
                case 8: {
                    return (char)BoxesRunTime.unboxToFloat((Object)this.value());
                }
                case 9: {
                    return (char)BoxesRunTime.unboxToDouble((Object)this.value());
                }
            }
            throw new Error(new StringBuilder(20).append("value ").append(this.value()).append(" is not a Char").toString());
        }

        public int intValue() {
            int n = this.tag();
            switch (n) {
                case 3: {
                    return BoxesRunTime.unboxToByte((Object)this.value());
                }
                case 4: {
                    return BoxesRunTime.unboxToShort((Object)this.value());
                }
                case 5: {
                    return BoxesRunTime.unboxToChar((Object)this.value());
                }
                case 6: {
                    return BoxesRunTime.unboxToInt((Object)this.value());
                }
                case 7: {
                    return (int)BoxesRunTime.unboxToLong((Object)this.value());
                }
                case 8: {
                    return (int)BoxesRunTime.unboxToFloat((Object)this.value());
                }
                case 9: {
                    return (int)BoxesRunTime.unboxToDouble((Object)this.value());
                }
            }
            throw new Error(new StringBuilder(20).append("value ").append(this.value()).append(" is not an Int").toString());
        }

        public long longValue() {
            int n = this.tag();
            switch (n) {
                case 3: {
                    return BoxesRunTime.unboxToByte((Object)this.value());
                }
                case 4: {
                    return BoxesRunTime.unboxToShort((Object)this.value());
                }
                case 5: {
                    return BoxesRunTime.unboxToChar((Object)this.value());
                }
                case 6: {
                    return BoxesRunTime.unboxToInt((Object)this.value());
                }
                case 7: {
                    return BoxesRunTime.unboxToLong((Object)this.value());
                }
                case 8: {
                    return (long)BoxesRunTime.unboxToFloat((Object)this.value());
                }
                case 9: {
                    return (long)BoxesRunTime.unboxToDouble((Object)this.value());
                }
            }
            throw new Error(new StringBuilder(20).append("value ").append(this.value()).append(" is not a Long").toString());
        }

        public float floatValue() {
            int n = this.tag();
            switch (n) {
                case 3: {
                    return BoxesRunTime.unboxToByte((Object)this.value());
                }
                case 4: {
                    return BoxesRunTime.unboxToShort((Object)this.value());
                }
                case 5: {
                    return BoxesRunTime.unboxToChar((Object)this.value());
                }
                case 6: {
                    return BoxesRunTime.unboxToInt((Object)this.value());
                }
                case 7: {
                    return BoxesRunTime.unboxToLong((Object)this.value());
                }
                case 8: {
                    return BoxesRunTime.unboxToFloat((Object)this.value());
                }
                case 9: {
                    return (float)BoxesRunTime.unboxToDouble((Object)this.value());
                }
            }
            throw new Error(new StringBuilder(21).append("value ").append(this.value()).append(" is not a Float").toString());
        }

        public double doubleValue() {
            int n = this.tag();
            switch (n) {
                case 3: {
                    return BoxesRunTime.unboxToByte((Object)this.value());
                }
                case 4: {
                    return BoxesRunTime.unboxToShort((Object)this.value());
                }
                case 5: {
                    return BoxesRunTime.unboxToChar((Object)this.value());
                }
                case 6: {
                    return BoxesRunTime.unboxToInt((Object)this.value());
                }
                case 7: {
                    return BoxesRunTime.unboxToLong((Object)this.value());
                }
                case 8: {
                    return BoxesRunTime.unboxToFloat((Object)this.value());
                }
                case 9: {
                    return BoxesRunTime.unboxToDouble((Object)this.value());
                }
            }
            throw new Error(new StringBuilder(22).append("value ").append(this.value()).append(" is not a Double").toString());
        }

        public String stringValue() {
            if (this.tag() == 11) {
                return "null";
            }
            return this.value().toString();
        }

        public Types.Type typeValue() {
            return (Types.Type)this.value();
        }

        public int hashCode() {
            int seed;
            int h = seed = 17;
            h = MurmurHash3$.MODULE$.mix(h, Statics.anyHash((Object)BoxesRunTime.boxToInteger((int)this.tag())));
            if (this.tag() != 11) {
                h = MurmurHash3$.MODULE$.mix(h, this.value().hashCode());
            }
            return MurmurHash3$.MODULE$.finalizeHash(h, 2);
        }

        public String toString() {
            return new StringBuilder(10).append("Constant(").append(this.value()).append(")").toString();
        }

        public boolean canEqual(Object x) {
            return true;
        }

        public Object get() {
            return this.value();
        }

        public boolean isEmpty() {
            return false;
        }

        public Object _1() {
            return this.value();
        }

        private final Object $init$$$anonfun$1(Object value$1, int tag$1) {
            return new StringBuilder(53).append("Illegal combination of value and tag for Constant(").append(value$1).append(", ").append(tag$1).append(")").toString();
        }
    }
}

