/*
 * Decompiled with CFR 0.152.
 */
package tastyquery.reader.pickles;

public class PickleFlagSet {
    private final long rawFlags;
    private final boolean isType;

    public PickleFlagSet(long rawFlags, boolean isType) {
        this.rawFlags = rawFlags;
        this.isType = isType;
    }

    public boolean isType() {
        return this.isType;
    }

    private boolean hasFlag(long flag) {
        return (this.rawFlags & flag) != 0L;
    }

    public boolean isImplicit() {
        return this.hasFlag(1L);
    }

    public boolean isFinal() {
        return this.hasFlag(2L);
    }

    public boolean isPrivate() {
        return this.hasFlag(4L);
    }

    public boolean isProtected() {
        return this.hasFlag(8L);
    }

    public boolean isSealed() {
        return this.hasFlag(16L);
    }

    public boolean isOverride() {
        return this.hasFlag(32L);
    }

    public boolean isCase() {
        return this.hasFlag(64L);
    }

    public boolean isAbstract() {
        return this.hasFlag(128L);
    }

    public boolean isDeferred() {
        return this.hasFlag(256L);
    }

    public boolean isMethod() {
        return this.hasFlag(512L);
    }

    public boolean isModule() {
        return this.hasFlag(1024L);
    }

    public boolean isInterface() {
        return this.hasFlag(2048L);
    }

    public boolean isMutable() {
        return this.hasFlag(4096L);
    }

    public boolean isParam() {
        return this.hasFlag(8192L);
    }

    public boolean isPackage() {
        return this.hasFlag(16384L);
    }

    public boolean isMacro() {
        return this.hasFlag(32768L);
    }

    public boolean isCovariant() {
        return this.isType() && this.hasFlag(65536L);
    }

    public boolean isCaptured() {
        return !this.isType() && this.hasFlag(65536L);
    }

    public boolean isByNameParam() {
        return this.hasFlag(65536L);
    }

    public boolean isContravariant() {
        return this.isType() && this.hasFlag(131072L);
    }

    public boolean isLabel() {
        return !this.isType() && this.hasFlag(131072L);
    }

    public boolean isInConstructor() {
        return this.hasFlag(131072L);
    }

    public boolean isAbstractOverride() {
        return this.hasFlag(262144L);
    }

    public boolean isLocal() {
        return this.hasFlag(524288L);
    }

    public boolean isJava() {
        return this.hasFlag(0x100000L);
    }

    public boolean isSynthetic() {
        return this.hasFlag(0x200000L);
    }

    public boolean isStable() {
        return this.hasFlag(0x400000L);
    }

    public boolean isStatic() {
        return this.hasFlag(0x800000L);
    }

    public boolean isCaseAccessor() {
        return this.hasFlag(0x1000000L);
    }

    public boolean isTrait() {
        return this.isType() && this.hasFlag(0x2000000L);
    }

    public boolean hasDefault() {
        return !this.isType() && this.hasFlag(0x2000000L);
    }

    public boolean isBridge() {
        return this.hasFlag(0x4000000L);
    }

    public boolean isAccessor() {
        return this.hasFlag(0x8000000L);
    }

    public boolean isSuperAccessor() {
        return this.hasFlag(0x10000000L);
    }

    public boolean isParamAccessor() {
        return this.hasFlag(0x20000000L);
    }

    public boolean isModuleVar() {
        return this.hasFlag(0x40000000L);
    }

    public boolean isSyntheticMethod() {
        return this.hasFlag(0x40000000L);
    }

    public boolean isMonomorphic() {
        return this.hasFlag(0x40000000L);
    }

    public boolean isLazy() {
        return this.hasFlag(0x80000000L);
    }

    public boolean isError() {
        return this.hasFlag(0x100000000L);
    }

    public boolean isOverloaded() {
        return this.hasFlag(0x200000000L);
    }

    public boolean isLifted() {
        return this.hasFlag(0x400000000L);
    }

    public boolean isMixedIn() {
        return !this.isType() && this.hasFlag(0x800000000L);
    }

    public boolean isExistential() {
        return this.isType() && this.hasFlag(0x800000000L);
    }

    public boolean isExpandedName() {
        return this.hasFlag(0x1000000000L);
    }

    public boolean isImplementationClass() {
        return this.hasFlag(0x2000000000L);
    }

    public boolean isPreSuper() {
        return this.hasFlag(0x2000000000L);
    }

    public boolean isSpecialized() {
        return this.hasFlag(0x10000000000L);
    }

    public boolean isVBridge() {
        return this.hasFlag(0x40000000000L);
    }

    public boolean isJavaVarargs() {
        return this.hasFlag(0x80000000000L);
    }

    public boolean isEnum() {
        return this.hasFlag(0x1000000000000L);
    }
}

