/*
 * Decompiled with CFR 0.152.
 */
package xsbt.api;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import xsbti.api.Access;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.ClassDefinition;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.Definition;
import xsbti.api.DefinitionType;
import xsbti.api.EmptyType;
import xsbti.api.Existential;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.Modifiers;
import xsbti.api.ParameterList;
import xsbti.api.ParameterModifier;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.ParameterizedDefinition;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Public;
import xsbti.api.Qualifier;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.This;
import xsbti.api.ThisQualifier;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Unqualified;
import xsbti.api.Val;
import xsbti.api.Var;
import xsbti.api.Variance;

public final class ShowAPI$ {
    public static ShowAPI$ MODULE$;
    private int numDecls;
    private volatile boolean bitmap$0;

    static {
        new ShowAPI$();
    }

    private int numDecls$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.numDecls = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.parseInt((String)package$.MODULE$.props().get("sbt.inc.apidiff.decls").get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                this.bitmap$0 = true;
            }
        }
        return this.numDecls;
    }

    private int numDecls() {
        if (!this.bitmap$0) {
            return this.numDecls$lzycompute();
        }
        return this.numDecls;
    }

    private ClassDefinition[] truncateDecls(ClassDefinition[] decls) {
        if (this.numDecls() <= 0) {
            return decls;
        }
        return (ClassDefinition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])decls)).take(this.numDecls());
    }

    private String lines(Seq<String> ls) {
        return ls.mkString("\n", "\n", "\n");
    }

    public String showApi(ClassLike c, int nesting) {
        return this.showDefinition((Definition)c, nesting);
    }

    public String showDefinition(Definition d, int nesting) {
        String string;
        if (d instanceof Val) {
            Val val = (Val)d;
            string = this.showMonoDef((Definition)val, "val", nesting) + ": " + this.showType(val.tpe(), nesting);
        } else if (d instanceof Var) {
            Var var = (Var)d;
            string = this.showMonoDef((Definition)var, "var", nesting) + ": " + this.showType(var.tpe(), nesting);
        } else if (d instanceof Def) {
            Def def = (Def)d;
            string = this.showPolyDef((ParameterizedDefinition)def, "def", nesting) + this.showValueParams((Seq<ParameterList>)Predef$.MODULE$.wrapRefArray((Object[])def.valueParameters()), nesting) + ": " + this.showType(def.returnType(), nesting);
        } else if (d instanceof TypeAlias) {
            TypeAlias typeAlias = (TypeAlias)d;
            string = this.showPolyDef((ParameterizedDefinition)typeAlias, "type", nesting) + " = " + this.showType(typeAlias.tpe(), nesting);
        } else if (d instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)d;
            string = this.showPolyDef((ParameterizedDefinition)typeDeclaration, "type", nesting) + this.showBounds(typeDeclaration.lowerBound(), typeDeclaration.upperBound(), nesting);
        } else if (d instanceof ClassLike) {
            ClassLike classLike = (ClassLike)d;
            string = this.showMonoDef(d, this.showDefinitionType(classLike.definitionType()), nesting) + this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])classLike.typeParameters()), nesting) + " extends " + this.showTemplate(classLike, nesting);
        } else if (d instanceof ClassLikeDef) {
            ClassLikeDef classLikeDef = (ClassLikeDef)d;
            string = this.showPolyDef((ParameterizedDefinition)classLikeDef, this.showDefinitionType(classLikeDef.definitionType()), nesting);
        } else {
            throw new MatchError((Object)d);
        }
        return string;
    }

    private String showTemplate(ClassLike cl, int nesting) {
        if (nesting <= 0) {
            return "<nesting level reached>";
        }
        String showSelf = cl.selfType() instanceof EmptyType ? "" : " self: " + this.showNestedType(cl.selfType(), nesting) + " =>";
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cl.structure().parents())).map((Function1 & Serializable & scala.Serializable)tp -> MODULE$.showNestedType((Type)tp, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("", " with ", " {") + showSelf + this.lines((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(cl.structure().inherited()))).map((Function1 & Serializable & scala.Serializable)d -> "^inherited^ " + MODULE$.showNestedDefinition((Definition)d, nesting), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())))) + this.lines((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(cl.structure().declared()))).map((Function1 & Serializable & scala.Serializable)d -> MODULE$.showNestedDefinition((Definition)d, nesting), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())))) + "}";
    }

    public String showType(Type t2, int nesting) {
        String string;
        if (t2 instanceof Projection) {
            Projection projection = (Projection)t2;
            string = this.showType(projection.prefix(), nesting) + "#" + projection.id();
        } else if (t2 instanceof ParameterRef) {
            ParameterRef parameterRef = (ParameterRef)t2;
            string = "<" + parameterRef.id() + ">";
        } else if (t2 instanceof Singleton) {
            Singleton singleton = (Singleton)t2;
            string = this.showPath(singleton.path());
        } else if (t2 instanceof EmptyType) {
            string = "<empty>";
        } else if (t2 instanceof Parameterized) {
            Parameterized parameterized = (Parameterized)t2;
            string = this.showType(parameterized.baseType(), nesting) + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameterized.typeArguments())).map((Function1 & Serializable & scala.Serializable)t -> MODULE$.showType((Type)t, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ", ", "]");
        } else if (t2 instanceof Constant) {
            Constant constant = (Constant)t2;
            string = this.showType(constant.baseType(), nesting) + "(" + constant.value() + ")";
        } else if (t2 instanceof Annotated) {
            Annotated annotated = (Annotated)t2;
            string = this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.wrapRefArray((Object[])annotated.annotations()), nesting) + " " + this.showType(annotated.baseType(), nesting);
        } else if (t2 instanceof Structure) {
            Structure structure2 = (Structure)t2;
            string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structure2.parents())).map((Function1 & Serializable & scala.Serializable)t -> MODULE$.showType((Type)t, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" with ") + (nesting <= 0 ? "{ <nesting level reached> }" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(structure2.declared()))).map((Function1 & Serializable & scala.Serializable)d -> MODULE$.showNestedDefinition((Definition)d, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" {", "\n", "}"));
        } else if (t2 instanceof Existential) {
            Existential existential = (Existential)t2;
            string = this.showType(existential.baseType(), nesting) + (nesting <= 0 ? " forSome { <nesting level reached> }" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existential.clause())).map((Function1 & Serializable & scala.Serializable)t -> "type " + MODULE$.showNestedTypeParameter((TypeParameter)t, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" forSome { ", "; ", " }"));
        } else if (t2 instanceof Polymorphic) {
            Polymorphic polymorphic = (Polymorphic)t2;
            string = this.showType(polymorphic.baseType(), nesting) + (nesting <= 0 ? " [ <nesting level reached> ]" : this.showNestedTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])polymorphic.parameters()), nesting));
        } else {
            throw new MatchError((Object)t2);
        }
        return string;
    }

    private String showPath(Path p) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.components())).map((Function1 & Serializable & scala.Serializable)pc -> MODULE$.showPathComponent((PathComponent)pc), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
    }

    private String showPathComponent(PathComponent pc) {
        String string;
        if (pc instanceof Super) {
            Super super_ = (Super)pc;
            string = "super[" + this.showPath(super_.qualifier()) + "]";
        } else if (pc instanceof This) {
            string = "this";
        } else if (pc instanceof Id) {
            string = ((Id)pc).id();
        } else {
            throw new MatchError((Object)pc);
        }
        return string;
    }

    private String space(String s) {
        if (s.isEmpty()) {
            return s;
        }
        return s + " ";
    }

    private String showMonoDef(Definition d, String label, int nesting) {
        return this.space(this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.wrapRefArray((Object[])d.annotations()), nesting)) + this.space(this.showAccess(d.access())) + this.space(this.showModifiers(d.modifiers())) + this.space(label) + d.name();
    }

    private String showPolyDef(ParameterizedDefinition d, String label, int nesting) {
        return this.showMonoDef((Definition)d, label, nesting) + this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])d.typeParameters()), nesting);
    }

    private String showTypeParameters(Seq<TypeParameter> tps, int nesting) {
        if (tps.isEmpty()) {
            return "";
        }
        return ((TraversableOnce)tps.map((Function1 & Serializable & scala.Serializable)tp -> MODULE$.showTypeParameter((TypeParameter)tp, nesting), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
    }

    private String showTypeParameter(TypeParameter tp, int nesting) {
        return this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.wrapRefArray((Object[])tp.annotations()), nesting) + " " + this.showVariance(tp.variance()) + tp.id() + this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])tp.typeParameters()), nesting) + " " + this.showBounds(tp.lowerBound(), tp.upperBound(), nesting);
    }

    private String showAnnotations(Seq<Annotation> as, int nesting) {
        return ((TraversableOnce)as.map((Function1 & Serializable & scala.Serializable)a -> MODULE$.showAnnotation((Annotation)a, nesting), Seq$.MODULE$.canBuildFrom())).mkString(" ");
    }

    private String showAnnotation(Annotation a2, int nesting) {
        return "@" + this.showType(a2.base(), nesting) + (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a2.arguments())).isEmpty() ? "" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a2.arguments())).map((Function1 & Serializable & scala.Serializable)a -> a.name() + " = " + a.value(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("(", ", ", ")"));
    }

    private String showBounds(Type lower, Type upper, int nesting) {
        return ">: " + this.showType(lower, nesting) + " <: " + this.showType(upper, nesting);
    }

    private String showValueParams(Seq<ParameterList> ps, int nesting) {
        return ((TraversableOnce)ps.map((Function1 & Serializable & scala.Serializable)pl -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pl.parameters())).map((Function1 & Serializable & scala.Serializable)mp -> mp.name() + ": " + MODULE$.showParameterModifier(MODULE$.showType(mp.tpe(), nesting), mp.modifier()) + (mp.hasDefault() ? "= ..." : ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(pl.isImplicit() ? "(implicit " : "(", ", ", ")"), Seq$.MODULE$.canBuildFrom())).mkString("");
    }

    private String showParameterModifier(String base, ParameterModifier pm) {
        String string;
        if (ParameterModifier.Plain.equals(pm)) {
            string = base;
        } else if (ParameterModifier.Repeated.equals(pm)) {
            string = base + "*";
        } else if (ParameterModifier.ByName.equals(pm)) {
            string = "=> " + base;
        } else {
            throw new MatchError((Object)pm);
        }
        return string;
    }

    private String showDefinitionType(DefinitionType d) {
        String string;
        if (DefinitionType.Trait.equals(d)) {
            string = "trait";
        } else if (DefinitionType.ClassDef.equals(d)) {
            string = "class";
        } else if (DefinitionType.Module.equals(d)) {
            string = "object";
        } else if (DefinitionType.PackageModule.equals(d)) {
            string = "package object";
        } else {
            throw new MatchError((Object)d);
        }
        return string;
    }

    private String showAccess(Access a) {
        String string;
        if (a instanceof Public) {
            string = "";
        } else if (a instanceof Protected) {
            Protected protected_ = (Protected)a;
            string = "protected" + this.showQualifier(protected_.qualifier());
        } else if (a instanceof Private) {
            Private private_ = (Private)a;
            string = "private" + this.showQualifier(private_.qualifier());
        } else {
            throw new MatchError((Object)a);
        }
        return string;
    }

    private String showQualifier(Qualifier q) {
        String string;
        if (q instanceof Unqualified) {
            string = "";
        } else if (q instanceof ThisQualifier) {
            string = "[this]";
        } else if (q instanceof IdQualifier) {
            IdQualifier idQualifier = (IdQualifier)q;
            string = "[" + idQualifier.value() + "]";
        } else {
            throw new MatchError((Object)q);
        }
        return string;
    }

    private String showModifiers(Modifiers m) {
        return ((TraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isOverride()), (Object)"override"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isFinal()), (Object)"final"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isSealed()), (Object)"sealed"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isImplicit()), (Object)"implicit"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isAbstract()), (Object)"abstract"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isLazy()), (Object)"lazy")})).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    boolean bl = x1._1$mcZ$sp();
                    String mod = (String)x1._2();
                    if (bl) {
                        object = mod;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, String> x1) {
                boolean bl;
                boolean bl2 = x1 != null && true == (bl = x1._1$mcZ$sp());
                return bl2;
            }
        }, List$.MODULE$.canBuildFrom())).mkString(" ");
    }

    private String showVariance(Variance v) {
        String string;
        if (Variance.Invariant.equals(v)) {
            string = "";
        } else if (Variance.Covariant.equals(v)) {
            string = "+";
        } else if (Variance.Contravariant.equals(v)) {
            string = "-";
        } else {
            throw new MatchError((Object)v);
        }
        return string;
    }

    private String showNestedType(Type tp, int nesting) {
        return this.showType(tp, nesting - 1);
    }

    private String showNestedTypeParameter(TypeParameter tp, int nesting) {
        return this.showTypeParameter(tp, nesting - 1);
    }

    private String showNestedTypeParameters(Seq<TypeParameter> tps, int nesting) {
        return this.showTypeParameters(tps, nesting - 1);
    }

    private String showNestedDefinition(Definition d, int nesting) {
        return this.showDefinition(d, nesting - 1);
    }

    private ShowAPI$() {
        MODULE$ = this;
    }
}

