/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sbt.internal.inc.IndexBasedZipFsOps$;
import sbt.internal.inc.IndexBasedZipOps;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.JarUtils$ClassInJar$;
import sbt.internal.inc.JarUtils$NoOutputJar$;
import sbt.internal.inc.zip.ZipCentralDir;
import sbt.io.IO$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import xsbti.compile.Output;
import xsbti.compile.SingleOutput;

public final class JarUtils$ {
    public static JarUtils$ MODULE$;
    private final Set<String> scalacOptions;
    private final Set<String> javacOptions;
    private File tempDir;
    private final String prevJarPrefix;

    static {
        new JarUtils$();
    }

    public Set<String> scalacOptions() {
        return this.scalacOptions;
    }

    public Set<String> javacOptions() {
        return this.javacOptions;
    }

    public ZipCentralDir stashIndex(File jar) {
        return (ZipCentralDir)IndexBasedZipFsOps$.MODULE$.readCentralDir(jar);
    }

    public void unstashIndex(File jar, ZipCentralDir index) {
        IndexBasedZipFsOps$.MODULE$.writeCentralDir(jar, index);
    }

    public void includeInJar(File jar, Seq<Tuple2<File, String>> files) {
        IndexBasedZipFsOps$.MODULE$.includeInArchive(jar, files);
    }

    public void mergeJars(File into, File from) {
        IndexBasedZipFsOps$.MODULE$.mergeArchives(into, from);
    }

    public Seq<String> listClassFiles(File jar) {
        return (Seq)IndexBasedZipFsOps$.MODULE$.listEntries(jar).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.endsWith(".class")));
    }

    public void removeFromJar(File jarFile, Iterable<String> classes) {
        if (jarFile.exists()) {
            IndexBasedZipFsOps$.MODULE$.removeEntries(jarFile, classes);
        }
    }

    public Function1<File, Object> readStamps(File jar) {
        return arg_0 -> JarUtils$.$anonfun$readStamps$1$adapted(new IndexBasedZipOps.CachedStamps(IndexBasedZipFsOps$.MODULE$, jar), arg_0);
    }

    public void withPreviousJar(Output output, Function1<Seq<File>, BoxedUnit> compile) {
        Tuple2 tuple2;
        Option<Tuple2<File, File>> option = this.preparePreviousJar(output);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            File prevJar = (File)tuple2._1();
            File outputJar = (File)tuple2._2();
            try {
                compile.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{prevJar})));
            }
            catch (Exception e) {
                IO$.MODULE$.move(prevJar, outputJar);
                throw e;
            }
            this.cleanupPreviousJar(prevJar, outputJar);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)compile.apply((Object)Nil$.MODULE$);
            return;
        }
        throw new MatchError(option);
    }

    public Option<Tuple2<File, File>> preparePreviousJar(Output output) {
        return this.getOutputJar(output).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.exists())).map((Function1 & Serializable & scala.Serializable)outputJar -> {
            File prevJar = MODULE$.createPrevJarPath();
            IO$.MODULE$.move(outputJar, prevJar);
            return new Tuple2((Object)prevJar, outputJar);
        });
    }

    public void cleanupPreviousJar(File prevJar, File outputJar) {
        if (outputJar.exists()) {
            this.mergeJars(prevJar, outputJar);
        }
        IO$.MODULE$.move(prevJar, outputJar);
    }

    private File tempDir() {
        return this.tempDir;
    }

    private void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public void setupTempClassesDir(Option<File> temporaryClassesDirectory) {
        if (temporaryClassesDirectory instanceof Some) {
            File dir = (File)((Some)temporaryClassesDirectory).value();
            IO$.MODULE$.createDirectory(dir);
            this.tempDir_$eq(dir);
            return;
        }
        if (None$.MODULE$.equals(temporaryClassesDirectory)) {
            this.tempDir_$eq(new File(IO$.MODULE$.temporaryDirectory(), "zinc_temp_classes_dir"));
            return;
        }
        throw new MatchError(temporaryClassesDirectory);
    }

    private File createPrevJarPath() {
        String prevJarName = new StringBuilder(5).append(this.prevJarPrefix()).append("-").append(UUID.randomUUID()).append(".jar").toString();
        return this.tempDir().toPath().resolve(prevJarName).toFile();
    }

    public String prevJarPrefix() {
        return this.prevJarPrefix;
    }

    public boolean isClassInJar(File file) {
        String[] stringArray = file.toString().split("!");
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        boolean bl = !option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0 ? ((String)((SeqLike)option.get()).apply(0)).endsWith(".jar") : false;
        return bl;
    }

    public boolean isCompilingToJar(Output output) {
        return this.getOutputJar(output).isDefined();
    }

    public Option<File> getOutputJar(Output output) {
        None$ none$;
        if (output instanceof SingleOutput) {
            SingleOutput singleOutput = (SingleOutput)output;
            none$ = new Some((Object)singleOutput.getOutputDirectory()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JarUtils$.$anonfun$getOutputJar$1(x$4)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public File javacTempOutput(File outputJar) {
        String outJarName = outputJar.getName();
        String outDirName = new StringBuilder(13).append(outJarName).append("-javac-output").toString();
        return outputJar.toPath().resolveSibling(outDirName).toFile();
    }

    public JarUtils.OutputJarContent createOutputJarContent(Output output) {
        JarUtils.OutputJarContent outputJarContent;
        Option<File> option = this.getOutputJar(output);
        if (option instanceof Some) {
            File jar = (File)((Some)option).value();
            outputJarContent = new JarUtils.ValidOutputJarContent(jar);
        } else if (None$.MODULE$.equals(option)) {
            outputJarContent = JarUtils$NoOutputJar$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return outputJarContent;
    }

    /*
     * WARNING - void declaration
     */
    public long readModifiedTime(String jc) {
        void var4_4;
        void var3_3;
        Tuple2<File, String> tuple2 = JarUtils$ClassInJar$.MODULE$.splitJarReference$extension(jc);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        File jar = (File)tuple2._1();
        String cls = (String)tuple2._2();
        void jar2 = var3_3;
        void cls2 = var4_4;
        if (jar2.exists()) {
            return BoxesRunTime.unboxToLong(this.withZipFile((File)jar2, arg_0 -> JarUtils$.$anonfun$readModifiedTime$1$adapted((String)cls2, arg_0)));
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public boolean exists(String jc) {
        void var4_4;
        void var3_3;
        Tuple2<File, String> tuple2 = JarUtils$ClassInJar$.MODULE$.splitJarReference$extension(jc);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        File jar = (File)tuple2._1();
        String cls = (String)tuple2._2();
        void jar2 = var3_3;
        void cls2 = var4_4;
        return jar2.exists() && BoxesRunTime.unboxToBoolean(this.withZipFile((File)jar2, arg_0 -> JarUtils$.$anonfun$exists$1$adapted((String)cls2, arg_0)));
    }

    private <A> A withZipFile(File zip, Function1<ZipFile, A> f) {
        Object object;
        try (ZipFile file = new ZipFile(zip);){
            object = f.apply((Object)file);
        }
        return (A)object;
    }

    public static final /* synthetic */ boolean $anonfun$getOutputJar$1(File x$4) {
        return x$4.getName().endsWith(".jar");
    }

    public static final /* synthetic */ long $anonfun$readModifiedTime$2(ZipEntry x$6) {
        return x$6.getLastModifiedTime().toMillis();
    }

    public static final /* synthetic */ long $anonfun$readModifiedTime$1(String cls$1, ZipFile zip) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)zip.getEntry(cls$1)).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)JarUtils$.$anonfun$readModifiedTime$2(x$6))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$exists$1(String cls$2, ZipFile zip) {
        return zip.getEntry(cls$2) != null;
    }

    private JarUtils$() {
        MODULE$ = this;
        this.scalacOptions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-YdisableFlatCpCaching"}));
        this.javacOptions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-XDuseOptimizedZip=false"}));
        this.prevJarPrefix = "prev-jar";
    }

    public static final /* synthetic */ Object $anonfun$readStamps$1$adapted(IndexBasedZipOps.CachedStamps stamps$1, File file) {
        return BoxesRunTime.boxToLong((long)stamps$1.getStamp(JarUtils$ClassInJar$.MODULE$.toClassFilePath$extension(JarUtils$ClassInJar$.MODULE$.fromFile(file))));
    }

    public static final /* synthetic */ Object $anonfun$readModifiedTime$1$adapted(String cls$1, ZipFile zip) {
        return BoxesRunTime.boxToLong((long)JarUtils$.$anonfun$readModifiedTime$1(cls$1, zip));
    }

    public static final /* synthetic */ Object $anonfun$exists$1$adapted(String cls$2, ZipFile zip) {
        return BoxesRunTime.boxToBoolean((boolean)JarUtils$.$anonfun$exists$1(cls$2, zip));
    }
}

