/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classfile;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import sbt.internal.inc.JarUtils$ClassInJar$;
import sbt.internal.inc.classfile.ClassFile;
import sbt.internal.inc.classfile.Parser$;
import sbt.io.IO$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import xsbti.AnalysisCallback;
import xsbti.api.DependencyContext;
import xsbti.compile.Output;

public final class Analyze$ {
    public static Analyze$ MODULE$;

    static {
        new Analyze$();
    }

    public <T> void apply(Seq<File> newClasses, Seq<File> sources, Logger log, Output output, Option<File> finalJarOutput, AnalysisCallback analysis, ClassLoader loader, Function2<File, Seq<Class<?>>, scala.collection.immutable.Set<Tuple2<String, String>>> readAPI) {
        Map sourceMap = sources.toSet().groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName());
        File outputJarOrNull = (File)finalJarOutput.getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        File singleOutputOrNull = output.getSingleOutput().orElse(null);
        Set classNames = scala.collection.mutable.Set$.MODULE$.empty();
        HashMap sourceToClassFiles = (HashMap)HashMap$.MODULE$.apply((Seq)sources.zip((GenIterable)Seq$.MODULE$.fill(sources.size(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer()), Seq$.MODULE$.canBuildFrom()));
        HashMap binaryClassNameToLoadedClass = new HashMap();
        scala.collection.mutable.Map classfilesCache = Map$.MODULE$.empty();
        ((IterableLike)newClasses.map((Function1 & Serializable & scala.Serializable)newClass -> {
            ClassFile classFile = Parser$.MODULE$.apply((File)newClass);
            return new Tuple2(newClass, (Object)classFile);
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            Analyze$.$anonfun$apply$7(this, sourceMap, log, binaryClassNameToLoadedClass, singleOutputOrNull, outputJarOrNull, analysis, classNames, sourceToClassFiles, loader, x$3);
            return BoxedUnit.UNIT;
        });
        sourceToClassFiles.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            Analyze$.$anonfun$apply$15(analysis, binaryClassNameToLoadedClass, loader, log, finalJarOutput, classfilesCache, classNames, readAPI, x$8);
            return BoxedUnit.UNIT;
        });
    }

    private File resolveFinalClassFile(File realClassFile, File outputDir, File outputJar, Logger log) {
        File file;
        Option option = IO$.MODULE$.relativize(outputDir, realClassFile);
        if (option instanceof Some) {
            String relativeClass = (String)((Some)option).value();
            file = JarUtils$ClassInJar$.MODULE$.toFile$extension(JarUtils$ClassInJar$.MODULE$.apply(outputJar, relativeClass));
        } else if (None$.MODULE$.equals(option)) {
            file = realClassFile;
        } else {
            throw new MatchError((Object)option);
        }
        return file;
    }

    private Option<File> urlAsFile(URL url, Logger log, Option<File> finalJarOutput) {
        try {
            return this.urlAsFile(url, finalJarOutput);
        }
        catch (Exception e) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Could not convert URL '").append(url.toExternalForm()).append("' to File: ").append(e.toString()).toString());
            return None$.MODULE$;
        }
    }

    private Option<File> urlAsFile(URL url, Option<File> finalJarOutput) {
        return IO$.MODULE$.urlAsFile(url).map((Function1 & Serializable & scala.Serializable)file -> {
            if (finalJarOutput.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Analyze$.$anonfun$urlAsFile$3(file, x$9)))) {
                return JarUtils$ClassInJar$.MODULE$.toFile$extension(JarUtils$ClassInJar$.MODULE$.fromURL(url, (File)file));
            }
            return file;
        });
    }

    private void trapAndLog(Logger log, Function0<BoxedUnit> execute) {
        try {
            execute.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            log.trace((Function0 & Serializable & scala.Serializable)() -> e);
            log.error((Function0 & Serializable & scala.Serializable)() -> e.toString());
            return;
        }
    }

    private Some<String> guessSourceName(String name) {
        return new Some((Object)this.takeToDollar(this.trimClassExt(name)));
    }

    private String takeToDollar(String name) {
        int dollar = name.indexOf(36);
        if (dollar < 0) {
            return name;
        }
        return name.substring(0, dollar);
    }

    private final String ClassExt() {
        return ".class";
    }

    private String trimClassExt(String name) {
        if (name.endsWith(".class")) {
            return name.substring(0, name.length() - ".class".length());
        }
        return name;
    }

    private String classNameToClassFile(String name) {
        return new StringBuilder(6).append(name.replace('.', '/')).append(".class").toString();
    }

    private Option<String> binaryToSourceName(Class<?> loadedClass) {
        return Option$.MODULE$.apply((Object)loadedClass.getCanonicalName());
    }

    private List<File> guessSourcePath(Map<String, scala.collection.immutable.Set<File>> sourceNameMap, ClassFile classFile, Logger log) {
        List list;
        String[] classNameParts = classFile.className().split("\\.");
        String[] pkg = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classNameParts)).init();
        String simpleClassName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classNameParts)).last();
        String sourceFileName = (String)classFile.sourceFile().getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(simpleClassName)).takeWhile((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Analyze$.$anonfun$guessSourcePath$2(BoxesRunTime.unboxToChar((Object)x$10)))))).mkString("", "", ".java"));
        List<File> candidates = this.findSource(sourceNameMap, (List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pkg)).toList(), sourceFileName);
        if (Nil$.MODULE$.equals(candidates)) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not determine source for class ").append(classFile.className()).toString());
        } else if (!(candidates instanceof .colon.colon) || !Nil$.MODULE$.equals(list = ((.colon.colon)candidates).tl$access$1())) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Multiple sources matched for class ").append(classFile.className()).append(": ").append(candidates.mkString(", ")).toString());
        }
        return candidates;
    }

    private List<File> findSource(Map<String, Iterable<File>> sourceNameMap, List<String> pkg, String sourceFileName) {
        return this.refine((List<Tuple2<File, File>>)((List)((List)sourceNameMap.get((Object)sourceFileName).toList().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)x.getParentFile()), List$.MODULE$.canBuildFrom())), (List<String>)pkg.reverse());
    }

    private List<File> refine(List<Tuple2<File, File>> sources, List<String> pkgRev) {
        block2: {
            while (true) {
                List xs;
                if (sources.isEmpty() || ((SeqLike)sources.tail()).isEmpty()) {
                    return Analyze$.make$1(sources);
                }
                if (Nil$.MODULE$.equals(pkgRev)) break block2;
                if (!(pkgRev instanceof .colon.colon)) break;
                .colon.colon colon2 = (.colon.colon)pkgRev;
                String x = (String)colon2.head();
                pkgRev = xs = colon2.tl$access$1();
                sources = (List)sources.flatMap(arg_0 -> Analyze$.$anonfun$refine$2(x, arg_0), List$.MODULE$.canBuildFrom());
            }
            throw new MatchError(pkgRev);
        }
        List<File> list = this.shortest((List<File>)Analyze$.make$1(sources));
        return list;
    }

    private List<File> shortest(List<File> files) {
        if (files.isEmpty()) {
            return files;
        }
        Map fs = files.groupBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToInteger((int)Analyze$.MODULE$.distanceToRoot(0, file)));
        return (List)fs.apply(fs.keys().min((Ordering)Ordering.Int$.MODULE$));
    }

    private int distanceToRoot(int acc, File file) {
        while (file != null) {
            file = file.getParentFile();
            ++acc;
        }
        return acc;
    }

    private static final Option load$1(String tpe, Function0 errMsg, ClassLoader loader$1, Logger log$1) {
        if (tpe.endsWith("module-info")) {
            return None$.MODULE$;
        }
        try {
            return new Some(Class.forName(tpe, false, loader$1));
        }
        catch (Throwable e) {
            ((Option)errMsg.apply()).foreach((Function1 & Serializable & scala.Serializable)msg -> {
                log$1.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(3).append(msg).append(" : ").append(e$1.toString()).toString());
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
    }

    private final Option loadEnclosingClass$1(Class clazz) {
        Option<String> option;
        while (None$.MODULE$.equals(option = this.binaryToSourceName(clazz)) && clazz.getEnclosingClass() != null) {
            clazz = clazz.getEnclosingClass();
        }
        return option;
    }

    public static final /* synthetic */ void $anonfun$apply$11(Analyze$ $this, HashMap binaryClassNameToLoadedClass$1, File singleOutputOrNull$1, File outputJarOrNull$1, File newClass$1, Logger log$1, AnalysisCallback analysis$1, Set classNames$1, HashMap sourceToClassFiles$1, ClassFile classFile$1, ClassLoader loader$1, Tuple2 x$2) {
        if (x$2 != null) {
            File source = (File)x$2._1();
            String binaryClassName = (String)x$2._2();
            Analyze$.load$1(binaryClassName, (Function0 & Serializable & scala.Serializable)() -> new Some((Object)new StringBuilder(35).append("Error reading API from class file: ").append(binaryClassName).toString()), loader$1, log$1).foreach((Function1 & Serializable & scala.Serializable)loadedClass -> {
                File finalClassFile;
                binaryClassNameToLoadedClass$1.update((Object)binaryClassName, loadedClass);
                Option srcClassName = $this.loadEnclosingClass$1((Class)loadedClass);
                File file = finalClassFile = singleOutputOrNull$1 == null || outputJarOrNull$1 == null ? newClass$1 : MODULE$.resolveFinalClassFile(newClass$1, singleOutputOrNull$1, outputJarOrNull$1, log$1);
                if (srcClassName instanceof Some) {
                    String className = (String)((Some)srcClassName).value();
                    analysis$1.generatedNonLocalClass(source, finalClassFile, binaryClassName, className);
                    classNames$1.$plus$eq((Object)className);
                } else if (None$.MODULE$.equals(srcClassName)) {
                    analysis$1.generatedLocalClass(source, finalClassFile);
                } else {
                    throw new MatchError((Object)srcClassName);
                }
                return ((BufferLike)sourceToClassFiles$1.apply((Object)source)).$plus$eq((Object)classFile$1);
            });
            return;
        }
        throw new MatchError((Object)x$2);
    }

    public static final /* synthetic */ void $anonfun$apply$9(Analyze$ $this, Map sourceMap$1, ClassFile classFile$1, Logger log$1, HashMap binaryClassNameToLoadedClass$1, File singleOutputOrNull$1, File outputJarOrNull$1, File newClass$1, AnalysisCallback analysis$1, Set classNames$1, HashMap sourceToClassFiles$1, ClassLoader loader$1, String _) {
        ((List)MODULE$.guessSourcePath((Map<String, scala.collection.immutable.Set<File>>)sourceMap$1, classFile$1, log$1).map((Function1 & Serializable & scala.Serializable)source -> {
            String binaryClassName = classFile$1.className();
            return new Tuple2(source, (Object)binaryClassName);
        }, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Analyze$.$anonfun$apply$11($this, binaryClassNameToLoadedClass$1, singleOutputOrNull$1, outputJarOrNull$1, newClass$1, log$1, analysis$1, classNames$1, sourceToClassFiles$1, classFile$1, loader$1, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$7(Analyze$ $this, Map sourceMap$1, Logger log$1, HashMap binaryClassNameToLoadedClass$1, File singleOutputOrNull$1, File outputJarOrNull$1, AnalysisCallback analysis$1, Set classNames$1, HashMap sourceToClassFiles$1, ClassLoader loader$1, Tuple2 x$3) {
        if (x$3 != null) {
            File newClass = (File)x$3._1();
            ClassFile classFile = (ClassFile)x$3._2();
            classFile.sourceFile().orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.guessSourceName(newClass.getName())).foreach((Function1 & Serializable & scala.Serializable)_ -> {
                Analyze$.$anonfun$apply$9($this, sourceMap$1, classFile, log$1, binaryClassNameToLoadedClass$1, singleOutputOrNull$1, outputJarOrNull$1, newClass, analysis$1, classNames$1, sourceToClassFiles$1, loader$1, _);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)x$3);
    }

    public static final /* synthetic */ boolean $anonfun$apply$17(Class x$4) {
        return x$4.getCanonicalName() != null;
    }

    private static final Option getMappedSource$1(String className, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1) {
        return binaryClassNameToLoadedClass$1.get((Object)className).flatMap((Function1 & Serializable & scala.Serializable)loadedClass -> MODULE$.binaryToSourceName((Class<?>)loadedClass).map((Function1 & Serializable & scala.Serializable)sourceName -> sourceName)).orElse((Function0 & Serializable & scala.Serializable)() -> localClassesToSources$1.get((Object)className));
    }

    private static final Option loadFromClassloader$1(ClassLoader loader$1, String onBinaryName$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1) {
        return Option$.MODULE$.apply((Object)loader$1.getResource(MODULE$.classNameToClassFile(onBinaryName$1))).flatMap((Function1 & Serializable & scala.Serializable)url -> MODULE$.urlAsFile((URL)url, log$1, (Option<File>)finalJarOutput$1).map((Function1 & Serializable & scala.Serializable)file -> {
            classfilesCache$1.update((Object)onBinaryName$1, file);
            return file;
        }));
    }

    private static final void processDependency$1(String onBinaryName, DependencyContext context, String fromBinaryName, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, AnalysisCallback analysis$1, File source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1) {
        Option option = Analyze$.getMappedSource$1(fromBinaryName, binaryClassNameToLoadedClass$1, localClassesToSources$1);
        if (option instanceof Some) {
            String fromClassName = (String)((Some)option).value();
            MODULE$.trapAndLog(log$1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String scalaLikeTypeName = onBinaryName.replace('$', '.');
                if (classNames$1.contains((Object)scalaLikeTypeName)) {
                    analysis$1.classDependency(scalaLikeTypeName, fromClassName, context);
                    return;
                }
                classfilesCache$1.get((Object)onBinaryName).orElse((Function0 & Serializable & scala.Serializable)() -> Analyze$.loadFromClassloader$1(loader$1, onBinaryName, log$1, finalJarOutput$1, classfilesCache$1)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                    analysis$1.binaryDependency(file, onBinaryName, fromClassName, source$2, context);
                    return BoxedUnit.UNIT;
                });
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private static final void processDependencies$1(Iterable binaryClassNames, DependencyContext context, String fromBinaryClassName, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, AnalysisCallback analysis$1, File source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1) {
        binaryClassNames.foreach((Function1 & Serializable & scala.Serializable)binaryClassName -> {
            Analyze$.processDependency$1(binaryClassName, context, fromBinaryClassName, loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$31(ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, AnalysisCallback analysis$1, File source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String binaryClassName = (String)x0$1._1();
            Analyze$.processDependencies$1((Iterable)((scala.collection.immutable.Set)x0$1._2()), DependencyContext.DependencyByMemberRef, binaryClassName, loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1);
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    private static final Map readInheritanceDependencies$1(Seq classes, Function2 readAPI$1, File source$2) {
        return (Map)((scala.collection.immutable.Set)readAPI$1.apply((Object)source$2, (Object)classes)).groupBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6._1()).map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), ((SetLike)kv._2()).map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7._2(), Set$.MODULE$.canBuildFrom())), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$apply$35(ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, AnalysisCallback analysis$1, File source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String className = (String)x0$2._1();
            Analyze$.processDependencies$1((Iterable)((scala.collection.immutable.Set)x0$2._2()), DependencyContext.DependencyByInheritance, className, loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1);
            return;
        }
        throw new MatchError((Object)x0$2);
    }

    public static final /* synthetic */ void $anonfun$apply$37(ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, AnalysisCallback analysis$1, File source$2, HashMap binaryClassNameToLoadedClass$1, Map localClassesToSources$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String className = (String)x0$3._1();
            Analyze$.processDependencies$1((Iterable)((scala.collection.immutable.Set)x0$3._2()), DependencyContext.LocalDependencyByInheritance, className, loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, source$2, binaryClassNameToLoadedClass$1, localClassesToSources$1);
            return;
        }
        throw new MatchError((Object)x0$3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$apply$15(AnalysisCallback analysis$1, HashMap binaryClassNameToLoadedClass$1, ClassLoader loader$1, Logger log$1, Option finalJarOutput$1, scala.collection.mutable.Map classfilesCache$1, Set classNames$1, Function2 readAPI$1, Tuple2 x$8) {
        if (x$8 != null) {
            void var13_13;
            void var12_12;
            File source = (File)x$8._1();
            Buffer classFiles = (Buffer)x$8._2();
            analysis$1.startSource(source);
            Tuple2 tuple2 = ((Buffer)classFiles.map((Function1 & Serializable & scala.Serializable)c -> (Class)binaryClassNameToLoadedClass$1.apply((Object)c.className()), Buffer$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Analyze$.$anonfun$apply$17(x$4)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer nonLocalClasses = (Buffer)tuple2._1();
            Buffer localClassesOrStale = (Buffer)tuple2._2();
            void nonLocalClasses2 = var12_12;
            void localClassesOrStale2 = var13_13;
            Map localClassesToSources = ((Buffer)localClassesOrStale2.flatMap((Function1 & Serializable & scala.Serializable)cls -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(cls.getEnclosingClass()).flatMap((Function1 & Serializable & scala.Serializable)enclosingCls -> MODULE$.binaryToSourceName((Class<?>)enclosingCls).map((Function1 & Serializable & scala.Serializable)sourceOfEnclosing -> new Tuple2((Object)cls.getName(), sourceOfEnclosing)))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            ((TraversableOnce)classFiles.map((Function1 & Serializable & scala.Serializable)cf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cf.className()), cf.types()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Analyze$.$anonfun$apply$31(loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, x0$1);
                return BoxedUnit.UNIT;
            });
            Analyze$.readInheritanceDependencies$1((Seq)nonLocalClasses2, readAPI$1, source).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Analyze$.$anonfun$apply$35(loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, x0$2);
                return BoxedUnit.UNIT;
            });
            Analyze$.readInheritanceDependencies$1((Seq)((Buffer)localClassesOrStale2.filter((Function1 & Serializable & scala.Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)localClassesToSources.contains((Object)cls.getName())))), readAPI$1, source).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Analyze$.$anonfun$apply$37(loader$1, log$1, finalJarOutput$1, classfilesCache$1, classNames$1, analysis$1, source, binaryClassNameToLoadedClass$1, localClassesToSources, x0$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)x$8);
    }

    public static final /* synthetic */ boolean $anonfun$urlAsFile$3(File file$1, File x$9) {
        File file = x$9;
        return !(file != null ? !((Object)file).equals(file$1) : file$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$guessSourcePath$2(char x$10) {
        return x$10 != '$';
    }

    private static final List make$1(List sources$1) {
        return (List)sources$1.map((Function1 & Serializable & scala.Serializable)x$11 -> (File)x$11._1(), List$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ List $anonfun$refine$2(String x$13, Tuple2 x0$1) {
        block3: {
            block2: {
                if (x0$1 == null) break block2;
                src = (File)x0$1._1();
                pre = (File)x0$1._2();
                if (pre == null) ** GOTO lbl-1000
                v0 = pre.getName();
                if (!(v0 != null ? v0.equals(x$13) == false : x$13 != null)) {
                    var5_4 = new Tuple2((Object)src, (Object)pre.getParentFile());
                    v1 = Nil$.MODULE$.$colon$colon((Object)var5_4);
                } else lbl-1000:
                // 2 sources

                {
                    v1 = Nil$.MODULE$;
                }
                break block3;
            }
            throw new MatchError((Object)x0$1);
        }
        var2_5 = v1;
        return var2_5;
    }

    private Analyze$() {
        MODULE$ = this;
    }
}

