/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classpath;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import sbt.io.IO$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0005-\u0011qb\u00117bgN\u0004\u0018\r\u001e5GS2$XM\u001d\u0006\u0003\u0007\u0011\t\u0011b\u00197bgN\u0004\u0018\r\u001e5\u000b\u0005\u00151\u0011aA5oG*\u0011q\u0001C\u0001\tS:$XM\u001d8bY*\t\u0011\"A\u0002tER\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!aC\"mCN\u001cHj\\1eKJD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006I\u0001D\u0001\u0007a\u0006\u0014XM\u001c;\t\u0011]\u0001!\u0011!Q\u0001\n1\tAA]8pi\"A1\u0001\u0001B\u0001B\u0003%\u0011\u0004E\u0002\u001bG\u0019r!aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0005yQ\u0011A\u0002\u001fs_>$hHC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011s$\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0015\u00121aU3u\u0015\t\u0011s\u0004\u0005\u0002(U5\t\u0001F\u0003\u0002*!\u0005\u0011\u0011n\\\u0005\u0003W!\u0012AAR5mK\")Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"BaL\u00193gA\u0011\u0001\u0007A\u0007\u0002\u0005!)Q\u0003\fa\u0001\u0019!)q\u0003\fa\u0001\u0019!)1\u0001\fa\u00013!)Q\u0007\u0001C!m\u0005AAo\\*ue&tw\rF\u00018!\tQ\u0002(\u0003\u0002:K\t11\u000b\u001e:j]\u001eDaa\u000f\u0001!\u0002\u0013a\u0014a\u00033je\u0016\u001cGo\u001c:jKN\u00042!\u0010\"'\u001d\tq\u0004I\u0004\u0002\u001d\u007f%\t\u0001%\u0003\u0002B?\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003~AQA\u0012\u0001\u0005B\u001d\u000b\u0011\u0002\\8bI\u000ec\u0017m]:\u0015\u0007!C&\f\r\u0002J\u001dB\u0019!D\u0013'\n\u0005-+#!B\"mCN\u001c\bCA'O\u0019\u0001!\u0011bT#\u0002\u0002\u0003\u0005)\u0011\u0001)\u0003\u0007}#S'\u0005\u0002R+B\u0011!kU\u0007\u0002?%\u0011Ak\b\u0002\b\u001d>$\b.\u001b8h!\t\u0011f+\u0003\u0002X?\t\u0019\u0011I\\=\t\u000be+\u0005\u0019A\u001c\u0002\u0013\rd\u0017m]:OC6,\u0007\"B.F\u0001\u0004a\u0016a\u0002:fg>dg/\u001a\t\u0003%vK!AX\u0010\u0003\u000f\t{w\u000e\\3b]\"1\u0001\r\u0001Q\u0005\n\u0005\fQB\u001a:p[\u000ec\u0017m]:qCRDGC\u0001/c\u0011\u0015\u0019w\f1\u0001e\u0003\u0005\u0019\u0007GA3h!\rQ\"J\u001a\t\u0003\u001b\u001e$\u0011\u0002\u001b2\u0002\u0002\u0003\u0005)\u0011\u0001)\u0003\u0007}#c\u0007\u0003\u0004k\u0001\u0001&Ia[\u0001\f_:\u001cE.Y:ta\u0006$\b\u000e\u0006\u0002]Y\")Q.\u001ba\u0001]\u0006\u00191O]2\u0011\u0005=\u0014X\"\u00019\u000b\u0005E\u0004\u0012a\u00018fi&\u00111\u000f\u001d\u0002\u0004+Jc\u0005\"B;\u0001\t\u00032\u0018aC4fiJ+7o\\;sG\u0016$\"A\\<\t\u000ba$\b\u0019A\u001c\u0002\t9\fW.\u001a\u0005\u0006u\u0002!\te_\u0001\rO\u0016$(+Z:pkJ\u001cWm\u001d\u000b\u0004y\u0006\u0015\u0001\u0003B?\u0002\u00029l\u0011A \u0006\u0003\u007fB\tA!\u001e;jY&\u0019\u00111\u0001@\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0005\u0006qf\u0004\ra\u000e\u0005\t\u0003\u0013\u0001\u0001\u0015\"\u0003\u0002\f\u0005i\u0011N\\2mk\u0012,Gj\\1eKJ$R\u0001XA\u0007\u0003\u001fAaaYA\u0004\u0001\u0004a\u0001bBA\t\u0003\u000f\u0001\r\u0001D\u0001\u0005E\u0006\u001cX\r\u000b\u0003\u0002\b\u0005U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005mq$\u0001\u0006b]:|G/\u0019;j_:LA!a\b\u0002\u001a\t9A/Y5me\u0016\u001c\u0007")
public final class ClasspathFilter
extends ClassLoader {
    private final ClassLoader parent;
    private final ClassLoader root;
    private final Set<File> classpath;
    private final Seq<File> directories;

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|ClasspathFilter(\n        |  parent = ", "\n        |  root = ", "\n        |  cp = ", "\n        |)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parent, this.root, this.classpath})))).stripMargin();
    }

    @Override
    public Class<?> loadClass(String className, boolean resolve) {
        Class<?> c = super.loadClass(className, resolve);
        if (this.includeLoader(c.getClassLoader(), this.root) || this.fromClasspath(c)) {
            return c;
        }
        throw new ClassNotFoundException(className);
    }

    private boolean fromClasspath(Class<?> c) {
        CodeSource codeSource = c.getProtectionDomain().getCodeSource();
        return codeSource == null || this.onClasspath(codeSource.getLocation());
    }

    private boolean onClasspath(URL src) {
        block8: {
            block7: {
                boolean bl;
                if (src == null) break block7;
                Option option = IO$.MODULE$.urlAsFile(src);
                if (option instanceof Some) {
                    File f = (File)((Some)option).value();
                    bl = this.classpath.apply((Object)f) || this.directories.exists((Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)ClasspathFilter.$anonfun$onClasspath$1(f, dir)));
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)option);
                }
                if (!bl) break block8;
            }
            return true;
        }
        return false;
    }

    @Override
    public URL getResource(String name) {
        URL u = super.getResource(name);
        if (this.onClasspath(u)) {
            return u;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        Enumeration<URL> us = super.getResources(name);
        if (us != null) {
            return JavaConverters$.MODULE$.asJavaEnumerationConverter(((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(us).asScala()).filter((Function1 & Serializable & scala.Serializable)src -> BoxesRunTime.boxToBoolean((boolean)this.onClasspath(src)))).asJavaEnumeration();
        }
        return null;
    }

    private boolean includeLoader(ClassLoader c, ClassLoader base) {
        while (base != null && c != null) {
            if (c != base) {
                c = c.getParent();
                continue;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$onClasspath$1(File f$1, File dir) {
        return IO$.MODULE$.relativize(dir, f$1).isDefined();
    }

    public ClasspathFilter(ClassLoader parent, ClassLoader root, Set<File> classpath) {
        this.parent = parent;
        this.root = root;
        this.classpath = classpath;
        super(parent);
        this.directories = (Seq)classpath.toSeq().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()));
    }
}

