/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classpath;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import sbt.internal.inc.classpath.ClasspathFilter;
import sbt.internal.inc.classpath.FixedResources;
import sbt.internal.inc.classpath.NativeCopyConfig;
import sbt.internal.inc.classpath.NativeCopyLoader;
import sbt.internal.inc.classpath.RawResources;
import sbt.io.IO$;
import sbt.io.Path$;
import sbt.io.PathFinder;
import sbt.io.Using;
import sbt.io.Using$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxesRunTime;
import xsbti.Launcher;
import xsbti.compile.ScalaInstance;

public final class ClasspathUtilities$ {
    public static ClasspathUtilities$ MODULE$;
    private ClassLoader rootLoader;
    private ClassLoader xsbtiLoader;
    private volatile byte bitmap$0;

    static {
        new ClasspathUtilities$();
    }

    public ClassLoader toLoader(PathFinder finder) {
        return this.toLoader(finder, this.rootLoader());
    }

    public ClassLoader toLoader(PathFinder finder, ClassLoader parent) {
        return new URLClassLoader(finder.getURLs(), parent);
    }

    public ClassLoader toLoader(Seq<File> paths) {
        return this.toLoader(paths, this.rootLoader());
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent) {
        return new URLClassLoader(Path$.MODULE$.toURLs(paths), parent);
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent, Map<String, String> resourceMap) {
        return new RawResources(paths, parent, resourceMap){
            private final Map<String, URL> resourceURL;
            private final Map resourceMap$2;

            public /* synthetic */ URL sbt$internal$inc$classpath$FixedResources$$super$findResource(String x$1) {
                return super.findResource(x$1);
            }

            public /* synthetic */ Enumeration sbt$internal$inc$classpath$FixedResources$$super$findResources(String x$1) {
                return super.findResources(x$1);
            }

            public URL findResource(String s) {
                return FixedResources.findResource$(this, s);
            }

            public Enumeration<URL> findResources(String s) {
                return FixedResources.findResources$(this, s);
            }

            public final Map<String, URL> resourceURL() {
                return this.resourceURL;
            }

            public final void sbt$internal$inc$classpath$RawResources$_setter_$resourceURL_$eq(Map<String, URL> x$1) {
                this.resourceURL = x$1;
            }

            public Map<String, String> resources() {
                return this.resourceMap$2;
            }
            {
                this.resourceMap$2 = resourceMap$2;
                super(Path$.MODULE$.toURLs(paths$2), parent$3);
                FixedResources.$init$(this);
                RawResources.$init$(this);
            }
        };
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent, Map<String, String> resourceMap, File nativeTemp) {
        return new RawResources(paths, parent, resourceMap, nativeTemp){
            private final NativeCopyConfig config;
            private final HashMap<String, String> sbt$internal$inc$classpath$NativeCopyLoader$$mapped;
            private final Map<String, URL> resourceURL;
            private final Seq paths$1;
            private final ClassLoader parent$2;
            private final Map resourceMap$1;
            private final File nativeTemp$1;

            public String findLibrary(String name) {
                return NativeCopyLoader.findLibrary$(this, name);
            }

            public /* synthetic */ URL sbt$internal$inc$classpath$FixedResources$$super$findResource(String x$1) {
                return super.findResource(x$1);
            }

            public /* synthetic */ Enumeration sbt$internal$inc$classpath$FixedResources$$super$findResources(String x$1) {
                return super.findResources(x$1);
            }

            public URL findResource(String s) {
                return FixedResources.findResource$(this, s);
            }

            public Enumeration<URL> findResources(String s) {
                return FixedResources.findResources$(this, s);
            }

            public HashMap<String, String> sbt$internal$inc$classpath$NativeCopyLoader$$mapped() {
                return this.sbt$internal$inc$classpath$NativeCopyLoader$$mapped;
            }

            public final void sbt$internal$inc$classpath$NativeCopyLoader$_setter_$sbt$internal$inc$classpath$NativeCopyLoader$$mapped_$eq(HashMap<String, String> x$1) {
                this.sbt$internal$inc$classpath$NativeCopyLoader$$mapped = x$1;
            }

            public final Map<String, URL> resourceURL() {
                return this.resourceURL;
            }

            public final void sbt$internal$inc$classpath$RawResources$_setter_$resourceURL_$eq(Map<String, URL> x$1) {
                this.resourceURL = x$1;
            }

            public Map<String, String> resources() {
                return this.resourceMap$1;
            }

            public NativeCopyConfig config() {
                return this.config;
            }

            public String toString() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(181).append("|URLClassLoader with NativeCopyLoader with RawResources(\n            |  urls = ").append(this.paths$1).append(",\n            |  parent = ").append(this.parent$2).append(",\n            |  resourceMap = ").append(this.resourceMap$1.keySet()).append(",\n            |  nativeTemp = ").append(this.nativeTemp$1).append("\n            |)").toString())).stripMargin();
            }
            {
                this.paths$1 = paths$1;
                this.parent$2 = parent$2;
                this.resourceMap$1 = resourceMap$1;
                this.nativeTemp$1 = nativeTemp$1;
                super(Path$.MODULE$.toURLs(paths$1), parent$2);
                FixedResources.$init$(this);
                RawResources.$init$(this);
                NativeCopyLoader.$init$(this);
                this.config = new NativeCopyConfig(nativeTemp$1, (Seq<File>)paths$1, ClasspathUtilities$.MODULE$.javaLibraryPaths());
            }
        };
    }

    public Seq<File> javaLibraryPaths() {
        return IO$.MODULE$.parseClasspath(System.getProperty("java.library.path"));
    }

    private ClassLoader rootLoader$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
                this.rootLoader = systemLoader != null ? this.parent$1(systemLoader) : this.parent$1(this.getClass().getClassLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.rootLoader;
    }

    public ClassLoader rootLoader() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.rootLoader$lzycompute();
        }
        return this.rootLoader;
    }

    private ClassLoader xsbtiLoader$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.xsbtiLoader = Launcher.class.getClassLoader();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.xsbtiLoader;
    }

    public ClassLoader xsbtiLoader() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.xsbtiLoader$lzycompute();
        }
        return this.xsbtiLoader;
    }

    public final String AppClassPath() {
        return "app.class.path";
    }

    public final String BootClassPath() {
        return "boot.class.path";
    }

    public Map<String, String> createClasspathResources(Seq<File> classpath, ScalaInstance instance) {
        return this.createClasspathResources(classpath, (Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])new File[]{instance.libraryJar()}));
    }

    public Map<String, String> createClasspathResources(Seq<File> appPaths, Seq<File> bootPaths) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ClasspathUtilities$.make$1("app.class.path", appPaths), ClasspathUtilities$.make$1("boot.class.path", bootPaths)}));
    }

    public ClassLoader filterByClasspath(Seq<File> classpath, ClassLoader loader) {
        return new ClasspathFilter(loader, this.xsbtiLoader(), (Set<File>)classpath.toSet());
    }

    public ClassLoader makeLoader(Seq<File> classpath, ScalaInstance instance) {
        return this.filterByClasspath(classpath, this.makeLoader(classpath, instance.loaderLibraryOnly(), instance));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ScalaInstance instance, File nativeTemp) {
        return this.filterByClasspath(classpath, this.makeLoader(classpath, instance.loaderLibraryOnly(), instance, nativeTemp));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ClassLoader parent, ScalaInstance instance) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ClassLoader parent, ScalaInstance instance, File nativeTemp) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance), nativeTemp);
    }

    public void printSource(Class<?> c) {
        Predef$.MODULE$.println((Object)new StringBuilder(18).append(c.getName()).append(" loader=").append(c.getClassLoader()).append(" location=").append(IO$.MODULE$.classLocationFile(c)).toString());
    }

    public boolean isArchive(File file) {
        return this.isArchive(file, false);
    }

    public boolean isArchive(File file, boolean contentFallback) {
        return file.isFile() && (this.isArchiveName(file.getName()) || contentFallback && this.hasZipContent(file));
    }

    public boolean isArchiveName(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".zip");
    }

    public boolean hasZipContent(File file) {
        try {
            return BoxesRunTime.unboxToBoolean((Object)((Using)Using$.MODULE$.fileInputStream()).apply((Object)file, (Function1 & Serializable & scala.Serializable)in -> BoxesRunTime.boxToBoolean((boolean)ClasspathUtilities$.$anonfun$hasZipContent$1(in))));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Iterable<File> compilerPlugins(Seq<File> classpath, boolean isDotty) {
        URLClassLoader loader = new URLClassLoader(Path$.MODULE$.toURLs(classpath));
        String metaFile = isDotty ? "plugin.properties" : "scalac-plugin.xml";
        return (Iterable)JavaConversions$.MODULE$.deprecated$u0020enumerationAsScalaIterator(loader.getResources(metaFile)).toList().flatMap((Function1 & Serializable & scala.Serializable)url -> MODULE$.asFile(true, (URL)url), List$.MODULE$.canBuildFrom());
    }

    public List<File> asFile(URL url) {
        return this.asFile(false, url);
    }

    public List<File> asFile(boolean jarOnly, URL url) {
        try {
            Nil$ nil$;
            String string = url.getProtocol();
            if ("file".equals(string) && !jarOnly) {
                File file = IO$.MODULE$.toFile(url);
                nil$ = Nil$.MODULE$.$colon$colon((Object)file);
            } else if ("jar".equals(string)) {
                String path = url.getPath();
                int end = path.indexOf(33);
                File file = new File(new URI(end == -1 ? path : path.substring(0, end)));
                nil$ = Nil$.MODULE$.$colon$colon((Object)file);
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }
        catch (Exception exception) {
            return Nil$.MODULE$;
        }
    }

    private final ClassLoader parent$1(ClassLoader loader) {
        ClassLoader p;
        while ((p = loader.getParent()) != null) {
            loader = p;
        }
        return loader;
    }

    private static final Tuple2 make$1(String name, Seq paths) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)Path$.MODULE$.makeString(paths));
    }

    public static final /* synthetic */ boolean $anonfun$hasZipContent$1(BufferedInputStream in) {
        return in.read() == 80 && in.read() == 75 && in.read() == 3 && in.read() == 4;
    }

    private ClasspathUtilities$() {
        MODULE$ = this;
    }
}

