/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.classpath;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Enumeration;
import sbt.internal.inc.classpath.ClasspathFilter;
import sbt.internal.inc.classpath.FixedResources;
import sbt.internal.inc.classpath.NativeCopyConfig;
import sbt.internal.inc.classpath.NativeCopyLoader;
import sbt.internal.inc.classpath.RawResources;
import sbt.io.IO$;
import sbt.io.Path$;
import sbt.io.PathFinder;
import sbt.io.Using;
import sbt.io.Using$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.control.NonFatal$;
import xsbti.Launcher;
import xsbti.compile.ScalaInstance;

public final class ClasspathUtilities$ {
    public static ClasspathUtilities$ MODULE$;
    private ClassLoader rootLoader;
    private ClassLoader xsbtiLoader;
    private FileSystem jrtFs;
    private final String FileScheme;
    private volatile byte bitmap$0;

    static {
        new ClasspathUtilities$();
    }

    public ClassLoader toLoader(PathFinder finder) {
        return this.toLoader(finder, this.rootLoader());
    }

    public ClassLoader toLoader(PathFinder finder, ClassLoader parent) {
        return new URLClassLoader(finder.getURLs(), parent);
    }

    public ClassLoader toLoader(Seq<File> paths) {
        return this.toLoader(paths, this.rootLoader());
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent) {
        return new URLClassLoader(Path$.MODULE$.toURLs(paths), parent);
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent, Map<String, String> resourceMap) {
        return new RawResources(paths, parent, resourceMap){
            private final Map<String, URL> resourceURL;
            private final Map resourceMap$1;

            public /* synthetic */ URL sbt$internal$inc$classpath$FixedResources$$super$findResource(String x$1) {
                return super.findResource(x$1);
            }

            public /* synthetic */ Enumeration sbt$internal$inc$classpath$FixedResources$$super$findResources(String x$1) {
                return super.findResources(x$1);
            }

            public URL findResource(String s) {
                return FixedResources.findResource$(this, s);
            }

            public Enumeration<URL> findResources(String s) {
                return FixedResources.findResources$(this, s);
            }

            public final Map<String, URL> resourceURL() {
                return this.resourceURL;
            }

            public final void sbt$internal$inc$classpath$RawResources$_setter_$resourceURL_$eq(Map<String, URL> x$1) {
                this.resourceURL = x$1;
            }

            public Map<String, String> resources() {
                return this.resourceMap$1;
            }
            {
                this.resourceMap$1 = resourceMap$1;
                super(Path$.MODULE$.toURLs(paths$1), parent$1);
                FixedResources.$init$(this);
                RawResources.$init$(this);
            }
        };
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent, Map<String, String> resourceMap, File nativeTemp) {
        return new RawResources(paths, parent, resourceMap, nativeTemp){
            private final NativeCopyConfig config;
            private final HashMap<String, String> sbt$internal$inc$classpath$NativeCopyLoader$$mapped;
            private final Map<String, URL> resourceURL;
            private final Map resourceMap$2;
            private final File nativeTemp$1;
            private final Seq paths$2;
            private final ClassLoader parent$2;

            public String findLibrary(String name) {
                return NativeCopyLoader.findLibrary$(this, name);
            }

            public /* synthetic */ URL sbt$internal$inc$classpath$FixedResources$$super$findResource(String x$1) {
                return super.findResource(x$1);
            }

            public /* synthetic */ Enumeration sbt$internal$inc$classpath$FixedResources$$super$findResources(String x$1) {
                return super.findResources(x$1);
            }

            public URL findResource(String s) {
                return FixedResources.findResource$(this, s);
            }

            public Enumeration<URL> findResources(String s) {
                return FixedResources.findResources$(this, s);
            }

            public HashMap<String, String> sbt$internal$inc$classpath$NativeCopyLoader$$mapped() {
                return this.sbt$internal$inc$classpath$NativeCopyLoader$$mapped;
            }

            public final void sbt$internal$inc$classpath$NativeCopyLoader$_setter_$sbt$internal$inc$classpath$NativeCopyLoader$$mapped_$eq(HashMap<String, String> x$1) {
                this.sbt$internal$inc$classpath$NativeCopyLoader$$mapped = x$1;
            }

            public final Map<String, URL> resourceURL() {
                return this.resourceURL;
            }

            public final void sbt$internal$inc$classpath$RawResources$_setter_$resourceURL_$eq(Map<String, URL> x$1) {
                this.resourceURL = x$1;
            }

            public Map<String, String> resources() {
                return this.resourceMap$2;
            }

            public NativeCopyConfig config() {
                return this.config;
            }

            public String toString() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(181).append("|URLClassLoader with NativeCopyLoader with RawResources(\n            |  urls = ").append(this.paths$2).append(",\n            |  parent = ").append(this.parent$2).append(",\n            |  resourceMap = ").append(this.resourceMap$2.keySet()).append(",\n            |  nativeTemp = ").append(this.nativeTemp$1).append("\n            |)").toString())).stripMargin();
            }
            {
                this.resourceMap$2 = resourceMap$2;
                this.nativeTemp$1 = nativeTemp$1;
                this.paths$2 = paths$2;
                this.parent$2 = parent$2;
                super(Path$.MODULE$.toURLs(paths$2), parent$2);
                FixedResources.$init$(this);
                RawResources.$init$(this);
                NativeCopyLoader.$init$(this);
                this.config = new NativeCopyConfig(nativeTemp$1, (Seq<File>)paths$2, ClasspathUtilities$.MODULE$.javaLibraryPaths());
            }
        };
    }

    public Seq<File> javaLibraryPaths() {
        return IO$.MODULE$.parseClasspath(System.getProperty("java.library.path"));
    }

    private ClassLoader rootLoader$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
                this.rootLoader = systemLoader != null ? this.parent$3(systemLoader) : this.parent$3(this.getClass().getClassLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.rootLoader;
    }

    public ClassLoader rootLoader() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.rootLoader$lzycompute();
        }
        return this.rootLoader;
    }

    private ClassLoader xsbtiLoader$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.xsbtiLoader = Launcher.class.getClassLoader();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.xsbtiLoader;
    }

    public ClassLoader xsbtiLoader() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.xsbtiLoader$lzycompute();
        }
        return this.xsbtiLoader;
    }

    public final String AppClassPath() {
        return "app.class.path";
    }

    public final String BootClassPath() {
        return "boot.class.path";
    }

    public Map<String, String> createClasspathResources(Seq<File> classpath, ScalaInstance instance) {
        return this.createClasspathResources(classpath, (Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])new File[]{instance.libraryJar()}));
    }

    public Map<String, String> createClasspathResources(Seq<File> appPaths, Seq<File> bootPaths) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ClasspathUtilities$.make$1("app.class.path", appPaths), ClasspathUtilities$.make$1("boot.class.path", bootPaths)}));
    }

    public ClassLoader filterByClasspath(Seq<File> classpath, ClassLoader loader) {
        return new ClasspathFilter(loader, this.xsbtiLoader(), (Set<File>)classpath.toSet());
    }

    public ClassLoader makeLoader(Seq<File> classpath, ScalaInstance instance) {
        return this.filterByClasspath(classpath, this.makeLoader(classpath, instance.loaderLibraryOnly(), instance));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ScalaInstance instance, File nativeTemp) {
        return this.filterByClasspath(classpath, this.makeLoader(classpath, instance.loaderLibraryOnly(), instance, nativeTemp));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ClassLoader parent, ScalaInstance instance) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ClassLoader parent, ScalaInstance instance, File nativeTemp) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance), nativeTemp);
    }

    public void printSource(Class<?> c) {
        Predef$.MODULE$.println((Object)new StringBuilder(18).append(c.getName()).append(" loader=").append(c.getClassLoader()).append(" location=").append(this.classLocationPath(c)).toString());
    }

    public String FileScheme() {
        return this.FileScheme;
    }

    private FileSystem jrtFs$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.jrtFs = FileSystems.getFileSystem(URI.create("jrt:/"));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.jrtFs;
    }

    private FileSystem jrtFs() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.jrtFs$lzycompute();
        }
        return this.jrtFs;
    }

    public File toFile(URL url) {
        try {
            return this.uriToFile(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(url.getPath());
        }
    }

    public Option<File> urlAsFile(URL url) {
        String path;
        int end;
        String string = url.getProtocol();
        String string2 = this.FileScheme();
        Object object = !(string2 != null ? !string2.equals(string) : string != null) ? new Some((Object)this.toFile(url)) : ("jar".equals(string) ? new Some((Object)this.uriToFile((end = (path = url.getPath()).indexOf(33)) == -1 ? path : path.substring(0, end))) : None$.MODULE$);
        return object;
    }

    private File uriToFile(String uriString) {
        return this.uriToFile(new URI(uriString));
    }

    /*
     * Unable to fully structure code
     */
    private File uriToFile(URI uri) {
        block3: {
            block2: {
                part = uri.getSchemeSpecificPart();
                var6_3 = Option$.MODULE$.apply((Object)uri.getScheme());
                if (!None$.MODULE$.equals(var6_3)) break block2;
                var4_4 = true;
                break block3;
            }
            if (!(var6_3 instanceof Some)) ** GOTO lbl-1000
            var7_5 = (String)((Some)var6_3).value();
            v0 = this.FileScheme();
            if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
                var4_4 = true;
            } else lbl-1000:
            // 2 sources

            {
                var4_4 = false;
            }
        }
        var3_6 = var4_4 != false;
        Predef$.MODULE$.assert(var3_6, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$uriToFile$1(java.net.URI ), ()Ljava/lang/String;)((URI)uri));
        var8_7 = Option$.MODULE$.apply((Object)uri.getAuthority());
        var2_8 = None$.MODULE$.equals(var8_7) != false && part.startsWith("/") != false ? new File(uri) : (part.startsWith("/") == false && part.contains(":") != false ? new File(new StringBuilder(2).append("//").append(part).toString()) : new File(part));
        return var2_8;
    }

    public Path classLocationPath(Class<?> cl) {
        URL u = this.classLocation(cl);
        String string = u.getProtocol();
        String string2 = this.FileScheme();
        Object object = !(string2 != null ? !string2.equals(string) : string != null) ? Option$.MODULE$.apply((Object)this.toFile(u).toPath()) : ("jar".equals(string) ? this.urlAsFile(u).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toPath()) : ("jrt".equals(string) ? Option$.MODULE$.apply((Object)this.jrtFs().getPath(u.getPath(), new String[0])) : None$.MODULE$));
        return (Path)object.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(32).append("Unable to create File from ").append(u).append(" for ").append(cl).toString()));
    }

    public URL classLocation(Class<?> cl) {
        String clsfile = new StringBuilder(6).append(cl.getName().replace('.', '/')).append(".class").toString();
        try {
            return (URL)ClasspathUtilities$.localcl$1(cl).orElse((Function0 & Serializable & scala.Serializable)() -> ClasspathUtilities$.syscl$1(clsfile)).map((Function1 & Serializable & scala.Serializable)url -> {
                String path;
                int end;
                String path2;
                int end2;
                String string = url.getProtocol();
                URL uRL = "jar".equals(string) ? new URL((end2 = (path2 = url.getPath()).indexOf(33)) == -1 ? path2 : path2.substring(0, end2)) : ("jrt".equals(string) ? new URL("jrt", null, (end = (path = url.getPath()).indexOf(47, 1)) == -1 ? path : path.substring(0, end)) : url);
                return uRL;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(22).append("No class location for ").append(cl).toString()));
        }
        catch (Throwable throwable) {
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                e.printStackTrace();
                throw e;
            }
            throw throwable;
        }
    }

    public boolean isArchive(File file) {
        return this.isArchive(file, false);
    }

    public boolean isArchive(File file, boolean contentFallback) {
        return file.isFile() && (this.isArchiveName(file.getName()) || contentFallback && this.hasZipContent(file));
    }

    public boolean isArchiveName(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".zip");
    }

    public boolean hasZipContent(File file) {
        try {
            return BoxesRunTime.unboxToBoolean((Object)((Using)Using$.MODULE$.fileInputStream()).apply((Object)file, (Function1 & Serializable & scala.Serializable)in -> BoxesRunTime.boxToBoolean((boolean)ClasspathUtilities$.$anonfun$hasZipContent$1(in))));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Iterable<File> compilerPlugins(Seq<File> classpath, boolean isDotty) {
        URLClassLoader loader = new URLClassLoader(ClasspathUtilities$.toURLs$1(classpath));
        String metaFile = isDotty ? "plugin.properties" : "scalac-plugin.xml";
        return (Iterable)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(loader.getResources(metaFile)).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)url -> MODULE$.asFile(true, (URL)url), List$.MODULE$.canBuildFrom());
    }

    public List<File> asFile(URL url) {
        return this.asFile(false, url);
    }

    public List<File> asFile(boolean jarOnly, URL url) {
        try {
            Nil$ nil$;
            String string = url.getProtocol();
            if ("file".equals(string) && !jarOnly) {
                File file = IO$.MODULE$.toFile(url);
                nil$ = Nil$.MODULE$.$colon$colon((Object)file);
            } else if ("jar".equals(string)) {
                String path = url.getPath();
                int end = path.indexOf(33);
                File file = new File(new URI(end == -1 ? path : path.substring(0, end)));
                nil$ = Nil$.MODULE$.$colon$colon((Object)file);
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }
        catch (Exception exception) {
            return Nil$.MODULE$;
        }
    }

    private final ClassLoader parent$3(ClassLoader loader) {
        ClassLoader p;
        while ((p = loader.getParent()) != null) {
            loader = p;
        }
        return loader;
    }

    private static final Tuple2 make$1(String name, Seq paths) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)Path$.MODULE$.makeString(paths));
    }

    public static final /* synthetic */ String $anonfun$uriToFile$1(URI uri$1) {
        return new StringBuilder(43).append("Expected protocol to be '").append(MODULE$.FileScheme()).append("' or empty in URI ").append(uri$1).toString();
    }

    private static final Option localcl$1(Class cl$2) {
        return Option$.MODULE$.apply((Object)cl$2.getProtectionDomain().getCodeSource()).flatMap((Function1 & Serializable & scala.Serializable)codeSource -> Option$.MODULE$.apply((Object)codeSource.getLocation()));
    }

    private static final Option syscl$1(String clsfile$1) {
        return Option$.MODULE$.apply((Object)ClassLoader.getSystemClassLoader()).flatMap((Function1 & Serializable & scala.Serializable)classLoader -> Option$.MODULE$.apply((Object)classLoader.getResource(clsfile$1)));
    }

    public static final /* synthetic */ boolean $anonfun$hasZipContent$1(BufferedInputStream in) {
        return in.read() == 80 && in.read() == 75 && in.read() == 3 && in.read() == 4;
    }

    private static final URL[] toURLs$1(Seq files) {
        return (URL[])((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toURI().toURL(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URL.class));
    }

    private ClasspathUtilities$() {
        MODULE$ = this;
        this.FileScheme = "file";
    }
}

